/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.teller.passbook;

import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.flow.Messages;
import com.ecc.ide.editor.transaction.DataProvider;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualTellerFramePanel;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TellerPassbookDefinePanel
extends Composite {
    private Table table;
    private Text passbookIdText;
    private Text passbookNameText;
    private Text descText;
    int[] weights;
    private VisualTellerFramePanel visualViewPanel;
    private EditorProfile editorProfile;
    private XMLNode contentNode;
    private XMLNode curPassbookNode;
    private String rootPath;
    private XMLNode dataDictionary;
    private XMLNode patternNode;
    private XMLNode functionNode;
    private XMLNode taskNode;
    private DataProvider dataProvider;
    private BuildProblemReporter reporter;

    public void setDataProvider(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
        this.visualViewPanel.setDataProvider(dataProvider);
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.visualViewPanel.setDataDictionary(node);
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.visualViewPanel.setDataEditorProfile(profile);
    }

    public void setViewEditorProfile(EditorProfile profile) {
        this.editorProfile = profile;
        this.visualViewPanel.setEditorProfile(profile);
    }

    public TellerPassbookDefinePanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        final SashForm sashForm = new SashForm((Composite)this, 0);
        Composite composite_1 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite_1.setLayout((Layout)gridLayout);
        Label label = new Label(composite_1, 0);
        label.setText(Messages.getString("TellerPassbookDefinePanel.passbookId"));
        this.passbookIdText = new Text(composite_1, 2048);
        GridData gridData_9 = new GridData(768);
        gridData_9.horizontalSpan = 3;
        this.passbookIdText.setLayoutData((Object)gridData_9);
        Label label_2 = new Label(composite_1, 0);
        label_2.setText(Messages.getString("TellerPassbookDefinePanel.passbookName"));
        this.passbookNameText = new Text(composite_1, 2048);
        GridData gridData_10 = new GridData(768);
        gridData_10.horizontalSpan = 3;
        this.passbookNameText.setLayoutData((Object)gridData_10);
        Label label_3 = new Label(composite_1, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalSpan = 4;
        label_3.setLayoutData((Object)gridData_1);
        label_3.setText(Messages.getString("TellerViewDefinePanel.Document__6"));
        this.descText = new Text(composite_1, 2818);
        GridData gridData_2 = new GridData(768);
        gridData_2.heightHint = 50;
        gridData_2.horizontalSpan = 4;
        this.descText.setLayoutData((Object)gridData_2);
        Composite composite_2 = new Composite(composite_1, 0);
        GridData gridData_3 = new GridData(256);
        gridData_3.horizontalSpan = 4;
        composite_2.setLayoutData((Object)gridData_3);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite_2.setLayout((Layout)gridLayout_1);
        Button button_1 = new Button(composite_2, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerPassbookDefinePanel.this.createNewPassbook();
            }
        });
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 80;
        button_1.setLayoutData((Object)gridData_4);
        button_1.setText(Messages.getString("TellerViewDefinePanel.Create_7"));
        Button button_2 = new Button(composite_2, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerPassbookDefinePanel.this.deleteCurrentPassbook();
            }
        });
        GridData gridData_5 = new GridData();
        gridData_5.widthHint = 80;
        button_2.setLayoutData((Object)gridData_5);
        button_2.setText(Messages.getString("TellerViewDefinePanel.Delete_8"));
        Button button_3 = new Button(composite_2, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerPassbookDefinePanel.this.updateCurrentPassbook();
            }
        });
        GridData gridData_6 = new GridData();
        gridData_6.widthHint = 80;
        button_3.setLayoutData((Object)gridData_6);
        button_3.setText(Messages.getString("TellerViewDefinePanel.Update_1"));
        this.table = new Table(composite_1, 67584);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerPassbookDefinePanel.this.setActivateView();
            }
        });
        GridData gridData_7 = new GridData(1808);
        gridData_7.horizontalSpan = 4;
        this.table.setLayoutData((Object)gridData_7);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(63);
        tableColumn.setText(Messages.getString("TellerPassbookDefinePanel.passbookId1"));
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(79);
        tableColumn_1.setText(Messages.getString("TellerPassbookDefinePanel.passbookName1"));
        TableColumn tableColumn_3 = new TableColumn(this.table, 0);
        tableColumn_3.setWidth(280);
        tableColumn_3.setText(Messages.getString("TellerViewDefinePanel.Document_11"));
        CTabFolder tabFolder = new CTabFolder((Composite)sashForm, 0);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                int[] ws = sashForm.getWeights();
                if (ws[0] == 0) {
                    sashForm.setWeights(TellerPassbookDefinePanel.this.weights);
                    TellerPassbookDefinePanel.this.layout(true);
                } else {
                    int[] nArray = new int[2];
                    nArray[1] = 400;
                    sashForm.setWeights(nArray);
                    TellerPassbookDefinePanel.this.layout(true);
                    TellerPassbookDefinePanel.this.weights[0] = ws[0];
                    TellerPassbookDefinePanel.this.weights[1] = ws[1];
                }
            }
        });
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("visualDesign"));
        this.visualViewPanel = new VisualTellerFramePanel((Composite)tabFolder, 0);
        this.visualViewPanel.setShowRule(true);
        tabItem.setControl((Control)this.visualViewPanel);
        tabFolder.setSelection(0);
        this.visualViewPanel.setAcceptableComponentNames("OperationPanel");
        this.visualViewPanel.setLabelMap("label", "Label");
        this.visualViewPanel.setLabelMap("text", "TextField");
        this.weights = new int[2];
        this.weights[0] = 1;
        this.weights[1] = 4;
        sashForm.setWeights(this.weights);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setXMLContent(XMLNode node) {
        this.contentNode = node;
        this.table.removeAll();
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode passbookNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(passbookNode.getNodeName())) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(passbookNode.getAttrValue("id"));
                item.setData((Object)passbookNode);
                if (passbookNode.getAttrValue("message") != null) {
                    item.setText(1, passbookNode.getAttrValue("message"));
                }
                if (passbookNode.getDocument() != null) {
                    item.setText(2, passbookNode.getDocument());
                }
            }
            ++i;
        }
        if (childs.size() > 0) {
            this.table.setSelection(0);
            this.setActivateView();
        }
    }

    private void createNewPassbook() {
        String passbookId = this.passbookIdText.getText();
        if (!this.checkPassbookName(passbookId)) {
            return;
        }
        if (this.contentNode.getChilds() != null && this.contentNode.findChildNode(passbookId) != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"warrning", (String)Messages.getString("TellerPassbookDefinePanel.duplicatedIdInfo"));
            return;
        }
        XMLNode passbookNode = new XMLNode();
        passbookNode.setNodeName("Passbook");
        passbookNode.setAttrValue("id", passbookId);
        passbookNode.setAttrValue("message", this.passbookNameText.getText());
        passbookNode.setDocument(this.descText.getText());
        XMLNode coverNode = new XMLNode("PassbookCover");
        passbookNode.add(coverNode);
        XMLNode lineNode = new XMLNode("PassbookLine");
        passbookNode.add(lineNode);
        passbookNode.setAttrValue("x", "40");
        passbookNode.setAttrValue("y", "40");
        passbookNode.setAttrValue("width", "525");
        passbookNode.setAttrValue("height", "785");
        passbookNode.setAttrValue("pageHeight", "5.98");
        passbookNode.setAttrValue("pageWidth", "12.04");
        passbookNode.setAttrValue("topMargin", "0.5");
        passbookNode.setAttrValue("bottomMargin", "0.5");
        passbookNode.setAttrValue("leftMargin", "1.0");
        passbookNode.setAttrValue("rightMargin", "1.0");
        passbookNode.setAttrValue("midMargin", "1.0");
        coverNode.setAttrValue("x", "35");
        coverNode.setAttrValue("y", "35");
        coverNode.setAttrValue("width", "455");
        coverNode.setAttrValue("height", "226");
        lineNode.setAttrValue("x", "72");
        lineNode.setAttrValue("y", "314");
        lineNode.setAttrValue("width", "381");
        lineNode.setAttrValue("height", "19");
        this.contentNode.add(passbookNode);
        TableItem item = new TableItem(this.table, 0);
        item.setText(passbookId);
        item.setText(1, this.passbookNameText.getText());
        item.setText(2, this.descText.getText());
        item.setData((Object)passbookNode);
    }

    private void setActivateView() {
        TableItem[] selects = this.table.getSelection();
        if (selects.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)selects[0].getData();
        if (this.curPassbookNode == node) {
            return;
        }
        try {
            this.visualViewPanel.setXMLContent(node);
            this.curPassbookNode = node;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.passbookIdText.setText(node.getAttrValue("id"));
        if (node.getAttrValue("message") != null) {
            this.passbookNameText.setText(node.getAttrValue("message"));
        } else {
            this.passbookNameText.setText("");
        }
        if (node.getDocument() != null) {
            this.descText.setText(node.getDocument());
        } else {
            this.descText.setText("");
        }
    }

    private void updateCurrentPassbook() {
        TableItem[] selects = this.table.getSelection();
        if (selects.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)selects[0].getData();
        String passbookId = this.passbookIdText.getText();
        if (!this.checkPassbookName(passbookId)) {
            return;
        }
        XMLNode aNode = this.contentNode.findChildNode(passbookId);
        if (aNode != null && aNode != node) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"warrning", (String)Messages.getString("TellerPassbookDefinePanel.duplicatedIdInfo"));
            return;
        }
        node.setAttrValue("id", passbookId);
        node.setAttrValue("message", this.passbookNameText.getText());
        node.setDocument(this.descText.getText());
        selects[0].setText(passbookId);
        selects[0].setText(1, this.passbookNameText.getText());
        selects[0].setText(2, this.descText.getText());
    }

    private void deleteCurrentPassbook() {
        TableItem[] items = this.table.getSelection();
        if (items.length != 1) {
            return;
        }
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("TellerPassbookDefinePanel.sureToInfo"), (String)Messages.getString("TellerPassbookDefinePanel.deleteInfo"))) {
            XMLNode viewNode = (XMLNode)items[0].getData();
            this.contentNode.remove(viewNode);
            items[0].dispose();
            if (this.table.getItemCount() > 0) {
                this.table.setSelection(0);
                this.setActivateView();
            } else {
                try {
                    this.visualViewPanel.setXMLContent(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setProblemReporter(BuildProblemReporter reporter) {
        this.reporter = reporter;
    }

    public void reportProblem(int type, String msg, String location, String fileName, Exception e) {
        if (this.reporter != null) {
            this.reporter.reportProblem(type, msg, location, fileName, e);
        } else {
            System.out.println("[" + type + "]" + msg + ":" + location);
        }
    }

    public void setPatternNode(XMLNode node) {
        this.patternNode = node;
        this.visualViewPanel.setPatternNode(node);
    }

    public void setFunctionNode(XMLNode node) {
        this.functionNode = node;
        this.visualViewPanel.setFunctionNode(this.functionNode);
    }

    public void setFunctionProfile(EditorProfile profile) {
        this.visualViewPanel.setFunctionProfile(profile);
    }

    public void setPatternProfile(EditorProfile profile) {
        this.visualViewPanel.setPatternProfile(profile);
    }

    public void setTaskNode(XMLNode node) {
        this.taskNode = node;
        this.visualViewPanel.setTaskNode(this.taskNode);
    }

    public void setRootPath(String path) {
        this.rootPath = path;
        this.visualViewPanel.setRootPath(path);
    }

    private boolean checkPassbookName(String name) {
        if (name.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TellerViewDefinePanel.Warning_18"), (String)Messages.getString("TellerPassbookDefinePanel.passbookIdInfo"));
            return false;
        }
        return true;
    }

    public String getSelectedPassbookId() {
        if (this.curPassbookNode != null) {
            return this.curPassbookNode.getAttrValue("id");
        }
        return null;
    }
}

