/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.transaction;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.transaction.DataProvider;
import com.ecc.ide.editor.transaction.HostDataPanel;
import com.ecc.ide.editor.transaction.Messages;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class HostAccessPanel
extends Composite {
    private Text documentText;
    private Text reqIDText;
    private Table reqListTable;
    private Combo hostListCombo;
    private XMLNode dataDictionary;
    private Button repRefCheckButton;
    private Button reqRefCheckButton;
    private XMLNode hostSettings;
    private XMLNode packageTypeNode;
    private XMLNode trxNode;
    private XMLNode curHostNode;
    private HostDataPanel hostReqDataPanel;
    private HostDataPanel hostRepDataPanel;
    XMLNode channelSettings;
    private String curHostId = null;
    private XMLNode hostReqNode;
    private XMLNode hostRepNode;

    public void setDataProvider(DataProvider provider) {
        this.hostReqDataPanel.setDataProvider(provider);
        this.hostRepDataPanel.setDataProvider(provider);
    }

    public void setChannelSettings(XMLNode node) {
        this.channelSettings = node;
        this.hostRepDataPanel.setChannelSettings(node);
        this.hostReqDataPanel.setChannelSettings(node);
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.hostReqDataPanel.setDataDictionary(node);
        this.hostRepDataPanel.setDataDictionary(node);
    }

    public HostAccessPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 0);
        Composite composite = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite.setLayout((Layout)gridLayout_1);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("HostAccessPanel.Host_ID__4"));
        this.hostListCombo = new Combo(composite, 8);
        this.hostListCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.widthHint = 80;
        this.hostListCombo.setLayoutData((Object)gridData);
        Label label_1 = new Label(composite, 0);
        label_1.setText(Messages.getString("HostAccessPanel.ID__5"));
        this.reqIDText = new Text(composite, 2048);
        GridData gridData_5 = new GridData();
        gridData_5.horizontalSpan = 3;
        gridData_5.widthHint = 90;
        this.reqIDText.setLayoutData((Object)gridData_5);
        this.reqIDText.setText("default");
        Label label_2 = new Label(composite, 0);
        GridData gridData_6 = new GridData();
        gridData_6.horizontalSpan = 4;
        label_2.setLayoutData((Object)gridData_6);
        label_2.setText(Messages.getString("HostAccessPanel.Document__7"));
        this.documentText = new Text(composite, 2818);
        GridData gridData_4 = new GridData(768);
        gridData_4.heightHint = 40;
        gridData_4.horizontalSpan = 4;
        this.documentText.setLayoutData((Object)gridData_4);
        Composite buttonComposite = new Composite(composite, 0);
        GridData gridData_9 = new GridData(768);
        gridData_9.horizontalSpan = 4;
        buttonComposite.setLayoutData((Object)gridData_9);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 4;
        buttonComposite.setLayout((Layout)gridLayout_2);
        Button button = new Button(buttonComposite, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostAccessPanel.this.createNewReqRep();
            }
        });
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 60;
        button.setLayoutData((Object)gridData_3);
        button.setText(Messages.getString("HostAccessPanel.Add_8"));
        Button button_1 = new Button(buttonComposite, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostAccessPanel.this.deleteCurrentReqRep();
            }
        });
        button_1.setText(Messages.getString("HostAccessPanel.Delete_9"));
        Button button_2 = new Button(buttonComposite, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostAccessPanel.this.updateCurrentReqRep();
            }
        });
        button_2.setText(Messages.getString("HostAccessPanel.update_1"));
        this.reqListTable = new Table(composite, 67584);
        this.reqListTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostAccessPanel.this.setActivateReqRep();
            }
        });
        GridData gridData_2 = new GridData(1808);
        gridData_2.horizontalSpan = 4;
        this.reqListTable.setLayoutData((Object)gridData_2);
        this.reqListTable.setLinesVisible(true);
        this.reqListTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.reqListTable, 0);
        tableColumn.setWidth(106);
        tableColumn.setText(Messages.getString("HostAccessPanel.Host_ID_1"));
        TableColumn tableColumn_1 = new TableColumn(this.reqListTable, 0);
        tableColumn_1.setWidth(100);
        tableColumn_1.setText(Messages.getString("HostAccessPanel.ID_2"));
        TableColumn tableColumn_2 = new TableColumn(this.reqListTable, 0);
        tableColumn_2.setWidth(128);
        tableColumn_2.setText(Messages.getString("HostAccessPanel.Document_3"));
        TabFolder tabFolder = new TabFolder((Composite)sashForm, 0);
        GridData gridData_1 = new GridData(1808);
        gridData_1.horizontalSpan = 4;
        tabFolder.setLayoutData((Object)gridData_1);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("HostAccessPanel.Request_10"));
        Composite comp1 = new Composite((Composite)tabFolder, 0);
        comp1.setLayout((Layout)new GridLayout());
        tabItem.setControl((Control)comp1);
        this.reqRefCheckButton = new Button(comp1, 32);
        this.reqRefCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostAccessPanel.this.hostReqNode.setAttrValue("refToHead", String.valueOf(HostAccessPanel.this.reqRefCheckButton.getSelection()));
            }
        });
        this.reqRefCheckButton.setText(Messages.getString("HostAccessPanel.Request_refer_to_Header_12"));
        this.hostReqDataPanel = new HostDataPanel(comp1, 0);
        this.hostReqDataPanel.setLayoutData(new GridData(1808));
        TabItem tabItem_1 = new TabItem(tabFolder, 0);
        tabItem_1.setText(Messages.getString("HostAccessPanel.Reply_13"));
        Composite comp2 = new Composite((Composite)tabFolder, 0);
        comp2.setLayout((Layout)new GridLayout());
        this.repRefCheckButton = new Button(comp2, 32);
        this.repRefCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostAccessPanel.this.hostRepNode.setAttrValue("refToHead", String.valueOf(HostAccessPanel.this.repRefCheckButton.getSelection()));
            }
        });
        this.repRefCheckButton.setText(Messages.getString("HostAccessPanel.Reply_refer_to_header_15"));
        this.hostRepDataPanel = new HostDataPanel(comp2, 0);
        this.hostRepDataPanel.setLayoutData(new GridData(1808));
        tabItem_1.setControl((Control)comp2);
        sashForm.setWeights(new int[]{1, 3});
    }

    public void setPackageTypeSettings(XMLNode node) {
        this.packageTypeNode = node;
        this.hostRepDataPanel.setPkgTypeXMLNode(node);
        this.hostReqDataPanel.setPkgTypeXMLNode(node);
    }

    public void setHostSettings(XMLNode node) {
        this.hostSettings = node;
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode host = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(host.getNodeName())) {
                String hostId = host.getAttrValue("id");
                this.hostListCombo.add(hostId);
            }
            ++i;
        }
    }

    private Element createElement(String elementName, XMLNode attrNode) {
        Element element = new Element();
        element.setElementName(elementName);
        if (attrNode.getChilds() == null) {
            return element;
        }
        Vector childs = attrNode.getChilds();
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                ElementAttribute attr = new ElementAttribute(aNode);
                element.addAttribute(attr);
            }
            ++i;
        }
        return element;
    }

    public void setTrxNode(XMLNode node) {
        this.trxNode = node;
        XMLNode hostAccessNode = this.trxNode.getChild("hostAccess");
        if (hostAccessNode == null || hostAccessNode.getChilds() == null) {
            return;
        }
        Vector childs = hostAccessNode.getChilds();
        int i = 0;
        while (i < childs.size()) {
            XMLNode hostReqNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(hostReqNode.getNodeName())) {
                String id = hostReqNode.getAttrValue("id");
                String hostId = hostReqNode.getAttrValue("hostId");
                String document = hostReqNode.getDocument();
                TableItem item = new TableItem(this.reqListTable, 0);
                item.setData((Object)hostReqNode);
                item.setText(hostId);
                item.setText(1, id);
                if (document != null) {
                    item.setText(2, document);
                }
            }
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
    }

    private void setActivateReqRep() {
        TableItem[] selects = this.reqListTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        XMLNode hostReqRepNode = (XMLNode)selects[0].getData();
        String id = hostReqRepNode.getAttrValue("id");
        String hostId = hostReqRepNode.getAttrValue("hostId");
        String document = hostReqRepNode.getDocument();
        this.reqIDText.setText(id);
        this.hostListCombo.setText(hostId);
        if (document != null) {
            this.documentText.setText(document);
        } else {
            this.documentText.setText("");
        }
        this.hostReqNode = hostReqRepNode.getChild("request");
        this.hostRepNode = hostReqRepNode.getChild("reply");
        if ("true".equals(this.hostReqNode.getAttrValue("refToHead"))) {
            this.reqRefCheckButton.setSelection(true);
        } else {
            this.reqRefCheckButton.setSelection(false);
        }
        if ("true".equals(this.hostRepNode.getAttrValue("refToHead"))) {
            this.repRefCheckButton.setSelection(true);
        } else {
            this.repRefCheckButton.setSelection(false);
        }
        this.hostReqDataPanel.setHostAccessDataNode(this.hostReqNode);
        this.hostRepDataPanel.setHostAccessDataNode(this.hostRepNode);
    }

    private void createNewReqRep() {
        String hostId = this.hostListCombo.getText();
        if (this.trxNode == null) {
            return;
        }
        String id = this.reqIDText.getText();
        if (hostId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostAccessPanel.warning_31"), (String)Messages.getString("HostAccessPanel.Please_select_the_host_!_32"));
            return;
        }
        if (id.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostAccessPanel.warning_33"), (String)Messages.getString("HostAccessPanel.Please_input_id_value_!_34"));
            return;
        }
        String document = this.documentText.getText();
        XMLNode hostAccessNode = this.trxNode.getChild("hostAccess");
        XMLNode hostNode = null;
        XMLNode hostReqNode = null;
        XMLNode hostRepNode = null;
        if (hostAccessNode == null) {
            hostAccessNode = new XMLNode();
            hostAccessNode.setNodeName("hostAccess");
            this.trxNode.add(hostAccessNode);
        } else {
            Vector childs = hostAccessNode.getChilds();
            int i = 0;
            while (childs != null && i < childs.size()) {
                XMLNode aNode = (XMLNode)childs.elementAt(i);
                if (!"#text".equals(aNode.getNodeName())) {
                    String hId = aNode.getAttrValue("hostId");
                    String aId = aNode.getAttrValue("id");
                    if (hostId.equals(hId) && id.equals(aId)) {
                        MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostAccessPanel.warning_39"), (String)Messages.getString("HostAccessPanel.Duplicated_HostID_and_Id_!_40"));
                        return;
                    }
                }
                ++i;
            }
        }
        hostNode = new XMLNode();
        hostNode.setNodeName("host");
        hostNode.setAttrValue("id", id);
        hostNode.setAttrValue("hostId", hostId);
        hostNode.setDocument(document);
        TableItem item = new TableItem(this.reqListTable, 0);
        item.setData((Object)hostNode);
        item.setText(hostId);
        item.setText(1, id);
        item.setText(2, document);
        this.curHostNode = hostNode;
        hostAccessNode.add(hostNode);
        hostReqNode = new XMLNode();
        hostReqNode.setNodeName("request");
        hostNode.add(hostReqNode);
        hostRepNode = new XMLNode();
        hostRepNode.setNodeName("reply");
        hostNode.add(hostRepNode);
        this.repRefCheckButton.setSelection(false);
        this.reqRefCheckButton.setSelection(false);
        this.hostReqDataPanel.setHostAccessDataNode(hostReqNode);
        this.hostRepDataPanel.setHostAccessDataNode(hostRepNode);
    }

    private void updateCurrentReqRep() {
        TableItem[] selects = this.reqListTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        XMLNode hostReqRepNode = (XMLNode)selects[0].getData();
        String hostId = this.hostListCombo.getText();
        String id = this.reqIDText.getText();
        if (hostId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostAccessPanel.warning_31"), (String)Messages.getString("HostAccessPanel.Please_select_the_host_!_32"));
            return;
        }
        if (id.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostAccessPanel.warning_33"), (String)Messages.getString("HostAccessPanel.Please_input_id_value_!_34"));
            return;
        }
        String document = this.documentText.getText();
        XMLNode hostAccessNode = this.trxNode.getChild("hostAccess");
        Vector childs = hostAccessNode.getChilds();
        int i = 0;
        while (childs != null && i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                String hId = aNode.getAttrValue("hostId");
                String aId = aNode.getAttrValue("id");
                if (hostId.equals(hId) && id.equals(aId) && aNode != hostReqRepNode) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostAccessPanel.warning_39"), (String)Messages.getString("HostAccessPanel.Duplicated_HostID_and_Id_!_40"));
                    return;
                }
            }
            ++i;
        }
        hostReqRepNode.setAttrValue("id", id);
        hostReqRepNode.setAttrValue("hostId", hostId);
        hostReqRepNode.setDocument(this.documentText.getText());
        selects[0].setText(hostId);
        selects[0].setText(1, id);
        selects[0].setText(2, this.documentText.getText());
    }

    private void deleteCurrentReqRep() {
        TableItem[] selects = this.reqListTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("HostAccessPanel.Are_you_sure..._5"), (String)Messages.getString("HostAccessPanel.Please_make_sure_to_delete_the_selected_host_access_define._6"))) {
            return;
        }
        XMLNode hostReqRepNode = (XMLNode)selects[0].getData();
        this.trxNode.getChild("hostAccess").remove(hostReqRepNode);
        this.reqListTable.remove(this.reqListTable.indexOf(selects[0]));
    }

    protected void checkSubclass() {
    }
}

