/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualJsp;

import com.ecc.ide.editor.visualJsp.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileNameEditPanel
extends Composite {
    private String rootPath;
    private Text text;

    public FileNameEditPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("FileNameEditPanel.Selected_File_Name__1"));
        this.text = new Text((Composite)this, 2048);
        this.text.setLayoutData((Object)new GridData(768));
        Button button = new Button((Composite)this, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileNameEditPanel.this.selectFileName();
            }
        });
        button.setText(">>");
        this.setSize(500, 180);
    }

    public void setRootPath(String path) {
        this.rootPath = path;
    }

    public String getFileName() {
        return this.text.getText();
    }

    public void setFileName(String fileName) {
        if (fileName != null) {
            this.text.setText(fileName);
        }
    }

    private void selectFileName() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        if (this.rootPath != null) {
            dialog.setFilterPath(String.valueOf(this.rootPath) + "/WebContent/");
        }
        String fileName = null;
        String result = dialog.open();
        if (result != null) {
            fileName = result;
            if (!this.checkPath(this.rootPath, fileName = fileName.replace('\\', '/'))) {
                fileName = null;
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please select file from project's workspace path!");
            } else {
                if ((fileName = fileName.substring(this.rootPath.length())).startsWith("/WebContent/")) {
                    // empty if block
                }
                fileName = fileName.substring(12);
            }
        }
        if (fileName != null) {
            this.text.setText(fileName);
        }
    }

    private boolean checkPath(String rootPath, String fileName) {
        int idx = 0;
        int idx1 = rootPath.indexOf(":");
        if (idx1 != -1) {
            char ch1 = rootPath.charAt(0);
            ch1 = Character.toLowerCase(ch1);
            char ch2 = fileName.charAt(0);
            if (ch1 != (ch2 = Character.toLowerCase(ch2))) {
                return false;
            }
            String str1 = rootPath.substring(1);
            String str2 = fileName.substring(1);
            idx = str2.indexOf(str1);
        } else {
            idx = fileName.indexOf(rootPath);
        }
        return idx != -1;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

