/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualJsp;

import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.NewDataDictionaryPanel;
import com.ecc.ide.editor.visualJsp.VisualJSPFramePanel;
import com.ecc.ide.editor.visualhtml.HTMLTrxRefOpDataPanel;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.Vector;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FlowDataSelectPage
extends WizardPage {
    XMLNode xmlContent;
    private XMLNode dataDictionary;
    private VisualJSPFramePanel visualEditor;
    private HTMLTrxRefOpDataPanel trxDataPanel = null;
    private NewDataDictionaryPanel dataDicPanel = null;

    public FlowDataSelectPage(String pageName) {
        super(pageName);
    }

    public FlowDataSelectPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        this.dataDictionary = this.visualEditor.getDataDictionary();
        String flowFileName = this.visualEditor.getFlowFileName();
        Object node = null;
        if (flowFileName != null) {
            Vector<String> opNames = new Vector<String>(10);
            Vector<XMLNode> refDatas = new Vector<XMLNode>(10);
            XMLElementObjectMaker maker = new XMLElementObjectMaker();
            XMLLoader loader = new XMLLoader();
            loader.addObjectMaker((ObjectMaker)maker);
            try {
                String fileName = String.valueOf(this.visualEditor.getRootPath()) + "/designFiles/MCITrxs/" + flowFileName;
                XMLNode opNode = (XMLNode)loader.loadXMLFile(fileName);
                XMLNode datasNode = opNode.getChild("datas");
                String opCode = opNode.getAttrValue("trxCode");
                opNames.addElement(opCode);
                refDatas.addElement(datasNode);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.trxDataPanel = new HTMLTrxRefOpDataPanel(parent, 0, opNames, refDatas, this.dataDictionary);
            this.trxDataPanel.setChannelSettings(this.visualEditor.getChannelSettings());
            this.setControl((Control)this.trxDataPanel);
            return;
        }
        this.dataDicPanel = new NewDataDictionaryPanel(parent, false, 0, 65538);
        this.dataDicPanel.setFilterStr("dataElement;dataCollection;");
        this.dataDicPanel.setEditorProfile(this.visualEditor.getDataEditorProfile());
        this.dataDicPanel.setDataDictionary(this.visualEditor.getDataDictionary());
        this.setControl((Control)this.dataDicPanel);
    }

    public void dispose() {
        super.dispose();
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void setXMLContent(XMLNode node) {
        this.xmlContent = node;
    }

    public void setDataDictionary(XMLNode dataDictionary) {
        this.dataDictionary = dataDictionary;
    }

    public void setVisualEditor(VisualJSPFramePanel visualEditor) {
        this.visualEditor = visualEditor;
    }

    public Vector getSelectedData() {
        if (this.trxDataPanel != null) {
            return this.trxDataPanel.getSelections();
        }
        if (this.dataDicPanel != null) {
            return this.dataDicPanel.getSelectedDatas();
        }
        return null;
    }
}

