/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualJsp;

import com.ecc.ide.editor.XMLNode;
import com.ecc.util.xmlloader.Externalizable;
import com.ecc.util.xmlloader.ObjectMaker;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class JSPLoader {
    private Vector objMakers = new Vector(10);
    private Document document;
    private Node rootNode;

    public InputStream getInputStream(String fileName) throws Exception {
        String xml_source = fileName;
        if (fileName.indexOf(":") != -1) {
            URL aURL;
            if (fileName.indexOf(":") <= 2) {
                xml_source = "file:///" + fileName;
                aURL = new URL(xml_source);
                xml_source = aURL.toString();
            }
            aURL = new URL(xml_source);
            return aURL.openStream();
        }
        FileInputStream fi = new FileInputStream(fileName);
        return fi;
    }

    public void loadJSPDocument(String fileName) throws Exception {
        try {
            FileInputStream fi = new FileInputStream(fileName);
            this.loadJSPDocument(fi);
            fi.close();
            return;
        }
        catch (Exception e) {
            InputStream in;
            URL aURL;
            String xml_source;
            System.out.println(e);
            if (fileName.indexOf(":") != -1) {
                if (fileName.indexOf(":") <= 2) {
                    xml_source = "file:///" + fileName;
                    aURL = new URL(xml_source);
                    xml_source = aURL.toString();
                } else {
                    xml_source = fileName;
                }
            } else {
                xml_source = fileName;
            }
            try {
                aURL = new URL(xml_source);
                in = aURL.openStream();
            }
            catch (Exception e2) {
                in = this.getClass().getResourceAsStream(xml_source);
            }
            if (in != null) {
                this.loadJSPDocument(in);
            } else {
                System.out.println("Warning failed to load the XML File:" + fileName);
            }
            return;
        }
    }

    public Node findNode(String nodeId) {
        if (this.rootNode == null) {
            return null;
        }
        NodeList children = this.rootNode.getChildNodes();
        int childrenSize = children.getLength();
        int i = 0;
        while (i < childrenSize) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && nodeId.equals(this.getNodeAttribute("id", child))) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public Node findNode(String nodeName, String nodeId) {
        if (this.rootNode == null) {
            return null;
        }
        NodeList children = this.rootNode.getChildNodes();
        int childrenSize = children.getLength();
        int i = 0;
        while (i < childrenSize) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && nodeId.equals(this.getNodeAttribute("id", child)) && nodeName.equals(child.getNodeName())) {
                return child;
            }
            ++i;
        }
        return null;
    }

    protected String getNodeAttribute(String attrName, Node node) {
        NamedNodeMap nm = node.getAttributes();
        Node attNode = nm.getNamedItem(attrName);
        if (attNode != null) {
            return attNode.getNodeValue();
        }
        return null;
    }

    public void loadJSPDocument(InputStream in) throws Exception {
        DOMParser parser = new DOMParser();
        parser.setProperty("http://apache.org/xml/properties/dom/document-class-name", (Object)"com.ecc.ide.editor.visualJsp.JSPDocumentImpl");
        parser.setProperty("http://cyberneko.org/html/properties/default-encoding", (Object)"GBK");
        parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"default");
        parser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"no-change");
        parser.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
        InputSource src = new InputSource(in);
        parser.parse(src);
        Document document = parser.getDocument();
        this.rootNode = document;
    }

    public Externalizable loadJSPFile(String fileName) throws Exception {
        InputStream in = this.getInputStream(fileName);
        this.loadJSPDocument(in);
        in.close();
        Externalizable obj = this.convertNodeToObject(this.rootNode);
        this.document = null;
        this.rootNode = null;
        return obj;
    }

    public Externalizable loadJSPContent(InputStream in) throws Exception {
        this.loadJSPDocument(in);
        Externalizable obj = this.convertNodeToObject(this.rootNode);
        this.document = null;
        this.rootNode = null;
        return obj;
    }

    public Externalizable readObject(String id) {
        Node node = this.findNode(id);
        return this.convertNodeToObject(node);
    }

    public Externalizable readObject(String nodeName, String id) {
        Node node = this.findNode(nodeName, id);
        return this.convertNodeToObject(node);
    }

    public Externalizable convertNodeToObject(Node node) {
        return this.manageNode(node);
    }

    public Externalizable manageNode(Node node) {
        Externalizable obj = this.createObject(node);
        if (obj == null) {
            return null;
        }
        Externalizable retObj = obj.initializeFrom(node);
        if (retObj == null) {
            return obj;
        }
        NodeList children = node.getChildNodes();
        int childrenSize = children.getLength();
        int i = 0;
        while (i < childrenSize) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 3: {
                    Externalizable childObj = this.manageNode(child);
                    obj.add(childObj);
                    break;
                }
                case 1: {
                    Externalizable childObj = this.manageNode(child);
                    obj.add(childObj);
                    break;
                }
                case 9: {
                    System.out.println("DOCUMENT_NODE");
                    System.out.println(child.getNodeValue());
                    break;
                }
                case 8: {
                    Externalizable childObj = this.manageNode(child);
                    obj.add(childObj);
                    break;
                }
            }
            ++i;
        }
        return obj;
    }

    public Externalizable manageNode(Externalizable pObj, Node node) {
        Externalizable obj = this.createObject(node);
        if (obj == null) {
            return null;
        }
        pObj.add(obj);
        Externalizable retObj = obj.initializeFrom(node);
        if (retObj == null) {
            return obj;
        }
        NodeList children = node.getChildNodes();
        int childrenSize = children.getLength();
        int i = 0;
        while (i < childrenSize) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 3: {
                    Externalizable childObj = this.manageNode(obj, child);
                    break;
                }
                case 1: {
                    Externalizable childObj = this.manageNode(obj, child);
                    break;
                }
                case 9: {
                    System.out.println("DOCUMENT_NODE");
                    System.out.println(child.getNodeValue());
                    break;
                }
                case 8: {
                    Externalizable childObj = this.manageNode(child);
                    obj.add(childObj);
                    break;
                }
            }
            ++i;
        }
        return obj;
    }

    protected Externalizable createObject(Node node) {
        try {
            if (node.getNodeType() == 8) {
                XMLNode element = new XMLNode();
                element.setNodeName("#comment");
                element.setAttrValue("value", node.getNodeValue());
                return element;
            }
            Externalizable obj = null;
            int i = 0;
            while (i < this.objMakers.size()) {
                ObjectMaker objMaker = (ObjectMaker)this.objMakers.elementAt(i);
                obj = objMaker.createObject(node);
                if (obj != null) {
                    return obj;
                }
                ++i;
            }
            return obj;
        }
        catch (Exception e) {
            System.out.println("Error instantiating a bean from node: " + node.getNodeName() + ". " + e);
            return null;
        }
    }

    public void addObjectMaker(ObjectMaker maker) {
        this.objMakers.addElement(maker);
    }
}

