/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualJsp;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualJsp.TableCell;
import com.ecc.ide.editor.visualJsp.TableCellWrapper;
import com.ecc.ide.editor.visualJsp.VisualContainerWrapper;
import com.ecc.ide.editor.visualJsp.VisualJSPFramePanel;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import java.util.Vector;
import org.eclipse.swt.graphics.Point;

public class Table {
    private int x0;
    private int y0;
    private static int dftRows = 20;
    private static int dftColls = 20;
    private static int dftHeight = 30;
    private static int dftWidth = 50;
    private static int cellSpace = 2;
    TableCell nullCell = new TableCell();
    int rows = dftRows;
    int colls = dftColls;
    Object[] rowObjects;
    int[] cellWidths;
    int[] cellHeights;
    int tableRows = 0;
    int tableColls = 0;
    int height;
    int width;
    VisualContainerWrapper tableWrapper;

    public Table() {
        this.initialize();
    }

    public Table(int rows, int colls) {
        if (rows <= 0) {
            rows = dftRows;
        }
        if (colls <= 0) {
            colls = dftColls;
        }
        this.rows = rows;
        this.colls = colls;
        this.initialize();
    }

    private void initialize() {
        this.rowObjects = new Object[this.rows];
        int i = 0;
        while (i < this.rows) {
            this.rowObjects[i] = new Object[this.colls];
            ++i;
        }
        this.cellWidths = new int[this.colls];
        this.cellHeights = new int[this.rows];
        this.nullCell.isNullCell = true;
    }

    public Point getCellOffset(int row, int coll, int tableWidth) {
        this.resize(row, 0, coll, 0);
        int refCellWidth = tableWidth / (this.tableColls + 1);
        Object[] rowObject = (Object[])this.rowObjects[row];
        while (rowObject[coll] != null) {
            ++coll;
        }
        Point point = new Point(0, 0);
        int i = 0;
        while (i < coll) {
            point.x = this.cellWidths[i] > 0 ? (point.x += this.cellWidths[i]) : (point.x += refCellWidth);
            ++i;
        }
        i = 0;
        while (i < row) {
            point.y = this.cellHeights[i] > 0 ? (point.y += this.cellHeights[i]) : (point.y += dftHeight);
            ++i;
        }
        return point;
    }

    public void addCell(TableCell cell, int row, int coll) {
        if (this.tableRows < row) {
            this.tableRows = row;
        }
        if (this.tableColls < coll) {
            this.tableColls = coll;
        }
        this.resize(row, cell.rowspan, coll, cell.colspan);
        Object[] rowObject = (Object[])this.rowObjects[row];
        while (rowObject[coll] != null) {
            ++coll;
        }
        rowObject[coll] = cell;
        if (cell.width > 0) {
            int cellWidth = cell.width;
            if (cell.colspan <= 0 && this.cellWidths[coll] < cellWidth) {
                this.cellWidths[coll] = cellWidth;
            }
        }
        if (cell.height > 0) {
            int cellHeight = cell.height;
            if (cell.rowspan <= 0 && cellHeight > this.cellHeights[row]) {
                this.cellHeights[row] = cellHeight;
            }
        }
        if (cell.rowspan > 1) {
            int cols = cell.colspan;
            if (cols == 0) {
                cols = 1;
            }
            int i = 1;
            while (i < cell.rowspan) {
                int k = 0;
                while (k < cols) {
                    this.addCell(this.nullCell, row + i, coll + k);
                    ++k;
                }
                ++i;
            }
        } else {
            int k = 1;
            while (k < cell.colspan) {
                this.addCell(this.nullCell, row, coll + k);
                ++k;
            }
        }
    }

    public int getRows() {
        return this.tableRows;
    }

    public int getColls() {
        return this.tableColls;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public TableCell getCell(int row, int coll) {
        if (row > this.rows) {
            return null;
        }
        if (coll > this.colls) {
            return null;
        }
        Object[] aRow = (Object[])this.rowObjects[row];
        TableCell cell = (TableCell)aRow[coll];
        if (cell == null || cell.isNullCell) {
            return null;
        }
        return cell;
    }

    private void endLayout(int cltWidth, int cltHeight) {
        this.width = 0;
        this.height = 0;
        int cellWidth = cltWidth / this.tableColls;
        int dftHeight = cltHeight / this.tableRows;
        if (dftHeight <= 0) {
            dftHeight = Table.dftHeight;
        }
        int ww = 0;
        int c = this.tableColls;
        int i = 0;
        while (i < this.tableColls) {
            if (this.cellWidths[i] > 0) {
                ww += this.cellWidths[i];
                --c;
            }
            ++i;
        }
        if (c > 0) {
            cellWidth = (cltWidth - ww) / c;
        }
        i = 0;
        while (i < this.tableColls) {
            if (this.cellWidths[i] > 0) {
                this.width += this.cellWidths[i];
            } else {
                this.cellWidths[i] = cellWidth;
                this.width += cellWidth;
            }
            ++i;
        }
        boolean isFirst = true;
        int ii = 0;
        while (ii < this.rows) {
            isFirst = true;
            int kk = 0;
            while (kk < this.colls) {
                int row = ii;
                Object[] aRow = (Object[])this.rowObjects[row];
                int coll = kk;
                TableCell cell = (TableCell)aRow[coll];
                if (cell != null && !cell.isNullCell) {
                    int rs = cell.rowspan;
                    if (rs == 0) {
                        rs = 1;
                    }
                    int h = 0;
                    int i2 = 0;
                    while (i2 < rs) {
                        if (this.cellHeights[row + i2] > 0) {
                            h += this.cellHeights[row + i2];
                        } else {
                            this.cellHeights[row + i2] = dftHeight;
                            h += dftHeight;
                        }
                        ++i2;
                    }
                    cell.height = h;
                    int cs = cell.colspan;
                    if (cs == 0) {
                        cs = 1;
                    }
                    int w = 0;
                    int i3 = 0;
                    while (i3 < cs) {
                        w = this.cellWidths[coll + i3] > 0 ? (w += this.cellWidths[coll + i3]) : (w += dftWidth);
                        ++i3;
                    }
                    cell.width = w;
                    cell.x0 = 0;
                    i3 = 0;
                    while (i3 < coll) {
                        cell.x0 = this.cellWidths[i3] > 0 ? (cell.x0 += this.cellWidths[i3]) : (cell.x0 += dftWidth);
                        ++i3;
                    }
                    cell.y0 = 0;
                    i3 = 0;
                    while (i3 < row) {
                        cell.y0 = this.cellHeights[i3] > 0 ? (cell.y0 += this.cellHeights[i3]) : (cell.y0 += dftHeight);
                        ++i3;
                    }
                    cell.wrapper.width = cell.width - cellSpace;
                    cell.wrapper.height = cell.height - cellSpace;
                    cell.wrapper.layout(this.x0 + cell.x0 + 2 + 2, this.y0 + cell.y0 + 2 + 2, cell.width - 2 - 4);
                    cell.wrapper.width = cell.width - cellSpace;
                    cell.wrapper.height = cell.height - cellSpace;
                    if (isFirst) {
                        cell.wrapper.getParentWrapper().x = cell.wrapper.x;
                        cell.wrapper.getParentWrapper().y = cell.wrapper.y;
                        cell.wrapper.getParentWrapper().width = cell.wrapper.width;
                        cell.wrapper.getParentWrapper().height = cell.wrapper.height;
                        isFirst = false;
                    }
                }
                ++kk;
            }
            ++ii;
        }
        int i4 = 0;
        while (i4 < this.tableRows) {
            this.height = this.cellHeights[i4] > 0 ? (this.height += this.cellHeights[i4]) : (this.height += dftHeight);
            ++i4;
        }
    }

    public void endLayout(int x0, int y0, int cltWidth, int cltHeight) {
        this.x0 = x0;
        this.y0 = y0;
        ++this.tableRows;
        ++this.tableColls;
        this.endLayout(cltWidth, cltHeight);
    }

    private void resize(int row, int rowspan, int coll, int colspan) {
        int size;
        int colResize;
        int rowResize = 20;
        if (rowResize < rowspan) {
            rowResize = 20 + rowspan;
        }
        if ((colResize = 20) < colspan) {
            colResize = 20 + colspan;
        }
        if (row + rowspan >= this.rowObjects.length) {
            size = this.rowObjects.length + rowResize;
            Object[] tmp = new Object[size];
            int i = this.rowObjects.length;
            while (i < size) {
                tmp[i] = new Object[this.colls];
                ++i;
            }
            System.arraycopy(this.rowObjects, 0, tmp, 0, this.rowObjects.length);
            this.rowObjects = tmp;
            this.rows += rowResize;
            int[] iTmp = new int[this.rows];
            System.arraycopy(this.cellHeights, 0, iTmp, 0, this.cellHeights.length);
            this.cellHeights = iTmp;
        }
        if (coll + colspan >= this.colls) {
            size = this.colls + colResize;
            int i = 0;
            while (i < this.rows) {
                Object[] tmp = new Object[size];
                Object[] aRow = (Object[])this.rowObjects[i];
                System.arraycopy(aRow, 0, tmp, 0, this.colls);
                this.rowObjects[i] = tmp;
                ++i;
            }
            this.colls += colResize;
            int[] tmp = new int[this.colls];
            System.arraycopy(this.cellWidths, 0, tmp, 0, this.cellWidths.length);
            this.cellWidths = tmp;
        }
    }

    public void resizeTable(int width, int height) {
        try {
            TableCell cell;
            int dw = width - this.width;
            int dh = height - this.height;
            int ddw = dw / this.tableColls;
            int ddh = dh / this.tableRows;
            int i = 0;
            while (i < this.tableColls) {
                if (this.cellWidths[i] > 0) {
                    this.cellWidths[i] = this.cellWidths[i] + ddw;
                }
                ++i;
            }
            i = 0;
            while (i < this.tableRows) {
                this.cellHeights[i] = this.cellHeights[i] > 0 ? this.cellHeights[i] + ddh : height / this.rows;
                ++i;
            }
            this.endLayout(width, height);
            i = 0;
            while (i < this.tableColls) {
                int k = 0;
                while (k < this.tableRows) {
                    Object[] rowObject = (Object[])this.rowObjects[k];
                    cell = (TableCell)rowObject[i];
                    if (cell != null && !cell.isNullCell && cell.colspan <= 1) {
                        this.setAttrValue(cell, "width", String.valueOf(this.cellWidths[i]));
                        break;
                    }
                    ++k;
                }
                ++i;
            }
            i = 0;
            while (i < this.tableRows) {
                Object[] rowObject = (Object[])this.rowObjects[i];
                int k = 0;
                while (k < this.tableColls) {
                    cell = (TableCell)rowObject[k];
                    if (cell != null && !cell.isNullCell && cell.rowspan <= 1) {
                        this.setAttrValue(cell, "height", String.valueOf(this.cellHeights[i]));
                        break;
                    }
                    ++k;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resizeCell(TableCell cell, int width, int height) {
        int rowIdx = 0;
        int collIdx = 0;
        int i = 0;
        while (i < this.tableRows) {
            Object[] aTableRow = (Object[])this.rowObjects[i];
            int k = 0;
            while (k < this.tableColls) {
                if (cell == aTableRow[k]) {
                    rowIdx = i;
                    collIdx = k;
                    break;
                }
                ++k;
            }
            ++i;
        }
        int ww = 0;
        if (cell.colspan >= 1) {
            int i2 = 0;
            while (i2 < cell.colspan - 1) {
                ww += this.cellWidths[collIdx + i2];
                ++i2;
            }
            collIdx = collIdx + cell.colspan - 1;
        }
        if (cell.rowspan >= 1) {
            rowIdx = rowIdx + cell.rowspan - 1;
        }
        if (width != cell.width - 2) {
            int tableWidth = this.width;
            if ((width -= ww) < 5) {
                width = 5;
            }
            this.cellWidths[collIdx] = width;
            this.setCellWidth(collIdx, this.cellWidths[collIdx]);
            if (collIdx < this.tableColls - 1) {
                this.cellWidths[collIdx + 1] = ww - width;
                this.setCellWidth(collIdx, this.cellWidths[collIdx]);
            }
            this.endLayout(this.width, this.height);
        } else {
            int tableHeight = this.height;
            if (height < 5) {
                height = 5;
            }
            int dh = height - cell.height;
            this.height += dh;
            this.cellHeights[rowIdx] = this.cellHeights[rowIdx] + dh;
            this.setCellHeight(rowIdx, height);
            this.endLayout(this.width, this.height);
        }
    }

    public void insertTableRow(TableCell cell) {
        int rowIdx = 0;
        int collIdx = 0;
        int i = 0;
        while (i < this.tableRows) {
            Object[] aTableRow = (Object[])this.rowObjects[i];
            int k = 0;
            while (k < this.tableColls) {
                if (cell == aTableRow[k]) {
                    rowIdx = i;
                    collIdx = k;
                    break;
                }
                ++k;
            }
            ++i;
        }
        VisualContainerWrapper trWrapper = (VisualContainerWrapper)cell.wrapper.getParentWrapper();
        Element trElement = trWrapper.getElement();
        Element tdElement = cell.wrapper.getElement();
        VisualJSPFramePanel editor = (VisualJSPFramePanel)this.tableWrapper.editor;
        VisualContainerWrapper newTRWrapper = (VisualContainerWrapper)editor.insertNewElement(this.tableWrapper, trWrapper, trElement, 0, 0);
        this.resize(this.tableRows + 1, this.tableColls + 1, 1, 1);
        int i2 = rowIdx;
        while (i2 < this.tableRows) {
            this.cellWidths[i2 + 1] = this.cellWidths[i2];
            this.rowObjects[i2 + 1] = this.rowObjects[i2];
            ++i2;
        }
        Object[] oldRow = (Object[])this.rowObjects[rowIdx];
        Object[] newRow = new Object[this.colls];
        int i3 = 0;
        while (i3 < this.tableColls) {
            TableCell aCell = (TableCell)oldRow[i3];
            if (aCell == null) break;
            if (aCell.isNullCell) {
                newRow[i3] = this.nullCell;
                int k = rowIdx - 1;
                while (k >= 0) {
                    Object[] rowObj = (Object[])this.rowObjects[k];
                    TableCell ac = (TableCell)rowObj[i3];
                    if (ac != null && !ac.isNullCell) {
                        ++ac.rowspan;
                        this.setAttrValue(ac, "rowspan", String.valueOf(ac.rowspan));
                        break;
                    }
                    --k;
                }
            } else if (aCell.rowspan > 1) {
                ++aCell.rowspan;
                this.setAttrValue(aCell, "rowspan", String.valueOf(aCell.rowspan));
                newRow[i3] = this.nullCell;
            } else {
                TableCellWrapper newTdWrapper = (TableCellWrapper)editor.addNewElement(newTRWrapper, tdElement, 0, 0);
                TableCell newCell = (TableCell)aCell.clone();
                newCell.wrapper = newTdWrapper;
                if (newCell.colspan > 0) {
                    this.setAttrValue(newCell, "colspan", String.valueOf(newCell.colspan));
                }
                newTdWrapper.cell = newCell;
                newRow[i3] = newCell;
            }
            ++i3;
        }
        this.rowObjects[rowIdx] = newRow;
        this.tableWrapper.getXMLNode().fireContentChangedEvent();
    }

    public void mergeTableColl(TableCell cell) {
        int k;
        int rowIdx = 0;
        int collIdx = 0;
        int i = 0;
        while (i < this.tableRows) {
            Object[] aTableRow = (Object[])this.rowObjects[i];
            k = 0;
            while (k < this.tableColls) {
                if (cell == aTableRow[k]) {
                    rowIdx = i;
                    collIdx = k;
                    break;
                }
                ++k;
            }
            ++i;
        }
        Object[] tableRow = (Object[])this.rowObjects[rowIdx];
        TableCell nextCell = null;
        k = 0;
        k = collIdx + 1;
        while (k < this.tableColls) {
            nextCell = (TableCell)tableRow[k];
            if (nextCell != null && !nextCell.isNullCell) break;
            ++k;
        }
        if (nextCell == null || nextCell.isNullCell) {
            System.out.println("Cant merge the coll!");
            return;
        }
        if (nextCell.rowspan != cell.rowspan) {
            System.out.println("Cant merge the coll!");
            return;
        }
        tableRow[k] = this.nullCell;
        cell.width += nextCell.width;
        cell.wrapper.width = cell.width - 2;
        cell.colspan += nextCell.colspan;
        if (cell.colspan <= 1) {
            cell.colspan = 2;
        }
        this.setAttrValue(cell, "colspan", String.valueOf(cell.colspan));
        VisualJSPFramePanel editor = (VisualJSPFramePanel)this.tableWrapper.editor;
        editor.removeElement(nextCell.wrapper);
        int i2 = 0;
        while (i2 < nextCell.wrapper.childs.size()) {
            VisualElementWrapper aWrapper = (VisualElementWrapper)nextCell.wrapper.childs.elementAt(i2);
            aWrapper.setParent(cell.wrapper);
            cell.wrapper.addChild(aWrapper);
            editor.addWrapperToBeanTree(cell.wrapper, aWrapper);
            ++i2;
        }
        Vector childNodes = nextCell.wrapper.getXMLNode().getChilds();
        XMLNode pNode = cell.wrapper.getXMLNode();
        int i3 = 0;
        while (i3 < childNodes.size()) {
            pNode.add((XMLNode)childNodes.elementAt(i3));
            ++i3;
        }
        this.mergeNullColumn();
        cell.wrapper.layout(cell.wrapper.x, cell.wrapper.y, cell.width);
    }

    public void splitTableColl(TableCell cell) {
        int rowIdx = 0;
        int collIdx = 0;
        int i = 0;
        while (i < this.tableRows) {
            Object[] aTableRow = (Object[])this.rowObjects[i];
            int k = 0;
            while (k < this.tableColls) {
                if (cell == aTableRow[k]) {
                    rowIdx = i;
                    collIdx = k;
                    break;
                }
                ++k;
            }
            ++i;
        }
        VisualContainerWrapper trWrapper = (VisualContainerWrapper)cell.wrapper.getParentWrapper();
        Element trElement = trWrapper.getElement();
        Element tdElement = cell.wrapper.getElement();
        VisualJSPFramePanel editor = (VisualJSPFramePanel)this.tableWrapper.editor;
        Object[] rowObject = (Object[])this.rowObjects[rowIdx];
        if (cell.colspan > 1) {
            --cell.colspan;
            if (cell.colspan > 1) {
                cell.wrapper.setAttrValue("colspan", String.valueOf(cell.colspan));
            } else {
                cell.wrapper.setAttrValue("colspan", String.valueOf(cell.colspan));
            }
            TableCell aCell = (TableCell)rowObject[collIdx + cell.colspan - 1];
            TableCellWrapper newTdWrapper = (TableCellWrapper)editor.insertNewElement(trWrapper, cell.wrapper, tdElement, 0, 0);
            TableCell newCell = (TableCell)aCell.clone();
            newCell.wrapper = newTdWrapper;
            newTdWrapper.cell = newCell;
            rowObject[collIdx + cell.colspan - 1] = newCell;
            this.tableWrapper.getXMLNode().fireContentChangedEvent();
            return;
        }
        Object[] tableRow = (Object[])this.rowObjects[rowIdx];
        this.resize(this.tableRows + 1, this.tableColls + 1, 5, 5);
        int i2 = rowIdx;
        while (i2 < this.tableRows) {
            this.cellWidths[i2 + 1] = this.cellWidths[i2];
            ++i2;
        }
        this.cellWidths[rowIdx] = cell.width / 2;
        this.cellWidths[rowIdx + 1] = cell.width / 2;
        cell.width /= 2;
        TableCellWrapper newTdWrapper = (TableCellWrapper)editor.insertNewElement(trWrapper, cell.wrapper, tdElement, 0, 0);
        TableCell newCell = (TableCell)cell.clone();
        newCell.rowspan = cell.rowspan;
        if (newCell.rowspan > 1) {
            newTdWrapper.setAttrValue("rowspan", String.valueOf(newCell.rowspan));
        }
        newCell.x0 = cell.x0 + cell.width / 2;
        newCell.wrapper = newTdWrapper;
        newTdWrapper.cell = newCell;
        if (cell.colspan > 1) {
            rowObject[collIdx + cell.colspan - 1] = newCell;
        } else {
            rowObject[collIdx] = newCell;
        }
        int i3 = 0;
        while (i3 < this.tableRows) {
            tableRow = (Object[])this.rowObjects[i3];
            TableCell aCell = (TableCell)tableRow[collIdx];
            if (aCell != null) {
                if (aCell == newCell) {
                    if (aCell.rowspan > 1) {
                        i3 = i3 + aCell.rowspan - 1;
                    }
                } else if (aCell.isNullCell) {
                    this.insertCellToRow(tableRow, this.nullCell, collIdx);
                    int k = collIdx;
                    while (k >= 0) {
                        TableCell ac = (TableCell)tableRow[k];
                        if (ac != null && !ac.isNullCell) {
                            ++ac.colspan;
                            if (ac.colspan <= 1) {
                                ++ac.colspan;
                            }
                            this.setAttrValue(ac, "colspan", String.valueOf(ac.colspan));
                            break;
                        }
                        --k;
                    }
                } else {
                    ++aCell.colspan;
                    if (aCell.colspan <= 1) {
                        ++aCell.colspan;
                    }
                    this.setAttrValue(aCell, "colspan", String.valueOf(aCell.colspan));
                    this.insertCellToRow(tableRow, this.nullCell, collIdx + 1);
                }
            }
            ++i3;
        }
        this.tableWrapper.getXMLNode().fireContentChangedEvent();
    }

    public void splitTableRow(TableCell cell) {
        int rowIdx = 0;
        int collIdx = 0;
        int i = 0;
        while (i < this.tableRows) {
            Object[] aTableRow = (Object[])this.rowObjects[i];
            int k = 0;
            while (k < this.tableColls) {
                if (cell == aTableRow[k]) {
                    rowIdx = i;
                    collIdx = k;
                    break;
                }
                ++k;
            }
            ++i;
        }
        Object[] tableRow = (Object[])this.rowObjects[rowIdx];
        VisualContainerWrapper trWrapper = (VisualContainerWrapper)cell.wrapper.getParentWrapper();
        Element trElement = trWrapper.getElement();
        Element tdElement = cell.wrapper.getElement();
        VisualJSPFramePanel editor = (VisualJSPFramePanel)this.tableWrapper.editor;
        if (cell.rowspan > 1) {
            Object[] tableRow1 = (Object[])this.rowObjects[rowIdx + cell.rowspan - 1];
            TableCell nextCell = (TableCell)tableRow1[collIdx];
            VisualContainerWrapper nextTrWrapper = null;
            int idx = collIdx;
            while ((nextCell == null || nextCell.isNullCell) && idx >= 0) {
                nextCell = (TableCell)tableRow1[idx];
                --idx;
            }
            VisualContainerWrapper refWrapper = null;
            if (nextCell == null || nextCell.isNullCell) {
                int i2 = 0;
                while (i2 < this.tableColls) {
                    TableCell aCell = (TableCell)tableRow1[i2];
                    if (aCell != null && !aCell.isNullCell) {
                        nextTrWrapper = (VisualContainerWrapper)aCell.wrapper.getParentWrapper();
                        break;
                    }
                    ++i2;
                }
            } else {
                nextTrWrapper = (VisualContainerWrapper)nextCell.wrapper.getParentWrapper();
                refWrapper = nextCell.wrapper;
            }
            TableCellWrapper newTdWrapper = (TableCellWrapper)editor.insertNewElement(nextTrWrapper, refWrapper, tdElement, 0, 0);
            TableCell newCell = (TableCell)cell.clone();
            newCell.rowspan = 0;
            if (newCell.colspan > 1) {
                newTdWrapper.setAttrValue("colspan", String.valueOf(newCell.colspan));
            }
            newCell.wrapper = newTdWrapper;
            newTdWrapper.cell = newCell;
            tableRow1[collIdx] = newCell;
            --cell.rowspan;
            if (cell.rowspan > 1) {
                cell.wrapper.setAttrValue("rowspan", String.valueOf(cell.rowspan));
            } else {
                cell.wrapper.setAttrValue("rowspan", "");
            }
            this.tableWrapper.getXMLNode().fireContentChangedEvent();
            return;
        }
        this.resize(this.tableRows + 1, this.tableColls + 1, 1, 1);
        VisualContainerWrapper newTRWrapper = (VisualContainerWrapper)editor.insertNewElement(this.tableWrapper, trWrapper, trElement, 0, 0);
        int i3 = rowIdx;
        while (i3 < this.tableRows) {
            this.cellWidths[i3 + 1] = this.cellWidths[i3];
            this.rowObjects[i3 + 1] = this.rowObjects[i3];
            ++i3;
        }
        Object[] oldRow = (Object[])this.rowObjects[rowIdx];
        Object[] newRow = new Object[this.colls];
        int i4 = 0;
        while (i4 < this.tableColls) {
            newRow[i4] = this.nullCell;
            ++i4;
        }
        i4 = 0;
        while (i4 < this.tableColls) {
            TableCell aCell = (TableCell)oldRow[i4];
            if (aCell == null) break;
            if (aCell == cell) {
                if (aCell.colspan > 1) {
                    i4 = i4 + aCell.colspan - 1;
                }
            } else {
                int k;
                if (aCell.isNullCell) {
                    newRow[i4] = this.nullCell;
                    k = rowIdx - 1;
                    while (k >= 0) {
                        Object[] rowObj = (Object[])this.rowObjects[k];
                        TableCell ac = (TableCell)rowObj[i4];
                        if (ac != null && !ac.isNullCell) {
                            ++ac.rowspan;
                            this.setAttrValue(ac, "rowspan", String.valueOf(ac.rowspan));
                            break;
                        }
                        --k;
                    }
                } else {
                    ++aCell.rowspan;
                    if (aCell.rowspan <= 1) {
                        ++aCell.rowspan;
                    }
                    this.setAttrValue(aCell, "rowspan", String.valueOf(aCell.rowspan));
                    newRow[i4] = this.nullCell;
                }
                if (aCell.colspan > 1) {
                    k = i4;
                    while (k < i4 + aCell.colspan - 1) {
                        newRow[k] = this.nullCell;
                        ++k;
                    }
                    i4 = i4 + aCell.colspan - 1;
                }
            }
            ++i4;
        }
        TableCellWrapper newTdWrapper = (TableCellWrapper)editor.addNewElement(newTRWrapper, tdElement, 0, 0);
        TableCell newCell = (TableCell)cell.clone();
        newCell.rowspan = 0;
        if (newCell.colspan > 1) {
            newTdWrapper.setAttrValue("colspan", String.valueOf(newCell.colspan));
        }
        newCell.wrapper = newTdWrapper;
        newTdWrapper.cell = newCell;
        newRow[collIdx] = newCell;
        this.rowObjects[rowIdx] = newRow;
        this.tableWrapper.getXMLNode().fireContentChangedEvent();
    }

    public void mergeTableRow(TableCell cell) {
        int rowIdx = 0;
        int collIdx = 0;
        int i = 0;
        while (i < this.tableRows) {
            Object[] aTableRow = (Object[])this.rowObjects[i];
            int k = 0;
            while (k < this.tableColls) {
                if (cell == aTableRow[k]) {
                    rowIdx = i;
                    collIdx = k;
                    break;
                }
                ++k;
            }
            ++i;
        }
        TableCell nextCell = null;
        int k = rowIdx + 1;
        if (cell.rowspan > 1) {
            k += cell.rowspan;
        }
        Object[] tableRow = null;
        if (k >= this.tableRows) {
            return;
        }
        tableRow = (Object[])this.rowObjects[k];
        nextCell = (TableCell)tableRow[collIdx];
        if (nextCell == null || nextCell.isNullCell) {
            System.out.println("Cant merge the row!");
            return;
        }
        if (nextCell.colspan != cell.colspan) {
            System.out.println("Cant merge the row!");
            return;
        }
        tableRow[collIdx] = this.nullCell;
        cell.height += nextCell.height;
        cell.wrapper.height = cell.height - 2;
        cell.rowspan += nextCell.rowspan;
        if (cell.rowspan <= 1) {
            cell.rowspan = 2;
        }
        this.setAttrValue(cell, "rowspan", String.valueOf(cell.rowspan));
        VisualJSPFramePanel editor = (VisualJSPFramePanel)this.tableWrapper.editor;
        editor.removeElement(nextCell.wrapper);
        int i2 = 0;
        while (i2 < nextCell.wrapper.childs.size()) {
            VisualElementWrapper aWrapper = (VisualElementWrapper)nextCell.wrapper.childs.elementAt(i2);
            aWrapper.setParent(cell.wrapper);
            cell.wrapper.addChild(aWrapper);
            editor.addWrapperToBeanTree(cell.wrapper, aWrapper);
            ++i2;
        }
        Vector childNodes = nextCell.wrapper.getXMLNode().getChilds();
        XMLNode pNode = cell.wrapper.getXMLNode();
        int i3 = 0;
        while (i3 < childNodes.size()) {
            pNode.add((XMLNode)childNodes.elementAt(i3));
            ++i3;
        }
        this.mergeNullRow();
        cell.wrapper.layout(cell.wrapper.x, cell.wrapper.y, cell.width);
    }

    public void insertTableColl(TableCell cell) {
        int rowIdx = 0;
        int collIdx = 0;
        int i = 0;
        while (i < this.tableRows) {
            Object[] aTableRow = (Object[])this.rowObjects[i];
            int k = 0;
            while (k < this.tableColls) {
                if (cell == aTableRow[k]) {
                    rowIdx = i;
                    collIdx = k;
                    break;
                }
                ++k;
            }
            ++i;
        }
        VisualContainerWrapper trWrapper = (VisualContainerWrapper)cell.wrapper.getParentWrapper();
        Element trElement = trWrapper.getElement();
        Element tdElement = cell.wrapper.getElement();
        VisualJSPFramePanel editor = (VisualJSPFramePanel)this.tableWrapper.editor;
        this.resize(this.tableRows + 1, this.tableColls + 1, 1, 1);
        int i2 = rowIdx;
        while (i2 < this.tableRows) {
            this.cellWidths[i2 + 1] = this.cellWidths[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.tableRows) {
            Object[] tableRow = (Object[])this.rowObjects[i2];
            TableCell aCell = (TableCell)tableRow[collIdx];
            if (aCell != null) {
                if (aCell.isNullCell) {
                    this.insertCellToRow(tableRow, this.nullCell, collIdx);
                    int k = collIdx;
                    while (k >= 0) {
                        TableCell ac = (TableCell)tableRow[k];
                        if (ac != null && !ac.isNullCell) {
                            ++ac.colspan;
                            this.setAttrValue(ac, "colspan", String.valueOf(ac.colspan));
                            break;
                        }
                        --k;
                    }
                } else if (aCell.colspan > 1) {
                    ++aCell.colspan;
                    this.setAttrValue(aCell, "colspan", String.valueOf(aCell.colspan));
                    this.insertCellToRow(tableRow, this.nullCell, collIdx + 1);
                } else {
                    TableCellWrapper tdWrapper = (TableCellWrapper)aCell.wrapper;
                    VisualContainerWrapper atrWrapper = (VisualContainerWrapper)tdWrapper.getParentWrapper();
                    TableCellWrapper newTdWrapper = (TableCellWrapper)editor.insertNewElement(atrWrapper, tdWrapper, tdElement, 0, 0);
                    TableCell newCell = (TableCell)aCell.clone();
                    newCell.wrapper = newTdWrapper;
                    newTdWrapper.cell = newCell;
                    this.insertCellToRow(tableRow, newCell, collIdx + 1);
                    if (aCell.rowspan > 1) {
                        this.setAttrValue(newCell, "rowspan", String.valueOf(aCell.rowspan));
                        i2 += aCell.rowspan - 1;
                    }
                }
            }
            ++i2;
        }
        this.tableWrapper.getXMLNode().fireContentChangedEvent();
    }

    private void insertCellToRow(Object[] rowObject, Object newObject, int colIdx) {
        int i = colIdx;
        while (i < this.tableColls - 1) {
            rowObject[i + 1] = rowObject[i];
            ++i;
        }
        rowObject[colIdx] = newObject;
    }

    private void setCellWidth(int collIdx, int width) {
        int i = 0;
        while (i < this.tableRows) {
            Object[] rowObject = (Object[])this.rowObjects[i];
            TableCell cell = (TableCell)rowObject[collIdx];
            if (cell != null && !cell.isNullCell && cell.colspan <= 1) {
                this.setAttrValue(cell, "width", String.valueOf(width));
                break;
            }
            ++i;
        }
    }

    private void setCellHeight(int rowIdx, int height) {
        Object[] rowObject = (Object[])this.rowObjects[rowIdx];
        int i = 0;
        while (i < this.tableColls) {
            TableCell cell = (TableCell)rowObject[i];
            if (cell != null && !cell.isNullCell && cell.rowspan <= 1) {
                this.setAttrValue(cell, "height", String.valueOf(height));
                break;
            }
            ++i;
        }
    }

    private void setAttrValue(TableCell cell, String attrId, String value) {
        XMLNode node = cell.wrapper.getXMLNode();
        node.setAttrValue(attrId, value);
    }

    private void mergeNullRow() {
        int idx = 0;
        while (idx < this.tableRows) {
            Object[] rowObject = (Object[])this.rowObjects[idx];
            boolean isNullLine = true;
            int i = 0;
            while (i < this.tableColls) {
                TableCell cell = (TableCell)rowObject[i];
                if (cell != null && !cell.isNullCell) {
                    isNullLine = false;
                    break;
                }
                ++i;
            }
            if (isNullLine) {
                int col = 0;
                while (col < this.tableColls) {
                    int k = idx - 1;
                    while (k >= 0) {
                        Object[] rowObject1 = (Object[])this.rowObjects[k];
                        TableCell aCell = (TableCell)rowObject1[col];
                        if (aCell != null && !aCell.isNullCell) {
                            --aCell.rowspan;
                            if (aCell.rowspan > 1) {
                                aCell.wrapper.setAttrValue("rowspan", String.valueOf(aCell.rowspan));
                            } else {
                                aCell.wrapper.setAttrValue("rowspan", "");
                            }
                            if (aCell.colspan <= 1) break;
                            col = col + aCell.colspan - 1;
                            break;
                        }
                        --k;
                    }
                    ++col;
                }
                int k = idx;
                while (k < this.tableRows - 1) {
                    this.rowObjects[k] = this.rowObjects[k + 1];
                    ++k;
                }
                --this.tableRows;
                continue;
            }
            ++idx;
        }
    }

    private void mergeNullColumn() {
        int idx = 0;
        while (idx < this.tableColls) {
            Object[] rowObject;
            boolean isNullColumn = true;
            int i = 0;
            while (i < this.tableRows) {
                rowObject = (Object[])this.rowObjects[i];
                TableCell cell = (TableCell)rowObject[idx];
                if (cell != null && !cell.isNullCell) {
                    isNullColumn = false;
                    break;
                }
                ++i;
            }
            if (isNullColumn) {
                int row = 0;
                while (row < this.tableRows) {
                    Object[] rowObject1 = (Object[])this.rowObjects[row];
                    int k = idx - 1;
                    while (k >= 0) {
                        TableCell aCell = (TableCell)rowObject1[k];
                        if (aCell != null && !aCell.isNullCell) {
                            --aCell.colspan;
                            if (aCell.colspan > 1) {
                                aCell.wrapper.setAttrValue("colspan", String.valueOf(aCell.colspan));
                            } else {
                                aCell.wrapper.setAttrValue("colspan", "");
                            }
                            if (aCell.rowspan <= 1) break;
                            row = row + aCell.rowspan - 1;
                            break;
                        }
                        --k;
                    }
                    ++row;
                }
                int kk = 0;
                while (kk < this.tableRows) {
                    rowObject = (Object[])this.rowObjects[kk];
                    int k = idx;
                    while (k < this.tableColls - 1) {
                        rowObject[k] = rowObject[k + 1];
                        ++k;
                    }
                    ++kk;
                }
                --this.tableColls;
                continue;
            }
            ++idx;
        }
    }
}

