/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualJsp;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualJsp.TableCell;
import com.ecc.ide.editor.visualJsp.TableWrapper;
import com.ecc.ide.editor.visualJsp.VisualContainerWrapper;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import java.util.Vector;
import org.eclipse.swt.graphics.Rectangle;

public class TableCellWrapper
extends VisualContainerWrapper {
    TableCell cell;

    public TableCellWrapper() {
        this.setResizable(true);
        this.setResizeMode(3);
    }

    public TableCellWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        super(pWrapper, node, profile);
        this.setResizable(true);
        this.setResizeMode(3);
    }

    public void setBounds(Rectangle rect) {
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        TableWrapper tableWrapper = (TableWrapper)this.getParentWrapper().getParentWrapper();
        tableWrapper.setCellBounds(this.cell, width, height);
    }

    public void moveCurrsorUp() {
        this.moveToLastRow();
    }

    public void moveCurrsorDown() {
        this.moveToNextRow();
    }

    public void moveCurrsorLeft() {
        if (this.isHead) {
            if (this.currentCursor == 0) {
                this.moveToLastColumn();
                return;
            }
            this.isHead = false;
            this.currentCursor = this.getProperCursor(false);
        } else {
            this.isHead = true;
        }
    }

    public void moveCurrsorRight() {
        if (this.isHead) {
            this.isHead = false;
        } else {
            if (this.currentCursor >= this.childs.size() - 1) {
                this.moveToNextColumn();
                return;
            }
            this.isHead = true;
            this.currentCursor = this.getProperCursor(true);
        }
    }

    private int getProperCursor(boolean inc) {
        int cursorIdx = this.currentCursor + 1;
        int properIdx = this.currentCursor;
        if (inc) {
            while (cursorIdx < this.childs.size()) {
                VisualContainerWrapper wrapper = (VisualContainerWrapper)this.childs.elementAt(cursorIdx);
                if (wrapper.height > 10) {
                    properIdx = cursorIdx;
                } else if (cursorIdx < this.childs.size()) {
                    ++cursorIdx;
                    continue;
                }
                break;
            }
        } else {
            cursorIdx = this.currentCursor - 1;
            while (cursorIdx >= 0) {
                VisualContainerWrapper wrapper = (VisualContainerWrapper)this.childs.elementAt(cursorIdx);
                if (wrapper.height > 10) {
                    properIdx = cursorIdx;
                } else if (cursorIdx < this.childs.size()) {
                    --cursorIdx;
                    continue;
                }
                break;
            }
        }
        return properIdx;
    }

    public void moveToNextColumn() {
        Vector childs = this.getParentWrapper().childs;
        int idx = childs.indexOf(this);
        if (idx < childs.size() - 1) {
            VisualContainerWrapper nextWrapper = (VisualContainerWrapper)childs.elementAt(++idx);
            this.editor.setActivateWrapper(nextWrapper);
        }
    }

    public void moveToLastColumn() {
        Vector childs = this.getParentWrapper().childs;
        int idx = childs.indexOf(this);
        if (idx > 0) {
            VisualContainerWrapper nextWrapper = (VisualContainerWrapper)childs.elementAt(--idx);
            this.editor.setActivateWrapper(nextWrapper);
        }
    }

    public void moveToNextRow() {
        Vector childs = this.getParentWrapper().getParentWrapper().childs;
        int idx = childs.indexOf(this.getParentWrapper());
        if (idx < childs.size() - 1) {
            int rowSpan = this.cell.rowspan;
            if (rowSpan == 0) {
                rowSpan = 1;
            }
            VisualContainerWrapper nextRowWrapper = (VisualContainerWrapper)childs.elementAt(idx += rowSpan);
            idx = this.getParentWrapper().childs.indexOf(this);
            int columnIdx = 0;
            int i = 0;
            while (i <= idx) {
                TableCellWrapper cellWrapper = (TableCellWrapper)this.getParentWrapper().childs.elementAt(i);
                columnIdx = cellWrapper.cell.colspan > 0 ? (columnIdx += cellWrapper.cell.colspan) : ++columnIdx;
                ++i;
            }
            int idx1 = 0;
            int i2 = 0;
            while (i2 <= nextRowWrapper.childs.size()) {
                TableCellWrapper cellWrapper = (TableCellWrapper)nextRowWrapper.childs.elementAt(i2);
                idx1 = cellWrapper.cell.colspan > 0 ? (idx1 += cellWrapper.cell.colspan) : ++idx1;
                if (idx1 >= columnIdx) {
                    this.editor.setActivateWrapper(cellWrapper);
                    break;
                }
                ++i2;
            }
        }
    }

    public void moveToLastRow() {
        Vector childs = this.getParentWrapper().getParentWrapper().childs;
        int idx = childs.indexOf(this.getParentWrapper());
        if (idx > 0) {
            VisualContainerWrapper nextRowWrapper = (VisualContainerWrapper)childs.elementAt(--idx);
            idx = this.getParentWrapper().childs.indexOf(this);
            int columnIdx = 0;
            int i = 0;
            while (i <= idx) {
                TableCellWrapper cellWrapper = (TableCellWrapper)this.getParentWrapper().childs.elementAt(i);
                columnIdx = cellWrapper.cell.colspan > 0 ? (columnIdx += cellWrapper.cell.colspan) : ++columnIdx;
                ++i;
            }
            int idx1 = 0;
            int i2 = 0;
            while (i2 <= nextRowWrapper.childs.size()) {
                TableCellWrapper cellWrapper = (TableCellWrapper)nextRowWrapper.childs.elementAt(i2);
                idx1 = cellWrapper.cell.colspan > 0 ? (idx1 += cellWrapper.cell.colspan) : ++idx1;
                if (idx1 >= columnIdx) {
                    this.editor.setActivateWrapper(cellWrapper);
                    break;
                }
                ++i2;
            }
        }
    }
}

