/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualJsp;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualJsp.Table;
import com.ecc.ide.editor.visualJsp.TableCell;
import com.ecc.ide.editor.visualJsp.TableCellWrapper;
import com.ecc.ide.editor.visualJsp.VisualContainerWrapper;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class TableWrapper
extends VisualContainerWrapper {
    private VisualElementWrapper activateColumn;
    public static final int CELL_SPACE = 2;
    public static final int LEFT_MARGIN = 2;
    public static final int TOP_MARGIN = 2;
    private int cellSpace = 2;
    private int colls = 0;
    private int rows = 0;
    private Table table;

    public TableWrapper() {
        this.setResizable(true);
    }

    public TableWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        super(pWrapper, node, profile);
        this.setResizable(true);
    }

    public void drawMe(GC gc) {
        if (this.table == null) {
            return;
        }
        int rows = this.table.getRows();
        int colls = this.table.getColls();
        int xOffset = this.x;
        int yOffset = this.y;
        Color forColor = gc.getForeground();
        Color newForColor = Display.getDefault().getSystemColor(15);
        int i = 0;
        while (i < rows) {
            int k = 0;
            while (k < colls) {
                TableCell cell = this.table.getCell(i, k);
                if (cell != null) {
                    cell.wrapper.drawMe(gc);
                    gc.setForeground(newForColor);
                    gc.drawRectangle(xOffset + cell.x0 + this.cellSpace, yOffset + cell.y0 + this.cellSpace, cell.width - this.cellSpace, cell.height - this.cellSpace);
                    gc.setForeground(forColor);
                }
                ++k;
            }
            ++i;
        }
        gc.setForeground(newForColor);
        gc.drawRectangle(xOffset, yOffset, this.table.getWidth() + this.cellSpace, this.table.getHeight() + this.cellSpace);
        gc.setForeground(forColor);
        if (this.isActivated) {
            this.paintActivateSymbol(gc);
        }
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        this.drawMe(gc);
    }

    public void addChild(VisualElementWrapper child) {
        this.childs.addElement(child);
    }

    public void removeChild(VisualElementWrapper child) {
        this.childs.remove(child);
        this.node.remove(child.getXMLNode());
    }

    public Rectangle layout(int x0, int y0, int cltWidth) {
        this.table = new Table();
        this.table.tableWrapper = this;
        isLayout = true;
        this.x = x0;
        this.y = y0;
        int realWidth = 200;
        String widthStr = this.node.getAttrValue("width");
        int iW = this.getWidth(cltWidth, widthStr);
        if (iW != 0) {
            realWidth = iW;
        }
        int row = 0;
        int coll = 0;
        int realHeight = this.node.getIntAttrValue("height");
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.childs.elementAt(i);
            XMLNode node = wrapper.getXMLNode();
            if ("TR".equalsIgnoreCase(node.getNodeName())) {
                coll = 0;
                int k = 0;
                while (k < wrapper.childs.size()) {
                    VisualContainerWrapper tdWrapper = (VisualContainerWrapper)wrapper.childs.elementAt(k);
                    tdWrapper.setResizable(true);
                    XMLNode tdNode = tdWrapper.getXMLNode();
                    if ("TD".equalsIgnoreCase(tdNode.getNodeName()) || "TH".equalsIgnoreCase(tdNode.getNodeName())) {
                        Point point = this.table.getCellOffset(row, coll, realWidth);
                        int rowspan = tdNode.getIntAttrValue("rowspan");
                        int colspan = tdNode.getIntAttrValue("colspan");
                        int width = this.getWidth(cltWidth, tdNode.getAttrValue("width"));
                        int height = tdNode.getIntAttrValue("height");
                        TableCell cell = new TableCell();
                        cell.colspan = colspan;
                        cell.rowspan = rowspan;
                        cell.width = width;
                        cell.height = height;
                        cell.wrapper = tdWrapper;
                        ((TableCellWrapper)tdWrapper).cell = cell;
                        Rectangle rect = tdWrapper.layout(x0 + point.x + 2 + 2, y0 + point.y + 2 + this.cellSpace, width);
                        if (cell.height < rect.height + 2 + 4) {
                            cell.height = rect.height + 2 + 4;
                        }
                        if (cell.width < rect.width + 4) {
                            cell.width = rect.width + 4;
                        }
                        this.table.addCell(cell, row, coll);
                        coll = cell.colspan > 0 ? (coll += cell.colspan) : ++coll;
                    }
                    ++k;
                }
                ++row;
            }
            ++i;
        }
        this.table.endLayout(x0, y0, realWidth, realHeight);
        this.width = this.table.getWidth();
        this.height = this.table.getHeight();
        return new Rectangle(x0, y0, this.width + 4, this.height + 4);
    }

    private int getWidth(int cltWidth, String widthStr) {
        int realWidth = 0;
        if (widthStr != null) {
            int idx = widthStr.indexOf(37);
            if (idx != -1) {
                int percent = Integer.parseInt(widthStr.substring(0, idx));
                realWidth = cltWidth * percent / 100;
            } else {
                realWidth = Integer.parseInt(widthStr);
            }
        }
        return realWidth;
    }

    public void setBounds(Rectangle rect) {
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (width < this.table.getColls() * 5) {
            width = this.table.getColls() * 5;
        }
        if (height < this.table.getRows() * 10) {
            height = this.table.getRows() * 10;
        }
        this.width = width;
        this.height = height;
        this.getXMLNode().setAttrValue("width", String.valueOf(width));
        this.getXMLNode().setAttrValue("height", String.valueOf(height));
        this.table.resizeTable(width, height);
        isLayout = false;
    }

    public void splitTableCollumn(TableCellWrapper wrapper) {
        this.table.splitTableColl(wrapper.cell);
        isLayout = false;
    }

    public void splitTableRow(TableCellWrapper wrapper) {
        this.table.splitTableRow(wrapper.cell);
        isLayout = false;
    }

    public void insertRow(TableCellWrapper wrapper) {
        this.table.insertTableRow(wrapper.cell);
        isLayout = false;
    }

    public void insertColumn(TableCellWrapper wrapper) {
        this.table.insertTableColl(wrapper.cell);
        isLayout = false;
    }

    public void mergeTableColl(TableCellWrapper wrapper) {
        this.table.mergeTableColl(wrapper.cell);
        isLayout = false;
    }

    public void mergeTableRow(TableCellWrapper wrapper) {
        this.table.mergeTableRow(wrapper.cell);
        isLayout = false;
    }

    public void setCellBounds(TableCell cell, int width, int height) {
        this.table.resizeCell(cell, width, height);
        isLayout = false;
    }

    public boolean getIsCanSetTabOrder() {
        return false;
    }
}

