/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualJsp;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualJsp.VisualContainerWrapper;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import com.swtdesigner.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class VisualComponentWrapper
extends VisualContainerWrapper {
    public VisualComponentWrapper() {
        this.setMoveable(true);
    }

    public VisualComponentWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        super(pWrapper, node, profile);
        this.setMoveable(true);
    }

    public void drawMe(GC gc) {
        String text;
        Image image;
        Color color;
        Color forColor;
        int cltWidth = gc.getClipping().width;
        XMLNode node = this.getXMLNode();
        String nodeName = node.getNodeName();
        if ("SCRIPT".equalsIgnoreCase(nodeName)) {
            return;
        }
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper aChild = (VisualElementWrapper)this.childs.elementAt(i);
            if (aChild instanceof VisualComponentWrapper) {
                VisualComponentWrapper vc = (VisualComponentWrapper)aChild;
                vc.drawMe(gc);
            } else {
                aChild.paintControl(gc, 0, 0);
            }
            ++i;
        }
        if ("CTP:LABEL".equalsIgnoreCase(nodeName)) {
            String text2 = node.getAttrValue("text");
            if ((text2 = this.getExternResource(text2)) != null) {
                gc.drawText(text2, this.x, this.y, 6);
            }
        } else if ("CTP:BUTTON".equalsIgnoreCase(nodeName) || "BUTTON".equalsIgnoreCase(nodeName)) {
            this.draw3DRect(gc, this.x, this.y, this.width, this.height, 1, Display.getDefault().getSystemColor(22));
            String text3 = node.getAttrValue("text");
            text3 = this.getExternResource(text3);
            if (text3 != null) {
                gc.setBackground(Display.getDefault().getSystemColor(22));
                gc.setForeground(Display.getDefault().getSystemColor(2));
                int len = text3.getBytes().length;
                int xs = (this.width - (len *= averageCharWidth)) / 2 + this.x;
                gc.drawText(text3, xs, this.y + (this.height - 16) / 2);
            }
        } else if ("CTP:TEXTAREA".equalsIgnoreCase(nodeName) || "TEXTAREA".equalsIgnoreCase(nodeName)) {
            Color bkColor = gc.getBackground();
            forColor = gc.getForeground();
            color = new Color(null, 28, 81, 128);
            gc.setForeground(color);
            gc.drawRectangle(this.x, this.y, this.width, this.height);
            Color aColor = new Color(null, 243, 241, 236);
            gc.setForeground(aColor);
            gc.setBackground(aColor);
            gc.fillRectangle(this.x + this.width - 17, this.y + 2, 16, this.height - 20);
            gc.fillRectangle(this.x + 2, this.y + this.height - 19, this.width - 2, 16);
            gc.setBackground(Display.getDefault().getSystemColor(1));
            gc.fillGradientRectangle(this.x + this.width - 17, this.y + 2, 16, this.height - 20, false);
            gc.fillGradientRectangle(this.x + 2, this.y + this.height - 19, this.width - 20, 16, true);
            gc.setForeground(Display.getDefault().getSystemColor(1));
            gc.setBackground(aColor);
            gc.fillRectangle(this.x + this.width - 17 + 1, this.y + 2, 15, 15);
            gc.drawRectangle(this.x + this.width - 17 + 1, this.y + 2, 15, 15);
            gc.fillRectangle(this.x + this.width - 17 + 1, this.y + this.height - 19 - 16, 15, 15);
            gc.drawRectangle(this.x + this.width - 17 + 1, this.y + this.height - 19 - 16, 15, 15);
            gc.fillRectangle(this.x + 3, this.y + this.height - 18, 15, 15);
            gc.drawRectangle(this.x + 3, this.y + this.height - 18, 15, 15);
            gc.fillRectangle(this.x + this.width - 17 - 18, this.y + this.height - 18, 15, 15);
            gc.drawRectangle(this.x + this.width - 17 - 18, this.y + this.height - 18, 15, 15);
            gc.setForeground(forColor);
            gc.setBackground(bkColor);
            color.dispose();
            aColor.dispose();
        } else if ("ctp:text".equalsIgnoreCase(nodeName)) {
            if (this.getElement() != null) {
                Image image2 = this.getElement().getImage();
                if (image2 != null) {
                    gc.drawImage(image2, this.x + 2, this.y + 2);
                }
                this.width = 20;
            }
        } else if ("CTP:INPUT".equalsIgnoreCase(nodeName) || "INPUT".equalsIgnoreCase(nodeName)) {
            String type = node.getAttrValue("type");
            if (type != null) {
                type = type.toLowerCase();
            }
            if ("button".equals(type) || "reset".equals(type) || "submit".equals(type)) {
                Color bkColor = gc.getBackground();
                Color forColor2 = gc.getForeground();
                Color color2 = new Color(null, 0, 60, 116);
                gc.setBackground(Display.getDefault().getSystemColor(15));
                gc.setForeground(Display.getDefault().getSystemColor(1));
                gc.fillGradientRectangle(this.x, this.y, this.width, this.height, true);
                gc.setForeground(color2);
                gc.drawRoundRectangle(this.x + 1, this.y + 1, this.width - 2, this.height - 2, 6, 6);
                gc.setForeground(forColor2);
                gc.setBackground(bkColor);
                color2.dispose();
            } else if ("radio".equals(type)) {
                forColor = gc.getForeground();
                color = new Color(null, 127, 157, 185);
                int ww = 13;
                gc.setForeground(color);
                gc.drawArc(this.x + 2, this.y + (this.height - ww) / 2, ww, ww, 0, 360);
                gc.setForeground(forColor);
                color.dispose();
            } else if ("checkbox".equals(type)) {
                forColor = gc.getForeground();
                color = new Color(null, 28, 81, 128);
                int ww = 13;
                gc.setForeground(color);
                gc.drawRectangle(this.x + 2, this.y + (this.height - ww) / 2, ww, ww);
                gc.setForeground(forColor);
                color.dispose();
            } else if ("hidden".equals(type)) {
                image = ResourceManager.getImage(this.getClass(), "/images/hiddenField.gif");
                if (image != null) {
                    gc.drawImage(image, this.x + 2, this.y + 2);
                }
                this.width = 20;
            } else {
                forColor = gc.getForeground();
                color = new Color(null, 127, 157, 185);
                gc.setForeground(color);
                gc.drawRectangle(this.x, this.y, this.width, this.height);
                gc.setForeground(forColor);
                color.dispose();
            }
        } else if ("ctp:jspAction".equalsIgnoreCase(nodeName) || "ctp:URL".equalsIgnoreCase(nodeName) || "ctp:srvOpAction".equalsIgnoreCase(nodeName) || "do".equalsIgnoreCase(nodeName) || "cmdItem".equalsIgnoreCase(nodeName)) {
            String text4 = node.getAttrValue("label");
            if (text4 == null || text4.length() == 0) {
                text4 = nodeName;
            }
            forColor = gc.getForeground();
            color = Display.getDefault().getSystemColor(9);
            gc.setForeground(color);
            Rectangle rect = gc.getClipping();
            gc.setClipping(this.x, this.y, this.width, this.height);
            gc.drawText(text4, this.x + 3, this.y + 3);
            int h = gc.getFontMetrics().getHeight();
            gc.drawLine(this.x + 3, this.y + h + 4, this.x + this.width - 6, this.y + h + 4);
            gc.setForeground(forColor);
            gc.setClipping(rect);
        } else if ("ctp:data".equalsIgnoreCase(nodeName) || "ctp:pageIndex".equalsIgnoreCase(nodeName)) {
            String text5 = node.getAttrValue("name");
            if (text5 == null || text5.length() == 0) {
                text5 = nodeName;
            }
            forColor = gc.getForeground();
            color = Display.getDefault().getSystemColor(16);
            gc.setForeground(color);
            Rectangle rect = gc.getClipping();
            gc.setClipping(this.x, this.y, this.width, this.height);
            gc.drawText(text5, this.x + 3, this.y + 3);
            gc.setForeground(forColor);
            gc.setClipping(rect);
        } else if ("#text".equalsIgnoreCase(nodeName) && (text = node.getTextValue()) != null) {
            if (text.trim().startsWith("<%")) {
                image = ResourceManager.getImage(this.getClass(), "/images/jsp.gif");
                if (image != null) {
                    gc.drawImage(image, this.x + 2, this.y + 2);
                }
                this.width = 20;
            } else {
                text = text.trim();
                if (node.getParent() != null && "A".equalsIgnoreCase(node.getParent().getNodeName())) {
                    forColor = gc.getForeground();
                    color = Display.getDefault().getSystemColor(9);
                    gc.setForeground(color);
                    Rectangle rect = gc.getClipping();
                    gc.setClipping(this.x, this.y, this.width, this.height);
                    gc.drawText(text, this.x + 3, this.y + 3);
                    int h = gc.getFontMetrics().getHeight();
                    gc.drawLine(this.x + 3, this.y + h + 4, this.x + this.width - 6, this.y + h + 4);
                    gc.setForeground(forColor);
                    gc.setClipping(rect);
                } else {
                    Rectangle rect = gc.getClipping();
                    gc.setClipping(this.x, this.y, this.width, this.height);
                    gc.drawText(text, this.x + 3, this.y + 3, 3);
                    gc.setClipping(rect);
                }
            }
        }
        if (this.isActivated) {
            this.paintActivateSymbol(gc);
        }
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        this.drawMe(gc);
    }

    public String toString() {
        return "VisualComponentWrapper: <" + this.node.toString() + ">";
    }

    public Rectangle layout(int x0, int y0, int cltWidth) {
        return super.layout(x0, y0, cltWidth);
    }
}

