/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualJsp;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import com.swtdesigner.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class VisualContainerWrapper
extends VisualElementWrapper {
    protected boolean isHead = true;
    protected int currentCursor = 0;
    public static boolean isLayout = false;
    public static int LEFT_MARGIN = 2;
    public static int TOP_MARGIN = 2;
    static final int LINE_SPACE = 10;
    static final int TEXT_LINE_HEIGHT = 15;
    private static int clientWidth = 0;
    static int averageCharWidth = 8;
    int borderWidth = 5;
    private String objectName;

    public VisualContainerWrapper() {
        this.setMoveable(false);
        this.setResizable(false);
    }

    public VisualContainerWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        this.node = node;
        this.parentWrapper = pWrapper;
        if (pWrapper != null) {
            this.parentWrapper.addChild(this);
        }
        this.width = 50;
        this.height = 25;
        try {
            this.width = Integer.parseInt(node.getAttrValue("width"));
            this.height = Integer.parseInt(node.getAttrValue("height"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.element = profile.getElement(node.getNodeName());
        this.objectName = node.getAttrValue("name");
        if (this.objectName == null && this.element != null) {
            this.objectName = this.element.getObjectName();
        }
        this.setMoveable(false);
        this.setResizable(false);
    }

    public void drawMe(GC gc) {
        String text;
        Image image;
        Color color;
        Color forColor;
        Color forColor2;
        XMLNode node;
        String nodeName;
        int cltWidth = gc.getClipping().width;
        averageCharWidth = gc.getFontMetrics().getAverageCharWidth();
        if (!isLayout) {
            this.layout(LEFT_MARGIN, TOP_MARGIN, cltWidth - 50);
        } else if (clientWidth != cltWidth) {
            this.layout(LEFT_MARGIN, TOP_MARGIN, cltWidth - 50);
        }
        clientWidth = cltWidth;
        if (this.width <= 0) {
            this.width = 50;
        }
        if (this.height <= 0) {
            this.height = 20;
        }
        if ("SCRIPT".equalsIgnoreCase(nodeName = (node = this.getXMLNode()).getNodeName())) {
            return;
        }
        if ("BODY".equalsIgnoreCase(nodeName)) {
            Color bkColor = gc.getBackground();
            gc.fillRectangle(0, 0, gc.getClipping().width, gc.getClipping().height);
        }
        if ("FORM".equalsIgnoreCase(nodeName) || "CTP:FORM".equalsIgnoreCase(nodeName)) {
            forColor2 = gc.getForeground();
            gc.setForeground(Display.getDefault().getSystemColor(3));
            gc.setLineStyle(3);
            gc.drawRectangle(this.x, this.y, this.width, this.height);
            gc.setLineStyle(1);
            gc.setForeground(forColor2);
        }
        if ("DIV".equalsIgnoreCase(nodeName)) {
            forColor2 = gc.getForeground();
            gc.setForeground(Display.getDefault().getSystemColor(13));
            gc.setLineStyle(3);
            gc.drawRectangle(this.x, this.y, this.width, this.height);
            gc.setLineStyle(1);
            gc.setForeground(forColor2);
        }
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper aChild = (VisualElementWrapper)this.childs.elementAt(i);
            if (aChild instanceof VisualContainerWrapper) {
                VisualContainerWrapper vc = (VisualContainerWrapper)aChild;
                vc.drawMe(gc);
            } else {
                aChild.paintControl(gc, 0, 0);
            }
            ++i;
        }
        if ("CTP:LABEL".equalsIgnoreCase(nodeName)) {
            String text2 = node.getAttrValue("text");
            if ((text2 = this.getExternResource(text2)) != null) {
                gc.drawText(text2, this.x, this.y, 6);
            }
        } else if ("CTP:BUTTON".equalsIgnoreCase(nodeName) || "BUTTON".equalsIgnoreCase(nodeName)) {
            this.draw3DRect(gc, this.x, this.y, this.width, this.height, 1, Display.getDefault().getSystemColor(22));
            String text3 = node.getAttrValue("text");
            text3 = this.getExternResource(text3);
            if (text3 != null) {
                gc.setBackground(Display.getDefault().getSystemColor(22));
                gc.setForeground(Display.getDefault().getSystemColor(2));
                int len = text3.getBytes().length;
                int xs = (this.width - (len *= averageCharWidth)) / 2 + this.x;
                gc.drawText(text3, xs, this.y + (this.height - 16) / 2);
            }
        } else if ("CTP:TEXTAREA".equalsIgnoreCase(nodeName) || "TEXTAREA".equalsIgnoreCase(nodeName)) {
            Color bkColor = gc.getBackground();
            forColor = gc.getForeground();
            color = new Color(null, 28, 81, 128);
            gc.setForeground(color);
            gc.drawRectangle(this.x, this.y, this.width, this.height);
            Color aColor = new Color(null, 243, 241, 236);
            gc.setForeground(aColor);
            gc.setBackground(aColor);
            gc.fillRectangle(this.x + this.width - 17, this.y + 2, 16, this.height - 20);
            gc.fillRectangle(this.x + 2, this.y + this.height - 19, this.width - 2, 16);
            gc.setBackground(Display.getDefault().getSystemColor(1));
            gc.fillGradientRectangle(this.x + this.width - 17, this.y + 2, 16, this.height - 20, false);
            gc.fillGradientRectangle(this.x + 2, this.y + this.height - 19, this.width - 20, 16, true);
            gc.setForeground(Display.getDefault().getSystemColor(1));
            gc.setBackground(aColor);
            gc.fillRectangle(this.x + this.width - 17 + 1, this.y + 2, 15, 15);
            gc.drawRectangle(this.x + this.width - 17 + 1, this.y + 2, 15, 15);
            gc.fillRectangle(this.x + this.width - 17 + 1, this.y + this.height - 19 - 16, 15, 15);
            gc.drawRectangle(this.x + this.width - 17 + 1, this.y + this.height - 19 - 16, 15, 15);
            gc.fillRectangle(this.x + 3, this.y + this.height - 18, 15, 15);
            gc.drawRectangle(this.x + 3, this.y + this.height - 18, 15, 15);
            gc.fillRectangle(this.x + this.width - 17 - 18, this.y + this.height - 18, 15, 15);
            gc.drawRectangle(this.x + this.width - 17 - 18, this.y + this.height - 18, 15, 15);
            gc.setForeground(forColor);
            gc.setBackground(bkColor);
            color.dispose();
            aColor.dispose();
        } else if ("ctp:text".equalsIgnoreCase(nodeName)) {
            if (this.getElement() != null) {
                Image image2 = this.getElement().getImage();
                if (image2 != null) {
                    gc.drawImage(image2, this.x + 2, this.y + 2);
                }
                this.width = 20;
            }
        } else if ("CTP:INPUT".equalsIgnoreCase(nodeName) || "INPUT".equalsIgnoreCase(nodeName)) {
            String type = node.getAttrValue("type");
            if (type != null) {
                type = type.toLowerCase();
            }
            if ("button".equals(type) || "reset".equals(type) || "submit".equals(type)) {
                Color bkColor = gc.getBackground();
                Color forColor3 = gc.getForeground();
                Color color2 = new Color(null, 0, 60, 116);
                gc.setBackground(Display.getDefault().getSystemColor(15));
                gc.setForeground(Display.getDefault().getSystemColor(1));
                gc.fillGradientRectangle(this.x, this.y, this.width, this.height, true);
                gc.setForeground(color2);
                gc.drawRoundRectangle(this.x + 1, this.y + 1, this.width - 2, this.height - 2, 6, 6);
                gc.setForeground(forColor3);
                gc.setBackground(bkColor);
                color2.dispose();
            } else if ("radio".equals(type)) {
                forColor = gc.getForeground();
                color = new Color(null, 127, 157, 185);
                int ww = 13;
                gc.setForeground(color);
                gc.drawArc(this.x + 2, this.y + (this.height - ww) / 2, ww, ww, 0, 360);
                gc.setForeground(forColor);
                color.dispose();
            } else if ("checkbox".equals(type)) {
                forColor = gc.getForeground();
                color = new Color(null, 28, 81, 128);
                int ww = 13;
                gc.setForeground(color);
                gc.drawRectangle(this.x + 2, this.y + (this.height - ww) / 2, ww, ww);
                gc.setForeground(forColor);
                color.dispose();
            } else if ("hidden".equals(type)) {
                image = ResourceManager.getImage(this.getClass(), "/images/hiddenField.gif");
                if (image != null) {
                    gc.drawImage(image, this.x + 2, this.y + 2);
                }
                this.width = 20;
            } else {
                forColor = gc.getForeground();
                color = new Color(null, 127, 157, 185);
                gc.setForeground(color);
                gc.drawRectangle(this.x, this.y, this.width, this.height);
                gc.setForeground(forColor);
                color.dispose();
            }
        } else if ("ctp:jspAction".equalsIgnoreCase(nodeName) || "ctp:URL".equalsIgnoreCase(nodeName) || "ctp:srvOpAction".equalsIgnoreCase(nodeName) || "do".equalsIgnoreCase(nodeName)) {
            String text4 = node.getAttrValue("label");
            if (text4 == null || text4.length() == 0) {
                text4 = nodeName;
            }
            forColor = gc.getForeground();
            color = Display.getDefault().getSystemColor(9);
            gc.setForeground(color);
            Rectangle rect = gc.getClipping();
            gc.setClipping(this.x, this.y, this.width, this.height);
            gc.drawText(text4, this.x + 3, this.y + 3);
            int h = gc.getFontMetrics().getHeight();
            gc.drawLine(this.x + 3, this.y + h + 4, this.x + this.width - 6, this.y + h + 4);
            gc.setForeground(forColor);
            gc.setClipping(rect);
        } else if ("#text".equalsIgnoreCase(nodeName) && (text = node.getTextValue()) != null) {
            if (text.trim().startsWith("<%")) {
                image = ResourceManager.getImage(this.getClass(), "/images/jsp.gif");
                if (image != null) {
                    gc.drawImage(image, this.x + 2, this.y + 2);
                }
                this.width = 20;
            } else {
                text = text.trim();
                if (node.getParent() != null && "A".equalsIgnoreCase(node.getParent().getNodeName())) {
                    forColor = gc.getForeground();
                    color = Display.getDefault().getSystemColor(9);
                    gc.setForeground(color);
                    Rectangle rect = gc.getClipping();
                    gc.setClipping(this.x, this.y, this.width, this.height);
                    gc.drawText(text, this.x + 3, this.y + 3);
                    int h = gc.getFontMetrics().getHeight();
                    gc.drawLine(this.x + 3, this.y + h + 4, this.x + this.width - 6, this.y + h + 4);
                    gc.setForeground(forColor);
                    gc.setClipping(rect);
                } else {
                    Rectangle rect = gc.getClipping();
                    gc.setClipping(this.x, this.y, this.width, this.height);
                    gc.drawText(text, this.x + 3, this.y + 3, 3);
                    gc.setClipping(rect);
                }
            }
        }
        if (this.isActivated) {
            this.paintActivateSymbol(gc);
        }
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        this.drawMe(gc);
    }

    public String getObjectName() {
        String nodeName = this.node.getNodeName();
        return nodeName;
    }

    public void setObjectName(String objName) {
        this.objectName = objName;
    }

    public Rectangle getRectangle() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle getBound(int refWidth) {
        String nodeName = this.node.getNodeName();
        if ("CTP:LABEL".equalsIgnoreCase(nodeName)) {
            int width;
            String text = this.node.getAttrValue("text");
            int height = 20;
            if (text != null) {
                width = averageCharWidth * text.getBytes().length;
                if (refWidth > 0 && width > refWidth) {
                    height = 20 * (1 + width / refWidth);
                    width = refWidth;
                }
            } else {
                width = refWidth;
            }
            return new Rectangle(0, 0, width, height);
        }
        if ("CTP:TEXTAREA".equalsIgnoreCase(nodeName) || "TEXTAREA".equalsIgnoreCase(nodeName)) {
            int cols = this.node.getIntAttrValue("cols");
            int rows = this.node.getIntAttrValue("rows");
            if (cols == 0) {
                cols = 20;
            }
            if (rows == 0) {
                rows = 4;
            }
            int height = rows * 15;
            int width = averageCharWidth * cols;
            return new Rectangle(0, 0, width, height);
        }
        if ("CTP:BUTTON".equalsIgnoreCase(nodeName)) {
            String text = this.node.getAttrValue("text");
            int width = (text = this.getExternResource(text)) != null ? averageCharWidth * text.getBytes().length + 10 : refWidth;
            int height = 20;
            return new Rectangle(0, 0, width, height);
        }
        if ("CTP:INPUT".equalsIgnoreCase(nodeName) || "INPUT".equalsIgnoreCase(nodeName)) {
            int size = this.node.getIntAttrValue("size");
            if (size == 0) {
                size = 8;
            }
            int width = size * 8;
            int height = 20;
            return new Rectangle(0, 0, width, height);
        }
        if ("CTP:COMBOBOX".equalsIgnoreCase(nodeName)) {
            int size = this.node.getIntAttrValue("size");
            if (size == 0) {
                size = 8;
            }
            int width = size * 8;
            int height = 20;
            return new Rectangle(0, 0, width, height);
        }
        if ("#text".equalsIgnoreCase(nodeName)) {
            int width;
            String text = this.node.getTextValue();
            int height = 20;
            if (text != null) {
                if (text.trim().startsWith("<%")) {
                    width = 20;
                } else if (text.trim().length() == 0) {
                    width = 1;
                    height = 1;
                } else {
                    width = averageCharWidth * text.getBytes().length;
                    if (refWidth > 0 && width > refWidth) {
                        height = 15 * (1 + width / refWidth);
                        width = refWidth;
                    }
                }
            } else {
                width = refWidth;
                int size = this.node.getIntAttrValue("size");
                if (size == 0) {
                    size = 8;
                }
                width = size * 8;
                height = 20;
            }
            return new Rectangle(0, 0, width, height);
        }
        if ("BR".equalsIgnoreCase(nodeName)) {
            return new Rectangle(0, 0, 1, 1);
        }
        if ("DIV".equalsIgnoreCase(nodeName)) {
            return new Rectangle(0, 0, 150, 20);
        }
        return new Rectangle(0, 0, 50, 20);
    }

    public Rectangle layout(int x0, int y0, int cltWidth) {
        isLayout = true;
        if (this.childs.size() == 0) {
            Rectangle rect = this.getBound(cltWidth);
            this.width = rect.width;
            this.height = rect.height;
            this.x = x0;
            this.y = y0;
            return rect;
        }
        int yOffset = y0 + TOP_MARGIN;
        int xOffset = x0 + LEFT_MARGIN;
        int lineHeight = 0;
        this.height = 0;
        this.width = 0;
        int w = 0;
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper aChild = (VisualElementWrapper)this.childs.elementAt(i);
            if (aChild instanceof VisualContainerWrapper) {
                VisualContainerWrapper vc = (VisualContainerWrapper)aChild;
                if (vc.shoudChangeLine()) {
                    xOffset = x0 + LEFT_MARGIN;
                    yOffset += lineHeight;
                    if (this.width < w) {
                        this.width = w;
                    }
                    w = 0;
                    this.height += lineHeight;
                    lineHeight = 0;
                }
                Rectangle rect = vc.layout(xOffset, yOffset, cltWidth);
                w += rect.width;
                if (lineHeight < rect.height) {
                    lineHeight = rect.height;
                }
                if (vc.shoudChangeLine()) {
                    xOffset = x0 + LEFT_MARGIN;
                    yOffset = yOffset + lineHeight + 10;
                    if (this.width < w) {
                        this.width = w;
                    }
                    w = 0;
                    this.height = this.height + lineHeight + 10;
                    lineHeight = 0;
                } else if (xOffset + rect.width >= cltWidth) {
                    xOffset = x0 + LEFT_MARGIN;
                    yOffset += lineHeight;
                    if (this.width < w) {
                        this.width = w;
                    }
                    w = 0;
                    this.height += lineHeight;
                    lineHeight = 0;
                } else {
                    xOffset += rect.width;
                }
            }
            ++i;
        }
        this.height += lineHeight;
        if (this.width < w) {
            this.width = w;
        }
        this.x = x0;
        this.y = y0;
        this.width += 2 * LEFT_MARGIN;
        if (this.width < 10) {
            this.width = 120;
        }
        if (this.height < 10) {
            this.height = 20;
        }
        this.height += 2 * TOP_MARGIN;
        return new Rectangle(x0, y0, this.width, this.height);
    }

    public boolean shoudChangeLine() {
        String nodeName = this.node.getNodeName();
        if ("TABLE".equalsIgnoreCase(nodeName)) {
            return true;
        }
        if ("DIV".equalsIgnoreCase(nodeName)) {
            return true;
        }
        if ("BR".equalsIgnoreCase(nodeName)) {
            return true;
        }
        if ("P".equalsIgnoreCase(nodeName)) {
            return true;
        }
        if ("card".equalsIgnoreCase(nodeName)) {
            return true;
        }
        if ("FORM".equalsIgnoreCase(nodeName)) {
            return true;
        }
        return "ctp:form".equalsIgnoreCase(nodeName);
    }

    protected void paintActivateSymbol(GC gc) {
        Color forColor = gc.getForeground();
        Color bkColor = gc.getBackground();
        gc.setForeground(Display.getDefault().getSystemColor(9));
        gc.setLineStyle(3);
        gc.drawRectangle(this.x - 1, this.y - 1, this.width + 2, this.height + 2);
        gc.setLineStyle(1);
        gc.setBackground(Display.getDefault().getSystemColor(2));
        if (this.getResizeable()) {
            gc.fillRectangle(this.x - this.borderWidth, this.y - this.borderWidth, this.borderWidth, this.borderWidth);
            gc.fillRectangle(this.x + (this.width - this.borderWidth) / 2, this.y - this.borderWidth, this.borderWidth, this.borderWidth);
            gc.fillRectangle(this.x + this.width, this.y - this.borderWidth, this.borderWidth, this.borderWidth);
            gc.fillRectangle(this.x - this.borderWidth, this.y + (this.height - this.borderWidth) / 2, this.borderWidth, this.borderWidth);
            gc.fillRectangle(this.x + this.width, this.y + (this.height - this.borderWidth) / 2, this.borderWidth, this.borderWidth);
            gc.fillRectangle(this.x - this.borderWidth, this.y + this.height, this.borderWidth, this.borderWidth);
            gc.fillRectangle(this.x + (this.width - this.borderWidth) / 2, this.y + this.height, this.borderWidth, this.borderWidth);
            gc.fillRectangle(this.x + this.width, this.y + this.height, this.borderWidth, this.borderWidth);
        }
        gc.setForeground(forColor);
        gc.setBackground(bkColor);
        this.paintCurrentCursorSymbol(gc);
    }

    protected void paintCurrentCursorSymbol(GC gc) {
        if (this.childs.size() == 0 || this.currentCursor >= this.childs.size()) {
            return;
        }
        Color forColor = gc.getForeground();
        VisualContainerWrapper curWrapper = (VisualContainerWrapper)this.childs.elementAt(this.currentCursor);
        int x1 = curWrapper.x;
        if (!this.isHead) {
            x1 += curWrapper.width;
        }
        int y1 = curWrapper.y;
        int y2 = curWrapper.y + curWrapper.height;
        gc.setForeground(Display.getDefault().getSystemColor(3));
        gc.setLineWidth(2);
        gc.drawLine(x1, y1, x1, y2);
        gc.setLineWidth(1);
        gc.setForeground(forColor);
    }

    public void moveCurrsorUp() {
        this.currentCursor = this.getProperCursor(false);
    }

    public void moveCurrsorDown() {
        this.currentCursor = this.getProperCursor(true);
    }

    public void moveCurrsorLeft() {
        if (this.isHead) {
            if (this.currentCursor == 0) {
                return;
            }
            this.isHead = false;
            this.currentCursor = this.getProperCursor(false);
        } else {
            this.isHead = true;
        }
    }

    public void moveCurrsorRight() {
        if (this.isHead) {
            this.isHead = false;
        } else {
            if (this.currentCursor >= this.childs.size() - 1) {
                return;
            }
            this.isHead = true;
            this.currentCursor = this.getProperCursor(true);
        }
    }

    private int getProperCursor(boolean inc) {
        int cursorIdx = this.currentCursor + 1;
        int properIdx = this.currentCursor;
        if (inc) {
            while (cursorIdx < this.childs.size()) {
                VisualContainerWrapper wrapper = (VisualContainerWrapper)this.childs.elementAt(cursorIdx);
                if (wrapper.height > 10) {
                    properIdx = cursorIdx;
                } else if (cursorIdx < this.childs.size()) {
                    ++cursorIdx;
                    continue;
                }
                break;
            }
        } else {
            cursorIdx = this.currentCursor - 1;
            while (cursorIdx >= 0) {
                VisualContainerWrapper wrapper = (VisualContainerWrapper)this.childs.elementAt(cursorIdx);
                if (wrapper.height > 10) {
                    properIdx = cursorIdx;
                } else if (cursorIdx < this.childs.size()) {
                    --cursorIdx;
                    continue;
                }
                break;
            }
        }
        return properIdx;
    }

    public String toString() {
        return "VisualContainerWrapper: " + this.node.toString();
    }

    public int insertChild(VisualElementWrapper child) {
        int idx;
        child.setParent(this);
        if (this.isHead) {
            if (this.currentCursor >= this.childs.size()) {
                this.childs.add(child);
                this.getXMLNode().add(child.getXMLNode());
                idx = this.childs.size() - 1;
            } else {
                XMLNode curNode = ((VisualElementWrapper)this.childs.elementAt(this.currentCursor)).getXMLNode();
                int nodeIdx = this.getXMLNode().getChilds().indexOf(curNode);
                this.getXMLNode().getChilds().add(nodeIdx, child.getXMLNode());
                this.childs.add(this.currentCursor, child);
                child.getXMLNode().setParent(this.getXMLNode());
                this.getXMLNode().fireContentChangedEvent();
                idx = this.currentCursor;
            }
        } else if (this.currentCursor + 1 >= this.childs.size()) {
            this.childs.add(child);
            this.getXMLNode().add(child.getXMLNode());
            idx = this.childs.size() - 1;
        } else {
            XMLNode curNode = ((VisualElementWrapper)this.childs.elementAt(this.currentCursor + 1)).getXMLNode();
            int nodeIdx = this.getXMLNode().getChilds().indexOf(curNode);
            this.getXMLNode().getChilds().add(nodeIdx, child.getXMLNode());
            this.childs.add(this.currentCursor + 1, child);
            child.getXMLNode().setParent(this.getXMLNode());
            this.getXMLNode().fireContentChangedEvent();
            idx = this.currentCursor + 1;
        }
        ++this.currentCursor;
        return idx;
    }

    public void addChild(VisualContainerWrapper newWrapper, VisualContainerWrapper refWrapper) {
        int idx = this.childs.indexOf(refWrapper);
        if (idx == -1) {
            this.childs.addElement(newWrapper);
            this.node.add(newWrapper.node);
        } else {
            this.childs.add(idx + 1, newWrapper);
            int idx1 = this.node.getChilds().indexOf(refWrapper.node);
            if (idx1 == -1) {
                this.node.add(newWrapper.node);
            } else {
                this.node.getChilds().add(idx1 + 1, newWrapper.node);
            }
        }
    }

    public void setParent(VisualElementWrapper wrapper) {
        this.parentWrapper = wrapper;
    }

    public VisualElementWrapper getParentWrapper() {
        return this.parentWrapper;
    }

    public void setCursorPosition(int x, int y) {
        int dx = 2048;
        int dy = 2048;
        int actIdx = 0;
        int i = 0;
        while (i < this.childs.size()) {
            VisualContainerWrapper wrapper = (VisualContainerWrapper)this.childs.elementAt(i);
            if (wrapper.height > 10) {
                int ddy;
                int ddx = wrapper.x - x;
                if (ddx < 0) {
                    ddx = -ddx;
                }
                if ((ddy = wrapper.y - y + wrapper.height / 2) < 0) {
                    ddy = -ddy;
                }
                if (ddy < dy) {
                    actIdx = i;
                    dx = ddx;
                    dy = ddy;
                } else if (ddy == dy && ddx < dx) {
                    actIdx = i;
                    dx = ddx;
                    dy = ddy;
                }
            }
            ++i;
        }
        this.currentCursor = actIdx;
    }
}

