/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualJsp;

import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.objectEditor.ObjectEditor;
import com.ecc.ide.editor.visualJsp.VisualContainerWrapper;
import com.ecc.ide.editor.visualJsp.VisualJSPFramePanel;
import com.ecc.ide.editor.xml.Messages;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.visualeditor.VisualEditorInterface;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import java.io.ByteArrayInputStream;
import java.util.Vector;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class VisualJSPContentPanel
extends Composite
implements MouseListener,
ControlListener,
MouseMoveListener,
PaintListener,
KeyListener {
    private Point mouseDownPoint = new Point(0, 0);
    private Point curMousePoint = new Point(0, 0);
    int borderWidth = 5;
    private Vector visualElements = new Vector();
    public VisualEditorInterface editor;
    private boolean isMoveDrag;
    private boolean isResizeDrag;
    private boolean isSelectDrag = false;
    private int curTabOrder = 0;
    private int tabElementSize = 0;
    private int resizeMode;
    private boolean isInsert = false;
    private Element insertElement;
    private Vector selectedWrapper = new Vector();
    Rectangle selectRect;
    Rectangle resizeRect = new Rectangle(0, 0, 10, 10);
    boolean isCtrlDown = false;
    boolean isShiftDown = false;
    private boolean isShowGrid = false;
    int gridSize = 8;
    private boolean isShowCMUnit = false;
    private String[] undoBuffer = new String[10];
    private int curUndoSize = 0;
    private int curUndo = 0;
    int actionSize = 0;
    int undoPoint = 0;

    public void setShowGrid(boolean value) {
        if (this.isShowGrid != value) {
            this.isShowGrid = value;
            this.redraw();
        }
    }

    public VisualJSPContentPanel(Composite parent, int style) {
        super(parent, style | 0x40000 | 0x200000);
        this.addMouseListener(this);
        this.addPaintListener(this);
        this.addMouseMoveListener(this);
        this.addKeyListener(this);
        parent.addControlListener((ControlListener)this);
    }

    public void controlResized(ControlEvent ce) {
        Point size = this.getParent().getSize();
        Point sz = this.getSize();
        if (sz.x < size.x) {
            sz.x = size.x;
        }
        if (sz.y < size.y) {
            sz.y = size.y;
        }
        this.setSize(sz);
    }

    public void controlMoved(ControlEvent ce) {
    }

    public void paintControl(PaintEvent event) {
        int i;
        Point size = this.getSize();
        VisualContainerWrapper rWrapper = (VisualContainerWrapper)this.editor.getRootElement();
        if (!VisualContainerWrapper.isLayout) {
            rWrapper.layout(VisualContainerWrapper.LEFT_MARGIN, VisualContainerWrapper.TOP_MARGIN, size.x);
            int width = size.x;
            int height = size.y;
            boolean needChangeSize = false;
            if (rWrapper.width > size.x - 50) {
                needChangeSize = true;
                width = rWrapper.width;
            }
            if (rWrapper.height > size.y - 50) {
                needChangeSize = true;
                height = rWrapper.height;
            }
            if (needChangeSize) {
                this.setSize(width + 50, height + 50);
                size = this.getSize();
            }
        }
        if (this.editor.getRootElement() == null) {
            event.gc.setBackground(this.getDisplay().getSystemColor(16));
            event.gc.fillRectangle(0, 0, size.x, size.y);
            return;
        }
        Image image = new Image((Device)Display.getDefault(), size.x, size.y);
        GC gc = new GC((Drawable)image);
        Color bkColor = event.gc.getBackground();
        gc.setBackground(bkColor);
        gc.setBackground(this.getDisplay().getSystemColor(1));
        gc.fillRectangle(0, 0, size.x, size.y);
        Rectangle rect = this.editor.getRootElement().getRectangle();
        if (this.isShowGrid) {
            gc.setForeground(this.getDisplay().getSystemColor(10));
            i = rect.y;
            while (i < rect.y + rect.height) {
                int j = rect.x;
                while (j < rect.x + rect.width) {
                    gc.drawLine(j, i, j, i);
                    j += this.gridSize;
                }
                i += this.gridSize;
            }
        }
        i = 0;
        while (i < this.visualElements.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.visualElements.elementAt(i);
            wrapper.paintControl(gc, 0, 0);
            ++i;
        }
        VisualElementWrapper aWrapper = this.editor.getActivateVisualElement();
        if (aWrapper != null && aWrapper != this.editor.getRootElement()) {
            Rectangle rect1 = aWrapper.getRectangle();
            aWrapper.paintControl(gc, rect1.x - aWrapper.x, rect1.y - aWrapper.y);
        }
        if (this.isResizeDrag) {
            gc.setForeground(this.getDisplay().getSystemColor(9));
            gc.setLineStyle(3);
            gc.drawRectangle(this.resizeRect);
            this.editor.showPosition(this.resizeRect);
            gc.setLineStyle(1);
        }
        if (this.isMoveDrag) {
            int xOff = this.curMousePoint.x - this.mouseDownPoint.x;
            int yOff = this.curMousePoint.y - this.mouseDownPoint.y;
            Rectangle rec = this.editor.getActivateVisualElement().getRectangle();
            rec.x += xOff;
            rec.y += yOff;
            gc.setForeground(this.getDisplay().getSystemColor(9));
            gc.setLineStyle(3);
            gc.drawRectangle(rec);
            this.editor.showPosition(rec);
            int i2 = 0;
            while (i2 < this.selectedWrapper.size()) {
                VisualElementWrapper wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i2);
                rec = wrapper.getRectangle();
                rec.x += xOff;
                rec.y += yOff;
                gc.drawRectangle(rec);
                ++i2;
            }
            gc.setLineStyle(1);
        }
        if (this.isSelectDrag) {
            Point top = new Point(0, 0);
            Point button = new Point(0, 0);
            if (this.mouseDownPoint.x > this.curMousePoint.x) {
                top.x = this.curMousePoint.x;
                button.x = this.mouseDownPoint.x;
            } else {
                top.x = this.mouseDownPoint.x;
                button.x = this.curMousePoint.x;
            }
            if (this.mouseDownPoint.y > this.curMousePoint.y) {
                top.y = this.curMousePoint.y;
                button.y = this.mouseDownPoint.y;
            } else {
                top.y = this.mouseDownPoint.y;
                button.y = this.curMousePoint.y;
            }
            gc.setForeground(this.getDisplay().getSystemColor(9));
            gc.setLineStyle(3);
            gc.drawRectangle(top.x, top.y, button.x - top.x, button.y - top.y);
            gc.setLineStyle(1);
        }
        event.gc.drawImage(image, 0, 0);
        image.dispose();
        gc.dispose();
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.isMoveDrag = false;
        this.editCurrentComponent();
    }

    public void mouseDown(MouseEvent e) {
        this.mouseDownPoint.x = e.x;
        this.mouseDownPoint.y = e.y;
        if (this.isInsert) {
            VisualElementWrapper wrapper = this.editor.getVisualElement(e.x, e.y);
            if (wrapper == null) {
                return;
            }
            if (wrapper.isAcceptable(this.insertElement)) {
                this.doInsert(wrapper, e.x, e.y);
            }
            return;
        }
        if (this.isCtrlDown) {
            this.selectElement();
            return;
        }
        if (this.isShiftDown) {
            this.selectElement();
            return;
        }
        boolean isResizePosition = this.getResizeMode(e.x, e.y);
        if (isResizePosition) {
            this.isResizeDrag = true;
            this.unselectElement();
            return;
        }
        VisualElementWrapper wrapper = this.editor.getVisualElement(e.x, e.y);
        if (wrapper == null) {
            wrapper = this.editor.getRootElement();
        }
        if (wrapper != null && wrapper instanceof VisualContainerWrapper) {
            VisualContainerWrapper vWrapper = (VisualContainerWrapper)wrapper;
            vWrapper.setCursorPosition(e.x, e.y);
        }
        if (wrapper != null && wrapper != this.editor.getActivateVisualElement()) {
            this.unselectElement();
            this.editor.setActivateWrapper(wrapper);
            if (wrapper.getMoveable()) {
                this.isMoveDrag = true;
            }
            this.editor.showPosition(wrapper.getRectangle());
            this.selectedWrapper.clear();
            return;
        }
        boolean isMovePosition = this.getMovePosition(e.x, e.y);
        if (isMovePosition && wrapper.getMoveable()) {
            this.isMoveDrag = true;
            return;
        }
        this.unselectElement();
        this.selectedWrapper.clear();
        wrapper = this.editor.getVisualElement(e.x, e.y);
        if (wrapper != null) {
            this.editor.setActivateWrapper(wrapper);
            this.editor.showPosition(wrapper.getRectangle());
            if (wrapper.getMoveable()) {
                this.isMoveDrag = true;
                return;
            }
        }
        this.isSelectDrag = true;
    }

    public void mouseMove(MouseEvent e) {
        this.curMousePoint.x = e.x;
        this.curMousePoint.y = e.y;
        if (this.isCtrlDown) {
            return;
        }
        if (this.isShiftDown) {
            return;
        }
        if (this.isMoveDrag) {
            VisualElementWrapper wrapper = this.editor.getVisualElement(e.x, e.y);
            Element movingElement = this.editor.getActivateVisualElement().getElement();
            if (wrapper != null && wrapper.isAcceptable(movingElement)) {
                this.setCursor(IDEConstance.getCursor(2));
            } else {
                this.setCursor(IDEConstance.getCursor(20));
            }
            this.drawTheMovingRectangle();
            return;
        }
        if (this.isResizeDrag) {
            this.drawTheResizeRectangle();
            return;
        }
        if (this.isInsert) {
            VisualElementWrapper wrapper = this.editor.getVisualElement(e.x, e.y);
            if (wrapper == null) {
                return;
            }
            if (wrapper.isAcceptable(this.insertElement)) {
                this.setCursor(IDEConstance.getCursor(2));
            } else {
                this.setCursor(IDEConstance.getCursor(20));
            }
            return;
        }
        if (this.isSelectDrag) {
            this.selectTheElements();
        }
        if (this.getResizeMode(e.x, e.y)) {
            if (this.resizeMode == 0) {
                this.setCursor(IDEConstance.getCursor(17));
            } else if (this.resizeMode == 1) {
                this.setCursor(IDEConstance.getCursor(10));
            } else if (this.resizeMode == 2) {
                this.setCursor(IDEConstance.getCursor(14));
            } else if (this.resizeMode == 3) {
                this.setCursor(IDEConstance.getCursor(16));
            } else if (this.resizeMode == 4) {
                this.setCursor(IDEConstance.getCursor(11));
            } else if (this.resizeMode == 5) {
                this.setCursor(IDEConstance.getCursor(15));
            } else if (this.resizeMode == 6) {
                this.setCursor(IDEConstance.getCursor(13));
            } else if (this.resizeMode == 7) {
                this.setCursor(IDEConstance.getCursor(12));
            }
        } else if (this.getMovePosition(e.x, e.y)) {
            VisualElementWrapper wrapper = this.editor.getVisualElement(e.x, e.y);
            VisualElementWrapper actWrapper = this.editor.getActivateVisualElement();
            if (wrapper == null || wrapper == actWrapper) {
                this.setCursor(IDEConstance.getCursor(5));
            } else {
                this.setCursor(IDEConstance.getCursor(0));
            }
        } else {
            this.setCursor(IDEConstance.getCursor(0));
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.isMoveDrag) {
            this.moveSelectedComponent(e.x, e.y);
            this.isMoveDrag = false;
        } else if (this.isResizeDrag) {
            this.isResizeDrag = false;
            this.editor.getActivateVisualElement().setBounds(this.resizeRect.x, this.resizeRect.y, this.resizeRect.width, this.resizeRect.height);
            int width = this.getSize().x;
            int height = this.getSize().y;
            if (this.resizeRect.x + this.resizeRect.width > width) {
                width = this.resizeRect.x + this.resizeRect.width + 20;
            }
            if (this.resizeRect.y + this.resizeRect.height > height) {
                height = this.resizeRect.y + this.resizeRect.height + 20;
            }
            Point size = new Point(width, height);
            this.saveCurrentAction();
            this.redraw();
        }
        if (this.isSelectDrag) {
            this.isSelectDrag = false;
            this.redraw();
        }
        this.setCursor(IDEConstance.getCursor(0));
    }

    private void moveSelectedComponent(int x, int y) {
        this.isMoveDrag = false;
        VisualContainerWrapper movingWrapper = (VisualContainerWrapper)this.editor.getActivateVisualElement();
        Element movingElement = movingWrapper.getElement();
        VisualContainerWrapper parentWrapper = (VisualContainerWrapper)this.editor.getVisualElement(x, y);
        if (parentWrapper == null || !parentWrapper.isAcceptable(movingElement)) {
            return;
        }
        parentWrapper.setCursorPosition(x, y);
        ((VisualJSPFramePanel)this.editor).moveElementTo(parentWrapper, movingWrapper);
        VisualContainerWrapper.isLayout = false;
        this.redraw();
        this.saveCurrentAction();
    }

    public void keyPressed(KeyEvent event) {
        if (this.isMoveDrag || this.isResizeDrag) {
            return;
        }
        int xOff = 0;
        int yOff = 0;
        int scale = 5;
        if (this.isCtrlDown) {
            scale = 1;
        }
        VisualContainerWrapper curElement = (VisualContainerWrapper)this.editor.getActivateVisualElement();
        if (event.keyCode == 0x1000001) {
            curElement.moveCurrsorUp();
            this.redraw();
            yOff = -scale;
        } else if (event.keyCode == 0x1000002) {
            curElement.moveCurrsorDown();
            this.redraw();
            yOff = scale;
        } else if (event.keyCode == 0x1000003) {
            curElement.moveCurrsorLeft();
            this.redraw();
            xOff = -scale;
        } else if (event.keyCode == 0x1000004) {
            curElement.moveCurrsorRight();
            this.redraw();
            xOff = scale;
        }
        if (this.isCtrlDown && event.keyCode == 97) {
            this.selectAllElement();
        }
        if (event.keyCode == 131072) {
            this.isShiftDown = true;
        } else if (event.keyCode == 262144) {
            this.isCtrlDown = true;
        } else if (event.keyCode == 127) {
            this.deleteSelectedElement();
        } else if (event.keyCode == 27) {
            this.editor.cancelCurrentAction();
        }
        if (this.isCtrlDown && event.keyCode == 122) {
            this.undo();
        }
    }

    public void keyReleased(KeyEvent event) {
        if (event.keyCode == 262144) {
            this.isCtrlDown = false;
        }
        if (event.keyCode == 131072) {
            this.isShiftDown = false;
        }
    }

    private boolean getResizeMode(int mx, int my) {
        if (this.editor.getActivateVisualElement() == null || !this.editor.getActivateVisualElement().getResizeable()) {
            return false;
        }
        int wrapperResizeMode = this.editor.getActivateVisualElement().getResizeMode();
        Rectangle selectRect = this.editor.getActivateVisualElement().getRectangle();
        int x = selectRect.x;
        int y = selectRect.y;
        int width = selectRect.width;
        int height = selectRect.height;
        if (my >= y - this.borderWidth && my <= y) {
            if (mx >= x - this.borderWidth && mx <= x && wrapperResizeMode == 0) {
                this.resizeMode = 0;
                return true;
            }
            if (mx >= x + (width - this.borderWidth) / 2 && mx <= x + (width - this.borderWidth) / 2 + this.borderWidth && (wrapperResizeMode == 0 || wrapperResizeMode == 2 || wrapperResizeMode == 3)) {
                this.resizeMode = 1;
                return true;
            }
            if (mx >= x + width && mx <= x + width + this.borderWidth && wrapperResizeMode == 0) {
                this.resizeMode = 2;
                return true;
            }
        }
        if (my >= y + height && my <= y + height + this.borderWidth) {
            if (mx >= x - this.borderWidth && mx <= x && wrapperResizeMode == 0) {
                this.resizeMode = 3;
                return true;
            }
            if (mx >= x + (width - this.borderWidth) / 2 && mx <= x + (width - this.borderWidth) / 2 + this.borderWidth && (wrapperResizeMode == 0 || wrapperResizeMode == 2 || wrapperResizeMode == 3)) {
                this.resizeMode = 4;
                return true;
            }
            if (mx >= x + width && mx <= x + width + this.borderWidth && wrapperResizeMode == 0) {
                this.resizeMode = 5;
                return true;
            }
        }
        if (my >= y + (height - this.borderWidth) / 2 && my <= y + (height - this.borderWidth) / 2 + this.borderWidth) {
            if (mx >= x - this.borderWidth && mx <= x && (wrapperResizeMode == 0 || wrapperResizeMode == 1 || wrapperResizeMode == 3)) {
                this.resizeMode = 6;
                return true;
            }
            if (mx >= x + width && mx <= x + width + this.borderWidth && (wrapperResizeMode == 0 || wrapperResizeMode == 1 || wrapperResizeMode == 3)) {
                this.resizeMode = 7;
                return true;
            }
        }
        return false;
    }

    private boolean getMovePosition(int mx, int my) {
        if (this.editor.getActivateVisualElement() == this.editor.getRootElement()) {
            return false;
        }
        if (this.selectRect != null) {
            return mx >= this.selectRect.x && mx <= this.selectRect.x + this.selectRect.width && my >= this.selectRect.y && my <= this.selectRect.y + this.selectRect.height;
        }
        if (this.editor.getActivateVisualElement() == null) {
            return false;
        }
        if (!this.editor.getActivateVisualElement().getMoveable()) {
            return false;
        }
        Rectangle rect = this.editor.getActivateVisualElement().getRectangle();
        return mx >= rect.x && mx <= rect.x + rect.width && my >= rect.y && my <= rect.y + rect.height;
    }

    public void addVisualElement(VisualElementWrapper wrapper) {
        this.visualElements.addElement(wrapper);
        int width = wrapper.x + wrapper.width;
        int height = wrapper.y + wrapper.height;
        Point size = this.getSize();
        if (size.x < width) {
            size.x = width + 20;
        }
        if (size.y < height) {
            size.y = height + 20;
        }
        this.setSize(size);
    }

    private synchronized void drawTheResizeRectangle() {
        Rectangle rec = this.editor.getActivateVisualElement().getRectangle();
        int xOff = this.curMousePoint.x - this.mouseDownPoint.x;
        int yOff = this.curMousePoint.y - this.mouseDownPoint.y;
        this.resizeRect.x = rec.x;
        this.resizeRect.y = rec.y;
        switch (this.resizeMode) {
            case 0: {
                this.resizeRect.x = rec.x + xOff;
                this.resizeRect.y = rec.y + yOff;
                this.resizeRect.width = rec.width - xOff;
                this.resizeRect.height = rec.height - yOff;
                break;
            }
            case 1: {
                this.resizeRect.y = rec.y + yOff;
                this.resizeRect.width = rec.width;
                this.resizeRect.height = rec.height - yOff;
                break;
            }
            case 2: {
                this.resizeRect.y = rec.y + yOff;
                this.resizeRect.width = rec.width + xOff;
                this.resizeRect.height = rec.height - yOff;
                break;
            }
            case 3: {
                this.resizeRect.x = rec.x + xOff;
                this.resizeRect.width = rec.width - xOff;
                this.resizeRect.height = rec.height + yOff;
                break;
            }
            case 4: {
                this.resizeRect.width = rec.width;
                this.resizeRect.height = rec.height + yOff;
                break;
            }
            case 5: {
                this.resizeRect.width = rec.width + xOff;
                this.resizeRect.height = rec.height + yOff;
                break;
            }
            case 6: {
                this.resizeRect.x = rec.x + xOff;
                this.resizeRect.width = rec.width - xOff;
                this.resizeRect.height = rec.height;
                break;
            }
            case 7: {
                this.resizeRect.width = rec.width + xOff;
                this.resizeRect.height = rec.height;
            }
        }
        if (this.resizeRect.width < 10) {
            this.resizeRect.width = 10;
        }
        if (this.resizeRect.height < 10) {
            this.resizeRect.height = 10;
        }
        this.redraw();
    }

    private synchronized void drawTheMovingRectangle() {
        this.redraw();
    }

    private void selectElement() {
        VisualElementWrapper actWrapper = this.editor.getActivateVisualElement();
        if (actWrapper == null) {
            return;
        }
        VisualElementWrapper wrapper = this.editor.getVisualElement(this.mouseDownPoint.x, this.mouseDownPoint.y);
        if (wrapper == null) {
            return;
        }
        if (wrapper.getParentWrapper() != actWrapper.getParentWrapper()) {
            if (this.isCtrlDown) {
                this.isCtrlDown = false;
                this.unselectElement();
                return;
            }
            return;
        }
        if (wrapper == actWrapper) {
            return;
        }
        if (wrapper.isSelected()) {
            wrapper.setIsSelected(false);
            this.selectedWrapper.removeElement(wrapper);
        } else {
            wrapper.setIsSelected(true);
            this.selectedWrapper.addElement(wrapper);
        }
        this.redraw();
    }

    private void selectTheElements() {
        VisualElementWrapper rootWrapper = this.editor.getRootElement();
        if (rootWrapper.childs.size() == 0) {
            return;
        }
        this.unselectElement();
        Point top = new Point(0, 0);
        Point button = new Point(0, 0);
        if (this.mouseDownPoint.x > this.curMousePoint.x) {
            top.x = this.curMousePoint.x;
            button.x = this.mouseDownPoint.x;
        } else {
            top.x = this.mouseDownPoint.x;
            button.x = this.curMousePoint.x;
        }
        if (this.mouseDownPoint.y > this.curMousePoint.y) {
            top.y = this.curMousePoint.y;
            button.y = this.mouseDownPoint.y;
        } else {
            top.y = this.mouseDownPoint.y;
            button.y = this.curMousePoint.y;
        }
        int i = 0;
        while (i < rootWrapper.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)rootWrapper.childs.elementAt(i);
            Rectangle rec = wrapper.getRectangle();
            if (rec.x >= top.x && rec.y >= top.y && rec.x + rec.width <= button.x && rec.y + rec.height <= button.y) {
                wrapper.setIsSelected(true);
                this.selectedWrapper.addElement(wrapper);
            }
            ++i;
        }
        if (this.selectedWrapper.size() > 0) {
            VisualElementWrapper wrapper0 = (VisualElementWrapper)this.selectedWrapper.elementAt(0);
            wrapper0.setIsSelected(false);
            this.editor.setActivateWrapper(wrapper0);
            this.selectedWrapper.removeElementAt(0);
        }
        this.redraw();
    }

    private void selectAllElement() {
        VisualElementWrapper rootWrapper = this.editor.getRootElement();
        if (rootWrapper.childs.size() == 0) {
            return;
        }
        this.unselectElement();
        this.editor.setActivateWrapper((VisualElementWrapper)rootWrapper.childs.elementAt(0));
        int i = 1;
        while (i < rootWrapper.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)rootWrapper.childs.elementAt(i);
            wrapper.setIsSelected(true);
            this.selectedWrapper.addElement(wrapper);
            ++i;
        }
        this.redraw();
    }

    private void unselectElement() {
        if (this.selectedWrapper.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.selectedWrapper.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i);
            wrapper.setIsSelected(false);
            ++i;
        }
        this.selectedWrapper.clear();
        this.redraw();
    }

    public void beginInsert(Element element) {
        if (element == null) {
            return;
        }
        this.insertElement = element;
        VisualElementWrapper wrapper = this.editor.getActivateVisualElement();
        if (wrapper.isAcceptable(this.insertElement)) {
            this.doInsert(wrapper, 0, 0);
        }
    }

    private void doInsert(VisualElementWrapper parent, int x, int y) {
        this.editor.addNewElement(parent, this.insertElement, x, y);
        this.unselectElement();
        this.isInsert = false;
        this.redraw();
        this.saveCurrentAction();
        this.editor.showStateMessage("ready");
    }

    public void beginLink() {
    }

    public void doLink() {
    }

    public void cancelLink() {
    }

    public void deleteSelectedElement() {
        VisualElementWrapper wrapper = this.editor.getActivateVisualElement();
        if (wrapper.canBeDelete()) {
            this.editor.removeElement(wrapper);
        }
        int i = 0;
        while (i < this.selectedWrapper.size()) {
            wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i);
            if (wrapper.canBeDelete()) {
                this.editor.removeElement(wrapper);
            }
            ++i;
        }
        this.selectedWrapper.clear();
        this.redraw();
        this.saveCurrentAction();
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void saveCurrentAction() {
        try {
            StringBuffer strBuf = new StringBuffer();
            String content = this.editor.getStringContent();
            strBuf.append(content);
            if (this.undoPoint < 10) {
                this.undoBuffer[this.undoPoint++] = strBuf.toString();
                this.actionSize = this.undoPoint;
            } else {
                int i = 1;
                while (i < 9) {
                    this.undoBuffer[i - 1] = this.undoBuffer[i];
                    ++i;
                }
                this.undoBuffer[9] = strBuf.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.enableUnDoAndRedo();
    }

    public void resetCurrentAction() {
        try {
            StringBuffer strBuf = new StringBuffer();
            this.undoPoint = 0;
            this.editor.getRootElement().getXMLNode().toXMLContent(0, strBuf);
            if (this.undoPoint < 10) {
                this.undoBuffer[this.undoPoint++] = strBuf.toString();
                this.actionSize = this.undoPoint;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.enableUnDoAndRedo();
    }

    public void undo() {
        if (this.undoPoint < 2) {
            return;
        }
        this.visualElements.clear();
        String content = this.undoBuffer[this.undoPoint - 2];
        --this.undoPoint;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
            this.editor.loadXMLContent(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.editor.setActivateWrapper(this.editor.getRootElement());
        this.redraw();
        this.enableUnDoAndRedo();
    }

    public void redo() {
        if (this.undoPoint < this.actionSize) {
            String content = this.undoBuffer[this.undoPoint];
            if (content == null) {
                return;
            }
            this.visualElements.clear();
            ++this.undoPoint;
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
                this.editor.loadXMLContent(in);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.editor.setActivateWrapper(this.editor.getRootElement());
            this.redraw();
        }
        this.enableUnDoAndRedo();
    }

    private void enableUnDoAndRedo() {
        try {
            if (this.undoPoint > 1) {
                this.editor.setItemEnable(0, true);
            } else {
                this.editor.setItemEnable(0, false);
            }
            if (this.undoPoint < this.actionSize) {
                this.editor.setItemEnable(1, true);
            } else {
                this.editor.setItemEnable(1, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void editCurrentComponent() {
        VisualElementWrapper wrapper = this.editor.getActivateVisualElement();
        if (wrapper == null) {
            return;
        }
        if (wrapper == this.editor.getRootElement()) {
            return;
        }
        Element element = wrapper.getElement();
        if (element.getEditClass() == null) {
            return;
        }
        try {
            ObjectEditor objEditor = (ObjectEditor)Class.forName(element.getEditClass()).newInstance();
            XMLNode node = (XMLNode)wrapper.getWrappedObject();
            XMLNode aNode = (XMLNode)node.clone();
            VisualElementWrapper aWrapper = new VisualElementWrapper(null, aNode, this.editor.getEditorProfile());
            aWrapper.setWrapperOwner(wrapper.getWrapperOwner());
            Object result = objEditor.editObject(aWrapper, this.getShell(), Messages.getString("VisualEditorContentPanel.Edit_the_element_1"));
            if (result != null && objEditor.isChanged()) {
                XMLNode pNode = node.getParent();
                pNode.replaceNode(node, aNode);
                wrapper.setWrappedObject(node);
                this.editor.setActivateWrapper(this.editor.getRootElement());
                this.editor.setActivateWrapper(wrapper);
                this.redraw();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reset() {
        this.visualElements.clear();
        this.curUndo = 0;
        this.curUndoSize = 0;
    }
}

