/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualJsp;

import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.ide.editor.Wrapper;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualJsp.TableCellWrapper;
import com.ecc.ide.editor.visualJsp.TableWrapper;
import com.ecc.ide.editor.visualJsp.VisualContainerWrapper;
import com.ecc.ide.editor.visualJsp.VisualJSPFramePanel;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ProfileObjectMaker;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class VisualKJavaFormFramePanel
extends VisualJSPFramePanel {
    private String jspHeadContent;

    public VisualKJavaFormFramePanel(Composite parent, int style) {
        super(parent, style);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText("Visual KJava Form");
        VisualKJavaFormFramePanel test = new VisualKJavaFormFramePanel((Composite)shell, 2048);
        try {
            String fileName = "profiles/kjavaFormEditorProfile.xml";
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new ProfileObjectMaker());
            EditorProfile profile = (EditorProfile)xmlLoader.loadXMLFile(fileName);
            if (profile != null) {
                test.setEditorProfile(profile);
                test.loadWMLFile("testKJavaForm.jsp");
                if (profile.getTitle() != null) {
                    shell.setText(profile.getTitle());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        try {
            FileWriter fw = new FileWriter("testKJavaForm.jsp");
            fw.write(test.getJSPStringContent());
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setXMLContent(XMLNode node) throws Exception {
        VisualContainerWrapper wrapper;
        Element element;
        this.xmlContent = node;
        this.resetObjName();
        this.visualElements.clear();
        this.workingArea.reset();
        if (node == null) {
            this.workingArea.redraw();
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            this.xmlContent.addContentChangedListener((ContentChangedListener)this.listeners.elementAt(i), null, 0);
            ++i;
        }
        VisualContainerWrapper.isLayout = false;
        XMLNode headNode = node;
        if (headNode != null) {
            int i2 = 0;
            while (i2 < headNode.getChilds().size()) {
                String content;
                XMLNode aNode = (XMLNode)headNode.getChilds().elementAt(i2);
                if ("#comment".equals(aNode.getNodeName()) && (content = aNode.getAttrValue("value")) != null && content.indexOf("htmlTrxCode") != -1) {
                    int idx1 = content.indexOf("htmlTrxCode");
                    idx1 = content.indexOf(34, idx1);
                    int idx2 = content.indexOf(34, idx1 + 1);
                    this.htmlTrxCode = content.substring(idx1 + 1, idx2);
                    idx1 = content.indexOf("htmlTrxFileName");
                    idx1 = content.indexOf(34, idx1);
                    idx2 = content.indexOf(34, idx1 + 1);
                    this.trxFileName = content.substring(idx1 + 1, idx2);
                }
                ++i2;
            }
        }
        if ((element = this.profile.getElement(node.getNodeName())) != null) {
            this.addObjectName(element.getElementName(), node.getAttrValue("name"));
        } else {
            this.addObjectName(node.getNodeName(), node.getAttrValue("name"));
        }
        if (element == null || element.getWrapperClassType() == null) {
            wrapper = new VisualContainerWrapper(null, node, this.profile);
            if (element != null) {
                wrapper.setElement(element);
            } else {
                wrapper.setElement(this.getDefaultElement());
            }
        } else {
            wrapper = (VisualContainerWrapper)Class.forName(element.getWrapperClassType()).newInstance();
            wrapper.setElement(element);
            wrapper.setXMLNode(node);
        }
        wrapper.editor = this;
        wrapper.setWrapperOwner(this);
        this.workingArea.addVisualElement(wrapper);
        this.visualElements.addElement(wrapper);
        this.beanTreePanel.setRootWrapper(wrapper);
        this.rootWrapper = wrapper;
        this.addViewElementToContent(wrapper, node);
        this.setActivateWrapper(wrapper);
        this.workingArea.redraw();
        this.rootWrapper.setMoveable(false);
        if (this.isFirst) {
            this.isFirst = false;
            this.workingArea.saveCurrentAction();
        }
    }

    public void loadWMLFile(String fileName) {
        try {
            FileInputStream fi = new FileInputStream(fileName);
            this.loadWMLContent(fi);
            fi.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadWMLContent(InputStream in) {
        try {
            XMLLoader xmlLoader = new XMLLoader();
            byte[] content = this.readContent(in);
            if (content == null) {
                return;
            }
            int offset = this.readJSPHead(content);
            ByteArrayInputStream bi = new ByteArrayInputStream(content, offset, content.length - offset);
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode node = (XMLNode)xmlLoader.loadXMLContent((InputStream)bi);
            this.setXMLContent(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setActivateWrapper(Wrapper wrapper) {
        super.setActivateWrapper(wrapper);
        if (wrapper instanceof TableWrapper || wrapper instanceof TableCellWrapper) {
            this.workingArea.setMenu(null);
        }
    }

    public String getJSPStringContent() {
        try {
            StringBuffer strBuf = new StringBuffer();
            if (this.jspHeadContent != null) {
                strBuf.append(this.jspHeadContent);
            }
            this.xmlContent.setEncoding("UTF-8");
            this.xmlContent.toWMLContent(0, strBuf, false);
            return strBuf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private int readJSPHead(byte[] content) {
        int offset = this.findString(content, "<?xml".getBytes());
        if (offset != -1) {
            this.jspHeadContent = new String(content, 0, offset);
            return offset;
        }
        offset = this.findString(content, "<kml".getBytes());
        if (offset != -1) {
            this.jspHeadContent = new String(content, 0, offset);
            return offset;
        }
        this.jspHeadContent = "";
        return 0;
    }

    private int findString(byte[] src, byte[] findingBytes) {
        if (src.length < findingBytes.length) {
            return -1;
        }
        int i = 0;
        while (i < src.length - findingBytes.length) {
            if (this.isMatch(src, i, findingBytes)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isMatch(byte[] src, int offset, byte[] findingBytes) {
        int i = 0;
        while (i < findingBytes.length) {
            if (src[offset + i] != findingBytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private byte[] readContent(InputStream in) {
        try {
            int readLen;
            int len = in.available();
            if (len <= 0) {
                len = 10240;
            }
            byte[] buf = new byte[len];
            int offset = 0;
            while ((offset = (readLen = in.read(buf, offset, len - offset)) + offset) < len && readLen != 0) {
            }
            return buf;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

