/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualflow;

import com.ecc.ide.editor.visualflow.FlowVisualPanel;
import com.ecc.ide.editor.visualflow.VisualComponent;
import org.eclipse.swt.graphics.GC;

public class ComponentLink {
    public VisualComponent from;
    public VisualComponent to;
    public String linkLabel;
    int apX = 0;
    int apY = 0;
    int apX1 = 0;
    int apY1 = 0;
    int apX2 = 0;
    int apY2 = 0;
    int al = 10;

    public ComponentLink(String linkLabel, VisualComponent from, VisualComponent to) {
        this.linkLabel = linkLabel;
        this.from = from;
        this.to = to;
    }

    public void paint(FlowVisualPanel panel, GC gc) {
        int al = 15;
        int x = this.from.getX() + this.from.getWidth() / 2;
        int y = this.from.getY() + this.from.getHeight() / 2;
        int x1 = this.to.getX() + this.to.getWidth() / 2;
        int y1 = this.to.getY() + this.to.getHeight() / 2;
        if (this.apX == 0 && this.apY == 0) {
            this.calculateArrowPosition();
            this.calculateArrow();
        } else if (panel.isDrag && (this.from == panel.dragedComponent || this.to == panel.dragedComponent)) {
            this.calculateArrowPosition();
            this.calculateArrow();
        }
        try {
            gc.setForeground(panel.linkLineColor);
            gc.drawLine(x, y, x1, y1);
            gc.drawLine(this.apX, this.apY, this.apX1, this.apY1);
            gc.drawLine(this.apX, this.apY, this.apX2, this.apY2);
            gc.setForeground(panel.linkLabelColor);
            gc.drawString(this.linkLabel, (x + x1) / 2, (y + y1) / 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void calculateArrowPosition() {
        int x0 = this.from.getX() + this.from.getWidth() / 2;
        int y0 = this.from.getY() + this.from.getHeight() / 2;
        int x1 = this.to.getX() + this.to.getWidth() / 2;
        int y1 = this.to.getY() + this.to.getHeight() / 2;
        if (x1 - x0 == 0 || y1 - y0 == 0) {
            return;
        }
        int yy1 = y0 + (y1 - y0) * (x1 - this.to.getWidth() / 2 - x0) / (x1 - x0);
        int yy2 = y0 + (y1 - y0) * (x1 + this.to.getWidth() / 2 - x0) / (x1 - x0);
        boolean isInX1 = false;
        if (yy1 >= y1 - this.to.getHeight() / 2 - 2 && yy1 <= y1 + this.to.getHeight() / 2) {
            this.apX = x1 - this.to.getWidth() / 2;
            this.apY = yy1;
            if (x1 > x0) {
                return;
            }
            isInX1 = true;
        }
        if (yy2 >= y1 - this.to.getHeight() / 2 - 2 && yy2 <= y1 + this.to.getHeight() / 2) {
            this.apX = x1 + this.to.getWidth() / 2;
            this.apY = yy2;
            return;
        }
        if (isInX1) {
            return;
        }
        int xx1 = x0 + (x1 - x0) * (y1 - this.to.getHeight() / 2 - y0) / (y1 - y0);
        int xx2 = x0 + (x1 - x0) * (y1 + this.to.getHeight() / 2 - y0) / (y1 - y0);
        if (xx1 >= x1 - this.to.getWidth() / 2 - 2 && xx1 <= x1 + this.to.getWidth() / 2) {
            this.apX = xx1;
            this.apY = y1 - this.to.getHeight() / 2;
            if (y1 > y0) {
                return;
            }
        }
        if (xx2 >= x1 - this.to.getWidth() / 2 - 2 && xx2 <= x1 + this.to.getWidth() / 2) {
            this.apX = xx2;
            this.apY = y1 + this.to.getHeight() / 2;
            return;
        }
    }

    private void calculateArrow() {
        int x = this.from.getX() + this.from.getWidth() / 2;
        int y = this.from.getY() + this.from.getHeight() / 2;
        int x1 = this.apX;
        int y1 = this.apY;
        int al = 16;
        double arrowWidth = 8.0;
        int ll = (x1 - x) * (x1 - x) + (y1 - y) * (y1 - y);
        if (ll == 0) {
            return;
        }
        ll = (int)Math.sqrt(ll);
        int xx = x1 > x ? x1 - al * (x1 - x) / ll - x : x1 + al * (x - x1) / ll - x;
        int yy = y1 > y ? y1 - al * (y1 - y) / ll - y : y1 + al * (y - y1) / ll - y;
        double l = ll - al;
        if (l <= 0.0) {
            return;
        }
        double arc = Math.atan(arrowWidth / l);
        this.apX1 = x + (int)((double)xx * Math.cos(arc) + (double)yy * Math.sin(arc));
        this.apY1 = y + (int)((double)(-xx) * Math.sin(arc) + (double)yy * Math.cos(arc));
        this.apX2 = x + (int)((double)xx * Math.cos(arc) - (double)yy * Math.sin(arc));
        this.apY2 = y + (int)((double)xx * Math.sin(arc) + (double)yy * Math.cos(arc));
    }
}

