/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualflow;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class FlowExtendPointElementWrapper
extends VisualElementWrapper {
    public FlowExtendPointElementWrapper() {
    }

    public FlowExtendPointElementWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        super(pWrapper, node, profile);
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        int x = this.x + xOffset;
        int y = this.y + yOffset;
        Rectangle parentClipRect = gc.getClipping();
        Rectangle clipRect = this.clipRect(this.getRectangle(), parentClipRect);
        gc.setClipping(clipRect);
        gc.fillRectangle(x, y, this.width, this.height);
        gc.setForeground(Display.getDefault().getSystemColor(2));
        Image image = this.element.getImage();
        int txtY = y + 3;
        if (image != null) {
            int imWidth = image.getBounds().width;
            gc.drawImage(image, x + (this.width - imWidth) / 2, y + 3);
            txtY = txtY + image.getBounds().height + 2;
        }
        int w = gc.getFontMetrics().getAverageCharWidth();
        int h = gc.getFontMetrics().getHeight();
        String label = this.getXMLNode().getAttrValue("label");
        if (label != null && label.length() > 0) {
            gc.drawText(label, x + (this.width - w * label.getBytes().length) / 2, txtY);
            txtY = txtY + h + 2;
        }
        String txt = "<" + this.getElement().getLabel() + ">";
        gc.drawText(txt, x + (this.width - w * txt.getBytes().length) / 2, txtY);
        gc.setForeground(new Color((Device)Display.getDefault(), 94, 142, 206));
        gc.setLineStyle(2);
        gc.drawRectangle(x, y, this.width, this.height);
        gc.setForeground(Display.getDefault().getSystemColor(2));
        gc.setLineStyle(1);
        if (this.isActivated) {
            this.paintActivateSymbol(gc, xOffset, yOffset);
        }
        if (this.isSelected) {
            this.paintSelectedSymbol(gc, xOffset, yOffset);
        }
        if (this.getParentWrapper() != null && this.getParentWrapper().getIsSetTabOrder()) {
            this.paintTabOrderSymbol(gc, xOffset, yOffset);
        }
        gc.setClipping(parentClipRect);
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.childs.elementAt(i);
            wrapper.paintControl(gc, x, y);
            ++i;
        }
    }

    public boolean isCanLinkOut() {
        return true;
    }

    public boolean isCanLinkIn(VisualElementWrapper wrapper) {
        return wrapper.getParentWrapper() == this.getParentWrapper();
    }

    public void setXMLNode(XMLNode node) {
        if (node.getAttrValue("extendId") == null) {
            node.setAttrValue("extendId", node.getAttrValue("name"));
        }
        super.setXMLNode(node);
    }
}

