/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualflow;

import com.ecc.ide.editor.visualflow.ComponentLink;
import com.ecc.ide.editor.visualflow.Messages;
import com.ecc.ide.editor.visualflow.VisualComponent;
import com.ecc.ide.editor.visualflow.VisualComponentImp;
import java.util.Vector;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FlowVisualPanel
extends Canvas {
    private Vector componentLinks = new Vector();
    private Vector components = new Vector();
    public Color linkLabelColor = new Color((Device)Display.getDefault(), 0, 0, 0);
    public Color linkLineColor = new Color((Device)Display.getDefault(), 255, 0, 0);
    public Color componentColor = new Color((Device)Display.getDefault(), 128, 255, 255);
    public Color componentLabelColor = new Color((Device)Display.getDefault(), 0, 0, 255);
    public Color componentBackColor = new Color((Device)Display.getDefault(), 0, 255, 255);
    boolean isDrag = false;
    private int xOffset;
    private int yOffset;
    protected VisualComponent dragedComponent = null;

    public FlowVisualPanel(Composite parent, int style) {
        super(parent, style | 0x40000 | 0x200000);
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                FlowVisualPanel.this.mouseMoveEvent(e);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                FlowVisualPanel.this.mouseUpEvent(e);
            }

            public void mouseDown(MouseEvent e) {
                FlowVisualPanel.this.mouseDownEvent(e);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                FlowVisualPanel.this.paint(e);
            }
        });
    }

    public void clear() {
        this.componentLinks = new Vector();
        this.components = new Vector();
    }

    public void addVisualComponent(VisualComponent component) {
        this.components.addElement(component);
        int x = component.getX() + component.getWidth();
        int y = component.getY() + component.getHeight();
        Rectangle rec = this.getBounds();
        int targetHeight = rec.height;
        int targetWidth = rec.width;
        if (y > rec.height - 20) {
            targetHeight = y + 20;
        }
        if (x > rec.width - 20) {
            targetWidth = x + 20;
        }
        if (targetHeight != rec.height || targetWidth != rec.width) {
            this.setSize(targetWidth, targetHeight);
        }
    }

    public void removeVisualComponent(VisualComponent component) {
        this.components.removeElement(component);
    }

    public void addComponentLink(ComponentLink link) {
        this.componentLinks.addElement(link);
    }

    public void removeComponentLink(ComponentLink link) {
        this.componentLinks.remove(link);
        this.redraw();
    }

    public Vector getComponentLinks() {
        return this.componentLinks;
    }

    public void mouseUpEvent(MouseEvent e) {
        this.isDrag = false;
    }

    public void mouseDownEvent(MouseEvent e) {
        int x = e.x;
        int y = e.y;
        int i = 0;
        while (i < this.components.size()) {
            VisualComponent cmp = (VisualComponent)this.components.elementAt(i);
            if (x >= cmp.getX() && x <= cmp.getX() + cmp.getWidth() && y >= cmp.getY() && y <= cmp.getY() + cmp.getHeight()) {
                this.dragedComponent = cmp;
                this.isDrag = true;
                this.xOffset = x - cmp.getX();
                this.yOffset = y - cmp.getY();
                break;
            }
            ++i;
        }
    }

    public void mouseMoveEvent(MouseEvent e) {
        if (this.isDrag) {
            this.dragedComponent.setX(e.x - this.xOffset);
            this.dragedComponent.setY(e.y - this.yOffset);
            int x = this.dragedComponent.getX() + this.dragedComponent.getWidth();
            int y = this.dragedComponent.getY() + this.dragedComponent.getHeight();
            Rectangle rec = this.getBounds();
            int targetHeight = rec.height;
            int targetWidth = rec.width;
            if (y > rec.height - 20) {
                targetHeight = y + 20;
            }
            if (x > rec.width - 20) {
                targetWidth = x + 20;
            }
            if (targetHeight != rec.height || targetWidth != rec.width) {
                this.setSize(targetWidth, targetHeight);
            } else {
                this.redraw();
            }
        }
    }

    public void paint(PaintEvent e) {
        Point size = this.getSize();
        Image image = new Image((Device)Display.getDefault(), size.x, size.y);
        GC gc = new GC((Drawable)image);
        int i = 0;
        while (i < this.componentLinks.size()) {
            ComponentLink link = (ComponentLink)this.componentLinks.elementAt(i);
            link.paint(this, gc);
            ++i;
        }
        i = 0;
        while (i < this.components.size()) {
            VisualComponent component = (VisualComponent)this.components.elementAt(i);
            component.paint(this, gc);
            ++i;
        }
        e.gc.drawImage(image, 0, 0);
        image.dispose();
        gc.dispose();
    }

    public void dispose() {
        super.dispose();
        this.linkLabelColor.dispose();
        this.linkLineColor.dispose();
        this.componentColor.dispose();
        this.componentLabelColor.dispose();
    }

    protected void checkSubclass() {
    }

    public static void main(String[] argv) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setBackground(Display.getCurrent().getSystemColor(1));
        shell.setLayout((Layout)new FillLayout());
        shell.setText(Messages.getString("FlowVisualPanel.View_editor_Profile_setting_1"));
        FlowVisualPanel visualPanel = new FlowVisualPanel((Composite)shell, 2361344);
        VisualComponentImp compoent1 = new VisualComponentImp("Comp1");
        VisualComponentImp compoent2 = new VisualComponentImp("Comp2");
        VisualComponentImp compoent3 = new VisualComponentImp("Comp3");
        VisualComponentImp compoent4 = new VisualComponentImp("Comp4");
        VisualComponentImp compoent5 = new VisualComponentImp("Comp5");
        VisualComponentImp compoent6 = new VisualComponentImp("Comp6");
        visualPanel.addVisualComponent(compoent1);
        visualPanel.addVisualComponent(compoent2);
        visualPanel.addVisualComponent(compoent3);
        visualPanel.addVisualComponent(compoent4);
        visualPanel.addVisualComponent(compoent5);
        visualPanel.addVisualComponent(compoent6);
        ComponentLink link1 = new ComponentLink("link1", compoent1, compoent2);
        ComponentLink link2 = new ComponentLink("link2", compoent1, compoent3);
        ComponentLink link3 = new ComponentLink("link3", compoent2, compoent4);
        ComponentLink link4 = new ComponentLink("link4", compoent2, compoent5);
        ComponentLink link5 = new ComponentLink("link5", compoent3, compoent5);
        ComponentLink link6 = new ComponentLink("link6", compoent4, compoent6);
        ComponentLink link7 = new ComponentLink("link7", compoent5, compoent6);
        visualPanel.addComponentLink(link1);
        visualPanel.addComponentLink(link2);
        visualPanel.addComponentLink(link3);
        visualPanel.addComponentLink(link4);
        visualPanel.addComponentLink(link5);
        visualPanel.addComponentLink(link6);
        visualPanel.addComponentLink(link7);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

