/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualflow;

import com.ecc.ide.editor.PropertyEditorSuport;
import com.ecc.ide.editor.Wrapper;
import com.ecc.ide.editor.visualflow.TransitionWrapper;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import java.util.Vector;

public class TransitionPropertyEditor
extends PropertyEditorSuport {
    private Vector valueList = null;
    private Vector valueMapList = null;

    public void setValueList(Vector valueList) {
        this.valueList = valueList;
    }

    public void setValueMapList(Vector valueMapList) {
        this.valueMapList = valueMapList;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text.length() == 0) {
            this.setValue("");
        }
        int i = 0;
        while (i < this.valueList.size()) {
            String valueStr = (String)this.valueList.elementAt(i);
            if (valueStr.equals(text)) {
                if (this.valueMapList != null) {
                    this.setValue((String)this.valueMapList.elementAt(i));
                    break;
                }
                this.setValue(text);
                break;
            }
            ++i;
        }
    }

    private void setValue(String value) {
        super.setValue(value);
    }

    public String getAsText() {
        Object value = super.getValue();
        if (value == null) {
            return null;
        }
        if (this.valueMapList != null) {
            String valueStr = value.toString();
            int i = 0;
            while (i < this.valueMapList.size()) {
                String aValueStr = (String)this.valueMapList.elementAt(i);
                if (valueStr.equals(aValueStr)) {
                    return (String)this.valueList.elementAt(i);
                }
                ++i;
            }
            return null;
        }
        return value.toString();
    }

    public String[] getTags() {
        int size = this.valueList.size();
        String[] tags = new String[size];
        int i = 0;
        while (i < size) {
            tags[i] = (String)this.valueList.elementAt(i);
            ++i;
        }
        return tags;
    }

    public void setEditingWrapper(Wrapper wrapper) {
        super.setEditingWrapper(wrapper);
        this.valueList = null;
        if (wrapper instanceof TransitionWrapper) {
            TransitionWrapper transitionWrapper = (TransitionWrapper)wrapper;
            Element element = transitionWrapper.getSrcWrapper().getElement();
            Vector attrDefs = element.getAttributes();
            int i = 0;
            while (attrDefs != null && i < attrDefs.size()) {
                ElementAttribute attr = (ElementAttribute)attrDefs.elementAt(i);
                if ("states".equals(attr.getAttrID())) {
                    this.valueList = attr.getValueList();
                    this.valueMapList = attr.getValueMapList();
                    break;
                }
                ++i;
            }
            if (this.valueList != null && !"none".equals((String)this.valueList.elementAt(0)) && this.valueMapList != null && ((String)this.valueMapList.elementAt(0)).length() != 0) {
                this.valueList.add(0, "none");
                this.valueMapList.add(0, "");
            }
            if (this.valueList != null) {
                return;
            }
            String states = transitionWrapper.getSrcWrapper().getAttrValue("states");
            this.valueList = new Vector(10);
            this.valueMapList = new Vector(10);
            this.valueList.addElement("none");
            this.valueMapList.addElement("");
            if (states != null) {
                int idx2;
                int idx1;
                int len = states.length();
                int offset = 0;
                while ((idx1 = states.indexOf(61, offset)) > 0 && (idx2 = states.indexOf(59, idx1)) > 0) {
                    String value = states.substring(offset, idx1);
                    String desc = states.substring(idx1 + 1, idx2);
                    this.valueList.addElement(desc);
                    this.valueMapList.addElement(value);
                    offset = idx2 + 1;
                    if (offset < len) continue;
                    break;
                }
            }
        }
    }
}

