/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualflow;

import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import java.util.Vector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class TransitionWrapper
extends VisualElementWrapper {
    VisualElementWrapper srcWrapper;
    VisualElementWrapper dstWrapper;
    private Vector valueList = null;
    private Vector valueMapList = null;
    private String linkLabel = null;
    int xs;
    int ys;
    int xe;
    int ye;
    int apX1;
    int apY1;
    int apX2;
    int apY2;
    int al = 8;
    int arcHeight = 60;
    String statesValue = null;

    public TransitionWrapper() {
        this.setResizable(false);
        this.setMoveable(false);
    }

    public TransitionWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        super(pWrapper, node, profile);
        this.setResizable(false);
        this.setMoveable(false);
        this.initializeActionsStatesValue();
    }

    public TransitionWrapper(VisualElementWrapper src, VisualElementWrapper dst, XMLNode node, EditorProfile profile) {
        this.setResizable(false);
        this.setMoveable(false);
        super.setElement(profile.getElement(node.getNodeName()));
        super.setXMLNode(node);
        super.setParent(src);
        this.srcWrapper = src;
        this.dstWrapper = dst;
        this.initializeActionsStatesValue();
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        String dstId;
        if (!IDEConstance.isFoldVisible(this.node)) {
            return;
        }
        int seq = 0;
        int i = 0;
        while (i < this.getParentWrapper().node.getChilds().size()) {
            XMLNode child = (XMLNode)this.getParentWrapper().node.getChilds().elementAt(i);
            if ("transition".equals(child.getNodeName())) {
                if (child.equals(this.node)) break;
                ++seq;
            }
            ++i;
        }
        if (this.srcWrapper == null) {
            this.srcWrapper = this.getParentWrapper();
        }
        if (this.dstWrapper == null && (dstId = this.node.getAttrValue("dest")) != null) {
            VisualElementWrapper pWrap = this.getParentWrapper().getParentWrapper();
            if (pWrap != null) {
                this.dstWrapper = pWrap.getChildNamed(dstId);
            }
            if (this.dstWrapper == null && pWrap != null) {
                System.out.println("Invalid transition: \n" + this.node.toString());
                this.node.getParent().remove(this.node);
                this.editor.removeElement(this);
            }
        }
        if (this.srcWrapper == null || this.dstWrapper == null) {
            return;
        }
        String statesStr = this.srcWrapper.getAttrValue("states");
        if (!(statesStr == null || this.statesValue != null && statesStr.equals(this.statesValue))) {
            System.out.println(statesStr);
            this.initializeActionsStatesValue();
        }
        if (this.srcWrapper == this.dstWrapper) {
            int yOff = 0;
            this.arcHeight = this.srcWrapper.height;
            if (this.srcWrapper.height > 50) {
                yOff = (this.srcWrapper.height - 50) / 2;
                this.arcHeight = 50;
            }
            this.xs = this.srcWrapper.x;
            this.ys = this.srcWrapper.y + yOff;
            this.xe = this.xs;
            this.ye = this.ys + this.arcHeight;
            this.apX1 = this.xe - 16;
            this.apX2 = this.xe - 16;
            this.apY1 = this.ye - 4;
            this.apY2 = this.ye + 4;
        } else {
            this.calculateLinePosition();
            this.calculateArrow();
        }
        Rectangle parentClipRect = gc.getClipping();
        Rectangle clipRect = this.editor.getRootElement().getRectangle();
        gc.setClipping(clipRect);
        if (this.isActivated) {
            gc.setForeground(Display.getDefault().getSystemColor(3));
        } else {
            gc.setForeground(Display.getDefault().getSystemColor(2));
        }
        if (this.dstWrapper != this.srcWrapper) {
            if (seq > 0) {
                Point midPoint = this.getMidPoint(this.xs, this.ys, this.xe, this.ye);
                gc.drawLine(this.xs, this.ys, midPoint.x, midPoint.y);
                gc.drawLine(midPoint.x, midPoint.y, this.xe, this.ye);
            } else {
                gc.drawLine(this.xs, this.ys, this.xe, this.ye);
            }
        }
        gc.drawLine(this.xe, this.ye, this.apX1, this.apY1);
        gc.drawLine(this.xe, this.ye, this.apX2, this.apY2);
        this.linkLabel = this.getAttrValue("label");
        if (this.linkLabel == null || this.linkLabel.length() == 0) {
            this.linkLabel = this.getAttrValue("desc");
        }
        if (this.linkLabel == null || this.linkLabel.length() == 0) {
            this.linkLabel = this.getAttrValue("retValue");
        }
        if (this.linkLabel == null || this.linkLabel.length() == 0) {
            this.linkLabel = this.getAttrValue("condition");
        }
        if (this.linkLabel == null && this.getAttrValue("id") != null) {
            this.setLinkID(this.getAttrValue("id"));
        }
        if (this.dstWrapper == this.srcWrapper) {
            gc.drawArc(this.xs - this.arcHeight / 2, this.ys, this.arcHeight, this.arcHeight, 90, 180);
            if (this.linkLabel != null) {
                gc.drawString(this.linkLabel, this.xs - this.arcHeight, this.ys + this.arcHeight / 2);
            }
        } else if (this.linkLabel != null) {
            int deltY = this.ye - this.ys;
            if (deltY < 10 && deltY > -10) {
                if (this.xs < this.xe) {
                    gc.drawString(this.linkLabel, this.xs + 10, (this.ys + this.ye) / 2 + 5);
                } else {
                    gc.drawString(this.linkLabel, this.xe + 10, (this.ys + this.ye) / 2 + 5);
                }
            } else {
                gc.drawString(this.linkLabel, (this.xs + this.xe) / 2, (this.ys + this.ye) / 2);
            }
        }
        if (this.isActivated) {
            this.paintActivateSymbol(gc, xOffset, yOffset);
        }
        if (this.isSelected) {
            this.paintSelectedSymbol(gc, xOffset, yOffset);
        }
        gc.setClipping(parentClipRect);
    }

    public VisualElementWrapper getSrcWrapper() {
        return this.srcWrapper;
    }

    public VisualElementWrapper getDstWrapper() {
        return this.dstWrapper;
    }

    private void calculateLinePosition() {
        Rectangle srcRect = this.srcWrapper.getRectangle();
        Rectangle dstRect = this.dstWrapper.getRectangle();
        int x0 = srcRect.x + srcRect.width / 2;
        int y0 = srcRect.y + srcRect.height / 2;
        int x1 = dstRect.x + dstRect.width / 2;
        int y1 = dstRect.y + dstRect.height / 2;
        Point start = this.getLineToRectPoint(x0, y0, x1, y1, srcRect);
        this.xs = start.x;
        this.ys = start.y;
        Point end = this.getLineToRectPoint(x0, y0, x1, y1, dstRect);
        this.xe = end.x;
        this.ye = end.y;
    }

    private Point getLineToRectPoint(int x0, int y0, int x1, int y1, Rectangle rect) {
        int minX;
        Point point = new Point(0, 0);
        int minY = y0;
        if (minY > y1) {
            minY = y1;
        }
        if ((minX = x0) > x1) {
            minX = x1;
        }
        int width = Math.abs(x1 - x0);
        int height = Math.abs(y1 - y0);
        Rectangle lineRect = new Rectangle(minX, minY, width, height);
        if (x0 == x1) {
            if (rect.y > minY) {
                point.x = x0;
                point.y = rect.y;
                return point;
            }
            point.x = x0;
            point.y = rect.y + rect.height;
            return point;
        }
        if (y0 == y1) {
            if (rect.x > minX) {
                point.x = rect.x;
                point.y = y0;
                return point;
            }
            point.x = rect.x + rect.width;
            point.y = y0;
            return point;
        }
        int xx1 = rect.x;
        int xx2 = rect.x + rect.width;
        int yy1 = y0 - (y1 - y0) * (x0 - rect.x) / (x1 - x0);
        int yy2 = y0 - (y1 - y0) * (x0 - rect.x - rect.width) / (x1 - x0);
        if (this.isWithinRect(xx1, yy1, lineRect) && yy1 >= rect.y && yy1 <= rect.y + rect.height) {
            point.x = xx1;
            point.y = yy1;
            return point;
        }
        if (this.isWithinRect(xx2, yy2, lineRect) && yy2 >= rect.y && yy2 <= rect.y + rect.height) {
            point.x = xx2;
            point.y = yy2;
            return point;
        }
        yy1 = rect.y;
        yy2 = rect.y + rect.height;
        xx1 = x0 - (x1 - x0) * (y0 - rect.y) / (y1 - y0);
        xx2 = x0 - (x1 - x0) * (y0 - rect.y - rect.height) / (y1 - y0);
        if (this.isWithinRect(xx1, yy1, lineRect)) {
            point.x = xx1;
            point.y = yy1;
            return point;
        }
        if (this.isWithinRect(xx2, yy2, lineRect)) {
            point.x = xx2;
            point.y = yy2;
            return point;
        }
        return point;
    }

    private void calculateArrow() {
        int x = this.xs;
        int y = this.ys;
        int x1 = this.xe;
        int y1 = this.ye;
        this.apX1 = x1;
        this.apY1 = y1;
        this.apX2 = x1;
        this.apY2 = y1;
        double arrowWidth = 4.0;
        int ll = (x1 - x) * (x1 - x) + (y1 - y) * (y1 - y);
        if (ll == 0) {
            return;
        }
        ll = (int)Math.sqrt(ll);
        int xx = x1 > x ? x1 - this.al * (x1 - x) / ll - x : x1 + this.al * (x - x1) / ll - x;
        int yy = y1 > y ? y1 - this.al * (y1 - y) / ll - y : y1 + this.al * (y - y1) / ll - y;
        double l = ll - this.al;
        if (l <= 0.0) {
            return;
        }
        double arc = Math.atan(arrowWidth / l);
        this.apX1 = x + (int)((double)xx * Math.cos(arc) + (double)yy * Math.sin(arc));
        this.apY1 = y + (int)((double)(-xx) * Math.sin(arc) + (double)yy * Math.cos(arc));
        this.apX2 = x + (int)((double)xx * Math.cos(arc) - (double)yy * Math.sin(arc));
        this.apY2 = y + (int)((double)xx * Math.sin(arc) + (double)yy * Math.cos(arc));
    }

    private boolean isWithinRect(int x, int y, Rectangle rect) {
        return x >= rect.x && x <= rect.x + rect.width && y >= rect.y && y <= rect.y + rect.height;
    }

    public boolean isPointIn(int x, int y) {
        if (this.hasMultiLine() && !this.isFirstLine()) {
            return this.nearMidPoint(x, y);
        }
        int delta = 5;
        int x0 = this.xs;
        int x1 = this.xe;
        if (x0 > this.xe) {
            x0 = this.xe;
            x1 = this.xs;
        }
        int y0 = this.ys;
        int y1 = this.ye;
        if (y0 > this.ye) {
            y0 = this.ye;
            y1 = this.ys;
        }
        if (this.xe == this.xs) {
            return y >= y0 && y <= y1 && Math.abs(x - this.xs) < delta;
        }
        if (this.ye == this.ys) {
            return x >= x0 && x <= x1 && Math.abs(y - this.ys) < delta;
        }
        int xx1 = this.xs - (this.xe - this.xs) * (this.ys - y) / (this.ye - this.ys);
        int yy1 = this.ys - (this.ye - this.ys) * (this.xs - x) / (this.xe - this.xs);
        if (Math.abs(xx1 - x) < 4 && y >= y0 && y <= y1) {
            return true;
        }
        return Math.abs(yy1 - y) < 4 && x >= x0 && x <= x1;
    }

    protected void paintSelectedSymbol(GC gc, int xOff, int yOff) {
        int borderWidth = 5;
        gc.setForeground(Display.getDefault().getSystemColor(3));
        gc.drawRectangle(this.xs - borderWidth, this.ys - borderWidth, borderWidth, borderWidth);
        gc.drawRectangle(this.xe - borderWidth, this.ye - borderWidth, borderWidth, borderWidth);
    }

    protected void paintActivateSymbol(GC gc, int xOff, int yOff) {
        Color bkColor = gc.getBackground();
        gc.setBackground(Display.getDefault().getSystemColor(3));
        int borderWidth = 5;
        gc.fillRectangle(this.xs - borderWidth, this.ys - borderWidth, borderWidth, borderWidth);
        gc.fillRectangle(this.xe - borderWidth, this.ye - borderWidth, borderWidth, borderWidth);
        gc.setBackground(bkColor);
    }

    public void setAttrValue(String key, Object value) {
        if ("id".equals(key) && value != null) {
            String idStr = value.toString();
            this.setLinkID(idStr);
        }
        super.setAttrValue(key, value);
    }

    private void setLinkLabel(String value) {
        this.linkLabel = value;
    }

    private void setLinkID(String idStr) {
        if (this.valueMapList == null) {
            return;
        }
        int i = 0;
        while (i < this.valueMapList.size()) {
            String aId = (String)this.valueMapList.elementAt(i);
            if (idStr.equals(aId)) {
                this.linkLabel = (String)this.valueList.elementAt(i);
                break;
            }
            ++i;
        }
    }

    public void setParent(VisualElementWrapper pWrapper) {
        super.setParent(pWrapper);
        this.srcWrapper = pWrapper;
        this.initializeActionsStatesValue();
    }

    private void initializeActionsStatesValue() {
        String states;
        Vector attrDefs = this.srcWrapper.getElement().getAttributes();
        int i = 0;
        while (attrDefs != null && i < attrDefs.size()) {
            ElementAttribute attr = (ElementAttribute)attrDefs.elementAt(i);
            if ("states".equals(attr.getAttrID())) {
                this.valueList = attr.getValueList();
                this.valueMapList = attr.getValueMapList();
                break;
            }
            ++i;
        }
        if (this.valueList != null) {
            return;
        }
        this.valueList = new Vector(10);
        this.valueMapList = new Vector(10);
        this.statesValue = states = this.srcWrapper.getAttrValue("states");
        if (states != null) {
            int idx2;
            int idx1;
            int len = states.length();
            int offset = 0;
            while ((idx1 = states.indexOf(61, offset)) > 0 && (idx2 = states.indexOf(59, idx1)) > 0) {
                String value = states.substring(offset, idx1);
                String desc = states.substring(idx1 + 1, idx2);
                this.valueList.addElement(desc);
                this.valueMapList.addElement(value);
                offset = idx2 + 1;
                if (offset < len) continue;
                break;
            }
        }
    }

    protected void paintTabOrderSymbol(GC gc, int xOff, int yOff) {
        int offset = 5;
        int delta = 16;
        int x = this.x + xOff;
        int y = this.y + yOff;
        Color bkColor = gc.getBackground();
        gc.fillRectangle(x - offset, y - offset, delta, delta);
        String txt = String.valueOf(this.getTabOrder());
        gc.drawText(txt, x - offset + (delta - 8 * txt.length()) / 2, y - offset + 2);
        gc.setBackground(bkColor);
    }

    private Point getMidPoint(int x1, int y1, int x2, int y2) {
        int seq = 0;
        int i = 0;
        while (i < this.getParentWrapper().node.getChilds().size()) {
            XMLNode child = (XMLNode)this.getParentWrapper().node.getChilds().elementAt(i);
            if ("transition".equals(child.getNodeName())) {
                if (child.equals(this.node)) break;
                ++seq;
            }
            ++i;
        }
        int f = seq * 8;
        if (x1 == x2) {
            return new Point(x1 - f, (y2 - y1) / 2 + y1);
        }
        if (y1 == y2) {
            return new Point((x2 - x1) / 2 + x1, y2 - f);
        }
        float k = (y2 - y1) / (x2 - x1);
        double arc = Math.atan(-1.0f / k);
        double resulty = (y2 - y1) / 2 + y1;
        double resultx = (x2 - x1) / 2 + x1;
        Point point = new Point((int)(resultx += (double)f * Math.cos(arc)), (int)(resulty += (double)f * Math.sin(arc)));
        return point;
    }

    private boolean nearMidPoint(int x, int y) {
        boolean flag;
        Point midPoint = this.getMidPoint(this.xs, this.ys, this.xe, this.ye);
        boolean bl = flag = Math.abs(x - midPoint.x) * Math.abs(x - midPoint.x) + Math.abs(y - midPoint.y) * Math.abs(y - midPoint.y) <= 16;
        if (flag) {
            flag = true;
        }
        return flag;
    }

    private boolean isFirstLine() {
        int seq = 0;
        int i = 0;
        while (i < this.getParentWrapper().node.getChilds().size()) {
            XMLNode child = (XMLNode)this.getParentWrapper().node.getChilds().elementAt(i);
            if ("transition".equals(child.getNodeName())) {
                if (child.equals(this.node)) break;
                ++seq;
            }
            ++i;
        }
        return seq == 0;
    }

    private boolean hasMultiLine() {
        int seq = 0;
        int i = 0;
        while (i < this.getParentWrapper().node.getChilds().size()) {
            XMLNode child = (XMLNode)this.getParentWrapper().node.getChilds().elementAt(i);
            if ("transition".equals(child.getNodeName())) {
                ++seq;
            }
            ++i;
        }
        return seq > 1;
    }
}

