/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualflow;

import com.ecc.ide.editor.Wrapper;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualflow.ActionElementWrapper;
import com.ecc.ide.editor.visualflow.FlowExtendPointElementWrapper;
import com.ecc.ide.editor.visualflow.Messages;
import com.ecc.ide.editor.visualflow.TransitionWrapper;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.ProfileObjectMaker;
import com.ecc.ide.visualeditor.VisualEditorFramePanel;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import com.swtdesigner.ResourceManager;
import java.io.FileWriter;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

public class VisualFlowFramePanel
extends VisualEditorFramePanel {
    private boolean isMainFlow = true;
    private ToolItem linkItem;
    public boolean isPop = false;
    static /* synthetic */ Class class$0;

    public VisualFlowFramePanel(Composite parent, int style) {
        super(parent, style);
        this.unitToolItem.dispose();
        this.linkItem = new ToolItem(this.toolBar, 32);
        this.linkItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualFlowFramePanel.this.beginLink();
            }
        });
        this.linkItem.setToolTipText(Messages.getString("VisualFlowFramePanel.State_transition_1"));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.linkItem.setImage(ResourceManager.getImage(clazz, "/images/action.gif"));
        ToolItem foldItem = new ToolItem(this.toolBar, 32);
        foldItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualFlowFramePanel.this.workingArea.foldSelectNode();
            }
        });
        foldItem.setToolTipText("\u9690\u85cf\u8282\u70b9");
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        foldItem.setImage(ResourceManager.getImage(clazz2, "/images/fold.gif"));
        this.workingArea.setBackground(Display.getCurrent().getSystemColor(1));
    }

    private void beginLink() {
        this.workingArea.beginLink();
    }

    public void doLink(VisualElementWrapper src, VisualElementWrapper dst) {
        this.linkItem.setSelection(false);
        if (!this.isMainFlow) {
            String parentName = src.getParentWrapper().getElement().getElementName();
            String name = src.getElement().getElementName();
            if (!"ExtendedAction".equals(parentName)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Message", (String)"You can't change the main flow!");
                return;
            }
        }
        XMLNode node = new XMLNode();
        node.setNodeName("transition");
        node.setAttrValue("name", this.getObjectName("transition"));
        node.setAttrValue("dest", dst.getAttrValue("name"));
        TransitionWrapper wrapper = new TransitionWrapper(src, dst, node, this.profile);
        wrapper.editor = this;
        src.getXMLNode().add(node);
        super.addWrapper(src, wrapper);
        super.setActivateWrapper(wrapper);
        this.workingArea.saveCurrentAction();
    }

    public void cancelCurrentAction() {
        super.cancelCurrentAction();
        this.linkItem.setSelection(false);
    }

    public static void main(String[] argv) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText(Messages.getString("VisualFlowFramePanel.Test_Frame_8"));
        VisualFlowFramePanel test = new VisualFlowFramePanel((Composite)shell, 2048);
        try {
            String fileName = "/profiles/srvActionProfile.xml";
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new ProfileObjectMaker());
            EditorProfile profile = (EditorProfile)xmlLoader.loadXMLFile(fileName);
            if (profile != null) {
                test.setEditorProfile(profile);
                test.loadXMLFile("testFlow.xml");
                if (profile.getTitle() != null) {
                    shell.setText(profile.getTitle());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        try {
            FileWriter fw = new FileWriter("testFlow.xml");
            fw.write(test.getXMLStringContent());
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeElement(VisualElementWrapper wrapper) {
        if (wrapper == null) {
            return;
        }
        if (!this.isMainFlow) {
            String parentName = null;
            String name = wrapper.getElement().getElementName();
            parentName = "transition".equals(name) ? wrapper.getParentWrapper().getParentWrapper().getElement().getElementName() : wrapper.getParentWrapper().getElement().getElementName();
            if (!"ExtendedAction".equals(parentName)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Message", (String)"You can't change the main flow!");
                return;
            }
        }
        super.removeElement(wrapper);
        if (wrapper instanceof ActionElementWrapper || wrapper instanceof FlowExtendPointElementWrapper) {
            String objName = wrapper.getAttrValue("name");
            Vector elements = (Vector)super.getVisualElements().clone();
            int i = 0;
            while (i < elements.size()) {
                VisualElementWrapper aWrapper = (VisualElementWrapper)elements.elementAt(i);
                if (aWrapper instanceof TransitionWrapper && objName.equals(aWrapper.getAttrValue("dest"))) {
                    super.removeElement(aWrapper);
                }
                ++i;
            }
        }
    }

    public void setActivateWrapper(Wrapper wrapper) {
        VisualElementWrapper vWrapper = (VisualElementWrapper)wrapper;
        if (!vWrapper.getIsShow()) {
            return;
        }
        if (wrapper == this.getRootElement()) {
            super.setActivateWrapper(wrapper);
            return;
        }
        if (!this.isMainFlow) {
            String parentName = null;
            String name = wrapper.getElement().getElementName();
            if ("ExtendedAction".equals(name)) {
                super.setActivateWrapper(wrapper);
                return;
            }
            parentName = "transition".equals(name) ? vWrapper.getParentWrapper().getParentWrapper().getElement().getElementName() : vWrapper.getParentWrapper().getElement().getElementName();
            if ("ExtendedAction".equals(parentName)) {
                super.setActivateWrapper(wrapper);
                return;
            }
        } else {
            super.setActivateWrapper(wrapper);
        }
    }

    public boolean isMainFlow() {
        return this.isMainFlow;
    }

    public void setMainFlow(boolean isMainFlow) {
        this.isMainFlow = isMainFlow;
    }

    public void addMaximizedItem() {
        ToolItem maximizedItem = new ToolItem(this.toolBar, 8);
        maximizedItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualFlowFramePanel.this.maximizedEditPrivateFlow();
            }
        });
        maximizedItem.setToolTipText("\u6700\u5927\u5316");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        maximizedItem.setImage(ResourceManager.getImage(clazz, "/images/maximized.gif"));
    }

    private void maximizedEditPrivateFlow() {
        Shell parent = this.getShell();
        Shell shell = new Shell(parent, 67696);
        shell.setLayout((Layout)new FillLayout());
        shell.setText("Visual Editor");
        VisualFlowFramePanel visualFlowFramePanel = this.clone(shell);
        shell.setMaximized(true);
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        try {
            this.setXMLContent(this.xmlContent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private VisualFlowFramePanel clone(Shell shell) {
        VisualFlowFramePanel visualFlowFramePanel = new VisualFlowFramePanel((Composite)shell, 0);
        visualFlowFramePanel.setEditorProfile(this.getEditorProfile());
        visualFlowFramePanel.setDataEditorProfile(this.getDataEditorProfile());
        visualFlowFramePanel.setDataDictionary(this.getDataDictionary());
        visualFlowFramePanel.setSelfDefineNode(this.getSelfDefineNode());
        visualFlowFramePanel.setCommonServiceNode(this.getCommonServiceNode());
        visualFlowFramePanel.setChannelSettings(this.getChannelSettings());
        visualFlowFramePanel.setExternResource(this.getExternResource());
        visualFlowFramePanel.setFunctionNode(this.getFunctionNode());
        visualFlowFramePanel.setMainFlow(this.isMainFlow);
        try {
            visualFlowFramePanel.setXMLContent(this.xmlContent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return visualFlowFramePanel;
    }
}

