/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualhtml;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import java.util.Vector;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ElementLinkWrapper
extends VisualElementWrapper {
    VisualElementWrapper srcWrapper;
    VisualElementWrapper dstWrapper;
    private Vector valueList = new Vector(20);
    private Vector valueMapList = new Vector(20);
    private String linkLabel = null;
    int xs;
    int ys;
    int xe;
    int ye;
    int apX1;
    int apY1;
    int apX2;
    int apY2;
    int al = 16;

    public ElementLinkWrapper() {
        this.setResizable(false);
        this.setMoveable(false);
    }

    public ElementLinkWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        super(pWrapper, node, profile);
        this.setResizable(false);
        this.setMoveable(false);
    }

    public ElementLinkWrapper(VisualElementWrapper src, VisualElementWrapper dst, XMLNode node, EditorProfile profile) {
        this.setResizable(false);
        this.setMoveable(false);
        super.setElement(profile.getElement(node.getNodeName()));
        super.setXMLNode(node);
        this.srcWrapper = src;
        this.dstWrapper = dst;
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        String dstId;
        if (this.srcWrapper == null) {
            this.srcWrapper = this.getParentWrapper();
        }
        if (this.dstWrapper == null && (dstId = this.node.getAttrValue("dest")) != null) {
            this.dstWrapper = this.editor.getVisualElementNamed(dstId);
        }
        if (this.srcWrapper == null || this.dstWrapper == null) {
            return;
        }
        this.calculateLinePosition();
        this.calculateArrow();
        int x = this.x + xOffset;
        int y = this.y + yOffset;
        Rectangle parentClipRect = gc.getClipping();
        Rectangle clipRect = this.editor.getRootElement().getRectangle();
        gc.setClipping(clipRect);
        gc.setForeground(Display.getDefault().getSystemColor(6));
        gc.drawLine(this.xs, this.ys, this.xe, this.ye);
        gc.drawLine(this.xe, this.ye, this.apX1, this.apY1);
        gc.drawLine(this.xe, this.ye, this.apX2, this.apY2);
        gc.setClipping(parentClipRect);
    }

    public VisualElementWrapper getSrcWrapper() {
        return this.srcWrapper;
    }

    public VisualElementWrapper getDstWrapper() {
        return this.dstWrapper;
    }

    private void calculateLinePosition() {
        Rectangle srcRect = this.srcWrapper.getRectangle();
        Rectangle dstRect = this.dstWrapper.getRectangle();
        int x0 = srcRect.x + srcRect.width / 2;
        int y0 = srcRect.y + srcRect.height / 2;
        int x1 = dstRect.x + dstRect.width / 2;
        int y1 = dstRect.y + dstRect.height / 2;
        Point start = this.getLineToRectPoint(x0, y0, x1, y1, srcRect);
        this.xs = start.x;
        this.ys = start.y;
        Point end = this.getLineToRectPoint(x0, y0, x1, y1, dstRect);
        this.xe = end.x;
        this.ye = end.y;
    }

    private Point getLineToRectPoint(int x0, int y0, int x1, int y1, Rectangle rect) {
        int minX;
        Point point = new Point(0, 0);
        int minY = y0;
        if (minY > y1) {
            minY = y1;
        }
        if ((minX = x0) > x1) {
            minX = x1;
        }
        int width = Math.abs(x1 - x0);
        int height = Math.abs(y1 - y0);
        Rectangle lineRect = new Rectangle(minX, minY, width, height);
        if (x0 == x1) {
            if (rect.y > minY) {
                point.x = x0;
                point.y = rect.y;
                return point;
            }
            point.x = x0;
            point.y = rect.y + rect.height;
            return point;
        }
        if (y0 == y1) {
            if (rect.x > minX) {
                point.x = rect.x;
                point.y = y0;
                return point;
            }
            point.x = rect.x + rect.width;
            point.y = y0;
            return point;
        }
        int xx1 = rect.x;
        int xx2 = rect.x + rect.width;
        int yy1 = y0 - (y1 - y0) * (x0 - rect.x) / (x1 - x0);
        int yy2 = y0 - (y1 - y0) * (x0 - rect.x - rect.width) / (x1 - x0);
        if (this.isWithinRect(xx1, yy1, lineRect) && yy1 >= rect.y && yy1 <= rect.y + rect.height) {
            point.x = xx1;
            point.y = yy1;
            return point;
        }
        if (this.isWithinRect(xx2, yy2, lineRect) && yy2 >= rect.y && yy2 <= rect.y + rect.height) {
            point.x = xx2;
            point.y = yy2;
            return point;
        }
        yy1 = rect.y;
        yy2 = rect.y + rect.height;
        xx1 = x0 - (x1 - x0) * (y0 - rect.y) / (y1 - y0);
        xx2 = x0 - (x1 - x0) * (y0 - rect.y - rect.height) / (y1 - y0);
        if (this.isWithinRect(xx1, yy1, lineRect)) {
            point.x = xx1;
            point.y = yy1;
            return point;
        }
        if (this.isWithinRect(xx2, yy2, lineRect)) {
            point.x = xx2;
            point.y = yy2;
            return point;
        }
        return point;
    }

    private void calculateArrow() {
        int x = this.xs;
        int y = this.ys;
        int x1 = this.xe;
        int y1 = this.ye;
        this.apX1 = x1;
        this.apY1 = y1;
        this.apX2 = x1;
        this.apY2 = y1;
        double arrowWidth = 8.0;
        int ll = (x1 - x) * (x1 - x) + (y1 - y) * (y1 - y);
        if (ll == 0) {
            return;
        }
        ll = (int)Math.sqrt(ll);
        int xx = x1 > x ? x1 - this.al * (x1 - x) / ll - x : x1 + this.al * (x - x1) / ll - x;
        int yy = y1 > y ? y1 - this.al * (y1 - y) / ll - y : y1 + this.al * (y - y1) / ll - y;
        double l = ll - this.al;
        if (l <= 0.0) {
            return;
        }
        double arc = Math.atan(arrowWidth / l);
        this.apX1 = x + (int)((double)xx * Math.cos(arc) + (double)yy * Math.sin(arc));
        this.apY1 = y + (int)((double)(-xx) * Math.sin(arc) + (double)yy * Math.cos(arc));
        this.apX2 = x + (int)((double)xx * Math.cos(arc) - (double)yy * Math.sin(arc));
        this.apY2 = y + (int)((double)xx * Math.sin(arc) + (double)yy * Math.cos(arc));
    }

    private boolean isWithinRect(int x, int y, Rectangle rect) {
        return x >= rect.x && x <= rect.x + rect.width && y >= rect.y && y <= rect.y + rect.height;
    }

    public boolean isPointIn(int x, int y) {
        int delta = 5;
        int x0 = this.xs;
        int x1 = this.xe;
        if (x0 > this.xe) {
            x0 = this.xe;
            x1 = this.xs;
        }
        int y0 = this.ys;
        int y1 = this.ye;
        if (y0 > this.ye) {
            y0 = this.ye;
            y1 = this.ys;
        }
        if (this.xe == this.xs) {
            return y >= y0 && y <= y1 && Math.abs(x - this.xs) < delta;
        }
        if (this.ye == this.ys) {
            return x >= x0 && x <= x1 && Math.abs(y - this.ys) < delta;
        }
        int xx1 = this.xs - (this.xe - this.xs) * (this.ys - y) / (this.ye - this.ys);
        int yy1 = this.ys - (this.ye - this.ys) * (this.xs - x) / (this.xe - this.xs);
        if (Math.abs(xx1 - x) < 4 && y >= y0 && y <= y1) {
            return true;
        }
        return Math.abs(yy1 - y) < 4 && x >= x0 && x <= x1;
    }

    public void setAttrValue(String key, Object value) {
        if ("id".equals(key) && value != null) {
            String idStr = value.toString();
            this.setLinkID(idStr);
        }
        super.setAttrValue(key, value);
    }

    private void setLinkID(String idStr) {
        int i = 0;
        while (i < this.valueMapList.size()) {
            String aId = (String)this.valueMapList.elementAt(i);
            if (idStr.equals(aId)) {
                this.linkLabel = (String)this.valueList.elementAt(i);
                break;
            }
            ++i;
        }
    }
}

