/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualhtml;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class HTMLFlowElementWrapper
extends VisualElementWrapper {
    public HTMLFlowElementWrapper() {
    }

    public HTMLFlowElementWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        super(pWrapper, node, profile);
        this.width = 80;
        this.height = 50;
        try {
            this.x = Integer.parseInt(node.getAttrValue("fx"));
            this.y = Integer.parseInt(node.getAttrValue("fy"));
            this.width = Integer.parseInt(node.getAttrValue("fWidth"));
            this.height = Integer.parseInt(node.getAttrValue("fHeight"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setXMLNode(XMLNode node) {
        super.setXMLNode(node);
        this.width = 80;
        this.height = 50;
        try {
            this.x = Integer.parseInt(node.getAttrValue("fx"));
            this.y = Integer.parseInt(node.getAttrValue("fy"));
            this.width = Integer.parseInt(node.getAttrValue("fWidth"));
            this.height = Integer.parseInt(node.getAttrValue("fHeight"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        Rectangle rec = new Rectangle(0, 0, 10, 10);
        if (this.getParentWrapper() != null) {
            Rectangle rec1 = this.getParentWrapper().getRectangle();
            rec.x = rec1.x;
            rec.y = rec1.y;
        }
        this.x = x - rec.x;
        this.y = y - rec.y;
        this.width = width;
        this.height = height;
        this.node.setAttrValue("fx", String.valueOf(this.x));
        this.node.setAttrValue("fy", String.valueOf(this.y));
        this.node.setAttrValue("fWidth", String.valueOf(width));
        this.node.setAttrValue("fHeight", String.valueOf(height));
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.node.setAttrValue("fWidth", String.valueOf(width));
        this.node.setAttrValue("fHeight", String.valueOf(height));
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        String label;
        int x = this.x + xOffset;
        int y = this.y + yOffset;
        Rectangle parentClipRect = gc.getClipping();
        Rectangle clipRect = this.clipRect(this.getRectangle(), parentClipRect);
        gc.setClipping(clipRect);
        gc.fillRectangle(x, y, this.width, this.height);
        gc.setForeground(Display.getDefault().getSystemColor(2));
        Image image = this.element.getImage();
        int txtY = y + 3;
        if (image != null) {
            int imWidth = image.getBounds().width;
            gc.drawImage(image, x + (this.width - imWidth) / 2, y + 3);
            txtY = txtY + image.getBounds().height + 2;
        }
        if ((label = this.getLabel()) == null) {
            label = "Unamed [" + this.node.getNodeName() + "]";
        }
        int w = gc.getFontMetrics().getAverageCharWidth() * label.getBytes().length;
        gc.drawText(label, x + (this.width - w) / 2, txtY);
        if (this.isActivated) {
            this.paintActivateSymbol(gc, xOffset, yOffset);
        }
        if (this.isSelected) {
            this.paintSelectedSymbol(gc, xOffset, yOffset);
        }
        if (this.getParentWrapper() != null && this.getParentWrapper().getIsSetTabOrder()) {
            this.paintTabOrderSymbol(gc, xOffset, yOffset);
        }
        gc.setClipping(parentClipRect);
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.childs.elementAt(i);
            wrapper.paintControl(gc, x, y);
            ++i;
        }
    }

    public boolean canBeDelete() {
        return false;
    }

    public String getLabel() {
        return this.node.getAttrValue("name");
    }
}

