/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualhtml;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import java.io.BufferedReader;
import java.io.StringReader;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class HtmlCustomizedContentWrapper
extends VisualElementWrapper {
    public HtmlCustomizedContentWrapper() {
        this.setResizable(false);
        this.width = 17;
        this.height = 17;
    }

    public HtmlCustomizedContentWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        super(pWrapper, node, profile);
        this.setResizable(false);
        this.width = 17;
        this.height = 17;
    }

    public void setBounds(int x, int y, int width, int height) {
        int x1 = this.x;
        int y1 = this.y;
        int w1 = this.width;
        int h1 = this.height;
        Rectangle rec = new Rectangle(0, 0, 10, 10);
        if (this.getParentWrapper() != null) {
            Rectangle rec1 = this.getParentWrapper().getRectangle();
            rec.x = rec1.x;
            rec.y = rec1.y;
        }
        this.x = x - rec.x;
        this.y = y - rec.y;
        if (x1 == this.x && y1 == this.y) {
            return;
        }
        this.node.setAttrValue("x", String.valueOf(this.x));
        this.node.setAttrValue("y", String.valueOf(this.y));
    }

    public void setXMLNode(XMLNode node) {
        super.setXMLNode(node);
        this.width = 17;
        this.height = 17;
    }

    public void setSize(int width, int height) {
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        String text;
        int x = this.x + xOffset;
        int y = this.y + yOffset;
        Rectangle parentClipRect = gc.getClipping();
        Rectangle clipRect = this.clipRect(this.getRectangle(), parentClipRect);
        gc.setClipping(clipRect);
        Color bkColor = gc.getBackground();
        Image image = this.element.getImage();
        if (image != null) {
            gc.drawImage(image, x, y);
        }
        if (this.isActivated) {
            this.paintActivateSymbol(gc, xOffset, yOffset);
        }
        if (this.isSelected) {
            this.paintSelectedSymbol(gc, xOffset, yOffset);
        }
        if (this.getParentWrapper() != null && this.getParentWrapper().getIsSetTabOrder()) {
            this.paintTabOrderSymbol(gc, xOffset, yOffset);
        }
        if (this.isActivated && (text = this.node.getAttrValue("nodeValue")) != null) {
            Rectangle rect = this.getNotationRectangle(gc, text);
            rect.x = x + 5;
            rect.y = y + 5;
            gc.setClipping(rect);
            gc.setBackground(Display.getDefault().getSystemColor(29));
            --rect.height;
            --rect.width;
            gc.fillRectangle(rect);
            gc.setForeground(Display.getDefault().getSystemColor(28));
            gc.drawRectangle(rect);
            gc.drawText(text, x + 10, y + 10, 3);
        }
        gc.setBackground(bkColor);
        gc.setClipping(parentClipRect);
    }

    private Rectangle getNotationRectangle(GC gc, String text) {
        Rectangle rect = new Rectangle(0, 0, 200, 120);
        try {
            String aline;
            StringReader sr = new StringReader(text);
            BufferedReader br = new BufferedReader(sr);
            String longestLine = "";
            int lineCount = 0;
            while ((aline = br.readLine()) != null) {
                ++lineCount;
                if (aline.length() <= longestLine.length()) continue;
                longestLine = aline;
            }
            int height = lineCount * gc.getFontMetrics().getHeight() + 10;
            int width = longestLine.length() * gc.getFontMetrics().getAverageCharWidth();
            if (height > 300) {
                height = 300;
            }
            if (width > 500) {
                width = 500;
            }
            rect.height = height;
            rect.width = width;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rect;
    }
}

