/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualhtml;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualhtml.TableCell;
import com.ecc.ide.editor.visualhtml.TableLine;
import com.ecc.ide.editor.visualhtml.XMLToHtmlConvertor;
import java.util.Vector;
import org.eclipse.swt.graphics.Rectangle;

public class HtmlTableMaker {
    private XMLToHtmlConvertor convertor;
    private Vector tableLines = null;
    int cols = 0;
    int rows = 0;
    int[] colX0 = new int[50];
    int[] rowY0 = new int[50];
    byte[][] cellSpace = new byte[50][50];
    private static final int XDIFF = 10;
    private static final int YDIFF = 5;

    public HtmlTableMaker() {
    }

    public HtmlTableMaker(XMLToHtmlConvertor convertor) {
        this.convertor = convertor;
    }

    private void addCol(int x0) {
        int idx = this.cols;
        boolean isFind = false;
        int k = 0;
        k = 0;
        while (k < this.cols) {
            int x = this.colX0[k];
            int dif = x0 - x;
            if (dif < 0) {
                dif = -dif;
            }
            if (dif <= 10) {
                isFind = true;
                break;
            }
            if (x > x0 && idx == this.cols) {
                idx = k;
            }
            ++k;
        }
        if (!isFind) {
            if (this.cols == 0) {
                this.colX0[idx] = x0;
            } else {
                int j = this.cols;
                while (j > idx) {
                    this.colX0[j] = this.colX0[j - 1];
                    --j;
                }
                this.colX0[idx] = x0;
            }
            ++this.cols;
        }
    }

    private TableCell addTableCell(XMLNode node) {
        TableCell tableCell = new TableCell(this.convertor, node);
        int i = 0;
        while (i < this.tableLines.size()) {
            TableLine tableLine = (TableLine)this.tableLines.elementAt(i);
            int ly = tableLine.y0;
            int dif = ly - tableCell.y0;
            if (dif < 0) {
                dif = -dif;
            }
            if (dif <= 5) {
                tableLine.addTableCell(tableCell);
                return tableCell;
            }
            ++i;
        }
        TableLine aTableLine = new TableLine(tableCell);
        this.addTableLine(aTableLine);
        return tableCell;
    }

    private void addTableLine(TableLine tableLine) {
        int y = tableLine.y0;
        int i = 0;
        while (i < this.tableLines.size()) {
            TableLine aTableLine = (TableLine)this.tableLines.elementAt(i);
            int y0 = aTableLine.y0;
            if (y < y0) {
                this.tableLines.insertElementAt(tableLine, i);
                return;
            }
            ++i;
        }
        this.tableLines.addElement(tableLine);
    }

    public void getHtmlTable(StringBuffer buffer, XMLNode node) {
        this.getHtmlTable(buffer, node, -1);
    }

    public void getHtmlTable(StringBuffer buffer, XMLNode node, int layout) {
        this.tableLines = new Vector();
        int x0 = 100000;
        int y0 = 100000;
        int xe = 0;
        int ye = 0;
        Vector childs = node.getChilds();
        if (childs == null || childs.size() == 0) {
            return;
        }
        TableCell curTableCell = null;
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if ("notation".equals(aNode.getNodeName())) {
                String notationTypeStr = aNode.getAttrValue("notateType");
                int noType = 0;
                try {
                    noType = Integer.parseInt(notationTypeStr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (noType != 0 && noType != 2 && noType != 3 && curTableCell != null) {
                    curTableCell.addAppendedNotation(aNode);
                }
            } else if (!("HiddenField".equals(aNode.getNodeName()) || "javaScript".equals(aNode.getNodeName()) || "funcDef".equals(aNode.getNodeName()) || "script".equals(aNode.getNodeName()) || "#text".equals(aNode.getNodeName()))) {
                curTableCell = this.addTableCell(aNode);
                Rectangle rec = HtmlTableMaker.getBounds(aNode);
                int x = rec.x;
                this.addCol(x);
                if (x0 > rec.x) {
                    x0 = rec.x;
                }
                if (y0 > rec.y) {
                    y0 = rec.y;
                }
                if (xe < rec.x + rec.width) {
                    xe = rec.x + rec.width;
                }
                if (ye < rec.y + rec.height) {
                    ye = rec.y + rec.height;
                }
            }
            ++i;
        }
        this.colX0[this.cols] = xe;
        i = 0;
        while (i < this.tableLines.size()) {
            this.rowY0[i] = ((TableLine)this.tableLines.elementAt((int)i)).y0;
            ++i;
        }
        this.rowY0[this.tableLines.size()] = ye;
        this.rows = this.tableLines.size();
        if (layout == 0) {
            String classStr = node.getAttrValue("CSSClass");
            if (classStr != null) {
                buffer.append("<Table width= \"");
                buffer.append(node.getAttrValue("width"));
                buffer.append("\" class=\"");
                buffer.append(classStr);
                buffer.append("\" ");
            } else {
                buffer.append("<Table width= \"");
                buffer.append(xe - x0);
                buffer.append("\" ");
            }
            if (node.getAttrValue("align") != null) {
                buffer.append(" align=\"");
                buffer.append(node.getAttrValue("align"));
                buffer.append("\" ");
            }
            if (node.getAttrValue("cellspacing") != null) {
                buffer.append(" cellspacing=\"");
                buffer.append(node.getAttrValue("cellspacing"));
                buffer.append("\" ");
            }
            if (node.getAttrValue("cellpadding") != null) {
                buffer.append(" cellpadding=\"");
                buffer.append(node.getAttrValue("cellpadding"));
                buffer.append("\" ");
            }
            if (node.getAttrValue("border") != null) {
                buffer.append(" border=\"");
                buffer.append(node.getAttrValue("border"));
                buffer.append("\" ");
            }
            if (node.getAttrValue("background") != null) {
                buffer.append(" background=\"");
                if (!XMLToHtmlConvertor.isPreview) {
                    buffer.append("<%=utb.getJSPPath(\"");
                    buffer.append(this.convertor.getImageFilePath(node.getAttrValue("background")));
                    buffer.append("\")%>\" ");
                } else {
                    buffer.append(this.convertor.getImageFilePath(node.getAttrValue("background")));
                    buffer.append("\" ");
                }
                buffer.append(" ");
            }
            int i2 = 0;
            while (i2 < childs.size()) {
                XMLNode aNode = (XMLNode)childs.elementAt(i2);
                if ("notation".equals(aNode.getNodeName())) {
                    String notationTypeStr = aNode.getAttrValue("notateType");
                    int noType = 0;
                    try {
                        noType = Integer.parseInt(notationTypeStr);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (noType == 3) {
                        buffer.append(aNode.getAttrValue("nodeValue"));
                    }
                }
                ++i2;
            }
            buffer.append(">\n");
        }
        i = 0;
        while (i < this.tableLines.size()) {
            TableLine tableLine = (TableLine)this.tableLines.elementAt(i);
            this.getTableLineHTMLString(buffer, i, tableLine, layout);
            ++i;
        }
        if (layout == 0) {
            buffer.append("\n</table>");
        }
    }

    private void getTableLineHTMLString(StringBuffer buffer, int line, TableLine tableLine, int layout) {
        int nodeType;
        TableCell lastCell = null;
        if (layout == 0) {
            buffer.append("\n<tr>");
        }
        int curCol = 0;
        int i = 0;
        while (i < tableLine.tableCells.size()) {
            TableCell tableCell;
            lastCell = tableCell = (TableCell)tableLine.tableCells.elementAt(i);
            int x0 = tableCell.x0;
            int j = 0;
            j = curCol;
            while (j < this.cols) {
                int x = this.colX0[j];
                int dif = x - x0;
                if (dif < 0) {
                    dif = -dif;
                }
                if (dif <= 10) {
                    int lR;
                    int k = 0;
                    k = j + 1;
                    while (k < this.cols) {
                        if (tableCell.x0 + tableCell.width <= this.colX0[k]) break;
                        ++tableCell.colspan;
                        ++k;
                    }
                    tableCell.width = this.colX0[k] - this.colX0[j];
                    k = line + 1;
                    while (k < this.rows) {
                        if (tableCell.y0 + tableCell.height <= this.rowY0[k]) break;
                        ++tableCell.rowspan;
                        ++k;
                    }
                    tableCell.height = this.rowY0[k] - this.rowY0[line];
                    tableCell.getHTMLString(buffer, layout);
                    this.cellSpace[line][j] = 1;
                    int ll = 0;
                    while (ll < tableCell.colspan) {
                        this.cellSpace[line][j + 1 + ll] = 1;
                        lR = 0;
                        while (lR < tableCell.rowspan) {
                            this.cellSpace[line + lR + 1][j + 1 + ll] = 1;
                            ++lR;
                        }
                        ++ll;
                    }
                    ll = 0;
                    while (ll < tableCell.rowspan) {
                        this.cellSpace[line + ll + 1][j] = 1;
                        lR = 0;
                        while (lR < tableCell.colspan) {
                            this.cellSpace[line + ll + 1][j + lR + 1] = 1;
                            ++lR;
                        }
                        ++ll;
                    }
                    break;
                }
                if (this.cellSpace[line][j] == 0 && layout == 0) {
                    buffer.append("<td></td>");
                }
                ++j;
            }
            curCol = ++j;
            ++i;
        }
        if (layout == 0) {
            buffer.append("</tr>\n");
        } else if (lastCell != null && (nodeType = lastCell.getNodeType(lastCell.node.getNodeName())) != TableCell.NODE_BLOCK && nodeType != TableCell.NODE_DIV && nodeType != TableCell.NODE_IMAGE) {
            buffer.append("<br>\n");
        }
    }

    public static Rectangle getBounds(XMLNode node) {
        Rectangle rec = new Rectangle(10, 10, 20, 40);
        try {
            int x = Integer.parseInt(node.getAttrValue("x"));
            int y = Integer.parseInt(node.getAttrValue("y"));
            int height = Integer.parseInt(node.getAttrValue("height"));
            int width = Integer.parseInt(node.getAttrValue("width"));
            rec.x = x;
            rec.y = y;
            rec.height = height;
            rec.width = width;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rec;
    }
}

