/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualhtml;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualEditorFramePanel;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ImageWrapper
extends VisualElementWrapper {
    private String imageFileName;
    private Image image;

    public ImageWrapper() {
    }

    public ImageWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        super(pWrapper, node, profile);
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        int x = this.x + xOffset;
        int y = this.y + yOffset;
        Rectangle parentClipRect = gc.getClipping();
        Rectangle clipRect = this.clipRect(this.getRectangle(), parentClipRect);
        gc.setClipping(clipRect);
        this.loadImage();
        if (this.image == null) {
            Image iconImage = this.element.getImage();
            if (iconImage != null) {
                gc.drawImage(iconImage, x, y);
            }
        } else {
            gc.drawImage(this.image, x, y);
        }
        if (this.isActivated) {
            this.paintActivateSymbol(gc, xOffset, yOffset);
        }
        if (this.isSelected) {
            this.paintSelectedSymbol(gc, xOffset, yOffset);
        }
        if (this.getParentWrapper() != null && this.getParentWrapper().getIsSetTabOrder()) {
            this.paintTabOrderSymbol(gc, xOffset, yOffset);
        }
        gc.setClipping(parentClipRect);
    }

    private void loadImage() {
        String fileName = this.node.getAttrValue("imageFile");
        if (fileName == null || fileName.length() == 0) {
            this.imageFileName = null;
            if (this.image != null) {
                this.image.dispose();
            }
            this.image = null;
            return;
        }
        if (fileName.equals(this.imageFileName)) {
            return;
        }
        try {
            String rootPath = "";
            if (this.editor instanceof VisualEditorFramePanel) {
                rootPath = ((VisualEditorFramePanel)this.editor).getRootPath();
            }
            this.imageFileName = String.valueOf(rootPath) + "/" + fileName;
            FileInputStream fi = new FileInputStream(this.imageFileName);
            this.image = new Image(null, (InputStream)fi);
            fi.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

