/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualhtml;

import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualhtml.HtmlTableMaker;
import com.ecc.ide.editor.visualhtml.XMLToHtmlConvertor;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.swt.graphics.Rectangle;

public class TableCell {
    private XMLToHtmlConvertor convertor;
    public XMLNode node = null;
    public int rowspan = 0;
    public int colspan = 0;
    public int x0;
    public int y0;
    public int height;
    public int width;
    private static final int FONTXPOINT = 8;
    private Vector appendedNotation = new Vector(10);
    private static String LABEL_TAG = "label";
    private static String TEXT_TAG = "text";
    private static String COMBO_TAG = "combobox";
    private static String LIST_TAG = "list";
    private static String FORM_TAG = "form";
    private static String TABLE_TAG = "table";
    private static String TABLE_COL_TAG = "tableColumn";
    private static String URI_JSP_TAG = "jspAction";
    private static String JSP_URL_TAG = "jspURL";
    private static String URI_SRVOP_TAG = "srvOpAction";
    private static String FILE_TAG = "file";
    private static String INPUT_FIELD_TAG = "input";
    private static String TEXT_AREA_TAG = "textArea";
    private static String URL_TAG = "URL";
    private static String SELECT_TAG = "select";
    private static String IMG_TAG = "img";
    static int NODE_LABEL = 0;
    static int NODE_TEXT_FIELD = 1;
    static int NODE_PASSWORD_FIELD = 2;
    static int NODE_IMAGE_INPUT = 3;
    static int NODE_TEXT_OUT_AREA = 4;
    static int NODE_IMAGE = 5;
    static int NODE_BUTTON = 6;
    static int NODE_SRV_OP_ACTION = 7;
    static int NODE_JSP_ACTION = 8;
    static int NODE_COMBOBOX = 9;
    static int NODE_OUT_FIELD = 10;
    static int NODE_FORM = 11;
    static int NODE_TABLE = 12;
    static int NODE_BLOCK = 13;
    static int NODE_PARAGRAPH = 14;
    static int NODE_DIV = 15;
    static int NODE_URL = 16;
    static int NODE_DOCUMENT = 17;
    static int NODE_TEAXAREA = 18;
    static int NODE_CHECK_BOX = 19;
    static int NODE_RADIO_BOX = 20;

    public void addAppendedNotation(Object obj) {
        this.appendedNotation.addElement(obj);
    }

    public TableCell() {
    }

    public TableCell(XMLToHtmlConvertor convertor, XMLNode node) {
        this.convertor = convertor;
        this.node = node;
        Rectangle rec = HtmlTableMaker.getBounds(node);
        this.x0 = rec.x;
        this.y0 = rec.y;
        this.width = rec.width;
        this.height = rec.height;
    }

    public int getNodeType(String nodeType) {
        if (nodeType.equals("Label")) {
            return NODE_LABEL;
        }
        if (nodeType.equals("TextField")) {
            return NODE_TEXT_FIELD;
        }
        if (nodeType.equals("PasswordField")) {
            return NODE_PASSWORD_FIELD;
        }
        if (nodeType.equals("ImageInput")) {
            return NODE_IMAGE_INPUT;
        }
        if (nodeType.equals("TextOutArea")) {
            return NODE_TEXT_OUT_AREA;
        }
        if (nodeType.equals("Image")) {
            return NODE_IMAGE;
        }
        if (nodeType.equals("Button")) {
            return NODE_BUTTON;
        }
        if (nodeType.equals("srvOpAction")) {
            return NODE_SRV_OP_ACTION;
        }
        if (nodeType.equals("jspAction")) {
            return NODE_JSP_ACTION;
        }
        if (nodeType.equals("URL")) {
            return NODE_URL;
        }
        if (nodeType.equals("ComboBox")) {
            return NODE_COMBOBOX;
        }
        if (nodeType.equals("OutField")) {
            return NODE_OUT_FIELD;
        }
        if (nodeType.equals("form")) {
            return NODE_FORM;
        }
        if (nodeType.equals("Table")) {
            return NODE_TABLE;
        }
        if (nodeType.equals("block")) {
            return NODE_BLOCK;
        }
        if (nodeType.equals("paragraph")) {
            return NODE_PARAGRAPH;
        }
        if (nodeType.equals("div")) {
            return NODE_DIV;
        }
        if (nodeType.equals("document")) {
            return NODE_DOCUMENT;
        }
        if (nodeType.equals("TextArea")) {
            return NODE_TEAXAREA;
        }
        if (nodeType.equals("checkBox")) {
            return NODE_CHECK_BOX;
        }
        if (nodeType.equals("radioBox")) {
            return NODE_RADIO_BOX;
        }
        return -1;
    }

    public void getHTMLString(StringBuffer buffer, int layout) {
        int nodeWidth = 0;
        try {
            nodeWidth = Integer.parseInt(this.node.getAttrValue("width"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String classStr = this.node.getAttrValue("CSSClass");
        String nodeTypeStr = this.node.getNodeName();
        int nodeType = this.getNodeType(nodeTypeStr);
        if (nodeType <= NODE_OUT_FIELD || nodeType == NODE_PARAGRAPH) {
            if (layout == 0) {
                this.addTD(buffer);
                if (classStr != null) {
                    buffer.append(" class=\"");
                    buffer.append(classStr);
                    buffer.append("\"");
                }
                this.addNotation(buffer, 3);
                buffer.append(" >");
            }
        } else if (layout == 0) {
            this.addTD(buffer);
            this.addNotation(buffer, 3);
            buffer.append(" >");
        }
        if (nodeType == NODE_LABEL) {
            this.getLabelDefine(this.node, buffer);
        } else if (nodeType == NODE_TEXT_FIELD || nodeType == NODE_PASSWORD_FIELD) {
            if (nodeType == NODE_PASSWORD_FIELD) {
                this.node.setAttrValue("type", "PASSWORD");
            }
            this.getInputFieldDefine(this.node, buffer, nodeType);
        } else if (nodeType == NODE_TEAXAREA) {
            this.getTextAreaDefine(this.node, buffer, nodeType);
        } else if (nodeType == NODE_IMAGE_INPUT) {
            this.getImageInputDefine(this.node, buffer);
        } else if (nodeType == NODE_TEXT_OUT_AREA) {
            this.addNotation(buffer, 0);
            this.appendParagraphs(buffer, this.node.getAttrValue("nodeValue"));
        } else if (nodeType == NODE_IMAGE) {
            this.addImageNode(this.node, buffer);
        } else if (nodeType == NODE_BUTTON) {
            this.getButtonDefine(this.node, buffer);
        } else if (nodeType == NODE_SRV_OP_ACTION) {
            this.getSrvOpActionDefine(this.node, buffer);
        } else if (nodeType == NODE_JSP_ACTION) {
            this.getJspActionDefine(this.node, buffer);
        } else if (nodeType == NODE_URL) {
            this.getURLDefine(this.node, buffer);
        } else if (nodeType == NODE_COMBOBOX) {
            this.getComboboxDefine(this.node, buffer);
        } else if (nodeType == NODE_OUT_FIELD) {
            this.getOutFieldDefine(this.node, buffer);
        } else if (nodeType == NODE_FORM) {
            this.getFormDefine(buffer);
        } else if (nodeType == NODE_TABLE) {
            this.getTableDefine(buffer);
        } else if (nodeType == NODE_BLOCK) {
            this.getBlockDefine(buffer);
        } else if (nodeType == NODE_PARAGRAPH) {
            this.getParagraphDefine(buffer);
        } else if (nodeType == NODE_DIV) {
            this.getDivDefine(buffer);
        } else if (nodeType == NODE_CHECK_BOX) {
            this.getSelectDefine(this.node, buffer, nodeType);
        } else if (nodeType == NODE_RADIO_BOX) {
            this.getSelectDefine(this.node, buffer, nodeType);
        } else if (nodeType == NODE_DOCUMENT) {
            int i = 0;
            ++i;
        } else {
            this.getUnDefinedNodeDefine(this.node, buffer);
        }
        this.addNotation(buffer, 2);
        if (layout == 0) {
            buffer.append("</td>");
        }
    }

    private void getDivDefine(StringBuffer buffer) {
        String style;
        buffer.append("\n<div ");
        String id = this.node.getAttrValue("id");
        if (id != null) {
            buffer.append("id=\"" + id + "\" ");
        }
        if ((style = this.node.getAttrValue("style")) != null) {
            buffer.append("style=\"" + style + "\"");
        }
        buffer.append(">");
        this.getBlockDefine(buffer);
        buffer.append("\n</div>\n");
    }

    private void addImageNode(XMLNode node, StringBuffer buffer) {
        if (!XMLToHtmlConvertor.isPreview) {
            String imgFile = this.getImageStr(node.getAttrValue("imageFile"));
            if (IDEConstance.buildJspWithTaglib) {
                buffer.append("<");
                buffer.append(IDEConstance.tagPrefix);
                buffer.append(IMG_TAG);
                buffer.append(this.getNodeAttrStr(node, "x;y;width;height;fx;fy;fWidth;fHeight;imageFile;"));
                buffer.append(" src=\"");
                buffer.append(imgFile);
                buffer.append("\"");
                StringBuffer buf = new StringBuffer();
                this.appendJSDefine(node, buf);
                this.appendCustomAttrs(buffer, buf.toString());
                this.appendPrivateJSDefine(node, buffer);
                buffer.append("/>");
            } else {
                buffer.append("<IMG SRC=\"");
                buffer.append("<%=utb.getJSPPath(\"");
                buffer.append(imgFile);
                buffer.append("\")%>\" ");
                this.appendJSDefine(node, buffer);
                this.addNotation(buffer, 3);
                buffer.append("id=\"");
                buffer.append(node.getAttrValue("name"));
                buffer.append("\" ");
                buffer.append("/>");
            }
        } else {
            buffer.append("<IMG SRC=\"");
            buffer.append(this.getImageStr(node.getAttrValue("imageFile")));
            buffer.append("\" ");
            this.appendJSDefine(node, buffer);
            this.addNotation(buffer, 3);
            buffer.append("id=\"");
            buffer.append(node.getAttrValue("name"));
            buffer.append("\" ");
            buffer.append("/>");
        }
    }

    private void getTableDefine(StringBuffer buffer) {
        if (!XMLToHtmlConvertor.isPreview && IDEConstance.buildJspWithTaglib) {
            buffer.append("\n<");
            buffer.append(IDEConstance.tagPrefix);
            buffer.append(TABLE_TAG);
            buffer.append(this.getNodeAttrStr(this.node, "x;y;height;fx;fy;fWidth;fHeight;jspFileName;"));
            buffer.append(this.getJSPFileAttrStr(this.node));
            buffer.append(this.getClientOpStr());
            buffer.append(" isLayoutContent=\"");
            buffer.append(this.convertor.isMeTheLayoutContent());
            buffer.append("\"");
            buffer.append(">");
            Vector childs = this.node.getChilds();
            int i = 0;
            while (childs != null && i < childs.size()) {
                XMLNode column = (XMLNode)childs.elementAt(i);
                if ("TableColumn".equals(column.getNodeName())) {
                    buffer.append("\n\t<");
                    buffer.append(IDEConstance.tagPrefix);
                    buffer.append(TABLE_COL_TAG);
                    buffer.append(this.getNodeAttrStr(column, "x;y;height;fx;fy;fWidth;fHeight;jspFileName;"));
                    buffer.append(this.getJSPFileAttrStr(this.node));
                    buffer.append(this.getClientOpStr());
                    buffer.append("/>");
                }
                ++i;
            }
            buffer.append("\n</");
            buffer.append(IDEConstance.tagPrefix);
            buffer.append(TABLE_TAG);
            buffer.append(">");
            return;
        }
        String titleClass = this.node.getAttrValue("titleClass");
        String line1Class = this.node.getAttrValue("line1Class");
        String line2Class = this.node.getAttrValue("line2Class");
        boolean toBeForm = "true".equals(this.node.getAttrValue("toBeForm"));
        int formType = 0;
        try {
            formType = Integer.parseInt(this.node.getAttrValue("formType"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (toBeForm && formType == 0) {
            this.getFormHeadDefine(this.node, buffer);
            this.getFormHiddenFieldDefine(this.node, buffer);
        }
        String classStr = this.node.getAttrValue("CSSClass");
        buffer.append("\n<Table width=\"");
        buffer.append(this.node.getAttrValue("width"));
        buffer.append("\"");
        if (classStr != null) {
            buffer.append(" class=\"");
            buffer.append(classStr);
            buffer.append("\"");
        }
        this.appendTableAttrs(buffer, this.node);
        buffer.append(">\n");
        Vector childs = this.node.getChilds();
        if ("true".equals(this.node.getAttrValue("needTableTitle"))) {
            if (titleClass != null) {
                buffer.append(" <tr class=");
                buffer.append(titleClass);
                buffer.append(">\n");
            } else {
                buffer.append(" <tr>\n");
            }
            int i = 0;
            while (childs != null && i < childs.size()) {
                XMLNode column = (XMLNode)childs.elementAt(i);
                if ("TableColumn".equals(column.getNodeName())) {
                    buffer.append("\n<td width=\"");
                    buffer.append(column.getAttrValue("width"));
                    buffer.append("\">");
                    if (column.getAttrValue("label") != null) {
                        buffer.append(column.getAttrValue("label"));
                    }
                    buffer.append("</td>");
                }
                ++i;
            }
            buffer.append(" </tr>\n");
        }
        buffer.append("<% IndexedCollection ");
        String iCollName = this.convertor.getICollName();
        buffer.append(iCollName);
        buffer.append(" = (IndexedCollection)utb.getContext().getElementAt(\"");
        buffer.append(this.node.getAttrValue("iCollName"));
        buffer.append("\");\n");
        buffer.append("for(int i=0; i<");
        buffer.append(iCollName);
        buffer.append(".size(); i++){\n KeyedCollection kColl = (KeyedCollection)");
        buffer.append(iCollName);
        buffer.append(".getElementAt(i); %>\n");
        buffer.append("\n<% if(i%2==0){ %>");
        if (line1Class != null) {
            buffer.append(" <tr class=");
            buffer.append(line1Class);
            buffer.append(">\n");
        } else {
            buffer.append(" <tr>\n");
        }
        buffer.append("\n<%} else {%>");
        if (line2Class != null) {
            buffer.append(" <tr class=");
            buffer.append(line2Class);
            buffer.append(">\n");
        } else {
            buffer.append(" <tr>\n");
        }
        buffer.append("\n<%}%>");
        if (toBeForm && formType == 1) {
            this.getFormHeadDefine(this.node, buffer);
            this.getFormHiddenFieldDefine(this.node, buffer);
        }
        int i = 0;
        while (childs != null && i < childs.size()) {
            XMLNode column = (XMLNode)childs.elementAt(i);
            if ("TableColumn".equals(column.getNodeName())) {
                String fieldType;
                if ("true".equals(column.getAttrValue("selfAction"))) {
                    buffer.append("\n<td width=\"");
                    buffer.append(column.getAttrValue("width"));
                    buffer.append("\" ");
                    this.appendTableAttrs(buffer, column);
                    this.addNotation(column, buffer, 3);
                    buffer.append(">");
                    this.addNotation(column, buffer, 0);
                    this.getTableColumnAction(column, buffer);
                    this.addNotation(column, buffer, 2);
                    if (toBeForm && ("hidden".equals(fieldType = column.getAttrValue("formFieldType")) || "checkbox".equals(fieldType) || "radio".equals(fieldType) || "text".equals(fieldType))) {
                        buffer.append("\n<INPUT TYPE=\"");
                        buffer.append(fieldType);
                        buffer.append("\" NAME=\"");
                        buffer.append(column.getAttrValue("formDataName"));
                        buffer.append("\"");
                        if (column.getAttrValue("formValue") != null) {
                            buffer.append(" value =\"");
                            buffer.append(column.getAttrValue("formValue"));
                            buffer.append("\"");
                        } else if (column.getAttrValue("dataName") != null) {
                            buffer.append(" value =\"");
                            buffer.append("<%=kColl.getValueAt(\"");
                            buffer.append(column.getAttrValue("dataName"));
                            buffer.append("\")%>");
                            buffer.append("\"");
                        }
                    }
                    buffer.append("</td>");
                } else {
                    buffer.append("\n<td width=\"");
                    buffer.append(column.getAttrValue("width"));
                    buffer.append("\" ");
                    this.appendTableAttrs(buffer, column);
                    this.addNotation(column, buffer, 3);
                    buffer.append(">");
                    this.addNotation(column, buffer, 0);
                    if (toBeForm) {
                        fieldType = column.getAttrValue("formFieldType");
                        if ("hidden".equals(fieldType) || "checkbox".equals(fieldType) || "radio".equals(fieldType) || "text".equals(fieldType)) {
                            buffer.append("\n<INPUT TYPE=\"");
                            buffer.append(fieldType);
                            buffer.append("\" NAME=\"");
                            buffer.append(column.getAttrValue("formDataName"));
                            buffer.append("\"");
                            if (column.getAttrValue("formValue") != null) {
                                buffer.append(" value =\"");
                                buffer.append(column.getAttrValue("formValue"));
                                buffer.append("\"");
                            } else if (column.getAttrValue("dataName") != null) {
                                buffer.append(" value =\"");
                                buffer.append("<%=kColl.getValueAt(\"");
                                buffer.append(column.getAttrValue("dataName"));
                                buffer.append("\")%>");
                                buffer.append("\"");
                            }
                            this.addNotation(column, buffer, 1);
                            buffer.append("/>\n");
                            if (("checkbox".equals(fieldType) || "radio".equals(fieldType)) && column.getAttrValue("dataName") != null) {
                                if (column.getAttrValue("pattern") != null) {
                                    buffer.append("<%=utb.formatValue((String)kColl.getValueAt(\"");
                                    buffer.append(column.getAttrValue("dataName"));
                                    buffer.append("\"), \"");
                                    buffer.append(column.getAttrValue("pattern"));
                                    buffer.append("\")%>");
                                } else {
                                    buffer.append("<%=kColl.getValueAt(\"");
                                    buffer.append(column.getAttrValue("dataName"));
                                    buffer.append("\")%>");
                                }
                            }
                        } else if ("submit".equals(fieldType) || "reset".equals(fieldType)) {
                            buffer.append("<INPUT TYPE=\"");
                            buffer.append(fieldType);
                            buffer.append("\" ");
                            this.addNotation(column, buffer, 3);
                            if (column.getAttrValue("formValue") != null) {
                                buffer.append(" value =\"");
                                buffer.append(column.getAttrValue("formValue"));
                                buffer.append("\"");
                            }
                            buffer.append("/>");
                        } else if (column.getAttrValue("pattern") != null) {
                            buffer.append("<%=utb.formatValue((String)kColl.getValueAt(\"");
                            buffer.append(column.getAttrValue("dataName"));
                            buffer.append("\"), \"");
                            buffer.append(column.getAttrValue("pattern"));
                            buffer.append("\")%>");
                        } else {
                            buffer.append("<%=kColl.getValueAt(\"");
                            buffer.append(column.getAttrValue("dataName"));
                            buffer.append("\")%>");
                        }
                        if ("hidden".equals(fieldType)) {
                            if (column.getAttrValue("pattern") != null) {
                                buffer.append("<%=utb.formatValue((String)kColl.getValueAt(\"");
                                buffer.append(column.getAttrValue("dataName"));
                                buffer.append("\"), \"");
                                buffer.append(column.getAttrValue("pattern"));
                                buffer.append("\")%>");
                            } else {
                                buffer.append("<%=kColl.getValueAt(\"");
                                buffer.append(column.getAttrValue("dataName"));
                                buffer.append("\")%>");
                            }
                        }
                    } else if (column.getAttrValue("pattern") != null) {
                        buffer.append("<%=utb.formatValue((String)kColl.getValueAt(\"");
                        buffer.append(column.getAttrValue("dataName"));
                        buffer.append("\"), \"");
                        buffer.append(column.getAttrValue("pattern"));
                        buffer.append("\")%>");
                    } else {
                        buffer.append("<%=kColl.getValueAt(\"");
                        buffer.append(column.getAttrValue("dataName"));
                        buffer.append("\")%>");
                    }
                    this.addNotation(column, buffer, 2);
                    buffer.append("</td>");
                }
            }
            ++i;
        }
        if (toBeForm && formType == 1) {
            buffer.append("</form>\n");
        }
        buffer.append("</tr>\n");
        buffer.append("\n<%}%>\n</Table>\n");
        this.addNotation(this.node, buffer, 2);
        if (toBeForm && formType == 0) {
            buffer.append("</form>\n");
        }
    }

    private void appendTableAttrs(StringBuffer buffer, XMLNode node) {
        if (node.getAttrValue("align") != null) {
            buffer.append(" align=\"");
            buffer.append(node.getAttrValue("align"));
            buffer.append("\" ");
        }
        if (node.getAttrValue("cellspacing") != null) {
            buffer.append(" cellspacing=\"");
            buffer.append(node.getAttrValue("cellspacing"));
            buffer.append("\" ");
        }
        if (node.getAttrValue("cellpadding") != null) {
            buffer.append(" cellpadding=\"");
            buffer.append(node.getAttrValue("cellpadding"));
            buffer.append("\" ");
        }
        if (node.getAttrValue("border") != null) {
            buffer.append(" border=\"");
            buffer.append(node.getAttrValue("border"));
            buffer.append("\" ");
        }
        if (node.getAttrValue("background") != null) {
            buffer.append(" background=\"");
            if (!XMLToHtmlConvertor.isPreview) {
                buffer.append("<%=utb.getJSPPath(\"");
                buffer.append(this.convertor.getImageFilePath(node.getAttrValue("background")));
                buffer.append("\")%>\" ");
            } else {
                buffer.append(this.convertor.getImageFilePath(node.getAttrValue("background")));
                buffer.append("\" ");
            }
            buffer.append(" ");
        }
    }

    private void getTableColumnAction(XMLNode node, StringBuffer buffer) {
        String actionType = node.getAttrValue("actionType");
        String classStr = node.getAttrValue("CSSClass");
        if ("serverOperation".equals(actionType)) {
            String servlet = "<%=utb.getRequestServletPath()%>";
            String sessIdStr = "&dse_sessionId=<%=utb.getSessionId()%>&htmlCltOp=" + this.convertor.getClientOpId();
            String href = String.valueOf(servlet) + "?dse_operationName=" + node.getAttrValue("srvOpName") + sessIdStr + "&dse_pageId=-1";
            String target = node.getAttrValue("target");
            buffer.append("<a ");
            if (target == null && IDEConstance.useIDELayout && this.convertor.isMeTheLayoutContent()) {
                buffer.append("href=# onClick=\"javascript:updateDivContent('");
                buffer.append(href);
                buffer.append("&");
                buffer.append(node.getAttrValue("formDataName"));
                buffer.append("=");
                buffer.append("<%=kColl.getValueAt(\"");
                buffer.append(node.getAttrValue("dataName"));
                buffer.append("\")%>");
                buffer.append("',  '");
                buffer.append(IDEConstance.contentDivID);
                buffer.append("', 'text')\"  ");
            } else {
                buffer.append("href=\"");
                buffer.append(href);
                buffer.append("&");
                buffer.append(node.getAttrValue("formDataName"));
                buffer.append("=");
                buffer.append("<%=kColl.getValueAt(\"");
                buffer.append(node.getAttrValue("dataName"));
                buffer.append("\")%>");
                buffer.append("\" ");
                if (target != null) {
                    buffer.append(" target=\"");
                    buffer.append(target);
                    buffer.append("\" ");
                }
            }
            if (classStr != null) {
                buffer.append(" class=\"");
                buffer.append(classStr);
                buffer.append("\" ");
            }
            this.addNotation(buffer, 3);
            buffer.append(">");
            buffer.append("<%=kColl.getValueAt(\"");
            buffer.append(node.getAttrValue("dataName"));
            buffer.append("\")%>");
            buffer.append("</a>");
        } else if ("JSPFile".equals(actionType)) {
            String sessIdStr = "?dse_sessionId=<%=utb.getSessionId()%>";
            buffer.append("<a ");
            String target = node.getAttrValue("target");
            if (target == null && IDEConstance.useIDELayout && this.convertor.isMeTheLayoutContent()) {
                buffer.append("href=# onClick=\"javascript:updateDivContent('");
                String jspFile = this.convertor.getRelativePath(node.getAttrValue("jspFileName"));
                buffer.append("<%=utb.getJSPPath(\"" + jspFile + "\")%>");
                buffer.append(sessIdStr);
                buffer.append("&");
                buffer.append(node.getAttrValue("formDataName"));
                buffer.append("=");
                buffer.append("<%=kColl.getValueAt(\"");
                buffer.append(node.getAttrValue("dataName"));
                buffer.append("\")%>");
                buffer.append("',  '");
                buffer.append(IDEConstance.contentDivID);
                buffer.append("', 'text')\"  ");
                if (classStr != null) {
                    buffer.append(" class=\"");
                    buffer.append(classStr);
                    buffer.append("\" ");
                }
                this.addNotation(buffer, 3);
                buffer.append(">");
            } else {
                buffer.append("href=\"");
                String jspFile = this.convertor.getRelativePath(node.getAttrValue("jspFileName"));
                buffer.append("<%=utb.getJSPPath(\"" + jspFile + "\")%>");
                buffer.append(sessIdStr);
                buffer.append("&");
                buffer.append(node.getAttrValue("formDataName"));
                buffer.append("=");
                buffer.append("<%=kColl.getValueAt(\"");
                buffer.append(node.getAttrValue("dataName"));
                buffer.append("\")%>");
                buffer.append("\" ");
                if (classStr != null) {
                    buffer.append(" class=\"");
                    buffer.append(classStr);
                    buffer.append("\" ");
                }
                this.addNotation(buffer, 3);
                buffer.append(">");
                buffer.append("<%=kColl.getValueAt(\"");
                buffer.append(node.getAttrValue("dataName"));
                buffer.append("\")%>");
            }
            buffer.append("</a>");
        }
    }

    private void getFormHeadDefine(XMLNode node, StringBuffer buffer) {
        if (!XMLToHtmlConvertor.isPreview && IDEConstance.buildJspWithTaglib) {
            buffer.append("\n<");
            buffer.append(IDEConstance.tagPrefix);
            buffer.append(FORM_TAG);
            buffer.append(this.getNodeAttrStr(node, "x;y;width;height;fx;fy;fWidth;fHeight;jspFileName;layout;align;valign;cellspacing;cellpadding;border;CSSClass;"));
            buffer.append(this.getJSPFileAttrStr(node));
            buffer.append(this.getClientOpStr());
            StringBuffer buf = new StringBuffer();
            this.appendJSDefine(node, buf);
            this.appendCustomAttrs(buffer, buf.toString());
            buffer.append(" isLayoutContent=\"");
            buffer.append(this.convertor.isMeTheLayoutContent());
            buffer.append("\"");
            buffer.append(">\n");
            this.appendPrivateJSDefine(node, buffer);
            return;
        }
        String reqType = node.getAttrValue("reqType");
        String servlet = "session".equals(reqType) ? "<%=utb.getSessionRequestServletPath()%>" : ("signOff".equals(reqType) ? "<%=utb.getSignOfServletPath()%>" : "<%=utb.getRequestServletPath()%>");
        buffer.append("<form name=\"");
        buffer.append(node.getAttrValue("name"));
        buffer.append("\"");
        String method = "POST";
        method = node.getAttrValue("method");
        if (method == null) {
            method = "POST";
        }
        buffer.append(" method=\"");
        buffer.append(method);
        buffer.append("\" ");
        if (IDEConstance.useIDELayout && this.convertor.isMeTheLayoutContent()) {
            String contentDivId = IDEConstance.contentDivID;
            buffer.append(" onsubmit=\"javascript:submitTheForm(this, '");
            buffer.append(contentDivId);
            buffer.append("')\" ");
        }
        if ("JSPFile".equals(node.getAttrValue("actionType"))) {
            String sessIdStr = "?dse_sessionId=<%=utb.getSessionId()%>";
            buffer.append(" action=\"");
            String jspFile = this.convertor.getRelativePath(node.getAttrValue("jspFileName"));
            buffer.append("<%=utb.getJSPPath(\"" + jspFile + "\")%>\" ");
            this.addNotation(buffer, 3);
            this.appendJSDefine(node, buffer);
            buffer.append(">\n");
            this.appendPrivateJSDefine(node, buffer);
            buffer.append("<%=utb.getRequiredHtmlFields()%>\n");
            buffer.append("<input type=\"hidden\" name=\"htmlCltOp\" value=\"");
            buffer.append(this.convertor.getClientOpId());
            buffer.append("\">");
        } else {
            buffer.append(" action=\"");
            buffer.append(servlet);
            buffer.append("\" ");
            this.addNotation(buffer, 3);
            this.appendJSDefine(node, buffer);
            buffer.append(">\n");
            this.appendPrivateJSDefine(node, buffer);
            buffer.append("<%=utb.getRequiredHtmlFields(\"\",\"");
            buffer.append(node.getAttrValue("srvOpName"));
            buffer.append("\")%>\n");
            buffer.append("<input type=\"hidden\" name=\"htmlCltOp\" value=\"");
            buffer.append(this.convertor.getClientOpId());
            buffer.append("\">\n");
        }
    }

    private void getFormHiddenFieldDefine(XMLNode node, StringBuffer buffer) {
        Vector childs = node.getChilds();
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if ("HiddenField".equals(aNode.getNodeName())) {
                if (!XMLToHtmlConvertor.isPreview && IDEConstance.buildJspWithTaglib) {
                    buffer.append("<");
                    buffer.append(IDEConstance.tagPrefix);
                    buffer.append(INPUT_FIELD_TAG);
                    buffer.append(this.getNodeAttrStr(aNode, "x;y;width;height;fx;fy;fWidth;fHeight;"));
                    buffer.append(" type=\"HIDDEN\"/>\n");
                } else {
                    buffer.append("\n<INPUT TYPE=\"HIDDEN\" NAME=\"");
                    buffer.append(aNode.getAttrValue("dataName"));
                    buffer.append("\"");
                    if (aNode.getAttrValue("value") != null) {
                        buffer.append(" value =\"");
                        buffer.append(aNode.getAttrValue("value"));
                        buffer.append("\"");
                    }
                    if (aNode.getAttrValue("valueDataName") != null) {
                        buffer.append(" value =\"");
                        buffer.append("<%=utb.getContext().getValueAt(\"");
                        buffer.append(aNode.getAttrValue("valueDataName"));
                        buffer.append("\")%>");
                        buffer.append("\"");
                    }
                    buffer.append("/>\n");
                }
            }
            ++i;
        }
    }

    private void getBlockDefine(StringBuffer buffer) {
        HtmlTableMaker maker = new HtmlTableMaker(this.convertor);
        int layout = -1;
        if ("0".equals(this.node.getAttrValue("layout"))) {
            layout = 0;
        }
        maker.getHtmlTable(buffer, this.node, layout);
    }

    private void getFormDefine(StringBuffer buffer) {
        this.getFormHeadDefine(this.node, buffer);
        HtmlTableMaker maker = new HtmlTableMaker(this.convertor);
        int layout = -1;
        if ("0".equals(this.node.getAttrValue("layout"))) {
            layout = 0;
        }
        maker.getHtmlTable(buffer, this.node, layout);
        this.getFormHiddenFieldDefine(this.node, buffer);
        if (!XMLToHtmlConvertor.isPreview && IDEConstance.buildJspWithTaglib) {
            buffer.append("\n</");
            buffer.append(IDEConstance.tagPrefix);
            buffer.append(FORM_TAG);
            buffer.append(">");
        } else {
            buffer.append("\n</form>");
        }
    }

    private void addAppendNotation(StringBuffer buffer) {
        int i = 0;
        while (i < this.appendedNotation.size()) {
            XMLNode aNode = (XMLNode)this.appendedNotation.elementAt(i);
            buffer.append("\n");
            buffer.append(aNode.getAttrValue("nodeValue"));
            buffer.append("\n");
            ++i;
        }
        Vector childs = this.node.getChilds();
        int i2 = 0;
        while (i2 < childs.size()) {
            String notationType;
            XMLNode aNode = (XMLNode)childs.elementAt(i2);
            if ("notation".equals(aNode.getNodeName()) && "2".equals(notationType = aNode.getAttrValue("notateType"))) {
                buffer.append("\n");
                buffer.append(aNode.getAttrValue("nodeValue"));
                buffer.append("\n");
            }
            ++i2;
        }
    }

    private void addNotation(StringBuffer buffer, int notateType) {
        this.addNotation(this.node, buffer, notateType);
    }

    private void addNotation(XMLNode node, StringBuffer buffer, int notateType) {
        Vector childs = node.getChilds();
        int i = 0;
        while (i < childs.size()) {
            String notationTypeStr;
            int type;
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if ("notation".equals(aNode.getNodeName()) && (type = Integer.parseInt(notationTypeStr = aNode.getAttrValue("notateType"))) == notateType) {
                buffer.append("\n");
                buffer.append(aNode.getAttrValue("nodeValue"));
                buffer.append("\n");
            }
            ++i;
        }
    }

    private void addTD(StringBuffer buffer) {
        buffer.append("<td width=\"");
        buffer.append(this.width);
        buffer.append("\" ");
        String classStr = this.node.getAttrValue("CSSClass");
        if (this.rowspan != 0) {
            buffer.append(" rowspan=\"");
            buffer.append(this.rowspan + 1);
            buffer.append("\" ");
        }
        if (this.colspan != 0) {
            buffer.append(" colspan=\"");
            buffer.append(this.colspan + 1);
            buffer.append("\" ");
        }
        if (this.node.getAttrValue("align") != null) {
            buffer.append(" align=\"");
            buffer.append(this.node.getAttrValue("align"));
            buffer.append("\" ");
        }
        if (this.node.getAttrValue("valign") != null) {
            buffer.append(" valign=\"");
            buffer.append(this.node.getAttrValue("valign"));
            buffer.append("\" ");
        }
    }

    private void appendPrivateJSDefine(XMLNode node, StringBuffer buffer) {
        XMLNode scriptNode = node.getChild("script");
        if (scriptNode == null) {
            return;
        }
        XMLNode jsFunNode = scriptNode.getChild("funcDef");
        if (jsFunNode != null && jsFunNode.getAttrValue("nodeValue") != null) {
            this.convertor.addScriptFunction(jsFunNode.getNodeValue());
        }
    }

    private void appendCustomAttrs(StringBuffer buffer, String src) {
        buffer.append(" customAttr=\"");
        src = src.replaceAll("\"", "&quot;");
        buffer.append(src);
        buffer.append("\" ");
    }

    private void appendJSDefine(XMLNode node, StringBuffer buffer) {
        XMLNode scriptNode = node.getChild("script");
        if (scriptNode == null) {
            return;
        }
        XMLNode scriptDefNode = scriptNode.getChild("scriptDef");
        if (scriptDefNode != null && scriptDefNode.getAttrValue("nodeValue") != null) {
            buffer.append(scriptDefNode.getAttrValue("nodeValue"));
        }
    }

    private void appendParagraphs(StringBuffer buffer, String src) {
        if (src == null) {
            return;
        }
        try {
            String aline;
            StringReader sr = new StringReader(src);
            BufferedReader br = new BufferedReader(sr);
            while ((aline = br.readLine()) != null) {
                buffer.append(aline);
                buffer.append("<br>\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getClientOpStr() {
        String cltOp = this.node.getAttrValue("htmlCltOp");
        if (cltOp == null || cltOp.length() == 0) {
            cltOp = this.convertor.getClientOpId();
        }
        return " htmlCltOp=\"" + cltOp + "\" ";
    }

    private String getJSPFileAttrStr(XMLNode node) {
        StringBuffer attrBuf = new StringBuffer(" ");
        String jspFileName = this.getJSPFileName();
        if (jspFileName != null) {
            attrBuf.append("jspFileName=\"");
            attrBuf.append(jspFileName);
            attrBuf.append("\" ");
        }
        return attrBuf.toString();
    }

    private String getNodeAttrStr(XMLNode node, String exclude) {
        StringBuffer attrBuf = new StringBuffer(" ");
        Hashtable attrs = node.getAttrs();
        Enumeration attrList = attrs.keys();
        while (attrList.hasMoreElements()) {
            String attrName = (String)attrList.nextElement();
            String value = node.getAttrValue(attrName);
            if (value == null || value == "") continue;
            if (exclude == null) {
                attrBuf.append(attrName);
                attrBuf.append("=\"");
                attrBuf.append(value);
                attrBuf.append("\" ");
                continue;
            }
            if (exclude.indexOf(attrName) != -1) continue;
            attrBuf.append(attrName);
            attrBuf.append("=\"");
            attrBuf.append(value);
            attrBuf.append("\" ");
        }
        return attrBuf.toString();
    }

    private void getLabelDefine(XMLNode node, StringBuffer buffer) {
        if (!XMLToHtmlConvertor.isPreview && IDEConstance.buildJspWithTaglib) {
            buffer.append("<");
            buffer.append(IDEConstance.tagPrefix);
            buffer.append(LABEL_TAG);
            buffer.append(this.getNodeAttrStr(node, "x;y;width;height;fx;fy;fWidth;fHeight;jspFileName;"));
            buffer.append("/>");
            return;
        }
        if (node.getAttrValue("text") != null) {
            buffer.append(node.getAttrValue("text"));
        }
    }

    private void getTextAreaDefine(XMLNode node, StringBuffer buffer, int nodeType) {
        if (!XMLToHtmlConvertor.isPreview && IDEConstance.buildJspWithTaglib) {
            buffer.append("<");
            buffer.append(IDEConstance.tagPrefix);
            buffer.append(TEXT_AREA_TAG);
            buffer.append(this.getNodeAttrStr(node, "x;y;width;height;fx;fy;fWidth;fHeight;jspFileName;"));
            StringBuffer buf = new StringBuffer();
            this.appendJSDefine(node, buf);
            this.appendCustomAttrs(buffer, buf.toString());
            buffer.append(">");
            if (node.getNodeValue() != null) {
                buffer.append(node.getNodeValue());
            }
            buffer.append("</");
            buffer.append(IDEConstance.tagPrefix);
            buffer.append(TEXT_AREA_TAG);
            buffer.append(">\n");
            this.appendPrivateJSDefine(node, buffer);
            return;
        }
        buffer.append("<textarea NAME=\"");
        String name = node.getAttrValue("dataName");
        if (name == null || name.length() == 0) {
            name = node.getAttrValue("name");
        }
        buffer.append(name);
        buffer.append("\"");
        if (node.getAttrValue("cols") != null) {
            buffer.append(" cols =\"");
            buffer.append(node.getAttrValue("cols"));
            buffer.append("\"");
        }
        if (node.getAttrValue("rows") != null) {
            buffer.append(" rows =\"");
            buffer.append(node.getAttrValue("rows"));
            buffer.append("\"");
        }
        this.addNotation(buffer, 3);
        this.appendJSDefine(node, buffer);
        buffer.append(">");
        buffer.append(node.getNodeValue());
        buffer.append("</textarea>\n");
        this.appendPrivateJSDefine(node, buffer);
    }

    private void getInputFieldDefine(XMLNode node, StringBuffer buffer, int nodeType) {
        int nodeWidth = 0;
        try {
            nodeWidth = Integer.parseInt(node.getAttrValue("width"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!XMLToHtmlConvertor.isPreview && IDEConstance.buildJspWithTaglib) {
            buffer.append("<");
            buffer.append(IDEConstance.tagPrefix);
            buffer.append(INPUT_FIELD_TAG);
            buffer.append(this.getNodeAttrStr(node, "x;y;width;height;fx;fy;fWidth;fHeight;jspFileName;"));
            StringBuffer buf = new StringBuffer();
            this.appendJSDefine(node, buf);
            this.appendCustomAttrs(buffer, buf.toString());
            buffer.append(" size=\"");
            buffer.append(nodeWidth / 8);
            buffer.append("\"/>\n");
            this.appendPrivateJSDefine(node, buffer);
            return;
        }
        if (nodeType == NODE_TEXT_FIELD) {
            buffer.append("<INPUT TYPE=\"TEXT\" NAME=\"");
        } else {
            buffer.append("<INPUT TYPE=\"PASSWORD\" NAME=\"");
        }
        String name = node.getAttrValue("dataName");
        if (name == null || name.length() == 0) {
            name = node.getAttrValue("name");
        }
        buffer.append(name);
        buffer.append("\" size =\"");
        buffer.append(nodeWidth / 8);
        buffer.append("\"");
        this.addNotation(buffer, 3);
        this.appendJSDefine(node, buffer);
        buffer.append("/>");
        this.appendPrivateJSDefine(node, buffer);
    }

    private void getImageInputDefine(XMLNode node, StringBuffer buffer) {
        buffer.append("<INPUT TYPE=\"IMAGE\" SRC=\"");
        if (!XMLToHtmlConvertor.isPreview) {
            buffer.append("<%=utb.getJSPPath(\"");
            buffer.append(this.getImageStr(node.getAttrValue("imageFile")));
            buffer.append("\")%>\" ");
        } else {
            buffer.append(this.getImageStr(node.getAttrValue("imageFile")));
            buffer.append("\" ");
        }
        this.addNotation(buffer, 3);
        buffer.append("/>");
    }

    private void getButtonDefine(XMLNode node, StringBuffer buffer) {
        int nodeWidth = 0;
        try {
            nodeWidth = Integer.parseInt(node.getAttrValue("width"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String type = "BUTTON";
        if ("submit".equals(node.getAttrValue("buttonType"))) {
            type = "SUBMIT";
        } else if ("reset".equals(node.getAttrValue("buttonType"))) {
            type = "RESET";
        }
        String text = node.getAttrValue("text");
        buffer.append("<INPUT TYPE=\"");
        buffer.append(type);
        buffer.append("\" WIDTH=\"");
        buffer.append(nodeWidth);
        buffer.append("\" ");
        this.addNotation(buffer, 3);
        if (text != null) {
            if (!XMLToHtmlConvertor.isPreview && IDEConstance.buildJspWithTaglib) {
                buffer.append(" value = \"");
                buffer.append("<");
                buffer.append(IDEConstance.tagPrefix);
                buffer.append(LABEL_TAG);
                buffer.append(" text=\"");
                buffer.append(text);
                buffer.append("\"");
                buffer.append("/>\"/>");
            } else {
                buffer.append(" value = \"");
                buffer.append(text);
                buffer.append("\"/>");
            }
        } else {
            buffer.append("/>");
        }
    }

    private void getSrvOpActionDefine(XMLNode node, StringBuffer buffer) {
        if (!XMLToHtmlConvertor.isPreview && IDEConstance.buildJspWithTaglib) {
            buffer.append("<");
            buffer.append(IDEConstance.tagPrefix);
            buffer.append(URI_SRVOP_TAG);
            buffer.append(this.getNodeAttrStr(node, "x;y;width;height;fx;fy;fWidth;fHeight;jspFileName;"));
            buffer.append(this.getJSPFileAttrStr(node));
            buffer.append(this.getClientOpStr());
            buffer.append(" isLayoutContent=\"");
            buffer.append(this.convertor.isMeTheLayoutContent());
            buffer.append("\"");
            buffer.append("/>");
            return;
        }
        String reqType = node.getAttrValue("reqType");
        String servlet = "session".equals(reqType) ? "<%=utb.getSessionRequestServletPath()%>" : ("signOff".equals(reqType) ? "<%=utb.getSignOfServletPath()%>" : "<%=utb.getRequestServletPath()%>");
        String sessIdStr = "&dse_sessionId=<%=utb.getSessionId()%>&htmlCltOp=" + this.convertor.getClientOpId();
        String href = String.valueOf(servlet) + "?dse_operationName=" + node.getAttrValue("srvOpName") + sessIdStr + "&dse_pageId=-1";
        String target = node.getAttrValue("target");
        buffer.append("<a ");
        if (target == null && IDEConstance.useIDELayout && this.convertor.isMeTheLayoutContent()) {
            buffer.append("href=# onClick=\"javascript:updateDivContent('");
            buffer.append(href);
            buffer.append("',  '");
            buffer.append(IDEConstance.contentDivID);
            buffer.append("', 'text')\"  ");
        } else {
            buffer.append("href=\"");
            buffer.append(href);
            buffer.append("\" ");
        }
        if (target != null) {
            buffer.append(" target=\"");
            buffer.append(target);
            buffer.append("\" ");
        }
        this.addNotation(buffer, 3);
        buffer.append(">");
        if (node.getAttrValue("imageFile") != null) {
            buffer.append("<IMG SRC=\"");
            if (!XMLToHtmlConvertor.isPreview) {
                buffer.append("<%=utb.getJSPPath(\"");
                buffer.append(this.getImageStr(node.getAttrValue("imageFile")));
                buffer.append("\")%>\"/>");
            } else {
                buffer.append(this.getImageStr(node.getAttrValue("imageFile")));
                buffer.append("\"/>");
            }
        } else {
            buffer.append(node.getAttrValue("label"));
        }
        buffer.append("</a>");
    }

    private void getJspActionDefine(XMLNode node, StringBuffer buffer) {
        if (!XMLToHtmlConvertor.isPreview && IDEConstance.buildJspWithTaglib) {
            buffer.append("<");
            buffer.append(IDEConstance.tagPrefix);
            buffer.append(URI_JSP_TAG);
            buffer.append(this.getNodeAttrStr(node, "x;y;width;height;fx;fy;fWidth;fHeight;jspFileName;"));
            buffer.append(this.getJSPFileAttrStr(node));
            buffer.append(this.getClientOpStr());
            buffer.append(" isLayoutContent=\"");
            buffer.append(this.convertor.isMeTheLayoutContent());
            buffer.append("\"");
            buffer.append("/>");
            return;
        }
        String sessIdStr = "?dse_sessionId=<%=utb.getSessionId()%>";
        buffer.append("<a ");
        String target = node.getAttrValue("target");
        if (target == null && IDEConstance.useIDELayout && this.convertor.isMeTheLayoutContent()) {
            buffer.append("href=# onClick=\"javascript:updateDivContent('");
            String jspFile = this.getJSPFileName();
            buffer.append("<%=utb.getJSPPath(\"" + jspFile + "\")%>");
            buffer.append(sessIdStr);
            buffer.append("',  '");
            buffer.append(IDEConstance.contentDivID);
            buffer.append("', 'text')\"  ");
        } else {
            buffer.append("href=\"");
            String jspFile = this.getJSPFileName();
            buffer.append("<%=utb.getJSPPath(\"" + jspFile + "\")%>");
            buffer.append(sessIdStr);
            buffer.append("\" ");
        }
        if (target != null) {
            buffer.append(" target=\"");
            buffer.append(node.getAttrValue("target"));
            buffer.append("\" ");
        }
        this.addNotation(buffer, 3);
        buffer.append(">");
        if (node.getAttrValue("imageFile") != null) {
            buffer.append("<IMG SRC=\"");
            if (!XMLToHtmlConvertor.isPreview) {
                buffer.append("<%=utb.getJSPPath(\"");
                buffer.append(this.getImageStr(node.getAttrValue("imageFile")));
                buffer.append("\")%>\"/>");
            } else {
                buffer.append(this.getImageStr(node.getAttrValue("imageFile")));
                buffer.append("\"/>");
            }
        } else {
            buffer.append(node.getAttrValue("label"));
        }
        buffer.append("</a>");
    }

    private String getJSPFileName() {
        String fileName = this.node.getAttrValue("jspFileName");
        if (fileName == null) {
            return null;
        }
        XMLNode jspsNode = this.node;
        while ((jspsNode = jspsNode.getParent()) != null && !"jsps".equals(jspsNode.getNodeName())) {
        }
        XMLNode jspNode = jspsNode.findChildNodeNamed(fileName);
        if (jspNode == null) {
            return null;
        }
        if ("refJsp".equals(jspNode.getNodeName())) {
            return fileName;
        }
        XMLNode trxNode = jspsNode.getParent();
        String path = trxNode.getAttrValue("classify");
        if (path == null || path.length() == 0) {
            return fileName;
        }
        return String.valueOf(path) + "/" + fileName;
    }

    private void getURLDefine(XMLNode node, StringBuffer buffer) {
        if (!XMLToHtmlConvertor.isPreview && IDEConstance.buildJspWithTaglib) {
            buffer.append("<");
            buffer.append(IDEConstance.tagPrefix);
            buffer.append(URL_TAG);
            buffer.append(this.getNodeAttrStr(node, "x;y;width;height;fx;fy;fWidth;fHeight;jspFileName;"));
            buffer.append("/>");
            return;
        }
        buffer.append("<a href=\"");
        String href = node.getAttrValue("href");
        buffer.append(href);
        buffer.append("\" ");
        if (node.getAttrValue("target") != null) {
            buffer.append(" target=\"");
            buffer.append(node.getAttrValue("target"));
            buffer.append("\" ");
        }
        this.addNotation(buffer, 3);
        buffer.append(">");
        if (node.getAttrValue("imageFile") != null) {
            buffer.append("<IMG SRC=\"");
            if (!XMLToHtmlConvertor.isPreview) {
                buffer.append("<%=utb.getJSPPath(\"");
                buffer.append(this.getImageStr(node.getAttrValue("imageFile")));
                buffer.append("\")%>\"/>");
            } else {
                buffer.append(this.getImageStr(node.getAttrValue("imageFile")));
                buffer.append("\"/>");
            }
        } else {
            buffer.append(node.getAttrValue("label"));
        }
        buffer.append("</a>");
    }

    private void getSelectDefine(XMLNode node, StringBuffer buffer, int nodeType) {
        if (!XMLToHtmlConvertor.isPreview && IDEConstance.buildJspWithTaglib) {
            buffer.append("<");
            buffer.append(IDEConstance.tagPrefix);
            buffer.append(SELECT_TAG);
            buffer.append(this.getNodeAttrStr(node, "x;y;width;height;fx;fy;fWidth;fHeight;jspFileName;"));
            StringBuffer buf = new StringBuffer();
            this.appendJSDefine(node, buf);
            this.appendCustomAttrs(buffer, buf.toString());
            if (nodeType == NODE_CHECK_BOX) {
                buffer.append(" type=\"checkbox\"");
            } else {
                buffer.append(" type=\"radio\"");
            }
            buffer.append("/>\n");
            this.appendPrivateJSDefine(node, buffer);
            return;
        }
        String optionSrc = node.getAttrValue("optionSrc");
        if ("0".equals(optionSrc)) {
            buffer.append("<% IndexedCollection ");
            String iCollName = this.convertor.getICollName();
            buffer.append(iCollName);
            buffer.append(" = (IndexedCollection)utb.getContext().getElementAt(\"");
            buffer.append(node.getAttrValue("iCollName"));
            buffer.append("\");\n");
            buffer.append("for(int i=0; i<");
            buffer.append(iCollName);
            buffer.append(".size(); i++){\n KeyedCollection kColl = (KeyedCollection)");
            buffer.append(iCollName);
            buffer.append(".getElementAt(i); %>\n");
            String dataName = node.getAttrValue("valueName");
            String descName = node.getAttrValue("descName");
            if (descName == null) {
                descName = dataName;
            }
            buffer.append("<input name=\"");
            buffer.append(node.getAttrValue("dataName"));
            if (nodeType == NODE_CHECK_BOX) {
                buffer.append("<%=String.valueOf(i)%>");
            }
            buffer.append("\" value=\"");
            buffer.append("<%=kColl.getValueAt(\"" + dataName + "\")%> \">");
            buffer.append("<%=kColl.getValueAt(\"" + descName + "\")%>");
            buffer.append("<%}%>");
        } else if ("1".equals(optionSrc)) {
            buffer.append("<input name=\"");
            buffer.append(node.getAttrValue("dataName"));
            buffer.append("\" value=\"");
            buffer.append(node.getAttrValue("value"));
            if (nodeType == NODE_CHECK_BOX) {
                buffer.append("\" type=\"checkbox\" ");
            } else {
                buffer.append("\" type=\"radio\" ");
            }
            buffer.append("\">");
            buffer.append(node.getAttrValue("label"));
        }
    }

    private void getComboboxDefine(XMLNode node, StringBuffer buffer) {
        String itemStr;
        String selName;
        StringBuffer buf;
        String srcURL = node.getAttrValue("srcURL");
        if (srcURL != null) {
            buf = new StringBuffer();
            buf.append("\tgetComboBoxSrc('<");
            buf.append(IDEConstance.tagPrefix);
            buf.append(JSP_URL_TAG);
            buf.append(" jspFileName=\"");
            buf.append(srcURL);
            buf.append("\"/>', '");
            buf.append(node.getParent().getAttrValue("name"));
            buf.append("', '");
            selName = node.getAttrValue("dataName");
            if (selName == null) {
                selName = node.getAttrValue("name");
            }
            buf.append(selName);
            buf.append("');\n ");
            this.convertor.addLoadMeScript(buf.toString());
        }
        if (node.getAttrValue("dstURL") != null && node.getAttrValue("dstComboBox") != null) {
            buf = new StringBuffer();
            buf.append("\tupdateComboBox('<");
            buf.append(IDEConstance.tagPrefix);
            buf.append(JSP_URL_TAG);
            buf.append(" jspFileName=\"");
            buf.append(node.getAttrValue("dstURL"));
            buf.append("\"/>', '");
            buf.append(node.getParent().getAttrValue("name"));
            buf.append("', '");
            buf.append(node.getAttrValue("dstComboBox"));
            buf.append("', '");
            selName = node.getAttrValue("dataName");
            if (selName == null) {
                selName = node.getAttrValue("name");
            }
            buf.append(selName);
            buf.append("');\n");
            this.convertor.addLoadMeScript(buf.toString());
        }
        if (!XMLToHtmlConvertor.isPreview && IDEConstance.buildJspWithTaglib) {
            buffer.append("<");
            buffer.append(IDEConstance.tagPrefix);
            buffer.append(COMBO_TAG);
            buffer.append(this.getNodeAttrStr(node, "x;y;width;height;fx;fy;fWidth;fHeight;jspFileName;"));
            buf = new StringBuffer();
            this.appendJSDefine(node, buf);
            this.appendCustomAttrs(buffer, buf.toString());
            buffer.append(" formName=\"");
            buffer.append(node.getParent().getAttrValue("name"));
            buffer.append("\"/>\n");
            this.appendPrivateJSDefine(node, buffer);
            return;
        }
        buffer.append("<SELECT name=\"");
        String name = node.getAttrValue("dataName");
        if (name == null || name.length() == 0) {
            name = node.getAttrValue("name");
        }
        buffer.append(name);
        buffer.append("\" ");
        this.addNotation(buffer, 3);
        this.appendJSDefine(node, buffer);
        buffer.append(">\n");
        this.appendPrivateJSDefine(node, buffer);
        String optionSrc = node.getAttrValue("optionSrc");
        if ("0".equals(optionSrc)) {
            buffer.append("<% IndexedCollection ");
            String iCollName = this.convertor.getICollName();
            buffer.append(iCollName);
            buffer.append(" = (IndexedCollection)utb.getContext().getElementAt(\"");
            buffer.append(node.getAttrValue("iCollName"));
            buffer.append("\");\n");
            buffer.append("for(int i=0; i<");
            buffer.append(iCollName);
            buffer.append(".size(); i++){\n KeyedCollection kColl = (KeyedCollection)");
            buffer.append(iCollName);
            buffer.append(".getElementAt(i); %>\n");
            String dataName = node.getAttrValue("valueName");
            String descName = node.getAttrValue("descName");
            if (descName == null) {
                descName = dataName;
            }
            buffer.append("<option value=\"<%=kColl.getValueAt(\"" + dataName + "\")%> \">");
            buffer.append("<%=kColl.getValueAt(\"" + descName + "\")%></option>");
            buffer.append("<%}%>");
        } else if ("1".equals(optionSrc) && (itemStr = node.getAttrValue("itemStr")) != null) {
            StringTokenizer token = new StringTokenizer(itemStr, ";");
            while (token.hasMoreElements()) {
                String value = token.nextToken();
                int idx = value.indexOf(61);
                if (idx == -1) {
                    buffer.append("<option value=\"" + value + "\">");
                    buffer.append(value);
                } else {
                    buffer.append("<option value=\"" + value.substring(0, idx) + "\">");
                    buffer.append(value.substring(idx + 1));
                }
                buffer.append("</option>");
            }
        }
        buffer.append("</select>");
    }

    private void getOutFieldDefine(XMLNode node, StringBuffer buffer) {
        if (!XMLToHtmlConvertor.isPreview && IDEConstance.buildJspWithTaglib) {
            buffer.append("<");
            buffer.append(IDEConstance.tagPrefix);
            buffer.append(TEXT_TAG);
            buffer.append(this.getNodeAttrStr(node, "x;y;width;height;fx;fy;fWidth;fHeight;jspFileName;"));
            buffer.append("/>");
            return;
        }
        if (node.getAttrValue("pattern") != null) {
            buffer.append("<%=utb.getValue(\"");
            buffer.append(node.getAttrValue("dataName"));
            buffer.append("\", \"");
            buffer.append(node.getAttrValue("pattern"));
            buffer.append("\")%>");
        } else {
            buffer.append("<%=utb.getContext().getValueAt(\"");
            buffer.append(node.getAttrValue("dataName"));
            buffer.append("\")%>");
        }
    }

    private void getUnDefinedNodeDefine(XMLNode node, StringBuffer buffer) {
        if ("#text".equals(node.getNodeName())) {
            return;
        }
        buffer.append("\n<");
        buffer.append(node.getNodeName());
        buffer.append(this.getNodeAttrStr(node, "x;y;width;height;fx;fy;fWidth;fHeight;jspFileName;"));
        Vector childs = node.getChilds();
        if (childs.size() == 0) {
            buffer.append("/>");
            return;
        }
        buffer.append(">");
        int i = 0;
        while (i < childs.size()) {
            XMLNode childNode = (XMLNode)childs.elementAt(i);
            this.getUnDefinedNodeDefine(childNode, buffer);
            ++i;
        }
        buffer.append("\n</");
        buffer.append(node.getNodeName());
        buffer.append(">\n");
    }

    private void getParagraphDefine(StringBuffer buffer) {
        Vector childs = this.node.getChilds();
        int i = 0;
        while (childs != null && i < childs.size()) {
            XMLNode node = (XMLNode)childs.elementAt(i);
            String classStr = node.getAttrValue("CSSClass");
            String nodeType = node.getNodeName();
            if (nodeType.equals("Label")) {
                if (classStr != null) {
                    buffer.append("<span class=\"");
                    buffer.append(classStr);
                    buffer.append("\"> ");
                }
                buffer.append(node.getAttrValue("text"));
                if (classStr != null) {
                    buffer.append("</span>");
                }
            } else if (nodeType.equals("Image")) {
                this.addImageNode(node, buffer);
            } else if (nodeType.equals("srvOpAction")) {
                String servlet = "<%=utb.getRequestServletPath()%>";
                servlet = "<%=utb.getRequestServletPath()%>";
                String sessIdStr = "&dse_sessionId=<%=utb.getSessionId()%>&htmlCltOp=" + this.convertor.getClientOpId();
                buffer.append("<a href=\"");
                buffer.append(servlet);
                buffer.append("?dse_operationName=");
                buffer.append(node.getAttrValue("srvOpName"));
                buffer.append(sessIdStr);
                buffer.append("&dse_pageId=-1");
                buffer.append("\" ");
                if (classStr != null) {
                    buffer.append(" class=\"");
                    buffer.append(classStr);
                    buffer.append("\" ");
                }
                if (node.getAttrValue("target") != null) {
                    buffer.append(" target=\"");
                    buffer.append(node.getAttrValue("target"));
                    buffer.append("\" ");
                }
                this.addNotation(buffer, 3);
                buffer.append(">");
                if (node.getAttrValue("imageFile") != null) {
                    buffer.append("<IMG SRC=\"");
                    if (!XMLToHtmlConvertor.isPreview) {
                        buffer.append("<%=utb.getJSPPath(\"");
                        buffer.append(this.getImageStr(node.getAttrValue("imageFile")));
                        buffer.append("\")%>\"/>");
                    } else {
                        buffer.append(this.getImageStr(node.getAttrValue("imageFile")));
                        buffer.append("\"/>");
                    }
                } else {
                    buffer.append(node.getAttrValue("label"));
                }
                buffer.append("</a>");
            } else if (nodeType.equals("jspAction")) {
                String sessIdStr = "?dse_sessionId=<%=utb.getSessionId()%>";
                buffer.append("<a href=\"");
                String jspFile = this.convertor.getRelativePath(node.getAttrValue("jspFileName"));
                buffer.append("<%=utb.getJSPPath(\"" + jspFile + "\")%>");
                buffer.append(sessIdStr);
                buffer.append("\" ");
                if (classStr != null) {
                    buffer.append(" class=\"");
                    buffer.append(classStr);
                    buffer.append("\" ");
                }
                if (node.getAttrValue("target") != null) {
                    buffer.append(" target=\"");
                    buffer.append(node.getAttrValue("target"));
                    buffer.append("\" ");
                }
                this.addNotation(buffer, 3);
                buffer.append(">");
                if (node.getAttrValue("imageFile") != null) {
                    buffer.append("<IMG SRC=\"");
                    if (!XMLToHtmlConvertor.isPreview) {
                        buffer.append("<%=utb.getJSPPath(\"");
                        buffer.append(this.getImageStr(node.getAttrValue("imageFile")));
                        buffer.append("\")%>\"/>");
                    } else {
                        buffer.append(this.getImageStr(node.getAttrValue("imageFile")));
                        buffer.append("\"/>");
                    }
                } else {
                    buffer.append(node.getAttrValue("label"));
                }
                buffer.append("</a>");
            } else if (nodeType.equals("OutField")) {
                if (classStr != null) {
                    buffer.append("<span class=\"");
                    buffer.append(classStr);
                    buffer.append("\"> ");
                }
                if (node.getAttrValue("pattern") != null) {
                    buffer.append("<%=utb.getValue(\"");
                    buffer.append(node.getAttrValue("dataName"));
                    buffer.append("\", \"");
                    buffer.append(node.getAttrValue("pattern"));
                    buffer.append("\")%>");
                } else {
                    buffer.append("<%=utb.getContext().getValueAt(\"");
                    buffer.append(node.getAttrValue("dataName"));
                    buffer.append("\")%>");
                }
            }
            if (classStr != null) {
                buffer.append("</span>");
            }
            ++i;
        }
    }

    private String getImageStr(String imageFile) {
        return this.convertor.getImageFilePath(imageFile);
    }
}

