/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualhtml;

import com.ecc.ide.editor.Wrapper;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualhtml.OperationDataSelectDialog;
import com.ecc.ide.editor.visualhtml.VisualHtmlSaver;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.ProfileObjectMaker;
import com.ecc.ide.visualeditor.Messages;
import com.ecc.ide.visualeditor.VisualEditorFramePanel;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import com.swtdesigner.ResourceManager;
import java.io.FileWriter;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

public class VisualHtmlFramePanel
extends VisualEditorFramePanel {
    private ToolItem addDataItem;
    private ToolItem saveItem;
    private XMLNode jsFunctionNode;
    private VisualHtmlSaver saver;
    static /* synthetic */ Class class$0;

    public void setVisualHtmlSaver(VisualHtmlSaver saver) {
        this.saver = saver;
        if (this.saveItem != null) {
            this.saveItem.setEnabled(true);
        }
    }

    public void setJSFunctionNode(XMLNode node) {
        this.jsFunctionNode = node;
    }

    public XMLNode getJSFunctionNode() {
        return this.jsFunctionNode;
    }

    public VisualHtmlFramePanel(Composite parent, int style) {
        super(parent, style);
        this.workingArea.setBackground(Display.getCurrent().getSystemColor(1));
    }

    private void beginLink() {
        this.workingArea.beginLink();
    }

    public static void main(String[] argv) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText(Messages.getString("VisualHtmlFramePanel.Test_Frame_3"));
        VisualHtmlFramePanel test = new VisualHtmlFramePanel((Composite)shell, 2048);
        try {
            String fileName = "/profiles/srvActionProfile.xml";
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new ProfileObjectMaker());
            EditorProfile profile = (EditorProfile)xmlLoader.loadXMLFile(fileName);
            if (profile != null) {
                test.setEditorProfile(profile);
                test.loadXMLFile("testFlow.xml");
                if (profile.getTitle() != null) {
                    shell.setText(profile.getTitle());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        try {
            FileWriter fw = new FileWriter("testFlow.xml");
            fw.write(test.getXMLStringContent());
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeElement(VisualElementWrapper wrapper) {
        super.removeElement(wrapper);
        if (wrapper == null) {
            return;
        }
    }

    public void setXMLContent(XMLNode node) throws Exception {
        super.setXMLContent(node);
        this.getRootElement().setMoveable(false);
    }

    public void setActivateWrapper(Wrapper wrapper) {
        super.setActivateWrapper(wrapper);
        String nodeType = wrapper.getElement().getElementName();
        if ("form".equals(nodeType) || "jsp".equals(nodeType)) {
            this.addDataItem.setEnabled(true);
        } else {
            this.addDataItem.setEnabled(false);
        }
    }

    private void addDataToForm() {
        XMLNode dataDictionary = super.getDataDictionary();
        if (dataDictionary == null) {
            return;
        }
        EditorProfile dataEditorProfile = super.getDataEditorProfile();
        XMLNode jspNode = this.getRootElement().getXMLNode();
        XMLNode jspsNode = jspNode.getParent();
        boolean haveRefToSrvOp = false;
        OperationDataSelectDialog dlg = new OperationDataSelectDialog(this.getShell(), 0);
        dlg.setDataDictionary(dataDictionary);
        XMLElementObjectMaker maker = new XMLElementObjectMaker();
        XMLLoader loader = new XMLLoader();
        loader.addObjectMaker((ObjectMaker)maker);
        Vector childs = jspsNode.getChilds();
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (aNode.getNodeName().equals("refSrvOp")) {
                try {
                    String fileName = aNode.getAttrValue("fileName");
                    fileName = String.valueOf(this.getRootPath()) + "/" + fileName;
                    XMLNode opNode = (XMLNode)loader.loadXMLFile(fileName);
                    XMLNode datasNode = opNode.getChild("datas");
                    if (datasNode != null) {
                        String opCode = String.valueOf(opNode.getAttrValue("trxCode")) + "SrvOp";
                        dlg.addOperationRefDataNode(opCode, datasNode);
                        haveRefToSrvOp = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (!haveRefToSrvOp) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("VisualHtmlFramePanel.Warning_2"), (String)Messages.getString("VisualHtmlFramePanel.Please_set_up_the_ref_Server_Operation_properties_first_!_3"));
            return;
        }
        try {
            Vector selectDatas = (Vector)dlg.open();
            if (selectDatas != null) {
                String nodeName = this.getActivateVisualElement().getXMLNode().getNodeName();
                if ("form".equals(nodeName)) {
                    this.addDataElementToForm(selectDatas, this.getActivateVisualElement());
                } else {
                    this.addDataElementToJSP(selectDatas, this.getActivateVisualElement());
                }
                this.workingArea.saveCurrentAction();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addDataElementToJSP(Vector datas, VisualElementWrapper jspWrapper) {
        int i;
        XMLNode viewNode = jspWrapper.getXMLNode();
        int x = 10;
        int y = 10;
        int height = 25;
        int space = 5;
        Vector childs = viewNode.getChilds();
        if (childs == null) {
            y = 10;
        } else {
            i = 0;
            while (i < childs.size()) {
                int h;
                XMLNode aNode = (XMLNode)childs.elementAt(i);
                String heightStr = aNode.getAttrValue("y");
                if (heightStr != null && y < (h = Integer.parseInt(heightStr))) {
                    y = h;
                }
                ++i;
            }
            y = y + space + height;
        }
        i = 0;
        while (i < datas.size()) {
            XMLNode dataNode = (XMLNode)datas.elementAt(i);
            if (!"#text".equals(dataNode.getNodeName()) && dataNode != null && !dataNode.getNodeName().equals("dataCollection")) {
                XMLNode textNode = new XMLNode();
                textNode.setNodeName("OutField");
                textNode.setAttrValue("dataName", dataNode.getAttrValue("id"));
                viewNode.add(textNode);
                int fieldLength = 100;
                if (dataNode.getAttrValue("length") != null) {
                    fieldLength = 8 * Integer.parseInt(dataNode.getAttrValue("length"));
                }
                textNode.setAttrValue("x", String.valueOf(x));
                textNode.setAttrValue("y", String.valueOf(y));
                textNode.setAttrValue("width", String.valueOf(fieldLength));
                textNode.setAttrValue("height", "25");
                textNode.setAttrValue("name", dataNode.getAttrValue("id"));
                this.addNewElement(jspWrapper, textNode);
                y = y + height + space;
            }
            ++i;
        }
        viewNode.setAttrValue("height", String.valueOf(y));
        this.workingArea.redraw();
    }

    private void addDataElementToForm(Vector datas, VisualElementWrapper formWrapper) {
        int i;
        XMLNode viewNode = formWrapper.getXMLNode();
        int x = 10;
        int y = 10;
        int height = 25;
        int space = 5;
        Vector childs = viewNode.getChilds();
        if (childs == null) {
            y = 10;
        } else {
            i = 0;
            while (i < childs.size()) {
                int h;
                XMLNode aNode = (XMLNode)childs.elementAt(i);
                String heightStr = aNode.getAttrValue("y");
                if (heightStr != null && y < (h = Integer.parseInt(heightStr))) {
                    y = h;
                }
                ++i;
            }
            y = y + space + height;
        }
        i = 0;
        while (i < datas.size()) {
            String label;
            XMLNode aNode;
            XMLNode dataNode = (XMLNode)datas.elementAt(i);
            if (!"#text".equals(dataNode.getNodeName()) && dataNode != null && (aNode = this.getViewNode(dataNode.getAttrValue("id"), viewNode)) == null && !dataNode.getNodeName().equals("dataCollection") && (label = dataNode.getAttrValue("label")) != null) {
                int labelLength = label.getBytes().length * 8 + 16;
                XMLNode labelNode = new XMLNode();
                labelNode.setAttrValue("name", this.getObjectName("Label"));
                labelNode.setNodeName("Label");
                labelNode.setAttrValue("text", label);
                labelNode.setAttrValue("dataName", dataNode.getAttrValue("id"));
                labelNode.setAttrValue("x", String.valueOf(10));
                labelNode.setAttrValue("y", String.valueOf(y));
                labelNode.setAttrValue("width", String.valueOf(labelLength));
                labelNode.setAttrValue("height", "25");
                viewNode.add(labelNode);
                this.addNewElement(formWrapper, labelNode);
                x = 10 + labelLength + 15;
                XMLNode textNode = new XMLNode();
                textNode.setNodeName("TextField");
                textNode.setAttrValue("dataName", dataNode.getAttrValue("id"));
                viewNode.add(textNode);
                int fieldLength = 100;
                if (dataNode.getAttrValue("length") != null) {
                    fieldLength = 8 * Integer.parseInt(dataNode.getAttrValue("length"));
                }
                textNode.setAttrValue("x", String.valueOf(x));
                textNode.setAttrValue("y", String.valueOf(y));
                textNode.setAttrValue("width", String.valueOf(fieldLength));
                textNode.setAttrValue("height", "25");
                textNode.setAttrValue("name", dataNode.getAttrValue("id"));
                this.addNewElement(formWrapper, textNode);
                y = y + height + space;
            }
            ++i;
        }
        viewNode.setAttrValue("height", String.valueOf(y));
        this.workingArea.redraw();
    }

    private XMLNode getViewNode(String dataName, XMLNode node) {
        Vector childs = node.getChilds();
        if (childs == null) {
            return null;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                String aDataName = aNode.getAttrValue("dataName");
                if (aDataName != null && aDataName.equals(dataName)) {
                    return aNode;
                }
                XMLNode subNode = this.getViewNode(dataName, aNode);
                if (subNode != null) {
                    return subNode;
                }
            }
            ++i;
        }
        return null;
    }

    public void createToolItems() {
        this.saveItem = new ToolItem(this.toolBar, 8);
        this.saveItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (VisualHtmlFramePanel.this.saver != null) {
                    VisualHtmlFramePanel.this.saver.saveFile();
                }
            }
        });
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.saveItem.setImage(ResourceManager.getImage(clazz, "/images/save.gif"));
        this.saveItem.setToolTipText("save the file");
        this.saveItem.setEnabled(false);
        ToolItem saveAsTempleteToolItem = new ToolItem(this.toolBar, 8);
        saveAsTempleteToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualHtmlFramePanel.this.saveAsTemplete();
            }
        });
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        saveAsTempleteToolItem.setImage(ResourceManager.getImage(clazz2, "/images/saveAsTemplete.gif"));
        saveAsTempleteToolItem.setToolTipText(Messages.getString("VisualHtmlFramePanel.Save_as_Templete_1"));
        ToolItem toolItem_10 = new ToolItem(this.toolBar, 2);
        this.addDataItem = new ToolItem(this.toolBar, 8);
        this.addDataItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualHtmlFramePanel.this.addDataToForm();
            }
        });
        this.addDataItem.setToolTipText(Messages.getString("VisualHtmlFramePanel.add_Data_Element_to_Form_1"));
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addDataItem.setImage(ResourceManager.getImage(clazz3, "/images/addDataToForm.gif"));
        ToolItem toolItem_11 = new ToolItem(this.toolBar, 2);
        super.createToolItems();
        this.unitToolItem.dispose();
    }

    private void saveAsTemplete() {
        FileDialog fileDlg = new FileDialog(this.getShell(), 8192);
        String aFileName = fileDlg.open();
        if (aFileName == null) {
            return;
        }
        try {
            String tmp = aFileName.toLowerCase();
            if (!tmp.endsWith(".tmp")) {
                aFileName = String.valueOf(aFileName) + ".tmp";
            }
            FileWriter fw = new FileWriter(aFileName);
            StringBuffer strBuf = new StringBuffer();
            XMLNode node = (XMLNode)this.getRootElement().getXMLNode().clone();
            int i = 0;
            while (i < node.getChilds().size()) {
                XMLNode aNode = (XMLNode)node.getChilds().elementAt(i);
                aNode.setAttrValue("fromTemplet", "true");
                ++i;
            }
            node.toXMLContent(0, strBuf);
            fw.write(strBuf.toString());
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

