/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualhtml;

import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualhtml.HtmlTableMaker;
import com.ecc.ide.editor.visualhtml.Messages;
import com.ecc.ide.editor.visualhtml.VisualViewConvertor;
import java.util.Vector;

public class XMLToHtmlConvertor
implements VisualViewConvertor {
    public static boolean isPreview = false;
    protected boolean isLayoutContent;
    protected String rootPath;
    protected String jspFileName;
    protected String clientOpId;
    protected AbstractBuilder builder;
    protected String classify = null;
    int iCollIdx = 0;
    protected XMLNode jsFunctionNode;
    private StringBuffer headBuffer = new StringBuffer();
    private StringBuffer onLoadBuffer = new StringBuffer("\nfunction loadMe()\n{\n");
    private String htmlTrxFileName;

    public void setJSFunctionNode(XMLNode node) {
        this.jsFunctionNode = node;
    }

    public void setBuilder(AbstractBuilder builder) {
        this.builder = builder;
    }

    public void setRootPath(String path) {
        this.rootPath = path;
    }

    public void setClientOpId(String value) {
        this.clientOpId = value;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    public String getClientOpId() {
        return this.clientOpId;
    }

    public String convertXMLNodeToHtml(XMLNode node) {
        String notationType;
        XMLNode aNode;
        this.jspFileName = node.getAttrValue("name");
        if (this.classify != null && this.classify.length() > 0) {
            this.jspFileName = String.valueOf(this.classify) + "/" + this.jspFileName;
        }
        HtmlTableMaker maker = new HtmlTableMaker(this);
        StringBuffer buffer = new StringBuffer();
        this.isLayoutContent = "true".equals(node.getAttrValue("toBeLayoutContent"));
        this.headBuffer.append("<%@page language=\"java\" contentType=\"text/html; charset=");
        this.headBuffer.append(System.getProperty("file.encoding"));
        this.headBuffer.append("\"%>\n");
        if (IDEConstance.buildJspWithTaglib) {
            this.headBuffer.append("<%@taglib uri=\"/WEB-INF/ctp.tld\" prefix=\"ctp\" %>\n");
            this.headBuffer.append("<%@taglib uri=\"/WEB-INF/emp.tld\" prefix=\"emp\" %>\n");
            this.headBuffer.append("<%@taglib uri=\"/WEB-INF/c.tld\" prefix=\"c\" %>\n");
        } else {
            String fileName = "includes/utb.jsp";
            fileName = this.getRelativePath(fileName);
            this.headBuffer.append("<%@ include file=\"");
            this.headBuffer.append(fileName);
            this.headBuffer.append("\"%>");
        }
        Vector childs = node.getChilds();
        int i = 0;
        while (i < childs.size()) {
            aNode = (XMLNode)childs.elementAt(i);
            if ("notation".equals(aNode.getNodeName()) && "0".equals(notationType = aNode.getAttrValue("notateType"))) {
                this.headBuffer.append("\n");
                this.headBuffer.append(aNode.getAttrValue("nodeValue"));
                this.headBuffer.append("\n");
            }
            ++i;
        }
        this.headBuffer.append("\n<html>\n<head>\n");
        if (node.getAttrValue("title") != null) {
            this.headBuffer.append("<title>");
            this.headBuffer.append(node.getAttrValue("title"));
            this.headBuffer.append("</title>\n");
        }
        this.headBuffer.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=GBK\">\n");
        this.headBuffer.append("<!-- IDE required content, please don't delete it. -->\n");
        this.headBuffer.append("<!-- htmlTrxCode=\"");
        this.headBuffer.append(this.clientOpId);
        this.headBuffer.append("\" toBeLayoutContent=\"");
        this.headBuffer.append(String.valueOf(this.isLayoutContent));
        this.headBuffer.append("\" contentDivId=\"");
        this.headBuffer.append(IDEConstance.contentDivID);
        this.headBuffer.append("\" htmlTrxFileName=\"");
        this.headBuffer.append(this.htmlTrxFileName);
        this.headBuffer.append("\" -->\n");
        if (node.getAttrValue("CSSFile") != null) {
            if (!isPreview && !this.isLayoutContent) {
                String fileName = this.getImageFilePath(node.getAttrValue("CSSFile"));
                if (IDEConstance.buildJspWithTaglib) {
                    this.headBuffer.append("<link rel=\"stylesheet\" href=\"<");
                    this.headBuffer.append(IDEConstance.tagPrefix);
                    this.headBuffer.append("file fileName=\"");
                    this.headBuffer.append(fileName);
                    this.headBuffer.append("\"/>");
                    this.headBuffer.append("\" type=\"text/css\">\n");
                } else {
                    this.headBuffer.append("\n<% String cssFile=\"" + fileName + "\";%>\n");
                    this.headBuffer.append("<link rel=\"stylesheet\" href=\"");
                    this.headBuffer.append("<%=utb.getJSPPath(cssFile)%>");
                    this.headBuffer.append("\" type=\"text/css\">\n");
                }
            } else if (isPreview) {
                this.headBuffer.append("<link rel=\"stylesheet\" href=\"");
                this.headBuffer.append(this.getImageFilePath(node.getAttrValue("CSSFile")));
                this.headBuffer.append("\" type=\"text/css\">\n");
            }
        }
        childs = node.getChilds();
        i = 0;
        while (i < childs.size()) {
            aNode = (XMLNode)childs.elementAt(i);
            if ("notation".equals(aNode.getNodeName()) && "1".equals(notationType = aNode.getAttrValue("notateType"))) {
                this.headBuffer.append("\n");
                this.headBuffer.append(aNode.getAttrValue("nodeValue"));
                this.headBuffer.append("\n");
            }
            ++i;
        }
        this.headBuffer.append("<script language=\"JavaScript\" type=\"text/JavaScript\">\n");
        XMLNode jsNode = node.getChild("javaScript");
        if (jsNode != null) {
            int i2 = 0;
            while (this.jsFunctionNode != null && i2 < jsNode.getChilds().size()) {
                XMLNode funcDefNode;
                XMLNode refNode = (XMLNode)jsNode.getChilds().elementAt(i2);
                XMLNode funcNode = this.jsFunctionNode.findChildNode(refNode.getAttrValue("id"));
                if (funcNode != null && (funcDefNode = funcNode.getChild("funcDef")) != null && funcDefNode.getAttrValue("nodeValue") != null) {
                    this.headBuffer.append(funcDefNode.getAttrValue("nodeValue"));
                }
                ++i2;
            }
        }
        buffer.append("</head>\n");
        XMLNode scriptNode = node.getChild("script");
        if (scriptNode != null) {
            XMLNode funcDefNode;
            XMLNode scriptDefNode = scriptNode.getChild("scriptDef");
            if (scriptDefNode != null && scriptDefNode.getAttrValue("nodeValue") != null) {
                int idx2;
                int idx1;
                String scriptDefValue = scriptDefNode.getAttrValue("nodeValue");
                String tmp = scriptDefValue.toLowerCase();
                if (tmp.indexOf("onload") != -1 && (idx1 = tmp.indexOf(34)) != -1 && (idx2 = tmp.indexOf(34, idx1 + 1)) != -1) {
                    String txt = scriptDefValue.substring(idx1 + 1, idx2);
                    this.addLoadMeScript(String.valueOf(txt) + ";\n");
                }
                buffer.append("\n<body ");
                buffer.append(scriptDefValue);
                buffer.append(">\n");
            }
            if ((funcDefNode = scriptNode.getChild("funcDefNode")) != null && funcDefNode.getNodeValue() != null) {
                this.addScriptFunction(funcDefNode.getNodeValue());
            }
        } else {
            buffer.append("\n<body>\n");
        }
        int layout = -1;
        String layoutStr = node.getAttrValue("layout");
        if ("0".equals(layoutStr)) {
            layout = 0;
        }
        maker.getHtmlTable(buffer, node, layout);
        int i3 = 0;
        while (i3 < childs.size()) {
            String notationType2;
            XMLNode aNode2 = (XMLNode)childs.elementAt(i3);
            if ("notation".equals(aNode2.getNodeName()) && "2".equals(notationType2 = aNode2.getAttrValue("notateType"))) {
                buffer.append("\n");
                buffer.append(aNode2.getAttrValue("nodeValue"));
                buffer.append("\n");
            }
            ++i3;
        }
        buffer.append("\n</body>\n");
        buffer.append("\n</html>\n");
        this.onLoadBuffer.append("\n}\n");
        this.headBuffer.append(this.onLoadBuffer);
        this.headBuffer.append("\n</script>\n");
        this.headBuffer.append(buffer);
        return this.headBuffer.toString();
    }

    public void addScriptFunction(String value) {
        this.headBuffer.append("\n");
        this.headBuffer.append(value);
    }

    public void addLoadMeScript(String value) {
        this.headBuffer.append("\n");
        this.onLoadBuffer.append(value);
    }

    public String getRelativePath(String dstPath) {
        String dst = "";
        String tmp = this.jspFileName.replace('\\', '/');
        int idx = tmp.indexOf(47);
        while (idx != -1) {
            dst = String.valueOf(dst) + "../";
            idx = tmp.indexOf(47, idx + 1);
        }
        return String.valueOf(dst) + dstPath;
    }

    public String getImageFilePath(String fileName) {
        try {
            fileName = fileName.replace('\\', '/');
            int idx = fileName.indexOf("WebContent");
            if (idx != -1) {
                if (isPreview) {
                    return this.getRelativePath(fileName.substring(idx + 11));
                }
                return fileName.substring(idx + 11);
            }
            this.reportProblem(0, String.valueOf(Messages.getString("XMLToHtmlConvertor.JSP_file_refer_image_file_to_other_path_otherthen_the_project_WebContentPath_!_n__10")) + fileName, "");
        }
        catch (Exception e) {
            this.reportProblem(0, String.valueOf(Messages.getString("XMLToHtmlConvertor.Internal_error_n__12")) + e, "");
        }
        return fileName;
    }

    public void reportProblem(int type, String msg, String location) {
        if (this.builder != null) {
            this.builder.reportProblem(type, msg, location);
        }
    }

    public String getICollName() {
        String value = "iColl" + this.iCollIdx++;
        return value;
    }

    public boolean isMeTheLayoutContent() {
        return this.isLayoutContent;
    }

    public void setHtmlTrxFileName(String htmlTrxFileName) {
        this.htmlTrxFileName = htmlTrxFileName;
    }
}

