/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualhtml;

import com.ecc.ide.builder.AbstractBuilder;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualhtml.Messages;
import com.ecc.ide.editor.visualhtml.VisualViewConvertor;

public class XMLToKJavaFormConvertor
implements VisualViewConvertor {
    public static boolean isPreview = false;
    private String rootPath;
    private String jspFileName;
    private String clientOpId;
    private AbstractBuilder builder;
    private String classify = null;
    int iCollIdx = 0;
    private XMLNode jsFunctionNode;

    public void setJSFunctionNode(XMLNode node) {
        this.jsFunctionNode = node;
    }

    public void setBuilder(AbstractBuilder builder) {
        this.builder = builder;
    }

    public void setRootPath(String path) {
        this.rootPath = path;
    }

    public void setClientOpId(String value) {
        this.clientOpId = value;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    public String getClientOpId() {
        return this.clientOpId;
    }

    public String convertXMLNodeToHtml(XMLNode node) {
        this.jspFileName = node.getAttrValue("name");
        if (this.classify != null && this.classify.length() > 0) {
            this.jspFileName = String.valueOf(this.classify) + "/" + this.jspFileName;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<%@page  buffer=\"160kb\" autoFlush=\"false\"%>\n");
        buffer.append("<%@page language=\"java\" contentType=\"text/html; charset=UTF-8\" %>\n");
        buffer.append("<%@include file=\"/includes/utb.jsp\"%>\n");
        buffer.append("\n<?xml version=\"1.0\" encoding=\"utf-8\"?>\n\n");
        buffer.append("<form title=\"");
        buffer.append(node.getAttrValue("title"));
        buffer.append("\"");
        XMLNode viewNode = node.getChild("form");
        if (viewNode != null) {
            buffer.append(" action=\"");
            buffer.append(this.getActionURL(viewNode));
            buffer.append("\">\n");
            this.convertView(viewNode, buffer);
        } else {
            buffer.append(">\n");
        }
        int i = 0;
        while (i < node.getChilds().size()) {
            XMLNode cmdNode = (XMLNode)node.getChilds().elementAt(i);
            if ("command".equals(cmdNode.getNodeName())) {
                this.convertCommand(cmdNode, buffer);
            }
            ++i;
        }
        buffer.append("\n</form>\n");
        return buffer.toString();
    }

    public String getRelativePath(String dstPath) {
        String dst = "";
        String tmp = this.jspFileName.replace('\\', '/');
        int idx = tmp.indexOf(47);
        while (idx != -1) {
            dst = String.valueOf(dst) + "../";
            idx = tmp.indexOf(47, idx + 1);
        }
        return String.valueOf(dst) + dstPath;
    }

    public String getImageFilePath(String fileName) {
        try {
            fileName = fileName.replace('\\', '/');
            int idx = fileName.indexOf("WebContent");
            if (idx != -1) {
                return this.getRelativePath(fileName.substring(idx + 11));
            }
            this.reportProblem(0, String.valueOf(Messages.getString("XMLToHtmlConvertor.JSP_file_refer_image_file_to_other_path_otherthen_the_project_WebContentPath_!_n__10")) + fileName, "");
        }
        catch (Exception e) {
            this.reportProblem(0, String.valueOf(Messages.getString("XMLToHtmlConvertor.Internal_error_n__12")) + e, "");
        }
        return fileName;
    }

    private void convertView(XMLNode node, StringBuffer buffer) {
        buffer.append("\n\t<view>\n");
        this.getFormHeadDefine(node, buffer);
        int i = 0;
        while (i < node.getChilds().size()) {
            XMLNode aNode = (XMLNode)node.getChilds().elementAt(i);
            String nodeName = aNode.getNodeName();
            if ("label".equals(nodeName)) {
                buffer.append("\t\t<label text=\"");
                buffer.append(aNode.getAttrValue("text"));
                buffer.append("\"/>\n");
            }
            if ("image".equals(nodeName)) {
                buffer.append("\t\t<image src=\"");
                buffer.append(this.getImageFilePath(aNode.getAttrValue("imageFile")));
                buffer.append("\"/>\n");
            } else if ("srvOpAction".equals(nodeName)) {
                buffer.append("\t\t<url text=\"");
                buffer.append(aNode.getAttrValue("label"));
                buffer.append("\" href=\"");
                buffer.append("<%=utb.getKJavaReqPath()%>");
                String params = aNode.getAttrValue("params");
                if (params == null) {
                    buffer.append("?dse_sessionId=<%=utb.getSessionId()%>");
                } else {
                    buffer.append("&amp;");
                    buffer.append(this.normalize(params));
                }
                buffer.append("\"/>\n");
            } else if ("jspAction".equals(nodeName)) {
                String fileName = this.getJSPFileName(aNode);
                buffer.append("\t\t<url text=\"");
                buffer.append(aNode.getAttrValue("label"));
                buffer.append("\" href=\"");
                buffer.append(fileName);
                String params = aNode.getAttrValue("params");
                if (params == null) {
                    buffer.append("?dse_sessionId=<%=utb.getSessionId()%>");
                } else {
                    buffer.append("&amp;");
                    buffer.append(this.normalize(params));
                }
                buffer.append("\"/>\n");
            } else if ("text".equals(nodeName)) {
                buffer.append("\t\t<text name=\"");
                buffer.append(aNode.getAttrValue("dataName"));
                buffer.append("\" label=\"");
                if (aNode.getAttrValue("label") != null) {
                    buffer.append(aNode.getAttrValue("label"));
                } else {
                    buffer.append(aNode.getAttrValue("name"));
                }
                buffer.append("\" type=\"");
                buffer.append(aNode.getAttrValue("type"));
                String maxLen = aNode.getAttrValue("maxLen");
                if (maxLen != null) {
                    buffer.append("\" maxLen=\"");
                    buffer.append(aNode.getAttrValue("maxLen"));
                }
                buffer.append("\"/>\n");
            } else if ("hidden".equals(nodeName)) {
                buffer.append("\t\t<hidden name=\"");
                buffer.append(aNode.getAttrValue("dataName"));
                buffer.append("\" value=\"");
                buffer.append(aNode.getAttrValue("value"));
                buffer.append("\"/>\n");
            } else if ("choiceGroup".equals(nodeName)) {
                this.getChoiceGroupDefine(buffer, aNode);
            } else if ("Table".equals(nodeName)) {
                this.getTableDefine(buffer, aNode);
            } else if ("button".equals(nodeName)) {
                buffer.append("\t\t<button text=\"");
                buffer.append(aNode.getAttrValue("text"));
                buffer.append("\"/>\n");
            } else if ("OutField".equals(nodeName)) {
                buffer.append("\t\t<label text=\"");
                if (aNode.getAttrValue("pattern") != null) {
                    buffer.append("<%=utb.getValue(\"");
                    buffer.append(aNode.getAttrValue("dataName"));
                    buffer.append("\", \"");
                    buffer.append(aNode.getAttrValue("pattern"));
                    buffer.append("\")%>");
                } else {
                    buffer.append("<%=utb.getContext().getValueAt(\"");
                    buffer.append(aNode.getAttrValue("dataName"));
                    buffer.append("\")%>");
                }
                buffer.append("\"/>\n");
            }
            ++i;
        }
        buffer.append("\n\t</view>\n");
    }

    private void getChoiceGroupDefine(StringBuffer buffer, XMLNode aNode) {
        buffer.append("\t\t<choiceGroup name=\"");
        buffer.append(aNode.getAttrValue("valueDataName"));
        buffer.append("\" text=\"");
        buffer.append(aNode.getAttrValue("text"));
        buffer.append("\">\n");
        String iCollDataName = aNode.getAttrValue("iCollName");
        String dataName = aNode.getAttrValue("dataName");
        String descName = aNode.getAttrValue("descName");
        if (descName == null) {
            descName = dataName;
        }
        String valueDataName = aNode.getAttrValue("valueDataName");
        if (iCollDataName != null && dataName != null) {
            buffer.append("\n<% IndexedCollection ");
            String iCollName = this.getICollName();
            buffer.append(iCollName);
            buffer.append(" = (IndexedCollection)utb.getContext().getElementAt(\"");
            buffer.append(iCollDataName);
            buffer.append("\");\n");
            buffer.append("for(int i=0; i<");
            buffer.append(iCollName);
            buffer.append(".size(); i++){\n KeyedCollection kColl = (KeyedCollection)");
            buffer.append(iCollName);
            buffer.append(".getElementAt(i); String itemName=\"item\" + String.valueOf(i); %>\n");
            buffer.append("\t\t\t<choice name=\"");
            buffer.append("<%=itemName%>");
            buffer.append("\" text=\"");
            String pattern = aNode.getAttrValue("pattern");
            if (pattern != null) {
                buffer.append("<%=utb.formatValue((String)kColl.getValueAt(\"");
                buffer.append(dataName);
                buffer.append("\"), \"");
                buffer.append(pattern);
                buffer.append("\")%>");
            } else {
                buffer.append("<%=kColl.getValueAt(\"" + dataName + "\")%>");
            }
            buffer.append("\" value=\"");
            buffer.append("<%=kColl.getValueAt(\"" + dataName + "\")%>");
            buffer.append("\"/>\n");
            buffer.append("<%}%>");
        } else {
            int k = 0;
            while (k < aNode.getChilds().size()) {
                XMLNode cNode = (XMLNode)aNode.getChilds().elementAt(k);
                buffer.append("\t\t\t<choice name=\"");
                buffer.append(cNode.getAttrValue("name"));
                buffer.append("\" text=\"");
                buffer.append(cNode.getAttrValue("text"));
                buffer.append("\" value=\"");
                buffer.append(cNode.getAttrValue("value"));
                buffer.append("\"/>\n");
                ++k;
            }
        }
        buffer.append("\t\t</choiceGroup>\n");
    }

    private void getTableDefine(StringBuffer buffer, XMLNode aNode) {
        String iCollDataName = aNode.getAttrValue("iCollName");
        if (iCollDataName == null) {
            return;
        }
        buffer.append("\n<% IndexedCollection ");
        String iCollName = this.getICollName();
        buffer.append(iCollName);
        buffer.append(" = (IndexedCollection)utb.getContext().getElementAt(\"");
        buffer.append(iCollDataName);
        buffer.append("\");\n");
        buffer.append("for(int i=0; i<");
        buffer.append(iCollName);
        buffer.append(".size(); i++){\n KeyedCollection kColl = (KeyedCollection)");
        buffer.append(iCollName);
        buffer.append(".getElementAt(i); %>\n");
        boolean needTitle = "true".equals(aNode.getAttrValue("needTableTitle"));
        int i = 0;
        while (i < aNode.getChilds().size()) {
            String pattern;
            XMLNode cNode = (XMLNode)aNode.getChilds().elementAt(i);
            String dataName = cNode.getAttrValue("dataName");
            buffer.append("\t\t\t<label name=\" \" text=\"");
            String label = cNode.getAttrValue("label");
            if (needTitle && label != null) {
                buffer.append(label);
                buffer.append(":");
            }
            if ((pattern = cNode.getAttrValue("pattern")) != null) {
                buffer.append("<%=utb.formatValue((String)kColl.getValueAt(\"");
                buffer.append(dataName);
                buffer.append("\"), \"");
                buffer.append(pattern);
                buffer.append("\")%>");
            } else {
                buffer.append("<%=kColl.getValueAt(\"" + dataName + "\")%>");
            }
            buffer.append("\"/>\n");
            ++i;
        }
        buffer.append("<%}%>");
    }

    private void convertCommand(XMLNode node, StringBuffer buffer) {
        if (node.getAttrValue("isMainMenu") != null) {
            buffer.append("\t<command isMainMenu=\"");
            buffer.append(node.getAttrValue("isMainMenu"));
            buffer.append("\">\n");
        } else {
            buffer.append("\t<command>\n");
        }
        int i = 0;
        while (i < node.getChilds().size()) {
            XMLNode aNode = (XMLNode)node.getChilds().elementAt(i);
            buffer.append("\t\t<item name=\"");
            buffer.append(aNode.getAttrValue("name"));
            buffer.append("\" text=\"");
            buffer.append(aNode.getAttrValue("text"));
            buffer.append("\" action=\"");
            String jspFile = this.getJSPFileName(aNode);
            if (jspFile != null) {
                buffer.append("<%=utb.getJSPPath(\"" + jspFile + "\")%>");
                String params = aNode.getAttrValue("params");
                if (params == null) {
                    buffer.append("?dse_sessionId=<%=utb.getSessionId()%>");
                } else {
                    buffer.append("&amp;");
                    buffer.append(this.normalize(params));
                }
            } else {
                buffer.append(aNode.getAttrValue("href"));
            }
            buffer.append("\"/>\n");
            ++i;
        }
        buffer.append("\t</command>\n");
    }

    private String getActionURL(XMLNode node) {
        if ("JSPFile".equals(node.getAttrValue("actionType"))) {
            String jspFile = this.getJSPFileName(node);
            return "<%=utb.getJSPPath(\"" + jspFile + "\")%>";
        }
        if ("true".equals(node.getAttrValue("isSessionReq"))) {
            return "<%=utb.getKJavaSessionReqPath()%>";
        }
        return "<%=utb.getKJavaReqPath()%>";
    }

    private void getFormHeadDefine(XMLNode node, StringBuffer buffer) {
        if ("JSPFile".equals(node.getAttrValue("actionType"))) {
            buffer.append("\t\t<hidden name=\"dse_sessionId\" value=\"<%=utb.getSessionId()%/>");
            buffer.append("\">");
            buffer.append("\t\t<hidden name=\"htmlCltOp\" value=\"");
            buffer.append(this.getClientOpId());
            buffer.append("\"/>\n");
        } else {
            buffer.append("\t\t<%=utb.getKJavaRequiredFields(\"\",\"");
            buffer.append(node.getAttrValue("srvOpName"));
            buffer.append("\")%>\n");
            buffer.append("\t\t<hidden name=\"htmlCltOp\" value=\"");
            buffer.append(this.getClientOpId());
            buffer.append("\"/>\n");
        }
    }

    public void reportProblem(int type, String msg, String location) {
        if (this.builder != null) {
            this.builder.reportProblem(type, msg, location);
        }
    }

    public String getICollName() {
        String value = "iColl" + this.iCollIdx++;
        return value;
    }

    protected String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                default: {
                    if (ch < ' ') {
                        str.append("&#");
                        str.append(String.valueOf((int)ch));
                        str.append(";");
                        break;
                    }
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    private String getJSPFileName(XMLNode node) {
        String fileName = node.getAttrValue("jspFileName");
        if (fileName == null) {
            return null;
        }
        XMLNode jspsNode = node;
        while ((jspsNode = jspsNode.getParent()) != null && !"jsps".equals(jspsNode.getNodeName())) {
        }
        XMLNode jspNode = jspsNode.findChildNodeNamed(fileName);
        if (jspNode == null) {
            return null;
        }
        if ("refJsp".equals(jspNode.getNodeName())) {
            return this.getRelativePath(fileName);
        }
        return fileName;
    }
}

