/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualmvc;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.ContentChangedEvent;
import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.ide.editor.Wrapper;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.objectEditor.ObjectEditor;
import com.ecc.ide.editor.visualmvc.MVCVisualPanel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class MVCElementEditor
implements ObjectEditor,
ContentChangedListener {
    Object result = null;
    Wrapper editWrapper;
    private boolean changed = false;

    public Object editObject(Wrapper wrapper, Shell shell, String title) {
        this.editWrapper = wrapper;
        XMLNode node = (XMLNode)wrapper.getWrappedObject();
        if (wrapper.getWrapperOwner() != null && wrapper.getWrapperOwner() instanceof MVCVisualPanel) {
            MVCVisualPanel panel = (MVCVisualPanel)wrapper.getWrapperOwner();
            final IProject project = panel.getProject();
            if ("flow".equals(node.getNodeName())) {
                String fileName = node.getAttrValue("fileName");
                if (fileName == null) {
                    return null;
                }
                String bizGrpId = IDEContent.getBizGroupIdFromMVCFile(project, panel.mvcFileName);
                final String aFileName = "designFiles\\bizs\\" + bizGrpId + "\\" + fileName;
                shell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        try {
                            IFile file = project.getFile(aFileName);
                            String extension = file.getFileExtension();
                            if ("mtx".equals(extension.toLowerCase())) {
                                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"com.ecc.ide.plugin.editors.MCITransactionEditor", (boolean)true);
                            } else if ("biz".equals(extension.toLowerCase())) {
                                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"com.ecc.ide.plugin.editors.BIZModelEditor", (boolean)true);
                            }
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else if ("view".equals(node.getNodeName())) {
                String jspFile = node.getAttrValue("jspFile");
                if (node.getAttrValue("designFile") != null && node.getAttrValue("designFile").length() > 0) {
                    jspFile = node.getAttrValue("designFile");
                }
                if (jspFile == null) {
                    return null;
                }
                final String aFileName = String.valueOf(panel.getRelaPath()) + "/" + jspFile;
                shell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        try {
                            IFile file = project.getFile(aFileName);
                            if (aFileName.endsWith(".jsp")) {
                                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"com.ecc.emp.ide.plugin.editors.jsp.JSPEditor", (boolean)true);
                            } else {
                                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                            }
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        return null;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void contentChanged(ContentChangedEvent event) {
        this.changed = true;
    }
}

