/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualmvc;

import com.ecc.ide.editor.XMLNode;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MVCSettingsNodePanel
extends Composite {
    private XMLNode mvcDefineNode;
    private Text servletNameText;
    private Text factoryNameText;
    private Text urlPatternText;
    private XMLNode servletNameNode;
    private XMLNode factoryNameNode;
    private XMLNode urlPatternNode;

    public MVCSettingsNodePanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        Group servletGroup = new Group((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        servletGroup.setLayout((Layout)gridLayout);
        servletGroup.setText("Servlet");
        servletGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label servletNameLabel = new Label((Composite)servletGroup, 0x1000000);
        GridData gridData_1 = new GridData();
        gridData_1.widthHint = 100;
        servletNameLabel.setLayoutData((Object)gridData_1);
        servletNameLabel.setText("Servlet Name");
        this.servletNameText = new Text((Composite)servletGroup, 2048);
        GridData gridData_2 = new GridData(4, 0x1000000, false, false);
        gridData_2.minimumWidth = 200;
        gridData_2.widthHint = 400;
        this.servletNameText.setLayoutData((Object)gridData_2);
        this.servletNameText.setEnabled(false);
        Label factoryNameLabel = new Label((Composite)servletGroup, 0x1000000);
        factoryNameLabel.setLayoutData((Object)gridData_1);
        factoryNameLabel.setText("Factory Name");
        this.factoryNameText = new Text((Composite)servletGroup, 2048);
        this.factoryNameText.setLayoutData((Object)gridData_2);
        this.factoryNameText.setEnabled(false);
        Group servletMappingGroup = new Group((Composite)this, 0);
        servletMappingGroup.setLayout((Layout)gridLayout);
        servletMappingGroup.setText("Servlet-Mapping");
        servletMappingGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label urlPatternLabel = new Label((Composite)servletMappingGroup, 0x1000000);
        urlPatternLabel.setLayoutData((Object)gridData_1);
        urlPatternLabel.setText("Url-Pattern");
        this.urlPatternText = new Text((Composite)servletMappingGroup, 2048);
        this.urlPatternText.setLayoutData((Object)gridData_2);
    }

    public void setMVCDefineNode(XMLNode node) {
        this.mvcDefineNode = node;
        XMLNode servletNode = node.findChild("servlet");
        this.servletNameNode = servletNode.findChild("servlet-name");
        String servletName = this.servletNameNode.getChild("#text").getTextValue();
        if (servletName != null && servletName.trim().length() != 0) {
            this.servletNameText.setText(String.valueOf(servletName));
        }
        this.factoryNameNode = this.getInitParamValueNode(servletNode, "factoryName");
        String factoryName = this.factoryNameNode.getChild("#text").getTextValue();
        if (factoryName != null && factoryName.trim().length() != 0) {
            this.factoryNameText.setText(String.valueOf(factoryName));
        }
        XMLNode servletMappingNode = node.findChild("servlet-mapping");
        this.urlPatternNode = servletMappingNode.findChild("url-pattern");
        String urlPatternValue = this.urlPatternNode.getChild("#text").getTextValue();
        if (urlPatternValue != null && urlPatternValue.trim().length() != 0) {
            this.urlPatternText.setText(String.valueOf(urlPatternValue));
        }
        this.urlPatternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MVCSettingsNodePanel.this.urlPatternText.getText().length() > 0) {
                    MVCSettingsNodePanel.this.urlPatternNode.getChild("#text").setTextValue(MVCSettingsNodePanel.this.urlPatternText.getText());
                } else {
                    MVCSettingsNodePanel.this.urlPatternNode.getChild("#text").setTextValue(null);
                }
                MVCSettingsNodePanel.this.mvcDefineNode.fireContentChangedEvent();
            }
        });
    }

    private XMLNode getInitParamValueNode(XMLNode servletNode, String paramName) {
        int i = 0;
        while (i < servletNode.getChilds().size()) {
            String initParamName;
            XMLNode initParamNode = (XMLNode)servletNode.getChilds().elementAt(i);
            if ("init-param".equals(initParamNode.getNodeName()) && paramName.equals(initParamName = initParamNode.findChild("param-name").getChild("#text").getTextValue())) {
                return initParamNode.findChild("param-value");
            }
            ++i;
        }
        return null;
    }

    public void dispose() {
        super.dispose();
    }
}

