/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualmvc;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualflow.TransitionWrapper;
import com.ecc.ide.editor.visualmvc.FlowElementWrapper;
import com.ecc.ide.editor.visualmvc.JSPElementWrapper;
import com.ecc.ide.editor.visualmvc.MVCElementWrapper;
import com.ecc.ide.editor.visualmvc.ModelUpdaterElementWrapper;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.plugin.views.PrjNodeSelectDialog;
import com.ecc.ide.plugin.views.PrjViewPanel;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import com.ecc.ide.visualeditor.Messages;
import com.ecc.ide.visualeditor.VisualEditorFramePanel;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import com.swtdesigner.ResourceManager;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class MVCVisualPanel
extends VisualEditorFramePanel {
    private ToolItem linkItem;
    private ToolItem viewItem;
    private ToolItem flowItem;
    public XMLNode commonStates;
    private IProject project;
    public String mvcFileName = "";
    private static String defaultWidth = "160";
    private static String defaultHeight = "70";
    static /* synthetic */ Class class$0;

    public void setProject(IProject prj) {
        this.project = prj;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setRootPath(String path) {
        super.setRootPath(path.replace('\\', '/'));
    }

    public MVCVisualPanel(Composite parent, int style) {
        super(parent, style);
        this.workingArea.setBackground(Display.getCurrent().getSystemColor(1));
    }

    private void beginLink() {
        this.workingArea.beginLink();
    }

    public void doLink(VisualElementWrapper src, VisualElementWrapper dst) {
        this.linkItem.setSelection(false);
        if (src instanceof FlowElementWrapper) {
            XMLNode node = new XMLNode();
            node.setNodeName("transition");
            node.setAttrValue("name", this.getObjectName("transition"));
            node.setAttrValue("dest", dst.getAttrValue("name"));
            TransitionWrapper wrapper = new TransitionWrapper(src, dst, node, this.profile);
            wrapper.editor = this;
            src.getXMLNode().add(node);
            super.addWrapper(src, wrapper);
            super.setActivateWrapper(wrapper);
        } else {
            XMLNode node = new XMLNode();
            node.setNodeName("reference");
            node.setAttrValue("name", this.getObjectName("ref"));
            node.setAttrValue("dest", dst.getAttrValue("name"));
            TransitionWrapper wrapper = new TransitionWrapper(src, dst, node, this.profile);
            wrapper.editor = this;
            if ((src instanceof JSPElementWrapper || src instanceof MVCElementWrapper) && dst instanceof ModelUpdaterElementWrapper) {
                node.setAttrValue("condition", "uses");
            }
            if (src instanceof ModelUpdaterElementWrapper && dst instanceof FlowElementWrapper) {
                node.setAttrValue("condition", "update");
            }
            if (src instanceof JSPElementWrapper && dst instanceof FlowElementWrapper) {
                node.setAttrValue("condition", "execute");
            }
            src.getXMLNode().add(node);
            super.addWrapper(src, wrapper);
            super.setActivateWrapper(wrapper);
        }
        this.workingArea.saveCurrentAction();
    }

    public void cancelCurrentAction() {
        super.cancelCurrentAction();
        this.linkItem.setSelection(false);
    }

    public void removeElement(VisualElementWrapper wrapper) {
        super.removeElement(wrapper);
        if (wrapper == null) {
            return;
        }
        String objName = wrapper.getAttrValue("name");
        Vector elements = (Vector)super.getVisualElements().clone();
        int i = 0;
        while (i < elements.size()) {
            VisualElementWrapper aWrapper = (VisualElementWrapper)elements.elementAt(i);
            if (aWrapper instanceof TransitionWrapper && objName.equals(aWrapper.getAttrValue("dest"))) {
                super.removeElement(aWrapper);
            }
            ++i;
        }
    }

    private void addJSPReference() {
        String mvcGroupId = IDEContent.getGroupId(this.mvcFileName);
        IFolder folder = this.project.getFolder("designFiles/mvcs/" + mvcGroupId);
        PrjNodeSelectDialog dialog = new PrjNodeSelectDialog(this.getShell(), folder);
        dialog.setSelectTypes(new String[]{"jsp", "grd", "htm", "html"});
        int result = dialog.open();
        if (result == 1) {
            return;
        }
        PrjViewXMLNode node = dialog.getResult();
        IFile file = (IFile)node.obj;
        String jspName = file.getLocation().toString();
        mvcGroupId = "designFiles/mvcs/" + mvcGroupId + "/";
        jspName = jspName.substring(jspName.indexOf(mvcGroupId) + mvcGroupId.length());
        String designFile = "";
        if (!(jspName.endsWith(".jsp") || jspName.endsWith(".htm") || jspName.endsWith(".html"))) {
            designFile = jspName;
            jspName = String.valueOf(jspName.substring(0, jspName.lastIndexOf("."))) + ".jsp";
        }
        XMLNode jspNode = new XMLNode("view");
        jspNode.setAttrValue("id", file.getName());
        jspNode.setAttrValue("jspFile", jspName);
        jspNode.setAttrValue("name", this.getObjectName("view"));
        jspNode.setAttrValue("width", defaultWidth);
        jspNode.setAttrValue("height", defaultHeight);
        if (designFile != null && designFile.length() > 0) {
            jspNode.setAttrValue("designFile", designFile);
        }
        this.addNewElement(this.rootWrapper, jspNode);
        this.xmlContent.add(jspNode);
        this.updateContent();
    }

    public void addFlowReference() {
        String bizGroupId = IDEContent.getBizGroupIdFromMVCFile(this.project, this.mvcFileName);
        IFolder folder = this.project.getFolder("designFiles/bizs/" + bizGroupId);
        PrjNodeSelectDialog dialog = new PrjNodeSelectDialog(this.getShell(), folder);
        dialog.setSelectTypes(new String[]{"biz", "mtx"});
        int result = dialog.open();
        if (result == 1) {
            return;
        }
        PrjViewXMLNode node = dialog.getResult();
        IFile file = (IFile)node.obj;
        XMLNode mtxNode = this.loadXMLFile(file);
        String trxCode = mtxNode.getAttrValue("trxCode");
        String fileName = file.getLocation().toOSString();
        bizGroupId = "designFiles\\bizs\\" + bizGroupId + "\\";
        fileName = fileName.substring(fileName.indexOf(bizGroupId) + bizGroupId.length());
        String opName = node.selectBizOp;
        if (opName == null || opName.trim().length() == 0) {
            opName = trxCode;
        }
        XMLNode flowNode = new XMLNode("flow");
        flowNode.setAttrValue("id", trxCode);
        flowNode.setAttrValue("refId", opName);
        flowNode.setAttrValue("fileName", fileName);
        flowNode.setAttrValue("name", this.getObjectName("flow"));
        flowNode.setAttrValue("width", defaultWidth);
        flowNode.setAttrValue("height", defaultHeight);
        this.addNewElement(this.rootWrapper, flowNode);
        this.xmlContent.add(flowNode);
        this.updateContent();
    }

    public void addJSPReference(IFile file) {
        String mvcGroupId = IDEContent.getGroupId(this.mvcFileName);
        String jspName = file.getLocation().toString();
        mvcGroupId = "designFiles/mvcs/" + mvcGroupId + "/";
        jspName = jspName.substring(jspName.indexOf(mvcGroupId) + mvcGroupId.length());
        String designFile = "";
        if (!(jspName.endsWith(".jsp") || jspName.endsWith(".htm") || jspName.endsWith(".html"))) {
            designFile = jspName;
            jspName = String.valueOf(jspName.substring(0, jspName.lastIndexOf("."))) + ".jsp";
        }
        XMLNode jspNode = new XMLNode("view");
        jspNode.setAttrValue("id", file.getName());
        jspNode.setAttrValue("jspFile", jspName);
        jspNode.setAttrValue("name", this.getObjectName("view"));
        jspNode.setAttrValue("width", defaultWidth);
        jspNode.setAttrValue("height", defaultHeight);
        if (designFile != null && designFile.length() > 0) {
            jspNode.setAttrValue("designFile", designFile);
        }
        this.addNewElement(this.rootWrapper, jspNode);
        this.xmlContent.add(jspNode);
        this.updateContent();
    }

    public void addFlowReference(IFile file) {
        XMLNode node = this.loadXMLFile(file);
        String trxCode = node.getAttrValue("trxCode");
        String bizGroupId = IDEContent.getBizGroupIdFromMVCFile(this.project, this.mvcFileName);
        String fileName = file.getLocation().toOSString();
        bizGroupId = "designFiles\\bizs\\" + bizGroupId + "\\";
        fileName = fileName.substring(fileName.indexOf(bizGroupId) + bizGroupId.length());
        XMLNode flowNode = new XMLNode("flow");
        flowNode.setAttrValue("id", trxCode);
        flowNode.setAttrValue("refId", trxCode);
        flowNode.setAttrValue("fileName", fileName);
        flowNode.setAttrValue("name", this.getObjectName("flow"));
        flowNode.setAttrValue("width", defaultWidth);
        flowNode.setAttrValue("height", defaultHeight);
        this.addNewElement(this.rootWrapper, flowNode);
        this.xmlContent.add(flowNode);
        this.updateContent();
    }

    public VisualElementWrapper addNewElement(VisualElementWrapper wrapper, Element element, int x, int y) {
        if (this.xmlContent == null) {
            return null;
        }
        VisualElementWrapper newWrapper = super.addNewElement(wrapper, element, x, y);
        if (newWrapper == null) {
            return null;
        }
        try {
            PrjViewXMLNode aNode = (PrjViewXMLNode)PrjViewXMLNode.nodesMap.get(this.project.getFile(this.mvcFileName));
            if (aNode != null) {
                PrjViewPanel.getPrjViewPanel().reload((PrjViewXMLNode)aNode.getParent());
            }
        }
        catch (Exception aNode) {
            // empty catch block
        }
        newWrapper.setAttrValue("width", defaultWidth);
        newWrapper.setAttrValue("height", defaultHeight);
        newWrapper.width = new Integer(defaultWidth);
        newWrapper.height = new Integer(defaultHeight);
        if ("view".equals(element.getElementName())) {
            XMLNode theNode = newWrapper.getXMLNode();
            String subDir = theNode.getAttrValue("subDir");
            String fileName = theNode.getAttrValue("fileName");
            String jspType = theNode.getAttrValue("jspType");
            String toBeLayout = theNode.getAttrValue("toBeLayout");
            String encoding = theNode.getAttrValue("encoding");
            String divId = theNode.getAttrValue("divId");
            theNode.setAttrValue("id", fileName);
            if (subDir != null) {
                fileName = String.valueOf(subDir) + "/" + fileName;
            }
            theNode.setAttrValue("jspFile", fileName);
            theNode.setAttrValue("subDir", subDir);
            theNode.setAttrValue("jspType", jspType);
            theNode.setAttrValue("toBeLayout", toBeLayout);
            theNode.setAttrValue("divId", divId);
            theNode.setAttrValue("encoding", encoding);
            if ("html".equals(jspType)) {
                this.createTheHtmlJspFile(fileName, encoding, toBeLayout, divId);
            } else if ("wml".equals(jspType)) {
                this.createTheWMLJspFile(fileName, encoding);
            } else if ("kjava".equals(jspType)) {
                this.createTheKJavaJspFile(fileName, encoding);
            }
            this.editJSP(fileName);
        } else {
            "flow".equals(element.getElementName());
        }
        return newWrapper;
    }

    private void createSubDir(String rootDir, String subDir) {
        File file = new File(String.valueOf(rootDir) + "/" + subDir);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private void createTheEMPFlowFile(String fileName, String subDir, String flowId, String flowName) {
        String encoding = System.getProperty("file.encoding");
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<?xml version=\"1.0\" encoding=\"");
        strBuf.append(encoding);
        strBuf.append("\" ?>\n\n");
        strBuf.append("<MCITransaction ");
        if (flowId != null && flowId.length() > 0) {
            strBuf.append(" trxCode=\"" + flowId + "\"");
        }
        if (flowName != null && flowName.length() > 0) {
            strBuf.append(" trxName=\"" + flowName + "\"");
        }
        if (subDir != null && subDir.length() > 0) {
            strBuf.append(" classify=\"" + subDir + "\"");
        }
        strBuf.append(" />");
        try {
            String theFileName = String.valueOf(this.getRootPath()) + "/designFiles/MCITrxs/" + fileName;
            FileWriter fw = new FileWriter(theFileName);
            fw.write(strBuf.toString());
            fw.close();
            if (this.project != null) {
                this.project.getFolder("/designFiles/MCITrxs").refreshLocal(2, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean checkPath(String rootPath, String fileName) {
        int idx = 0;
        int idx1 = rootPath.indexOf(":");
        if (idx1 != -1) {
            char ch1 = rootPath.charAt(0);
            ch1 = Character.toLowerCase(ch1);
            char ch2 = fileName.charAt(0);
            if (ch1 != (ch2 = Character.toLowerCase(ch2))) {
                return false;
            }
            String str1 = rootPath.substring(1);
            String str2 = fileName.substring(1);
            idx = str2.indexOf(str1);
        } else {
            idx = fileName.indexOf(rootPath);
        }
        return idx != -1;
    }

    public void createToolItems() {
        this.viewItem = new ToolItem(this.toolBar, 8);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.viewItem.setImage(ResourceManager.getImage(clazz, "/icons/jsp.gif"));
        this.viewItem.setToolTipText("Add JSP");
        this.viewItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.addJSPReference();
            }
        });
        this.flowItem = new ToolItem(this.toolBar, 8);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.flowItem.setImage(ResourceManager.getImage(clazz2, "/icons/biz.gif"));
        this.flowItem.setToolTipText("Add Flow");
        this.flowItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.addFlowReference();
            }
        });
        ToolItem toolItem_11 = new ToolItem(this.toolBar, 2);
        this.linkItem = new ToolItem(this.toolBar, 32);
        this.linkItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.beginLink();
            }
        });
        this.linkItem.setToolTipText(Messages.getString("VisualFlowFramePanel.State_transition_1"));
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.linkItem.setImage(ResourceManager.getImage(clazz3, "/icons/link.gif"));
        ToolItem saveToImgToolItem = new ToolItem(this.toolBar, 8);
        saveToImgToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.saveToImageFile();
            }
        });
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        saveToImgToolItem.setImage(ResourceManager.getImage(clazz4, "/images/image.gif"));
        saveToImgToolItem.setToolTipText(Messages.getString("VisualEditorFramePanel.Save_to_image_file_2"));
        ToolItem toolItem_10 = new ToolItem(this.toolBar, 2);
        ToolItem toolItem_6 = new ToolItem(this.toolBar, 8);
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        toolItem_6.setImage(ResourceManager.getImage(clazz5, "/icons/delete.gif"));
        toolItem_6.setToolTipText(Messages.getString("VisualEditorFramePanel.Delete_10"));
        toolItem_6.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.deleteActivateComponent();
            }
        });
        ToolItem toolItem_9 = new ToolItem(this.toolBar, 2);
        toolItem_9.setEnabled(false);
        toolItem_9.setWidth(5);
        this.undoItem = new ToolItem(this.toolBar, 8);
        this.undoItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.unDo();
            }
        });
        this.undoItem.setToolTipText(Messages.getString("VisualEditorFramePanel.unDo_1"));
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.undoItem.setImage(ResourceManager.getImage(clazz6, "/icons/undo.gif"));
        this.redoItem = new ToolItem(this.toolBar, 8);
        this.redoItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.reDo();
            }
        });
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.redoItem.setImage(ResourceManager.getImage(clazz7, "/icons/redo.gif"));
        this.redoItem.setToolTipText(Messages.getString("VisualEditorFramePanel.reDo_4"));
        ToolItem toolItem_5 = new ToolItem(this.toolBar, 2);
        final ToolItem gridToolItem = new ToolItem(this.toolBar, 32);
        gridToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.setShowGrid(gridToolItem.getSelection());
            }
        });
        gridToolItem.setToolTipText(Messages.getString("VisualEditorFramePanel.align_all_component_to_grid_29"));
        Class<?> clazz8 = class$0;
        if (clazz8 == null) {
            try {
                clazz8 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        gridToolItem.setImage(ResourceManager.getImage(clazz8, "/icons/table.gif"));
        ToolItem tabOrderToolItem = new ToolItem(this.toolBar, 8);
        tabOrderToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.beginSetTabOrder();
            }
        });
        Class<?> clazz9 = class$0;
        if (clazz9 == null) {
            try {
                clazz9 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        tabOrderToolItem.setImage(ResourceManager.getImage(clazz9, "/icons/order.gif"));
        tabOrderToolItem.setToolTipText(Messages.getString("VisualEditorFramePanel.set_tab_order_32"));
        ToolItem toolItem_7 = new ToolItem(this.toolBar, 2);
        ToolItem alLeftToolItem = new ToolItem(this.toolBar, 8);
        alLeftToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.alignLeft();
            }
        });
        alLeftToolItem.setToolTipText(Messages.getString("VisualEditorFramePanel.Align_Left_11"));
        Class<?> clazz10 = class$0;
        if (clazz10 == null) {
            try {
                clazz10 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        alLeftToolItem.setImage(ResourceManager.getImage(clazz10, "/images/align_h_left.gif"));
        ToolItem alRightToolItem = new ToolItem(this.toolBar, 8);
        alRightToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.alignRight();
            }
        });
        alRightToolItem.setToolTipText(Messages.getString("VisualEditorFramePanel.Align_Right_13"));
        Class<?> clazz11 = class$0;
        if (clazz11 == null) {
            try {
                clazz11 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        alRightToolItem.setImage(ResourceManager.getImage(clazz11, "/images/align_h_right.gif"));
        ToolItem alBottonToolItem = new ToolItem(this.toolBar, 8);
        alBottonToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.alignBotton();
            }
        });
        alBottonToolItem.setToolTipText(Messages.getString("VisualEditorFramePanel.align_Botton_15"));
        Class<?> clazz12 = class$0;
        if (clazz12 == null) {
            try {
                clazz12 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        alBottonToolItem.setImage(ResourceManager.getImage(clazz12, "/images/align_v_button.gif"));
        ToolItem alTopToolItem = new ToolItem(this.toolBar, 8);
        alTopToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.alignTop();
            }
        });
        alTopToolItem.setToolTipText(Messages.getString("VisualEditorFramePanel.align_Top_17"));
        Class<?> clazz13 = class$0;
        if (clazz13 == null) {
            try {
                clazz13 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        alTopToolItem.setImage(ResourceManager.getImage(clazz13, "/images/align_v_top.gif"));
        ToolItem toolItem_1 = new ToolItem(this.toolBar, 2);
        toolItem_1.setEnabled(false);
        ToolItem spaceHToolItem = new ToolItem(this.toolBar, 8);
        spaceHToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.makeSameSpaceH();
            }
        });
        spaceHToolItem.setToolTipText(Messages.getString("VisualEditorFramePanel.make_same_space_horizontal_19"));
        Class<?> clazz14 = class$0;
        if (clazz14 == null) {
            try {
                clazz14 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        spaceHToolItem.setImage(ResourceManager.getImage(clazz14, "/images/space_h.gif"));
        ToolItem spaceVToolItem = new ToolItem(this.toolBar, 8);
        spaceVToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.makeSameSpaceV();
            }
        });
        Class<?> clazz15 = class$0;
        if (clazz15 == null) {
            try {
                clazz15 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        spaceVToolItem.setImage(ResourceManager.getImage(clazz15, "/images/space_v.gif"));
        spaceVToolItem.setToolTipText(Messages.getString("VisualEditorFramePanel.make_same_space_vertical_22"));
        ToolItem toolItem_2 = new ToolItem(this.toolBar, 2);
        toolItem_2.setEnabled(false);
        ToolItem sizeHToolItem = new ToolItem(this.toolBar, 8);
        sizeHToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.makeSameSizeH();
            }
        });
        sizeHToolItem.setToolTipText(Messages.getString("VisualEditorFramePanel.make_same_size_horizontal_23"));
        Class<?> clazz16 = class$0;
        if (clazz16 == null) {
            try {
                clazz16 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sizeHToolItem.setImage(ResourceManager.getImage(clazz16, "/images/size_h.gif"));
        ToolItem sizeVToolItem = new ToolItem(this.toolBar, 8);
        sizeVToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.makeSameSizeV();
            }
        });
        sizeVToolItem.setToolTipText(Messages.getString("VisualEditorFramePanel.make_same_size_vertical_25"));
        Class<?> clazz17 = class$0;
        if (clazz17 == null) {
            try {
                clazz17 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sizeVToolItem.setImage(ResourceManager.getImage(clazz17, "/images/size_v.gif"));
        ToolItem sizeHVToolItem = new ToolItem(this.toolBar, 8);
        sizeHVToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCVisualPanel.this.makeSameSizeHV();
            }
        });
        sizeHVToolItem.setToolTipText(Messages.getString("VisualEditorFramePanel.make_same_size_27"));
        Class<?> clazz18 = class$0;
        if (clazz18 == null) {
            try {
                clazz18 = class$0 = Class.forName("com.ecc.ide.visualeditor.VisualEditorFramePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sizeHVToolItem.setImage(ResourceManager.getImage(clazz18, "/images/size_v_h.gif"));
    }

    protected void createTheWMLJspFile(String fileName, String encoding) {
        try {
            String theFileName = "";
            String emptyJspFileContent = "<%@page language=\"java\" contentType=\"text/vnd.wap.wml; charset=" + encoding + "\"%>\n" + "<%@taglib uri=\"/WEB-INF/ctp.tld\" prefix=\"ctp\" %>\n" + "<%@taglib uri=\"/WEB-INF/emp.tld\" prefix=\"emp\" %>\n" + "<%@taglib uri=\"/WEB-INF/c.tld\" prefix=\"c\" %>\n" + "<% response.setContentType(\"text/vnd.wap.wml\"); %>\n\n" + "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n" + "<wml>\n<head>\n<title>CTP WML file</title>\n" + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + encoding + "\"/>\n" + "<meta http-equiv=\"Cache-Control\" content=\"no-cache\" />\n" + "<!-- ECC IDE required comment, please don't delete it! -->\n";
            FileWriter fw = new FileWriter(theFileName);
            fw.write(emptyJspFileContent);
            fw.write("<!-- CTP WML JSP File -->\n");
            fw.write("<!-- mvcFile=\"");
            fw.write(this.mvcFileName);
            fw.write("\" -->\n</head>\n<card><p>CTP WML file</p></card></wml>\n");
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createTheKJavaJspFile(String fileName, String encoding) {
        String theFileName = "";
        try {
            String emptyJspFileContent = "<%@page language=\"java\" contentType=\"text/XML; charset=" + encoding + "\"%>\n" + "<%@taglib uri=\"/WEB-INF/ctp.tld\" prefix=\"ctp\" %>\n\n" + "<%@taglib uri=\"/WEB-INF/emp.tld\" prefix=\"emp\" %>\n\n" + "<%@taglib uri=\"/WEB-INF/c.tld\" prefix=\"c\" %>\n\n" + "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n" + "<kml title=\"CTP Form\">\n" + "<!-- ECC IDE required comment, please don't delete it! -->\n";
            FileWriter fw = new FileWriter(theFileName);
            fw.write(emptyJspFileContent);
            fw.write("<!-- CTP KJava JSP File -->\n");
            fw.write("<!-- mvcFile=\"");
            fw.write(this.mvcFileName);
            fw.write("\" -->\n</kml>\n");
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void editEMPFlow(String fileName) {
        String relativePath = "/designFiles/MCITrxs";
        final String aFileName = String.valueOf(relativePath) + "/" + fileName;
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IFile file = MVCVisualPanel.this.project.getFile(aFileName);
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"com.ecc.ide.plugin.editors.MCITransactionEditor", (boolean)true);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void editJSP(String fileName) {
        final String aFileName = String.valueOf(this.getRelaPath()) + "/" + fileName;
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IFile file = MVCVisualPanel.this.project.getFile(aFileName);
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"com.ecc.ide.plugin.editors.jsp.JSPEditor", (boolean)true);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void createTheHtmlJspFile(String fileName, String encoding, String toBeLayout, String divId) {
        String contentDivId = divId;
        String temp = this.getRelaPath();
        String theFileName = String.valueOf(this.getRootPath()) + "/" + temp + "/" + fileName;
        try {
            String emptyJspFileContent = "<%@page language=\"java\" contentType=\"text/html; charset=" + encoding + "\"%>\n" + "<%@taglib uri=\"/WEB-INF/ctp.tld\" prefix=\"ctp\" %>\n\n" + "<%@taglib uri=\"/WEB-INF/emp.tld\" prefix=\"emp\" %>\n\n" + "<%@taglib uri=\"/WEB-INF/c.tld\" prefix=\"c\" %>\n\n" + "<html>\n<head>\n<title>ECC IDE Jsp file</title>\n" + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + encoding + "\"/>\n" + "<!-- ECC IDE required comment, please don't delete it! -->\n";
            FileWriter fw = new FileWriter(theFileName);
            fw.write(emptyJspFileContent);
            fw.write("<!-- toBeLayoutContent=\"");
            fw.write(toBeLayout);
            fw.write("\" mvcFile=\"");
            fw.write(this.mvcFileName);
            fw.write("\" -->\n");
            fw.write("</head>\n<body>\n</body>\n</html>\n");
            fw.close();
            if (this.project != null) {
                this.project.getFolder(temp).refreshLocal(2, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMvcFileName(String mvcFileName) {
        this.mvcFileName = mvcFileName;
    }

    public String getRelaPath() {
        String temp = this.mvcFileName;
        String s = "designFiles/mvcs/";
        temp = temp.substring(0, temp.indexOf("/", temp.indexOf(s) + s.length() + 1));
        return temp;
    }

    private XMLNode loadXMLFile(IFile file) {
        try {
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode node = (XMLNode)xmlLoader.loadXMLFile(file.getLocation().toOSString());
            return node;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

