/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualmvc;

import com.ecc.ide.editor.EditorBeanPropertyPanel;
import com.ecc.ide.editor.WrapperOwner;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.DataDictionarySelectDialog;
import com.ecc.ide.editor.data.RefDataWrapper;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.visualeditor.Messages;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.Vector;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ModelUpdaterPanel
extends Composite
implements WrapperOwner {
    private Table table;
    private TableTree tableTree;
    private EditorBeanPropertyPanel editorBeanPropertyPanel;
    private EditorProfile dataDictProfile = null;
    private XMLNode dataNode;
    private Element element = null;
    private XMLNode dataDictionary;
    private XMLNode activateNode;
    private TableTreeItem activateItem;
    private XMLNode channelSettings;
    private XMLNode xmlContent;
    private String rootPath;
    private XMLNode flowDatas;

    public ModelUpdaterPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 0);
        Composite composite = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        this.tableTree = new TableTree(composite, 67586);
        this.table = this.tableTree.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn newColumnTableColumn = new TableColumn(this.table, 0);
        newColumnTableColumn.setWidth(200);
        newColumnTableColumn.setText("dataId");
        TableColumn newColumnTableColumn_1 = new TableColumn(this.table, 0);
        newColumnTableColumn_1.setWidth(200);
        newColumnTableColumn_1.setText("dataName");
        this.tableTree.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayoutData((Object)new GridData(3, 2, false, false));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        composite_1.setLayout((Layout)gridLayout_1);
        Button addButton = new Button(composite_1, 0);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelUpdaterPanel.this.addDataField();
            }
        });
        addButton.setLayoutData((Object)new GridData(90, -1));
        addButton.setText("Add");
        Button deleteButton = new Button(composite_1, 0);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelUpdaterPanel.this.deleteDataField();
            }
        });
        deleteButton.setLayoutData((Object)new GridData(90, -1));
        deleteButton.setText("Delete");
        this.initializeElementInfo();
    }

    private void initializeElementInfo() {
        this.element = new Element();
        ElementAttribute attr = new ElementAttribute();
        attr.setAttrID("required");
        attr.setAttrName("required");
        attr.setAttrType("boolean");
        this.element.addAttribute(attr);
        attr = new ElementAttribute();
        attr.setAttrID("type");
        attr.setAttrName("type");
        this.element.addAttribute(attr);
        attr.setValueListStr("Int;Short;String;Double;Decimal;Date;IP;Mail;URL;");
        attr = new ElementAttribute();
        attr.setAttrID("srcDataName");
        attr.setAttrName("srcDataName");
        this.element.addAttribute(attr);
    }

    public void setRootPath(String value) {
        this.rootPath = value;
    }

    public void setXMLContent(XMLNode node) {
        this.xmlContent = node;
        XMLNode datas = node.getChild("datas");
        if (datas == null) {
            datas = new XMLNode("datas");
            this.xmlContent.add(datas);
        }
        this.setModelDataNode(datas);
        this.loadEMPFlowInfos();
    }

    private void loadEMPFlowInfos() {
        try {
            XMLNode refFlowNode = this.xmlContent.getChild("reference");
            if (refFlowNode == null) {
                return;
            }
            String flowNodeName = refFlowNode.getAttrValue("dest");
            XMLNode refFlow = this.xmlContent.getParent().findChildNodeNamed(flowNodeName);
            String fileName = refFlow.getAttrValue("fileName");
            fileName = String.valueOf(this.rootPath) + "/" + fileName;
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode node = (XMLNode)xmlLoader.loadXMLFile(fileName);
            this.flowDatas = node.getChild("datas");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setModelDataNode(XMLNode node) {
        this.dataNode = node;
        RefDataWrapper refWrapper = null;
        this.tableTree.removeAll();
        refWrapper = new RefDataWrapper(null, this.dataNode, null);
        refWrapper.setWrapperOwner(this);
        TableTreeItem rootItem = new TableTreeItem(this.tableTree, 0);
        rootItem.setText(Messages.getString("DataDictionaryEditPanel.Data_Defines_7"));
        rootItem.setData((Object)refWrapper);
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                String refId = aNode.getAttrValue("refId");
                TableTreeItem item = new TableTreeItem(rootItem, 0);
                if (refId != null) {
                    item.setText(refId);
                } else {
                    item.setText(Messages.getString("HostDataPanel.DataGroup_1"));
                    if (aNode.getAttrValue("label") != null) {
                        item.setText(1, aNode.getAttrValue("label"));
                    }
                }
                if (refId != null && this.dataDictionary != null) {
                    XMLNode data = this.getDataNode(refId);
                    if (data != null) {
                        if (data.getAttrValue("label") != null) {
                            item.setText(1, data.getAttrValue("label"));
                        }
                        if (data.getAttrValue("desc") != null) {
                            item.setText(2, data.getAttrValue("desc"));
                        }
                    } else {
                        item.setText(1, "Data Not defined!");
                    }
                }
                RefDataWrapper refDataWrapper = "dataGroup".equals(aNode.getNodeName()) ? new RefDataWrapper(null, aNode, null) : ("refColl".equals(aNode.getNodeName()) ? new RefDataWrapper(null, aNode, null) : new RefDataWrapper(null, aNode, this.element));
                refDataWrapper.setWrapperOwner(this);
                item.setData((Object)refDataWrapper);
                refDataWrapper.setTableTreeItem(item);
                if (aNode == this.activateNode) {
                    this.activateItem = item;
                }
                this.addRefData(item, aNode);
            }
            ++i;
        }
        TableTreeItem[] items = rootItem.getItems();
        if (items.length > 0) {
            this.tableTree.showItem(items[0]);
        }
    }

    private void addRefData(TableTreeItem item, XMLNode node) {
        Vector childs = node.getChilds();
        if (childs == null || childs.size() == 0) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                String refId = aNode.getAttrValue("refId");
                TableTreeItem aItem = new TableTreeItem(item, 0);
                if (refId != null) {
                    aItem.setText(refId);
                } else {
                    aItem.setText(Messages.getString("HostDataPanel.DataGroup_4"));
                    if (aNode.getAttrValue("label") != null) {
                        item.setText(1, aNode.getAttrValue("label"));
                    }
                }
                if (refId != null && this.dataDictionary != null) {
                    XMLNode data = this.getDataNode(refId);
                    if (data != null) {
                        if (data.getAttrValue("label") != null) {
                            aItem.setText(1, data.getAttrValue("label"));
                        }
                        if (data.getAttrValue("desc") != null) {
                            aItem.setText(2, data.getAttrValue("desc"));
                        }
                    } else {
                        aItem.setText(1, "Data Not defined!");
                    }
                }
                RefDataWrapper refDataWrapper = "dataGroup".equals(aNode.getNodeName()) ? new RefDataWrapper(null, aNode, null) : ("refColl".equals(aNode.getNodeName()) ? new RefDataWrapper(null, aNode, null) : new RefDataWrapper(null, aNode, this.element));
                refDataWrapper.setWrapperOwner(this);
                aItem.setData((Object)refDataWrapper);
                refDataWrapper.setTableTreeItem(aItem);
                if (aNode == this.activateNode) {
                    this.activateItem = aItem;
                }
                this.addRefData(aItem, aNode);
            }
            ++i;
        }
    }

    private void addDataField() {
        Vector selectDatas = this.selectData();
        if (selectDatas == null) {
            return;
        }
        TableTreeItem parentItem = this.tableTree.getItem(0);
        XMLNode pNode = this.dataNode;
        if (selectDatas != null) {
            int i = 0;
            while (i < selectDatas.size()) {
                XMLNode aNode = (XMLNode)selectDatas.elementAt(i);
                if (!"#text".equals(aNode.getNodeName()) && !aNode.getNodeName().equals("refCommData")) {
                    XMLNode node = null;
                    String dataId = aNode.getAttrValue("refId");
                    if (dataId != null) {
                        node = this.getDataNode(dataId);
                    } else {
                        node = aNode;
                        dataId = node.getAttrValue("id");
                    }
                    if (node != null) {
                        Element element;
                        TableTreeItem item = new TableTreeItem(parentItem, 0);
                        item.setText(dataId);
                        if (node.getAttrValue("label") != null) {
                            item.setText(1, node.getAttrValue("label"));
                        }
                        if (node.getAttrValue("desc") != null) {
                            item.setText(2, node.getAttrValue("desc"));
                        }
                        XMLNode refNode = new XMLNode();
                        if (!node.getNodeName().equals("dataCollection")) {
                            refNode.setNodeName("refData");
                            element = this.element;
                        } else {
                            refNode.setNodeName("refColl");
                            element = null;
                        }
                        refNode.setAttrValue("refId", dataId);
                        if (element != null) {
                            Vector attrs = element.getAttributes();
                            int j = 0;
                            while (j < attrs.size()) {
                                ElementAttribute attr = (ElementAttribute)attrs.elementAt(j);
                                if (attr.getDefaultValue() != null) {
                                    refNode.setAttrValue(attr.getAttrID(), attr.getDefaultValue());
                                }
                                ++j;
                            }
                        }
                        pNode.add(refNode);
                        RefDataWrapper refDataWrapper = new RefDataWrapper(node, refNode, element);
                        refDataWrapper.setWrapperOwner(this);
                        item.setData((Object)refDataWrapper);
                        refDataWrapper.setTableTreeItem(item);
                        this.addDataElement(item, node, refNode);
                    }
                }
                ++i;
            }
        }
    }

    private void deleteDataField() {
        TableTreeItem[] selects = this.tableTree.getSelection();
        if (selects.length == 0) {
            return;
        }
        int i = 0;
        while (i < selects.length) {
            block7: {
                TableTreeItem item;
                block6: {
                    RefDataWrapper wrapper;
                    block5: {
                        item = selects[i];
                        wrapper = (RefDataWrapper)item.getData();
                        TableTreeItem parent = item.getParentItem();
                        if (parent == null) break block5;
                        RefDataWrapper aWrapper = (RefDataWrapper)parent.getData();
                        aWrapper.getRefDataNode().remove(wrapper.getRefDataNode());
                        break block6;
                    }
                    if (wrapper.getRefDataNode() == this.dataNode) break block7;
                    this.dataNode.remove(wrapper.getRefDataNode());
                }
                item.dispose();
            }
            ++i;
        }
    }

    private void addDataElement(TableTreeItem item, XMLNode node, XMLNode refNode) {
        Vector childs = node.getChilds();
        if (childs == null || childs.size() == 0) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                TableTreeItem aItem = new TableTreeItem(item, 0);
                String id = aNode.getAttrValue("id");
                if (id == null) {
                    id = aNode.getAttrValue("refId");
                }
                XMLNode dataNode = this.dataDictionary.findChildNode(id);
                aItem.setText(id);
                if (dataNode.getAttrValue("label") != null) {
                    aItem.setText(1, dataNode.getAttrValue("label"));
                }
                if (dataNode.getAttrValue("desc") != null) {
                    aItem.setText(2, dataNode.getAttrValue("desc"));
                }
                XMLNode aRefNode = new XMLNode();
                if (!aNode.getNodeName().equals("dataCollection")) {
                    aRefNode.setNodeName("refData");
                } else {
                    aRefNode.setNodeName("refColl");
                }
                aRefNode.setAttrValue("refId", id);
                refNode.add(aRefNode);
                RefDataWrapper refDataWrapper = new RefDataWrapper(aNode, aRefNode, this.element);
                refDataWrapper.setWrapperOwner(this);
                aItem.setData((Object)refDataWrapper);
                refDataWrapper.setTableTreeItem(aItem);
                this.addDataElement(aItem, aNode, aRefNode);
            }
            ++i;
        }
    }

    private void setActivateDataItem() {
        TableTreeItem[] selects = this.tableTree.getSelection();
        if (selects.length != 1) {
            return;
        }
        RefDataWrapper wrapper = (RefDataWrapper)selects[0].getData();
        this.editorBeanPropertyPanel.showWrapperProperties(wrapper);
    }

    private Vector selectData() {
        DataDictionarySelectDialog dlg = new DataDictionarySelectDialog(this.getShell(), 0);
        dlg.setDataDictionary(this.dataDictionary);
        dlg.setProfile(this.dataDictProfile);
        Vector result = (Vector)dlg.open();
        return result;
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    private XMLNode getDataNode(String refId) {
        int idx = refId.lastIndexOf(46);
        if (idx != -1) {
            return this.dataDictionary.findChildNode(refId.substring(idx + 1));
        }
        return this.dataDictionary.findChildNode(refId);
    }

    public XMLNode getDataDictionary() {
        return this.dataDictionary;
    }

    public XMLNode getChannelSettings() {
        return null;
    }

    public EditorProfile getDataEditorProfile() {
        return null;
    }

    public XMLNode getCommonServiceNode() {
        return null;
    }

    public XMLNode getSelfDefineNode() {
        return null;
    }

    public XMLNode getExternResource() {
        return null;
    }

    public XMLNode getDataType() {
        return null;
    }

    public XMLNode getDataTypeDef() {
        return null;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setDataDictionaryEditorProfile(EditorProfile profile) {
        this.dataDictProfile = profile;
    }
}

