/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualmvc;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualmvc.MVCVisualPanel;
import com.ecc.ide.editor.visualmvc.RefFileWizardPage;
import com.ecc.ide.editor.wizard.ECCIDEWizard;
import com.ecc.ide.plugin.views.PrjNodeSelectDialog;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;

public class NewFlowWizard
extends ECCIDEWizard {
    private RefFileWizardPage definePage;

    public void addPages() {
        String mvcFileName = ((MVCVisualPanel)this.editor).mvcFileName;
        String projectId = this.rootPath.substring(this.rootPath.lastIndexOf("/") + 1, this.rootPath.length());
        IProject project = IDEContent.getProject(projectId);
        String bizGroupId = IDEContent.getBizGroupIdFromMVCFile(project, mvcFileName);
        IFolder folder = project.getFolder("designFiles/bizs/" + bizGroupId);
        this.definePage = new RefFileWizardPage("Reference an new EMP Flow ", "Reference a new EMP Flow ", null, folder, "biz");
        this.addPage((IWizardPage)this.definePage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return null;
    }

    public XMLNode getXMLNode() {
        this.project = ((MVCVisualPanel)this.editor).getProject();
        String bizGroupId = IDEContent.getBizGroupIdFromMVCFile(this.project, ((MVCVisualPanel)this.editor).mvcFileName);
        IFolder folder = this.project.getFolder("designFiles/bizs/" + bizGroupId);
        PrjNodeSelectDialog dialog = new PrjNodeSelectDialog(this.getShell(), folder);
        dialog.setSelectTypes(new String[]{"biz"});
        int result = dialog.open();
        if (result == 1) {
            return null;
        }
        PrjViewXMLNode node = dialog.getResult();
        IFile file = (IFile)node.obj;
        XMLNode mtxNode = this.loadXMLFile(file);
        String trxCode = mtxNode.getAttrValue("trxCode");
        String fileName = file.getLocation().toOSString();
        String temp = "designFiles\\bizs\\" + bizGroupId + "\\";
        fileName = fileName.substring(fileName.indexOf(temp) + temp.length(), fileName.length());
        String opName = node.selectBizOp;
        if (opName == null || opName.trim().length() == 0) {
            opName = trxCode;
        }
        this.xmlContentNode.setAttrValue("id", trxCode);
        this.xmlContentNode.setAttrValue("refId", opName);
        this.xmlContentNode.setAttrValue("fileName", fileName);
        return this.xmlContentNode;
    }

    public boolean performFinish() {
        PrjViewXMLNode node = this.definePage.getResult();
        if (!".biz".equals(node.getNodeName())) {
            return false;
        }
        if (node != null) {
            IFile file = (IFile)node.obj;
            String opName = file.getName();
            opName = opName.substring(0, opName.lastIndexOf("."));
            String fileName = file.getLocation().toOSString();
            fileName = fileName.substring(fileName.indexOf("designFiles"), fileName.length());
            this.xmlContentNode.setAttrValue("id", opName);
            this.xmlContentNode.setAttrValue("flowId", opName);
            this.xmlContentNode.setAttrValue("flowName", opName);
            this.xmlContentNode.setAttrValue("refId", opName);
            this.xmlContentNode.setAttrValue("fileName", fileName);
            return true;
        }
        return false;
    }

    public boolean isSelfWizard() {
        return true;
    }

    private XMLNode loadXMLFile(IFile file) {
        try {
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode node = (XMLNode)xmlLoader.loadXMLFile(file.getLocation().toOSString());
            return node;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

