/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualmvc;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLNode;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewJSPWizardPage
extends WizardPage {
    private Text divIdText;
    private Text encodingText;
    private Text subDirText;
    private Text jspFileNameText;
    private XMLNode xmlContent;
    private boolean toBeLayout = true;
    private String jspType = "html";
    private IProject project;
    private String subDir;

    public NewJSPWizardPage(String pageName) {
        super(pageName);
        this.setTitle("EMP Application");
        this.setDescription("\u6b64\u5411\u5bfc\u5c06\u521b\u5efa\u4e00\u4e2a\u4ee5 *.jsp \u4e3a\u540e\u7f00\u7684EMP\u8868\u73b0\u9875\u9762\u6587\u4ef6\uff0c\u5b83\u53ef\u4ee5\u7531EMP JSP\u7f16\u8f91\u5668\u8fdb\u884c\u53ef\u89c6\u7f16\u8f91.");
    }

    public NewJSPWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        this.setControl((Control)container);
        Label jspFilenameLabel = new Label(container, 0);
        jspFilenameLabel.setText("JSP FileName:");
        this.jspFileNameText = new Text(container, 2048);
        GridData gridData = new GridData(1, 2, true, false, 2, 1);
        gridData.widthHint = 240;
        this.jspFileNameText.setLayoutData((Object)gridData);
        Label subDirectoryLabel = new Label(container, 0);
        subDirectoryLabel.setText("Sub Directory:");
        this.subDirText = new Text(container, 2048);
        this.subDirText.setEnabled(false);
        GridData gridData_1 = new GridData(1, 2, true, false, 2, 1);
        gridData_1.widthHint = 170;
        this.subDirText.setLayoutData((Object)gridData_1);
        if (this.subDir != null && this.subDir.length() != 0) {
            this.subDirText.setText(String.valueOf(this.subDir));
        }
        Label pageEncodingLabel = new Label(container, 0);
        pageEncodingLabel.setText("page encoding:");
        this.encodingText = new Text(container, 2048);
        GridData gridData_3 = new GridData(1, 2, true, false, 2, 1);
        gridData_3.widthHint = 102;
        this.encodingText.setLayoutData((Object)gridData_3);
        this.setEncodingText();
        final Button htmlJspButton = new Button(container, 16);
        htmlJspButton.setSelection(true);
        htmlJspButton.setText("Html JSP");
        final Button wmlJspButton = new Button(container, 16);
        wmlJspButton.setEnabled(false);
        wmlJspButton.setText("WML JSP");
        Button kjavaJspButton = new Button(container, 16);
        kjavaJspButton.setEnabled(false);
        kjavaJspButton.setText("KJava JSP");
        final Button toBeLayoutButton = new Button(container, 32);
        toBeLayoutButton.setSelection(true);
        toBeLayoutButton.setLayoutData((Object)new GridData());
        toBeLayoutButton.setText("To be Layout content");
        toBeLayoutButton.setVisible(false);
        final Label contentDivIdLabel = new Label(container, 0);
        contentDivIdLabel.setLayoutData((Object)new GridData());
        contentDivIdLabel.setText("Content Div ID");
        contentDivIdLabel.setVisible(false);
        this.divIdText = new Text(container, 2048);
        GridData gridData_2 = new GridData(1, 2, true, false);
        gridData_2.widthHint = 111;
        this.divIdText.setLayoutData((Object)gridData_2);
        this.divIdText.setVisible(false);
        htmlJspButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (htmlJspButton.getSelection()) {
                    NewJSPWizardPage.this.jspType = "html";
                    toBeLayoutButton.setVisible(true);
                    if (toBeLayoutButton.getSelection()) {
                        contentDivIdLabel.setVisible(true);
                        NewJSPWizardPage.this.divIdText.setVisible(true);
                    } else {
                        contentDivIdLabel.setVisible(false);
                        NewJSPWizardPage.this.divIdText.setVisible(false);
                    }
                } else {
                    toBeLayoutButton.setVisible(false);
                    contentDivIdLabel.setVisible(false);
                    NewJSPWizardPage.this.divIdText.setVisible(false);
                }
            }
        });
        wmlJspButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (wmlJspButton.getSelection()) {
                    NewJSPWizardPage.this.jspType = "wml";
                    toBeLayoutButton.setVisible(false);
                    contentDivIdLabel.setVisible(false);
                    NewJSPWizardPage.this.divIdText.setVisible(false);
                }
            }
        });
        kjavaJspButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewJSPWizardPage.this.jspType = "kjava";
                toBeLayoutButton.setVisible(false);
                contentDivIdLabel.setVisible(false);
                NewJSPWizardPage.this.divIdText.setVisible(false);
            }
        });
        toBeLayoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (toBeLayoutButton.getSelection()) {
                    contentDivIdLabel.setVisible(true);
                    NewJSPWizardPage.this.divIdText.setVisible(true);
                } else {
                    contentDivIdLabel.setVisible(false);
                    NewJSPWizardPage.this.divIdText.setVisible(false);
                }
            }
        });
    }

    private void setEncodingText() {
        try {
            XMLNode prjSettingNode = IDEContent.getSettingNode(this.project, 35);
            String jspEncode = prjSettingNode.findChild("properties").findChildNode("property", "JSPEncode").getAttrValue("value");
            this.encodingText.setText(String.valueOf(jspEncode));
        }
        catch (Exception e) {
            this.encodingText.setText(System.getProperty("file.encoding"));
            e.printStackTrace();
        }
    }

    public void dispose() {
        super.dispose();
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void setXMLContent(XMLNode node) {
        this.xmlContent = node;
    }

    public boolean setValueToXMLNode(XMLNode node) {
        String subDir_1;
        String jspFileName = this.jspFileNameText.getText();
        if (jspFileName.length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)"error", (String)"Please input proper fileName!");
            return false;
        }
        if (!jspFileName.endsWith(".jsp")) {
            jspFileName = String.valueOf(jspFileName) + ".jsp";
        }
        if ((subDir_1 = this.subDirText.getText()) != null && subDir_1.length() != 0) {
            jspFileName = String.valueOf(subDir_1) + "/" + jspFileName;
        }
        node.setAttrValue("fileName", jspFileName);
        node.setAttrValue("jspType", this.jspType);
        node.setAttrValue("toBeLayout", String.valueOf(this.toBeLayout));
        node.setAttrValue("divId", this.divIdText.getText());
        node.setAttrValue("encoding", this.encodingText.getText());
        return true;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public String getJspFileName() {
        String jspFileName = this.jspFileNameText.getText();
        if (!jspFileName.endsWith(".jsp")) {
            jspFileName = String.valueOf(jspFileName) + ".jsp";
        }
        return jspFileName;
    }

    public void setSubDir(String subDir) {
        this.subDir = subDir;
    }
}

