/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.visualmvc;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.PropertyEditorSuport;
import com.ecc.ide.editor.Wrapper;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualmvc.MVCVisualPanel;
import com.ecc.ide.plugin.views.PrjViewTreePanel;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class PrjNodeSelectPropertyEditor
extends PropertyEditorSuport {
    public static final String TYPE_FLOW = "flow";
    public static final String TYPE_VIEW = "view";
    public static final String TYPE_BIZ = "biz";
    public static final String TYPE_JSP = "jsp";
    public static final String TYPE_GRD = "grd";
    public static final String TYPE_HTM = "htm";
    public static final String TYPE_HTML = "html";
    private PrjViewTreePanel treePanel = null;
    private List operationList = null;
    private String selectType = null;
    private String grpId = null;
    private IFolder rootObject = null;
    private XMLNode editingNode = null;

    public boolean isCustomEditor() {
        return true;
    }

    public Composite getCustomEditor(Composite parent) {
        Wrapper wrapper = this.getEditingWrapper();
        if (wrapper == null || wrapper.getWrapperOwner() == null) {
            return null;
        }
        this.editingNode = (XMLNode)wrapper.getWrappedObject();
        this.selectType = this.editingNode.getNodeName();
        MVCVisualPanel mvcPanel = (MVCVisualPanel)wrapper.getWrapperOwner();
        IProject project = mvcPanel.getProject();
        SashForm sashForm = new SashForm(parent, 0);
        sashForm.setLayout((Layout)new GridLayout(2, true));
        this.treePanel = new PrjViewTreePanel((Composite)sashForm, 0, false);
        this.treePanel.setLayoutData(new GridData(1808));
        if (TYPE_FLOW.equalsIgnoreCase(this.selectType)) {
            this.grpId = IDEContent.getBizGroupIdFromMVCFile(project, mvcPanel.mvcFileName);
            this.rootObject = project.getFolder("designFiles/bizs/" + this.grpId);
            this.treePanel.addNodeFilter(new String[]{TYPE_BIZ});
        } else {
            this.grpId = IDEContent.getGroupId(mvcPanel.mvcFileName);
            this.rootObject = project.getFolder("designFiles/mvcs/" + this.grpId);
            this.treePanel.addNodeFilter(new String[]{TYPE_JSP, TYPE_GRD, TYPE_HTM, TYPE_HTML});
        }
        this.treePanel.setInput(this.rootObject);
        this.operationList = new List((Composite)sashForm, 2564);
        this.operationList.setLayoutData((Object)new GridData(1808));
        this.treePanel.getTreeViewer().getTree().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)PrjNodeSelectPropertyEditor.this.treePanel.getTreeViewer().getSelection();
                PrjViewXMLNode selectNode = (PrjViewXMLNode)selection.getFirstElement();
                IResource resource = (IResource)selectNode.obj;
                try {
                    PrjNodeSelectPropertyEditor.this.operationList.removeAll();
                    PrjNodeSelectPropertyEditor.this.operationList.setItems(PrjNodeSelectPropertyEditor.this.getOperationList(resource));
                    PrjNodeSelectPropertyEditor.this.operationList.setSelection(0);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        });
        if (TYPE_FLOW.equalsIgnoreCase(this.selectType)) {
            sashForm.setWeights(new int[]{1, 1});
        } else {
            sashForm.setWeights(new int[]{1, 1});
        }
        return sashForm;
    }

    private String[] getOperationList(IResource resource) {
        ArrayList<String> opList = new ArrayList<String>();
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (!TYPE_BIZ.endsWith(file.getFileExtension())) {
                return null;
            }
            try {
                XMLNode bizNode = this.loadXMLFile(file);
                int i = 0;
                while (i < bizNode.getChilds().size()) {
                    XMLNode opNode = (XMLNode)bizNode.getChilds().elementAt(i);
                    if ("operation".equalsIgnoreCase(opNode.getNodeName())) {
                        opList.add(opNode.getAttrValue("id"));
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return opList.toArray(new String[0]);
    }

    public Object getValue() {
        IStructuredSelection selection = (IStructuredSelection)this.treePanel.getTreeViewer().getSelection();
        PrjViewXMLNode result = (PrjViewXMLNode)selection.getFirstElement();
        IFile file = null;
        String filePath = null;
        try {
            file = (IFile)result.obj;
            filePath = file.getProjectRelativePath().toString();
            filePath = filePath.substring(this.rootObject.getProjectRelativePath().toString().length() + 1);
        }
        catch (Exception e) {
            return super.getValue();
        }
        if (TYPE_BIZ.equalsIgnoreCase(result.getNodeName())) {
            String[] selectOp = this.operationList.getSelection();
            if (selectOp != null && selectOp.length != 0 && TYPE_FLOW.equalsIgnoreCase(this.editingNode.getNodeName())) {
                this.editingNode.setAttrValue("fileName", filePath);
                XMLNode bizNode = this.loadXMLFile(file);
                if (bizNode != null) {
                    this.editingNode.setAttrValue("id", bizNode.getAttrValue("trxCode"));
                }
                return selectOp[0];
            }
        } else if (TYPE_JSP.equalsIgnoreCase(result.getNodeName()) || TYPE_GRD.equalsIgnoreCase(result.getNodeName()) || TYPE_HTM.equalsIgnoreCase(result.getNodeName()) || TYPE_HTML.equalsIgnoreCase(result.getNodeName())) {
            return filePath;
        }
        return super.getValue();
    }

    private XMLNode loadXMLFile(IFile file) {
        XMLLoader xmlLoader = new XMLLoader();
        xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
        XMLNode node = null;
        try {
            node = (XMLNode)xmlLoader.loadXMLFile(file.getLocation().toOSString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return node;
    }
}

