/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import java.sql.Driver;
import java.sql.DriverManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DBConnectionDialog
extends Dialog {
    private Shell shell;
    private Group dbConnectionPanel;
    private Combo driverTypeCombo;
    private Text passwordText;
    private Text userNameText;
    private Text dbURLText;
    private Text jdbcDriverText;
    private XMLNode dbAccessNode;

    public DBConnectionDialog(Shell parent, int style) {
        super(parent, style);
    }

    public void open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67696);
        this.shell.setLayout((Layout)new GridLayout());
        this.shell.setText("\u6570\u636e\u5e93\u8fde\u63a5");
        this.shell.setSize(400, 300);
        this.creatDialogPanel();
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(128));
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Button button = new Button(composite, 0);
        GridData gridData = new GridData(128);
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBConnectionDialog.this.performOk();
                DBConnectionDialog.this.shell.dispose();
            }
        });
        button.setText("\u786e\u5b9a");
        Button button_1 = new Button(composite, 0);
        GridData gridData_1 = new GridData(128);
        gridData_1.widthHint = 80;
        button_1.setLayoutData((Object)gridData_1);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBConnectionDialog.this.shell.dispose();
            }
        });
        button_1.setText("\u53d6\u6d88");
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void creatDialogPanel() {
        String propertyValue;
        this.dbConnectionPanel = new Group((Composite)this.shell, 0);
        this.dbConnectionPanel.setText("\u6570\u636e\u5e93\u8fde\u63a5");
        this.dbConnectionPanel.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.dbConnectionPanel.setLayout((Layout)layout);
        layout.verticalSpacing = 5;
        Label label_4 = new Label((Composite)this.dbConnectionPanel, 0);
        label_4.setText(Messages.getString("DBConnectionPage.DriverType__1"));
        this.driverTypeCombo = new Combo((Composite)this.dbConnectionPanel, 0);
        this.driverTypeCombo.add("DB2 Native JDBC Driver");
        this.driverTypeCombo.add("DB2 Remote JDBC Driver");
        this.driverTypeCombo.add("Oracle JDBC Driver");
        this.driverTypeCombo.add("AS400 toolBox Driver");
        this.driverTypeCombo.add("Sybase JDBC Driver");
        this.driverTypeCombo.add("sourceforge JDBC Driver");
        this.driverTypeCombo.add("Microsoft SQLServer JDBC Driver");
        this.driverTypeCombo.add("ODBC JDBC Driver");
        this.driverTypeCombo.add("MySQL JDBC Driver");
        this.driverTypeCombo.add("PostgreSQL JDBC Driver");
        this.driverTypeCombo.add("Informix JDBC Driver");
        XMLNode propertyNode = this.dbAccessNode.findChild("driverType");
        if (propertyNode != null && (propertyValue = propertyNode.getChild("#text").getTextValue()) != null && propertyValue.trim().length() != 0) {
            this.driverTypeCombo.setText(propertyValue);
        }
        this.driverTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBConnectionDialog.this.setDriverType();
            }
        });
        GridData gridData_5 = new GridData();
        gridData_5.horizontalSpan = 3;
        this.driverTypeCombo.setLayoutData((Object)gridData_5);
        Label label = new Label((Composite)this.dbConnectionPanel, 0);
        label.setText(Messages.getString("DBConnectionPage.JDBC_Driver__1"));
        this.jdbcDriverText = new Text((Composite)this.dbConnectionPanel, 2048);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.jdbcDriverText.setLayoutData((Object)gridData);
        this.setText("driverName", this.jdbcDriverText);
        Label label_1 = new Label((Composite)this.dbConnectionPanel, 0);
        label_1.setText(Messages.getString("DBConnectionPage.DB_URL__3"));
        this.dbURLText = new Text((Composite)this.dbConnectionPanel, 2048);
        GridData gridData_1 = new GridData(768);
        gridData_1.horizontalSpan = 3;
        this.dbURLText.setLayoutData((Object)gridData_1);
        this.setText("dbURL", this.dbURLText);
        Label label_2 = new Label((Composite)this.dbConnectionPanel, 0);
        label_2.setText(Messages.getString("DBConnectionPage.UserName__5"));
        this.userNameText = new Text((Composite)this.dbConnectionPanel, 2048);
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 103;
        this.userNameText.setLayoutData((Object)gridData_2);
        this.setText("userName", this.userNameText);
        Label label_3 = new Label((Composite)this.dbConnectionPanel, 0);
        label_3.setText(Messages.getString("DBConnectionPage.Password__7"));
        this.passwordText = new Text((Composite)this.dbConnectionPanel, 2048);
        this.passwordText.setEchoChar('*');
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 119;
        this.passwordText.setLayoutData((Object)gridData_3);
        this.setText("password", this.passwordText);
        Button button = new Button((Composite)this.dbConnectionPanel, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBConnectionDialog.this.testDBConnection();
            }
        });
        GridData gridData_4 = new GridData(128);
        gridData_4.widthHint = 79;
        gridData_4.horizontalSpan = 4;
        button.setLayoutData((Object)gridData_4);
        button.setText(Messages.getString("DBConnectionPage.Connect_8"));
    }

    public void setDBAccessNode(XMLNode node) {
        this.dbAccessNode = node;
    }

    private void setText(String propertyName, Text text) {
        String propertyValue;
        XMLNode propertyNode = this.dbAccessNode.findChild(propertyName);
        if (propertyNode != null && (propertyValue = propertyNode.getChild("#text").getTextValue()) != null && propertyValue.trim().length() != 0) {
            text.setText(propertyValue);
        }
    }

    public void performOk() {
        XMLNode propertyNode = this.dbAccessNode.findChild("driverType");
        if (propertyNode == null) {
            propertyNode = new XMLNode("driverType");
            this.dbAccessNode.add(propertyNode);
        }
        String propertyValue = this.driverTypeCombo.getText();
        propertyNode.removeAllChilds();
        if (propertyValue != null && propertyValue.trim().length() != 0) {
            XMLNode textNode = new XMLNode("#text");
            textNode.setTextValue(propertyValue);
            propertyNode.add(textNode);
        }
        this.setDBProperty("driverName", this.jdbcDriverText);
        this.setDBProperty("dbURL", this.dbURLText);
        this.setDBProperty("userName", this.userNameText);
        this.setDBProperty("password", this.passwordText);
    }

    private void setDBProperty(String propertyName, Text text) {
        XMLNode propertyNode = this.dbAccessNode.findChild(propertyName);
        if (propertyNode == null) {
            propertyNode = new XMLNode(propertyName);
            this.dbAccessNode.add(propertyNode);
        }
        String propertyValue = text.getText();
        propertyNode.removeAllChilds();
        if (propertyValue != null && propertyValue.trim().length() != 0) {
            XMLNode textNode = new XMLNode("#text");
            textNode.setTextValue(propertyValue);
            propertyNode.add(textNode);
        }
    }

    private void testDBConnection() {
        try {
            String driverName = this.jdbcDriverText.getText();
            String dbURL = this.dbURLText.getText();
            String userId = this.userNameText.getText();
            String password = this.passwordText.getText();
            Class<?> aclass = Class.forName(driverName);
            Driver driver = (Driver)aclass.newInstance();
            DriverManager.registerDriver(driver);
            DriverManager.getConnection(dbURL, userId, password);
            MessageDialog.openInformation((Shell)this.shell, (String)"DB connection test", (String)"Connection testing succeed!");
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.shell, (String)Messages.getString("DBConnectionPage.Error_9"), (String)(String.valueOf(Messages.getString("DBConnectionPage.Connect_to_Database_failed_!_nException__n_10")) + e));
        }
    }

    private void setDriverType() {
        int idx = this.driverTypeCombo.getSelectionIndex();
        if (idx == 0) {
            this.jdbcDriverText.setText("COM.ibm.db2.jdbc.app.DB2Driver");
            this.dbURLText.setText("jdbc:db2:demo");
        } else if (idx == 1) {
            this.jdbcDriverText.setText("com.ibm.db2.jcc.DB2Driver");
            this.dbURLText.setText("jdbc:db2://127.0.0.1:50000/demo");
        } else if (idx == 2) {
            this.jdbcDriverText.setText("oracle.jdbc.driver.OracleDriver");
            this.dbURLText.setText("jdbc:oracle:thin:@MyDbComputerNameOrIP:1521:ORCL");
        } else if (idx == 3) {
            this.jdbcDriverText.setText("com.ibm.as400.access.AS400JDBCDriver");
            this.dbURLText.setText("jdbc:as400://127.0.0.1/demo");
        } else if (idx == 4) {
            this.jdbcDriverText.setText("com.sybase.jdbc2.jdbc.SybDriver");
            this.dbURLText.setText("jdbc:sybase:Tds:MyDbComputerNameOrIP:2638");
        } else if (idx == 5) {
            this.jdbcDriverText.setText("net.sourceforge.jtds.jdbc.Driver");
            this.dbURLText.setText("jdbc:jtds:sqlserver://MyDbComputerNameOrIP:1433/master");
        } else if (idx == 6) {
            this.jdbcDriverText.setText("com.microsoft.jdbc.sqlserver.SQLServerDriver");
            this.dbURLText.setText("jdbc:microsoft:sqlserver://MyDbComputerNameOrIP:1433;databaseName=master");
        } else if (idx == 7) {
            this.jdbcDriverText.setText("sun.jdbc.odbc.JdbcOdbcDriver");
            this.dbURLText.setText("jdbc:odbc:sDsn");
        } else if (idx == 8) {
            this.jdbcDriverText.setText("org.gjt.mm.mysql.Driver");
            this.dbURLText.setText("jdbc:mysql://MyDbComputerNameOrIP:3306/myDatabaseName");
        } else if (idx == 9) {
            this.jdbcDriverText.setText("org.postgresql.Driver");
            this.dbURLText.setText("jdbc:postgresql://MyDbComputerNameOrIP/myDatabaseName");
        } else if (idx == 10) {
            this.jdbcDriverText.setText("com.informix.jdbc.IfxDriver");
            this.dbURLText.setText("jdbc:informix-sqli://MyDbComputerNameOrIP:6668/myDatabaseName");
        }
    }
}

