/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc;

import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DBConnectionPage
extends WizardPage {
    private Combo driverTypeCombo;
    private Connection connection;
    private Text passwordText;
    private Text userNameText;
    private Text dbURLText;
    private Text jdbcDriverText;
    private String rootPath;
    private XMLNode settingsNode;
    private XMLNode drvTypeNode;
    private XMLNode dbURLNode;
    private XMLNode userNameNode;
    private XMLNode passNode;
    private XMLNode driverNameNode;
    private boolean isOk = false;

    public DBConnectionPage(String pageName) {
        super(pageName);
    }

    public DBConnectionPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void setRootPath(String value) {
        this.rootPath = value;
        this.settingsNode = IDEConstance.getProjectSettings(value);
        if (this.settingsNode == null) {
            return;
        }
        XMLNode dbAccessNode = this.settingsNode.findChild("dbAccess");
        if (dbAccessNode == null) {
            dbAccessNode = new XMLNode("dbAccess");
            this.settingsNode.add(dbAccessNode);
            this.drvTypeNode = new XMLNode("driverType");
            this.drvTypeNode.setAttrValue("nodeValue", "DB2 Native JDBC Driver");
            dbAccessNode.add(this.drvTypeNode);
            this.driverNameNode = new XMLNode("driverName");
            this.driverNameNode.setAttrValue("nodeValue", "COM.ibm.db2.jdbc.app.DB2Driver");
            dbAccessNode.add(this.driverNameNode);
            this.dbURLNode = new XMLNode("dbURL");
            this.dbURLNode.setAttrValue("nodeValue", "jdbc:db2:demo");
            dbAccessNode.add(this.dbURLNode);
            this.userNameNode = new XMLNode("userName");
            this.userNameNode.setAttrValue("nodeValue", "db2admin");
            dbAccessNode.add(this.userNameNode);
            this.passNode = new XMLNode("password");
            this.passNode.setAttrValue("nodeValue", "db2admin");
            dbAccessNode.add(this.passNode);
        } else {
            this.drvTypeNode = dbAccessNode.getChild("driverType");
            this.dbURLNode = dbAccessNode.getChild("dbURL");
            this.userNameNode = dbAccessNode.getChild("userName");
            this.passNode = dbAccessNode.getChild("password");
            this.driverNameNode = dbAccessNode.getChild("driverName");
            if (this.driverNameNode == null) {
                this.driverNameNode = new XMLNode("driverName");
                this.driverNameNode.setAttrValue("nodeValue", "COM.ibm.db2.jdbc.app.DB2Driver");
                dbAccessNode.add(this.driverNameNode);
            }
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        container.setLayout((Layout)layout);
        layout.verticalSpacing = 9;
        Label label_4 = new Label(container, 0);
        label_4.setText(Messages.getString("DBConnectionPage.DriverType__1"));
        this.driverTypeCombo = new Combo(container, 0);
        this.driverTypeCombo.add("DB2 Native JDBC Driver");
        this.driverTypeCombo.add("DB2 Remote JDBC Driver");
        this.driverTypeCombo.add("Oracle JDBC Driver");
        this.driverTypeCombo.add("AS400 toolBox Driver");
        this.driverTypeCombo.add("Sybase JDBC Driver");
        this.driverTypeCombo.add("sourceforge JDBC Driver");
        this.driverTypeCombo.add("Microsoft SQLServer JDBC Driver");
        this.driverTypeCombo.add("ODBC JDBC Driver");
        this.driverTypeCombo.add("MySQL JDBC Driver");
        this.driverTypeCombo.add("PostgreSQL JDBC Driver");
        this.driverTypeCombo.select(0);
        this.driverTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBConnectionPage.this.setDriverType();
            }
        });
        GridData gridData_5 = new GridData();
        gridData_5.horizontalSpan = 3;
        this.driverTypeCombo.setLayoutData((Object)gridData_5);
        Label label = new Label(container, 0);
        label.setText(Messages.getString("DBConnectionPage.JDBC_Driver__1"));
        this.jdbcDriverText = new Text(container, 2048);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.jdbcDriverText.setLayoutData((Object)gridData);
        this.jdbcDriverText.setText("COM.ibm.db2.jdbc.app.DB2Driver");
        Label label_1 = new Label(container, 0);
        label_1.setText(Messages.getString("DBConnectionPage.DB_URL__3"));
        this.dbURLText = new Text(container, 2048);
        GridData gridData_1 = new GridData(768);
        gridData_1.horizontalSpan = 3;
        this.dbURLText.setLayoutData((Object)gridData_1);
        this.dbURLText.setText("jdbc:db2:demo");
        Label label_2 = new Label(container, 0);
        label_2.setText(Messages.getString("DBConnectionPage.UserName__5"));
        this.userNameText = new Text(container, 2048);
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 103;
        this.userNameText.setLayoutData((Object)gridData_2);
        this.userNameText.setText("db2admin");
        Label label_3 = new Label(container, 0);
        label_3.setText(Messages.getString("DBConnectionPage.Password__7"));
        this.passwordText = new Text(container, 2048);
        this.passwordText.setEchoChar('*');
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 119;
        this.passwordText.setLayoutData((Object)gridData_3);
        Button button = new Button(container, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBConnectionPage.this.connectToDataBase();
            }
        });
        GridData gridData_4 = new GridData(128);
        gridData_4.widthHint = 79;
        gridData_4.horizontalSpan = 4;
        button.setLayoutData((Object)gridData_4);
        button.setText(Messages.getString("DBConnectionPage.Connect_8"));
        this.initialize();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.drvTypeNode == null) {
            return;
        }
        this.driverTypeCombo.setText(this.drvTypeNode.getNodeValue());
        this.dbURLText.setText(this.dbURLNode.getNodeValue());
        this.userNameText.setText(this.userNameNode.getNodeValue());
        this.passwordText.setText(this.passNode.getNodeValue());
        this.jdbcDriverText.setText(this.driverNameNode.getNodeValue());
    }

    private void saveSettings() {
        if (this.drvTypeNode == null) {
            return;
        }
        String driverType = this.driverTypeCombo.getText();
        String driverName = this.jdbcDriverText.getText();
        String dbURL = this.dbURLText.getText();
        String userId = this.userNameText.getText();
        String password = this.passwordText.getText();
        this.drvTypeNode.setAttrValue("nodeValue", driverType);
        this.dbURLNode.setAttrValue("nodeValue", dbURL);
        this.userNameNode.setAttrValue("nodeValue", userId);
        this.driverNameNode.setAttrValue("nodeValue", driverName);
        this.passNode.setAttrValue("nodeValue", password);
        IDEConstance.saveProjectSettings(this.settingsNode, this.rootPath);
    }

    private void connectToDataBase() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            this.connection = null;
            this.isOk = false;
            String driverName = this.jdbcDriverText.getText();
            String dbURL = this.dbURLText.getText();
            String userId = this.userNameText.getText();
            String password = this.passwordText.getText();
            Class<?> aclass = Class.forName(driverName);
            Driver driver = (Driver)aclass.newInstance();
            DriverManager.registerDriver(driver);
            this.connection = DriverManager.getConnection(dbURL, userId, password);
            this.saveSettings();
            this.isOk = true;
            super.getWizard().getContainer().updateButtons();
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("DBConnectionPage.Error_9"), (String)(String.valueOf(Messages.getString("DBConnectionPage.Connect_to_Database_failed_!_nException__n_10")) + e));
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean canFlipToNextPage() {
        return this.isOk;
    }

    private void setDriverType() {
        int idx = this.driverTypeCombo.getSelectionIndex();
        if (idx == 0) {
            this.jdbcDriverText.setText("COM.ibm.db2.jdbc.app.DB2Driver");
            this.dbURLText.setText("jdbc:db2:demo");
        } else if (idx == 1) {
            this.jdbcDriverText.setText("COM.ibm.db2.jdbc.net.DB2Driver");
            this.dbURLText.setText("jdbc:db2://127.0.0.1/demo");
        } else if (idx == 2) {
            this.jdbcDriverText.setText("oracle.jdbc.driver.OracleDriver");
            this.dbURLText.setText("jdbc:oracle:thin:@MyDbComputerNameOrIP:1521:ORCL");
        } else if (idx == 3) {
            this.jdbcDriverText.setText("com.ibm.as400.access.AS400JDBCDriver");
            this.dbURLText.setText("jdbc:as400://127.0.0.1/demo");
        } else if (idx == 4) {
            this.jdbcDriverText.setText("com.sybase.jdbc2.jdbc.SybDriver");
            this.dbURLText.setText("jdbc:sybase:Tds:MyDbComputerNameOrIP:2638");
        } else if (idx == 5) {
            this.jdbcDriverText.setText("net.sourceforge.jtds.jdbc.Driver");
            this.dbURLText.setText("jdbc:jtds:sqlserver://MyDbComputerNameOrIP:1433/master");
        } else if (idx == 6) {
            this.jdbcDriverText.setText("com.microsoft.jdbc.sqlserver.SQLServerDriver");
            this.dbURLText.setText("jdbc:microsoft:sqlserver://MyDbComputerNameOrIP:1433;databaseName=master");
        } else if (idx == 7) {
            this.jdbcDriverText.setText("sun.jdbc.odbc.JdbcOdbcDriver");
            this.dbURLText.setText("jdbc:odbc:sDsn");
        } else if (idx == 8) {
            this.jdbcDriverText.setText("org.gjt.mm.mysql.Driver");
            this.dbURLText.setText("jdbc:mysql://MyDbComputerNameOrIP:3306/myDatabaseName");
        } else if (idx == 9) {
            this.jdbcDriverText.setText("org.postgresql.Driver");
            this.dbURLText.setText("jdbc:postgresql://MyDbComputerNameOrIP/myDatabaseName");
        }
    }

    public XMLNode getXMLNode() {
        return this.settingsNode;
    }
}

