/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.DataDictionarySelectDialog;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import com.ecc.ide.editor.wizard.jdbc.TableColumnInfo;
import com.ecc.ide.editor.wizard.jdbc.TableInfo;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DataMapPage
extends WizardPage {
    private Text iCollNameText;
    private Table tableInfoTable;
    private Button iCollButton;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;
    private int accessMode = 0;
    private boolean isCanFinish = false;

    public DataMapPage(String pageName) {
        super(pageName);
    }

    public DataMapPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        layout.verticalSpacing = 9;
        this.setControl((Control)container);
        Label label = new Label(container, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("DataMapPage.Selected_Table_Info_1"));
        this.tableInfoTable = new Table(container, 67616);
        this.tableInfoTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                DataMapPage.this.getContainer().updateButtons();
            }

            public void mouseDoubleClick(MouseEvent e) {
                DataMapPage.this.mapColumnToData();
            }
        });
        GridData gridData_1 = new GridData(1808);
        gridData_1.horizontalSpan = 2;
        this.tableInfoTable.setLayoutData((Object)gridData_1);
        this.tableInfoTable.setLinesVisible(true);
        this.tableInfoTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.tableInfoTable, 0);
        tableColumn.setWidth(100);
        tableColumn.setText(Messages.getString("DataMapPage.ColumnName_2"));
        TableColumn tableColumn_6 = new TableColumn(this.tableInfoTable, 0);
        tableColumn_6.setWidth(100);
        tableColumn_6.setText(Messages.getString("DataMapPage.Data_Name_3"));
        TableColumn tableColumn_1 = new TableColumn(this.tableInfoTable, 0);
        tableColumn_1.setWidth(78);
        tableColumn_1.setText(Messages.getString("DataMapPage.ColumnType_4"));
        TableColumn tableColumn_2 = new TableColumn(this.tableInfoTable, 0);
        tableColumn_2.setWidth(100);
        tableColumn_2.setText(Messages.getString("DataMapPage.Length_5"));
        TableColumn tableColumn_3 = new TableColumn(this.tableInfoTable, 0);
        tableColumn_3.setWidth(100);
        tableColumn_3.setText(Messages.getString("DataMapPage.New_Maped_dataName_6"));
        Composite composite = new Composite(container, 0);
        GridData gridData_4 = new GridData(768);
        gridData_4.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData_4);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite.setLayout((Layout)gridLayout);
        Button button = new Button(composite, 0);
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 100;
        button.setLayoutData((Object)gridData_2);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataMapPage.this.createNewData();
            }
        });
        button.setText(Messages.getString("DataMapPage.Create_new_data_7"));
        Button button_1 = new Button(composite, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataMapPage.this.mapColumnToData();
            }
        });
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 100;
        button_1.setLayoutData((Object)gridData_3);
        button_1.setText(Messages.getString("DataMapPage.Map_The_Data_8"));
        Composite composite_1 = new Composite(container, 0);
        GridData gridData_5 = new GridData(768);
        gridData_5.horizontalSpan = 2;
        composite_1.setLayoutData((Object)gridData_5);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        composite_1.setLayout((Layout)gridLayout_1);
        Label label_1 = new Label(composite_1, 0);
        label_1.setText(Messages.getString("DataMapPage.iCollName__9"));
        this.iCollNameText = new Text(composite_1, 2048);
        this.iCollNameText.setLayoutData((Object)new GridData(768));
        this.iCollButton = new Button(composite_1, 0);
        this.iCollButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataMapPage.this.selectICollName();
            }
        });
        this.iCollButton.setText(Messages.getString("DataMapPage.>>_10"));
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.loadTableInfo(tableInfo);
        this.isCanFinish = true;
    }

    public void setTableInfos(TableInfo[] infos) {
        this.loadTableInfo(infos);
        this.isCanFinish = true;
        super.getWizard().getContainer().updateButtons();
    }

    private void loadTableInfo(TableInfo tableInfo) {
        try {
            this.tableInfoTable.removeAll();
            int i = 0;
            while (i < tableInfo.columns.size()) {
                TableColumnInfo column = (TableColumnInfo)tableInfo.columns.elementAt(i);
                TableItem item = new TableItem(this.tableInfoTable, 0);
                if (column.isSelected) {
                    item.setChecked(true);
                }
                item.setText(column.columnName);
                if (column.dataName != null) {
                    item.setText(1, column.dataName);
                } else {
                    String dataName = this.getDataName(column.columnName, tableInfo.tableName);
                    if (dataName != null) {
                        item.setText(1, dataName);
                        column.dataName = dataName;
                    }
                }
                item.setText(2, column.columnTypeName);
                item.setText(3, String.valueOf(column.precision));
                item.setData((Object)column);
                ++i;
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("DataMapPage.Error_11"), (String)(String.valueOf(Messages.getString("DataMapPage.Access_Database_failed_!_nException__n_12")) + e));
            e.printStackTrace();
        }
    }

    private void loadTableInfo(TableInfo[] tableInfos) {
        try {
            this.tableInfoTable.removeAll();
            int k = 0;
            while (k < tableInfos.length) {
                TableInfo tableInfo = tableInfos[k];
                int i = 0;
                while (i < tableInfo.columns.size()) {
                    TableColumnInfo column = (TableColumnInfo)tableInfo.columns.elementAt(i);
                    TableItem item = new TableItem(this.tableInfoTable, 0);
                    if (column.isSelected) {
                        item.setChecked(true);
                    }
                    if (tableInfo.tableName != null) {
                        item.setText(String.valueOf(tableInfo.tableName) + "." + column.columnName);
                    } else {
                        item.setText(column.columnName);
                    }
                    String dataName = null;
                    if (column.dataName != null) {
                        dataName = column.dataName;
                    } else {
                        this.getDataName(column.columnName, tableInfo.tableName);
                    }
                    if (dataName != null) {
                        item.setText(1, dataName);
                        column.dataName = dataName;
                    }
                    item.setText(2, column.columnTypeName);
                    item.setText(3, String.valueOf(column.precision));
                    item.setData((Object)column);
                    ++i;
                }
                ++k;
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("DataMapPage.Error_14"), (String)("Access Database failed!\nException:\n" + e));
            e.printStackTrace();
        }
    }

    public boolean canFinish() {
        return this.isCanFinish;
    }

    public void gotoNextPage() {
        TableItem[] items = this.tableInfoTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableColumnInfo column = (TableColumnInfo)items[i].getData();
            column.isSelected = items[i].getChecked();
            ++i;
        }
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    private String getDataName(String columnName, String tableName) {
        if (this.dataDictionary == null) {
            return null;
        }
        XMLNode dataNode = this.dataDictionary.findChildNodeIgnoreCase(columnName);
        if (dataNode == null) {
            dataNode = this.dataDictionary.findChildNodeIgnoreCase(String.valueOf(tableName) + "_" + columnName);
        }
        if (dataNode != null) {
            return dataNode.getAttrValue("id");
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        boolean canFlip = false;
        boolean dataSeted = true;
        TableItem[] items = this.tableInfoTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableColumnInfo column = (TableColumnInfo)items[i].getData();
            if (items[i].getChecked()) {
                if (column.dataName == null) {
                    dataSeted = false;
                } else {
                    canFlip = true;
                }
                column.isSelected = true;
            } else {
                column.isSelected = false;
            }
            ++i;
        }
        if (this.accessMode != 0 && this.accessMode != 4 && this.accessMode != 5) {
            return canFlip && dataSeted;
        }
        if (this.iCollNameText.getText().length() > 0) {
            return canFlip && dataSeted;
        }
        return false;
    }

    private void mapColumnToData() {
        TableItem[] items = this.tableInfoTable.getSelection();
        if (items.length != 1) {
            return;
        }
        DataDictionarySelectDialog dialog = new DataDictionarySelectDialog(this.getShell(), 0);
        dialog.setProfile(this.dataEditorProfile);
        dialog.setDataDictionary(this.dataDictionary);
        Vector datas = (Vector)dialog.open();
        if (datas == null || datas.size() == 0) {
            return;
        }
        XMLNode dataNode = (XMLNode)datas.elementAt(0);
        String dataID = dataNode.getAttrValue("id");
        if (dataID != null) {
            TableColumnInfo column = (TableColumnInfo)items[0].getData();
            column.mapedDataName = dataID;
            items[0].setText(4, dataID);
            this.getContainer().updateButtons();
        }
    }

    private void selectICollName() {
        DataDictionarySelectDialog dialog = new DataDictionarySelectDialog(this.getShell(), 0);
        dialog.setProfile(this.dataEditorProfile);
        dialog.setDataDictionary(this.dataDictionary);
        dialog.setFilterStr("dataCollection");
        Vector datas = (Vector)dialog.open();
        if (datas == null || datas.size() == 0) {
            return;
        }
        XMLNode dataNode = (XMLNode)datas.elementAt(0);
        if (!dataNode.getNodeName().equals("dataCollection")) {
            return;
        }
        String dataID = dataNode.getAttrValue("id");
        this.iCollNameText.setText(dataID);
        this.getContainer().updateButtons();
    }

    private void createNewData() {
        TableItem[] items = this.tableInfoTable.getSelection();
        if (items.length != 1) {
            return;
        }
        TableColumnInfo column = (TableColumnInfo)items[0].getData();
        DataDictionarySelectDialog dialog = new DataDictionarySelectDialog(this.getShell(), 0);
        dialog.setProfile(this.dataEditorProfile);
        dialog.setDataDictionary(this.dataDictionary);
        dialog.setDataName(column.columnName);
        dialog.setEditable(true);
        Vector datas = (Vector)dialog.open();
        if (datas == null || datas.size() == 0) {
            return;
        }
        XMLNode dataNode = (XMLNode)datas.elementAt(0);
        String dataID = dataNode.getAttrValue("id");
        if (dataID != null) {
            column.mapedDataName = dataID;
            items[0].setText(4, dataID);
            this.getContainer().updateButtons();
        }
    }

    public String getICollName() {
        return this.iCollNameText.getText();
    }

    public void setAccessMode(int mode) {
        this.accessMode = mode;
        if (mode != 4 && mode != 5) {
            this.iCollNameText.setEnabled(false);
            this.iCollButton.setEnabled(false);
        } else {
            this.iCollNameText.setEnabled(true);
            this.iCollButton.setEnabled(true);
        }
    }
}

