/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.DataDictionarySelectDialog;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import com.ecc.ide.editor.wizard.jdbc.SQLDefineInfo;
import com.ecc.ide.editor.wizard.jdbc.SelectedColumnInfo;
import com.ecc.ide.editor.wizard.jdbc.TableColumnInfo;
import com.ecc.ide.editor.wizard.jdbc.TableInfo;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class InsertUpdateColumnDefPanel
extends Composite {
    private Text text;
    private Table table;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;
    private TableInfo[] tableInfos;

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    public void setTableInfos(TableInfo[] infos) {
        this.tableInfos = infos;
        this.loadTableInfo(infos);
    }

    public InsertUpdateColumnDefPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        GridData gridData_1 = new GridData();
        label.setLayoutData((Object)gridData_1);
        label.setText(Messages.getString("SelectSQLDefinePanel.Please_Select_the_column_to_select_from__2"));
        this.table = new Table((Composite)this, 67616);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InsertUpdateColumnDefPanel.this.setActiveItem();
            }
        });
        GridData gridData_2 = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)gridData_2);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(100);
        tableColumn.setText(Messages.getString("SelectSQLDefinePanel.Column_Name_3"));
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(100);
        tableColumn_1.setText(Messages.getString("SelectSQLDefinePanel.DataName_4"));
        TableColumn tableColumn_2 = new TableColumn(this.table, 0);
        tableColumn_2.setWidth(100);
        tableColumn_2.setText(Messages.getString("SelectSQLDefinePanel.Column_Type_5"));
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite.setLayout((Layout)gridLayout_1);
        Label columnValueLabel = new Label(composite, 0);
        columnValueLabel.setText("Column Value:");
        this.text = new Text(composite, 2048);
        GridData gridData = new GridData(1, 2, true, false);
        gridData.widthHint = 140;
        this.text.setLayoutData((Object)gridData);
        Button selectdataButton = new Button(composite, 0);
        selectdataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InsertUpdateColumnDefPanel.this.selectData();
            }
        });
        selectdataButton.setText("SelectData");
        Button updateButton = new Button(composite, 0);
        updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InsertUpdateColumnDefPanel.this.updateItem();
            }
        });
        updateButton.setText("Update");
    }

    private void loadTableInfo(TableInfo[] tableInfos) {
        try {
            this.table.removeAll();
            int k = 0;
            while (k < tableInfos.length) {
                TableInfo tableInfo = tableInfos[k];
                int i = 0;
                while (i < tableInfo.columns.size()) {
                    TableColumnInfo column = (TableColumnInfo)tableInfo.columns.elementAt(i);
                    TableItem item = new TableItem(this.table, 0);
                    if (column.isSelected) {
                        item.setChecked(true);
                    }
                    if (tableInfo.tableName != null) {
                        item.setText(String.valueOf(tableInfo.tableName) + "." + column.columnName);
                    } else {
                        item.setText(column.columnName);
                    }
                    if (column.dataName != null) {
                        item.setText(1, column.dataName);
                    }
                    item.setText(2, column.columnTypeName);
                    item.setText(3, String.valueOf(column.precision));
                    item.setText(4, String.valueOf(column.scale));
                    item.setData((Object)column);
                    ++i;
                }
                ++k;
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("SelectSQLDefinePanel.Error_7"), (String)(String.valueOf(Messages.getString("SelectSQLDefinePanel.Internal_Error_!_nException__n_8")) + e));
            e.printStackTrace();
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void setActiveItem() {
        TableItem[] items = this.table.getSelection();
        if (items.length == 0) {
            return;
        }
        TableColumnInfo column = (TableColumnInfo)items[0].getData();
        String dataName = column.mapedDataName;
        if (dataName != null) {
            this.text.setText(dataName);
        } else {
            dataName = column.dataName;
            if (dataName != null) {
                dataName = "$" + dataName;
                this.text.setText(dataName);
            } else {
                this.text.setText("");
            }
        }
    }

    private void updateItem() {
        TableItem[] items = this.table.getSelection();
        if (items.length == 0) {
            return;
        }
        TableColumnInfo column = (TableColumnInfo)items[0].getData();
        String dataName = this.text.getText();
        if (dataName.length() == 0) {
            return;
        }
        if (dataName.startsWith("$")) {
            column.dataName = dataName = dataName.substring(1);
            items[0].setText(1, dataName);
            column.mapedDataName = null;
        } else {
            column.mapedDataName = dataName;
            items[0].setText(1, "Constant[" + dataName + "]");
        }
    }

    private void selectData() {
        DataDictionarySelectDialog dialog = new DataDictionarySelectDialog(this.getShell(), 0);
        dialog.setProfile(this.dataEditorProfile);
        dialog.setDataDictionary(this.dataDictionary);
        Vector datas = (Vector)dialog.open();
        if (datas == null || datas.size() == 0) {
            return;
        }
        XMLNode dataNode = (XMLNode)datas.elementAt(0);
        String dataID = dataNode.getAttrValue("id");
        if (dataID != null) {
            this.text.setText("$" + dataID);
        }
    }

    public SQLDefineInfo getSQLDefineInfo() {
        SQLDefineInfo sqlDefine = new SQLDefineInfo();
        sqlDefine.selectedColumns = new Vector();
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                TableColumnInfo column = (TableColumnInfo)items[i].getData();
                SelectedColumnInfo selColumn = new SelectedColumnInfo();
                selColumn.columnName = String.valueOf(column.tableName) + "." + column.columnName;
                selColumn.columnTypeName = column.columnTypeName;
                if (column.mapedDataName == null) {
                    selColumn.dataName = column.dataName;
                } else {
                    selColumn.value = column.mapedDataName;
                }
                sqlDefine.selectedColumns.addElement(selColumn);
            }
            ++i;
        }
        return sqlDefine;
    }
}

