/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.DataDictionarySelectDialog;
import com.ecc.ide.editor.wizard.jdbc.ConditionItem;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import com.ecc.ide.editor.wizard.jdbc.SelectedColumnInfo;
import com.ecc.ide.editor.wizard.jdbc.TableColumnInfo;
import com.ecc.ide.editor.wizard.jdbc.TableInfo;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class InsertUpdateColumnDefinePanel
extends Composite {
    private Table selectedColumnTable;
    private Text dataText;
    private Combo columnSelector;
    private Vector selectedColumns = new Vector(20);
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;
    private String columnTypeName;
    private TableInfo tableInfo;
    private TableInfo[] tableInfos;

    public InsertUpdateColumnDefinePanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        this.setLayout((Layout)gridLayout);
        Label label_1 = new Label((Composite)this, 0);
        GridData gridData_3 = new GridData();
        gridData_3.horizontalSpan = 6;
        label_1.setLayoutData((Object)gridData_3);
        label_1.setText(Messages.getString("InsertUpdateColumnDefinePanel.Define_the_column_to_modify__1"));
        this.selectedColumnTable = new Table((Composite)this, 67584);
        GridData gridData_10 = new GridData(1808);
        gridData_10.horizontalSpan = 6;
        this.selectedColumnTable.setLayoutData((Object)gridData_10);
        this.selectedColumnTable.setLinesVisible(true);
        this.selectedColumnTable.setHeaderVisible(true);
        TableColumn tableColumn_3 = new TableColumn(this.selectedColumnTable, 0);
        tableColumn_3.setWidth(100);
        tableColumn_3.setText(Messages.getString("InsertUpdateColumnDefinePanel.Column_Name_2"));
        TableColumn tableColumn_5 = new TableColumn(this.selectedColumnTable, 0);
        tableColumn_5.setWidth(100);
        tableColumn_5.setText(Messages.getString("InsertUpdateColumnDefinePanel.Dest_Data_3"));
        TableColumn tableColumn_4 = new TableColumn(this.selectedColumnTable, 0);
        tableColumn_4.setWidth(100);
        tableColumn_4.setText(Messages.getString("InsertUpdateColumnDefinePanel.ColumnType_4"));
        TableColumn tableColumn = new TableColumn(this.selectedColumnTable, 0);
        tableColumn.setWidth(94);
        tableColumn.setText(Messages.getString("InsertUpdateColumnDefinePanel.Length_5"));
        Label label_5 = new Label((Composite)this, 0);
        label_5.setLayoutData((Object)new GridData(64));
        label_5.setText(Messages.getString("InsertUpdateColumnDefinePanel.Column_6"));
        this.columnSelector = new Combo((Composite)this, 0);
        this.columnSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InsertUpdateColumnDefinePanel.this.setUpDataField();
            }
        });
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 120;
        this.columnSelector.setLayoutData((Object)gridData_8);
        Label label_7 = new Label((Composite)this, 0);
        GridData gridData_5 = new GridData(64);
        label_7.setLayoutData((Object)gridData_5);
        label_7.setText(Messages.getString("InsertUpdateColumnDefinePanel.Data__7"));
        this.dataText = new Text((Composite)this, 2048);
        GridData gridData_14 = new GridData();
        gridData_14.widthHint = 120;
        this.dataText.setLayoutData((Object)gridData_14);
        Button button_1 = new Button((Composite)this, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InsertUpdateColumnDefinePanel.this.selectData();
            }
        });
        GridData gridData = new GridData();
        gridData.widthHint = 73;
        button_1.setLayoutData((Object)gridData);
        button_1.setText(Messages.getString("InsertUpdateColumnDefinePanel.Select_8"));
        Composite composite = new Composite((Composite)this, 0);
        GridData gridData_9 = new GridData();
        gridData_9.horizontalSpan = 6;
        composite.setLayoutData((Object)gridData_9);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite.setLayout((Layout)gridLayout_1);
        Button button_2 = new Button(composite, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InsertUpdateColumnDefinePanel.this.addNewColumn();
            }
        });
        GridData gridData_12 = new GridData();
        gridData_12.widthHint = 80;
        button_2.setLayoutData((Object)gridData_12);
        button_2.setText(Messages.getString("InsertUpdateColumnDefinePanel.Add_9"));
        Button button_3 = new Button(composite, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InsertUpdateColumnDefinePanel.this.removeSelectedColumnItem();
            }
        });
        GridData gridData_13 = new GridData();
        gridData_13.widthHint = 80;
        button_3.setLayoutData((Object)gridData_13);
        button_3.setText(Messages.getString("InsertUpdateColumnDefinePanel.Remove_10"));
        Button button = new Button(composite, 0);
        GridData gridData_15 = new GridData();
        gridData_15.widthHint = 80;
        button.setLayoutData((Object)gridData_15);
        button.setText(Messages.getString("InsertUpdateColumnDefinePanel.Generate_it_11"));
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
        this.columnSelector.removeAll();
        if (tableInfo.columns == null) {
            return;
        }
        int i = 0;
        while (i < tableInfo.columns.size()) {
            TableColumnInfo column = (TableColumnInfo)tableInfo.columns.elementAt(i);
            this.columnSelector.add(String.valueOf(tableInfo.tableName) + "." + column.columnName);
            ++i;
        }
    }

    public void setTableInfos(TableInfo[] infos) {
        this.tableInfos = infos;
        this.columnSelector.removeAll();
        int k = 0;
        while (k < infos.length) {
            TableInfo tableInfo = infos[k];
            if (tableInfo.columns != null) {
                int i = 0;
                while (i < tableInfo.columns.size()) {
                    TableColumnInfo column = (TableColumnInfo)tableInfo.columns.elementAt(i);
                    this.columnSelector.add(String.valueOf(tableInfo.tableName) + "." + column.columnName);
                    ++i;
                }
            }
            ++k;
        }
    }

    public void setUpDataField() {
        int idx = this.columnSelector.getSelectionIndex();
        if (idx == -1) {
            return;
        }
        int tableIdx = 0;
        int off = 0;
        while (true) {
            int size = this.tableInfos[tableIdx].columns.size();
            if (idx >= off && idx < off + size) break;
            ++tableIdx;
            off += size;
        }
        TableColumnInfo column = (TableColumnInfo)this.tableInfos[tableIdx].columns.elementAt(idx -= off);
        if (column.dataName != null) {
            this.dataText.setText("$" + column.dataName);
        }
        this.columnTypeName = column.columnTypeName;
    }

    private void selectData() {
        DataDictionarySelectDialog dialog = new DataDictionarySelectDialog(this.getShell(), 0);
        dialog.setProfile(this.dataEditorProfile);
        dialog.setDataDictionary(this.dataDictionary);
        Vector datas = (Vector)dialog.open();
        if (datas == null || datas.size() == 0) {
            return;
        }
        XMLNode dataNode = (XMLNode)datas.elementAt(0);
        String dataID = dataNode.getAttrValue("id");
        if (dataID != null) {
            this.dataText.setText("$" + dataID);
        }
    }

    private void addNewColumn() {
        String columnName = this.columnSelector.getText();
        String data = this.dataText.getText();
        if (columnName.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("InsertUpdateColumnDefinePanel.Warning_17"), (String)Messages.getString("InsertUpdateColumnDefinePanel.Please_select_a_column._18"));
            return;
        }
        if (data.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("InsertUpdateColumnDefinePanel.Warning_19"), (String)Messages.getString("InsertUpdateColumnDefinePanel.Please_select_a_data_or_input_the_dataValue._20"));
            return;
        }
        int i = 0;
        while (i < this.selectedColumns.size()) {
            SelectedColumnInfo columnInfo = (SelectedColumnInfo)this.selectedColumns.elementAt(i);
            if (columnName.equals(columnInfo.columnName)) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("InsertUpdateColumnDefinePanel.Warning_21"), (String)Messages.getString("InsertUpdateColumnDefinePanel.you_have_already_select_this_column._22"));
                return;
            }
            ++i;
        }
        SelectedColumnInfo columnInfo = new SelectedColumnInfo();
        columnInfo.columnName = columnName;
        if (data.indexOf(36) != -1) {
            columnInfo.dataName = data.substring(1);
        } else {
            columnInfo.value = data;
        }
        columnInfo.columnTypeName = this.columnTypeName;
        TableItem item = new TableItem(this.selectedColumnTable, 0);
        item.setText(columnName);
        item.setText(1, data);
        item.setData((Object)columnInfo);
        this.selectedColumns.addElement(columnInfo);
    }

    private void removeSelectedColumnItem() {
        TableItem[] items = this.selectedColumnTable.getSelection();
        if (items.length != 1) {
            return;
        }
        ConditionItem cItem = (ConditionItem)items[0].getData();
        this.selectedColumns.removeElement(cItem);
        this.selectedColumnTable.remove(this.selectedColumnTable.indexOf(items[0]));
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public Vector getSelectedColumns() {
        return this.selectedColumns;
    }
}

