/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.wizard.ECCIDEWizard;
import com.ecc.ide.editor.wizard.jdbc.DBConnectionPage;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import java.sql.SQLException;
import org.eclipse.jface.wizard.IWizardPage;

public class JDBCDataSourceWizard
extends ECCIDEWizard {
    boolean isCanFInish = false;
    private DBConnectionPage connectionPage;

    public void addPages() {
        this.connectionPage = new DBConnectionPage(Messages.getString("JDBCSQLServiceWizard.DBConnection_Page_1"), Messages.getString("JDBCSQLServiceWizard.Please_specify_the_dest_database_to_connect_to_!_2"), null);
        this.connectionPage.setRootPath(this.rootPath);
        this.addPage((IWizardPage)this.connectionPage);
    }

    public boolean canFinish() {
        return this.connectionPage.canFlipToNextPage();
    }

    public XMLNode getXMLNode() {
        XMLNode node = this.xmlContentNode;
        if (node == null) {
            node = new XMLNode();
        }
        node.setNodeName("JDBCDriverDataSource");
        XMLNode dbAccessNode = this.connectionPage.getXMLNode().getChild("dbAccess");
        if (dbAccessNode == null) {
            return null;
        }
        try {
            String driverName = dbAccessNode.getChild("driverName").getAttrValue("nodeValue");
            String dbURL = dbAccessNode.getChild("dbURL").getAttrValue("nodeValue");
            String userName = dbAccessNode.getChild("userName").getAttrValue("nodeValue");
            String password = dbAccessNode.getChild("password").getAttrValue("nodeValue");
            node.setAttrValue("driverName", driverName);
            node.setAttrValue("dbURL", dbURL);
            node.setAttrValue("userName", userName);
            node.setAttrValue("password", password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return node;
    }

    public boolean performFinish() {
        try {
            this.connectionPage.getConnection().close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return true;
    }
}

