/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.wizard.ECCIDEWizard;
import com.ecc.ide.editor.wizard.jdbc.ConditionItem;
import com.ecc.ide.editor.wizard.jdbc.JDBCTableAccessModeSelectPage;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import com.ecc.ide.editor.wizard.jdbc.SQLConditionDefinePage;
import com.ecc.ide.editor.wizard.jdbc.ServiceSelectPage;
import com.ecc.ide.editor.wizard.jdbc.TableColumnInfo;
import com.ecc.ide.editor.wizard.jdbc.TableDataMapPage;
import com.ecc.ide.editor.wizard.jdbc.TableInfo;
import java.util.Vector;
import org.eclipse.jface.wizard.IWizardPage;

public class JDBCEJOpStepWizard
extends ECCIDEWizard {
    private ServiceSelectPage serviceSelectPage;
    private JDBCTableAccessModeSelectPage accessModeSelectPage;
    private TableDataMapPage dataMapPage;
    private SQLConditionDefinePage conditionPage;
    private int accessMode;
    private TableInfo tableInfo;
    private Vector conditions;
    private String userCondition;
    private String serviceName;

    public void addPages() {
        this.serviceSelectPage = new ServiceSelectPage(Messages.getString("JDBCEJOpStepWizard.Service_Select_Page_1"), Messages.getString("JDBCEJOpStepWizard.Please_select_the_EJ_service_this_step_will_operate_!_2"), null);
        this.serviceSelectPage.setCommonServiceNode(this.commonServiceNode);
        this.serviceSelectPage.setSelfDefineNode(this.selfDefineNode);
        this.serviceSelectPage.setFilter("EJService");
        this.addPage((IWizardPage)this.serviceSelectPage);
        this.accessModeSelectPage = new JDBCTableAccessModeSelectPage(Messages.getString("JDBCEJOpStepWizard.Access_Mode_Select_Page_4"), Messages.getString("JDBCEJOpStepWizard.Please_select_the_Access_mode_!_5"), null);
        this.addPage((IWizardPage)this.accessModeSelectPage);
        this.dataMapPage = new TableDataMapPage(Messages.getString("JDBCEJOpStepWizard.Column_select_and_dataMap_Page_6"), Messages.getString("JDBCEJOpStepWizard.Please_select_the_Column_you_want_to_operate_and_map_the_data_!_7"), null);
        this.dataMapPage.setDataEditorProfile(this.dataEditorProfile);
        this.dataMapPage.setDataDictionary(this.dataDictionary);
        this.addPage((IWizardPage)this.dataMapPage);
        this.conditionPage = new SQLConditionDefinePage(Messages.getString("JDBCEJOpStepWizard.Condition_define_page_8"), Messages.getString("JDBCEJOpStepWizard.please_define_the_SQL_condition._9"), null);
        this.conditionPage.setDataEditorProfile(this.dataEditorProfile);
        this.conditionPage.setDataDictionary(this.dataDictionary);
        this.addPage((IWizardPage)this.conditionPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.serviceSelectPage) {
            this.tableInfo = this.loadTableInfo(this.serviceSelectPage.getServiceNode());
            this.dataMapPage.setTableInfo(this.tableInfo);
            this.conditionPage.setTableInfo(this.tableInfo);
            return this.accessModeSelectPage;
        }
        if (page == this.accessModeSelectPage) {
            this.accessMode = this.accessModeSelectPage.getAccessMode();
            if (this.accessMode == 2) {
                this.conditionPage.setTableInfo(this.tableInfo);
                return this.conditionPage;
            }
            return this.dataMapPage;
        }
        if (page == this.dataMapPage) {
            if (this.accessMode == 0) {
                return null;
            }
            return this.conditionPage;
        }
        return null;
    }

    public XMLNode getXMLNode() {
        String[] opModes = new String[]{"insert", "update", "delete", "retrieve", "enquiry", "pageEnquiry"};
        XMLNode node = this.xmlContentNode;
        if (node == null) {
            node = new XMLNode();
            node.setNodeName("JDBCTableOpStep");
        }
        node.setAttrValue("serviceName", this.serviceName);
        node.setAttrValue("OP", opModes[this.accessMode]);
        String conditionStr = "";
        int k = 0;
        while (k < this.conditions.size()) {
            String aStr;
            ConditionItem item = (ConditionItem)this.conditions.elementAt(k);
            conditionStr = String.valueOf(conditionStr) + item.OP + " " + item.columnName + item.operator;
            if (item.dataName != null) {
                aStr = this.getValueStr(item.dataName, item.columnTypeName);
                conditionStr = String.valueOf(conditionStr) + aStr + " ";
            } else {
                aStr = this.getValueStr(item.value, item.columnTypeName);
                conditionStr = String.valueOf(conditionStr) + aStr + " ";
            }
            ++k;
        }
        if (this.userCondition != null) {
            conditionStr = String.valueOf(conditionStr) + this.userCondition;
        }
        if (conditionStr.length() > 0) {
            node.setAttrValue("condition", conditionStr);
        }
        String columns = "";
        String dataMap = "";
        int i = 0;
        while (i < this.tableInfo.columns.size()) {
            TableColumnInfo column = (TableColumnInfo)this.tableInfo.columns.elementAt(i);
            if (column.isSelected) {
                columns = String.valueOf(columns) + column.columnName + ";";
            }
            if (column.mapedDataName != null) {
                dataMap = String.valueOf(dataMap) + column.columnName + ":" + column.mapedDataName + ";";
            }
            ++i;
        }
        if (columns.length() != 0) {
            node.setAttrValue("columns", columns);
        }
        if (dataMap.length() != 0) {
            node.setAttrValue("dataMapping", dataMap);
        }
        return node;
    }

    public boolean performFinish() {
        this.conditions = this.conditionPage.getConditions();
        this.userCondition = this.conditionPage.getUserDefinedCondition();
        return true;
    }

    private TableInfo loadTableInfo(XMLNode serviceNode) {
        this.tableInfo = new TableInfo();
        Vector childs = serviceNode.getChilds();
        if (childs == null) {
            return this.tableInfo;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode columnNode = (XMLNode)childs.elementAt(i);
            if (columnNode.getNodeName().equals("column")) {
                TableColumnInfo column = new TableColumnInfo();
                column.columnName = columnNode.getAttrValue("columnName");
                column.columnTypeName = columnNode.getAttrValue("columnType");
                column.dataName = columnNode.getAttrValue("dataName");
                column.isSelected = true;
                this.tableInfo.addColumn(column);
            }
            ++i;
        }
        return this.tableInfo;
    }

    private String getValueStr(String value, String columnType) {
        if (columnType == null) {
            return value;
        }
        if ((columnType = columnType.toUpperCase()).indexOf("INT") != -1) {
            return value;
        }
        if (columnType.equals("DOUBLE")) {
            return value;
        }
        if (columnType.equals("REAL")) {
            return value;
        }
        if (columnType.equals("DECIMAL")) {
            return value;
        }
        return "'" + value + "'";
    }
}

