/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.Vector;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class JDBCPoolAndDataSourceSelectPage
extends WizardPage {
    private Table dataSourceTable;
    private Text dataSourceText;
    private Text poolServiceText;
    private Table serviceListTable;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;
    private XMLNode commonServiceNode;
    private XMLNode selfDefineNode;
    private String filterStr = "WASJDBCConnectionPool;ECCJDBCConnectionPool;";
    private String serviceId;
    private XMLNode serviceNode;
    private boolean isOk = false;

    public JDBCPoolAndDataSourceSelectPage(String pageName) {
        super(pageName);
    }

    public JDBCPoolAndDataSourceSelectPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        container.setLayout((Layout)layout);
        layout.verticalSpacing = 9;
        Label label_8 = new Label(container, 0);
        GridData gridData_9 = new GridData();
        gridData_9.horizontalSpan = 2;
        label_8.setLayoutData((Object)gridData_9);
        label_8.setText(Messages.getString("JDBCPoolAndDataSourceSelectPage.Please_select_a_pool_Service__2"));
        this.poolServiceText = new Text(container, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 153;
        gridData.horizontalSpan = 2;
        this.poolServiceText.setLayoutData((Object)gridData);
        this.serviceListTable = new Table(container, 67584);
        this.serviceListTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JDBCPoolAndDataSourceSelectPage.this.setPoolService();
            }
        });
        GridData gridData_8 = new GridData(1808);
        gridData_8.horizontalSpan = 4;
        this.serviceListTable.setLayoutData((Object)gridData_8);
        this.serviceListTable.setLinesVisible(true);
        this.serviceListTable.setHeaderVisible(true);
        TableColumn tableColumn_2 = new TableColumn(this.serviceListTable, 0);
        tableColumn_2.setWidth(108);
        tableColumn_2.setText(Messages.getString("JDBCPoolAndDataSourceSelectPage.Service_Type_3"));
        TableColumn tableColumn_4 = new TableColumn(this.serviceListTable, 0);
        tableColumn_4.setWidth(213);
        tableColumn_4.setText(Messages.getString("JDBCPoolAndDataSourceSelectPage.Service_ID_4"));
        TableColumn tableColumn_5 = new TableColumn(this.serviceListTable, 0);
        tableColumn_5.setWidth(250);
        tableColumn_5.setText(Messages.getString("JDBCPoolAndDataSourceSelectPage.Document_5"));
        Label label = new Label(container, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalSpan = 2;
        label.setLayoutData((Object)gridData_1);
        label.setText(Messages.getString("JDBCPoolAndDataSourceSelectPage.Please_select_dataSource__6"));
        this.setControl((Control)container);
        this.dataSourceText = new Text(container, 2048);
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 150;
        gridData_2.horizontalSpan = 2;
        this.dataSourceText.setLayoutData((Object)gridData_2);
        this.dataSourceTable = new Table(container, 67584);
        this.dataSourceTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JDBCPoolAndDataSourceSelectPage.this.setDataSourceName();
            }
        });
        GridData gridData_3 = new GridData(1808);
        gridData_3.horizontalSpan = 4;
        this.dataSourceTable.setLayoutData((Object)gridData_3);
        this.dataSourceTable.setLinesVisible(true);
        this.dataSourceTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.dataSourceTable, 0);
        tableColumn.setWidth(157);
        tableColumn.setText(Messages.getString("JDBCPoolAndDataSourceSelectPage.DataSourceID_7"));
        TableColumn tableColumn_1 = new TableColumn(this.dataSourceTable, 0);
        tableColumn_1.setWidth(280);
        tableColumn_1.setText(Messages.getString("JDBCPoolAndDataSourceSelectPage.Attributes_8"));
        this.initializeTable();
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    public void setFilter(String filterStr) {
        this.filterStr = filterStr;
    }

    public void setCommonServiceNode(XMLNode node) {
        this.commonServiceNode = node;
    }

    public void setSelfDefineNode(XMLNode node) {
        this.selfDefineNode = node;
    }

    private void initializeTable() {
        Vector services;
        if (this.commonServiceNode != null) {
            services = this.commonServiceNode.getChilds();
            int i = 0;
            while (services != null && i < services.size()) {
                XMLNode aNode = (XMLNode)services.elementAt(i);
                if (!("#text".equals(aNode.getNodeName()) || this.filterStr != null && this.filterStr.indexOf(aNode.getNodeName()) == -1)) {
                    TableItem item = new TableItem(this.serviceListTable, 0);
                    item.setText(aNode.getNodeName());
                    item.setText(1, aNode.getAttrValue("id"));
                    if (aNode.getAttrValue("desc") != null) {
                        item.setText(2, aNode.getAttrValue("desc"));
                    }
                    item.setData((Object)aNode);
                }
                ++i;
            }
        }
        if (this.selfDefineNode == null || this.selfDefineNode.getChild("services") == null) {
            return;
        }
        XMLNode servicesNode = this.selfDefineNode.getChild("services");
        services = servicesNode.getChilds();
        if (services == null) {
            return;
        }
        int i = 0;
        while (services != null && i < services.size()) {
            XMLNode aNode = (XMLNode)services.elementAt(i);
            if (!("#text".equals(aNode.getNodeName()) || this.filterStr != null && this.filterStr.indexOf(aNode.getNodeName()) == -1)) {
                TableItem item = new TableItem(this.serviceListTable, 0);
                item.setText(aNode.getNodeName());
                item.setText(1, aNode.getAttrValue("id"));
                if (aNode.getAttrValue("desc") != null) {
                    item.setText(2, aNode.getAttrValue("desc"));
                }
                item.setData((Object)aNode);
            }
            ++i;
        }
    }

    private void setPoolService() {
        TableItem[] items = this.serviceListTable.getSelection();
        if (items.length != 1) {
            this.poolServiceText.setText("");
            this.serviceId = null;
            this.serviceNode = null;
            this.dataSourceTable.removeAll();
        } else {
            XMLNode node = (XMLNode)items[0].getData();
            this.serviceId = node.getAttrValue("id");
            this.serviceNode = node;
            this.poolServiceText.setText(this.serviceId);
            this.dataSourceTable.removeAll();
            if (node.getChilds() == null) {
                return;
            }
            int i = 0;
            while (i < node.getChilds().size()) {
                XMLNode srcNode = (XMLNode)node.getChilds().elementAt(i);
                if ("JDBCResource".equals(srcNode.getNodeName())) {
                    TableItem item = new TableItem(this.dataSourceTable, 0);
                    item.setText(srcNode.getAttrValue("resourceID"));
                    item.setText(1, srcNode.getAttributesString());
                    item.setData((Object)srcNode);
                }
                ++i;
            }
        }
    }

    private void setDataSourceName() {
        TableItem[] items = this.dataSourceTable.getSelection();
        if (items.length != 1) {
            this.dataSourceText.setText("");
            this.isOk = false;
        } else {
            XMLNode node = (XMLNode)items[0].getData();
            this.dataSourceText.setText(node.getAttrValue("resourceID"));
            this.isOk = true;
        }
        this.getContainer().updateButtons();
    }

    public boolean canFlipToNextPage() {
        return this.isOk;
    }

    public String getServiceID() {
        return this.serviceId;
    }

    public XMLNode getServiceNode() {
        return this.serviceNode;
    }

    public String getDataSourceName() {
        return this.dataSourceText.getText();
    }
}

