/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.wizard.ECCIDEWizard;
import com.ecc.ide.editor.wizard.jdbc.DBConnectionPage;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import com.ecc.ide.editor.wizard.jdbc.ResultSetInfo;
import com.ecc.ide.editor.wizard.jdbc.TableColumnInfo;
import com.ecc.ide.editor.wizard.jdbc.TableDataMapPage;
import com.ecc.ide.editor.wizard.jdbc.TableInfo;
import com.ecc.ide.editor.wizard.jdbc.TableViewProcedureSelectPage;
import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizardPage;

public class JDBCProcedureServiceWizard
extends ECCIDEWizard {
    boolean isCanFInish = false;
    private DBConnectionPage connectionPage;
    private TableViewProcedureSelectPage tableSelectPage;
    private TableDataMapPage tableDataMapPage;
    private TableInfo tableInfo;

    public void addPages() {
        this.connectionPage = new DBConnectionPage(Messages.getString("JDBCProcedureServiceWizard.DBConnection_Page_1"), Messages.getString("JDBCProcedureServiceWizard.Please_specify_the_dest_database_to_connect_to_!_2"), null);
        this.connectionPage.setRootPath(this.rootPath);
        this.addPage((IWizardPage)this.connectionPage);
        this.tableSelectPage = new TableViewProcedureSelectPage(Messages.getString("JDBCProcedureServiceWizard.Table_select_Page_3"), Messages.getString("JDBCProcedureServiceWizard.please_select_the_dest_Store_procedure__to_access_!_4"), null);
        this.tableSelectPage.setSelectType("procedure");
        this.addPage((IWizardPage)this.tableSelectPage);
        this.tableDataMapPage = new TableDataMapPage(Messages.getString("JDBCProcedureServiceWizard.Data_Map_page_6"), Messages.getString("JDBCProcedureServiceWizard.setting_up_the_Procedure_In/Out_Parameter_and_data_define_mapping_._7"), null);
        this.tableDataMapPage.setDataDictionary(this.dataDictionary);
        this.tableDataMapPage.setDataEditorProfile(this.dataEditorProfile);
        this.addPage((IWizardPage)this.tableDataMapPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.connectionPage) {
            this.tableSelectPage.setDBConnection(this.connectionPage.getConnection());
            this.isCanFInish = true;
            return this.tableSelectPage;
        }
        if (page == this.tableSelectPage) {
            this.tableInfo = this.tableSelectPage.getTableInfo();
            int i = 0;
            while (i < this.tableInfo.columns.size()) {
                TableColumnInfo column = (TableColumnInfo)this.tableInfo.columns.elementAt(i);
                column.isSelected = true;
                ++i;
            }
            this.tableDataMapPage.setTableInfo(this.tableInfo);
            return this.tableDataMapPage;
        }
        return null;
    }

    public boolean performFinish() {
        try {
            this.connectionPage.getConnection().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean canFinish() {
        return this.tableDataMapPage.canFinish();
    }

    public XMLNode getXMLNode() {
        XMLNode node = this.xmlContentNode;
        if (node == null) {
            node = new XMLNode();
        }
        node.setNodeName("JDBCProcedureDefine");
        node.setAttrValue("procedureName", this.tableInfo.tableName);
        XMLNode inputNode = new XMLNode();
        inputNode.setNodeName("input");
        XMLNode outputNode = new XMLNode();
        outputNode.setNodeName("output");
        ArrayList<XMLNode> rsNodeList = new ArrayList<XMLNode>();
        int i = 0;
        while (i < this.tableInfo.columns.size()) {
            TableColumnInfo column = (TableColumnInfo)this.tableInfo.columns.elementAt(i);
            XMLNode aNode = new XMLNode();
            aNode.setNodeName("param");
            aNode.setAttrValue("dataName", column.dataName);
            aNode.setAttrValue("dataType", column.columnTypeName.toUpperCase());
            if (column.inOutType == 1) {
                inputNode.add(aNode);
            } else if (column.inOutType == 3 || column.inOutType == 4) {
                if ("REF CURSOR".equals(column.columnTypeName)) {
                    ResultSetInfo rsInfo = (ResultSetInfo)this.tableInfo.columns.elementAt(i);
                    XMLNode resultSetNode = new XMLNode();
                    resultSetNode.setNodeName("resultSet");
                    resultSetNode.setAttrValue("iCollName", rsInfo.iCollName);
                    resultSetNode.setAttrValue("isAppend", rsInfo.append);
                    int j = 0;
                    while (j < rsInfo.subColumns.size()) {
                        TableColumnInfo aColumn = (TableColumnInfo)rsInfo.subColumns.elementAt(j);
                        XMLNode aNode1 = new XMLNode();
                        aNode1.setNodeName("param");
                        aNode1.setAttrValue("dataName", aColumn.dataName);
                        aNode1.setAttrValue("dataType", aColumn.columnTypeName.toUpperCase());
                        resultSetNode.add(aNode1);
                        ++j;
                    }
                    rsNodeList.add(resultSetNode);
                } else {
                    outputNode.add(aNode);
                }
            }
            ++i;
        }
        if (inputNode.getChilds() != null && inputNode.getChilds().size() > 0) {
            node.add(inputNode);
        }
        if (outputNode.getChilds() != null && outputNode.getChilds().size() > 0) {
            node.add(outputNode);
        }
        i = 0;
        while (i < rsNodeList.size()) {
            node.add((XMLNode)rsNodeList.get(i));
            ++i;
        }
        return node;
    }
}

