/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.wizard.ECCIDEWizard;
import com.ecc.ide.editor.wizard.jdbc.ConditionItem;
import com.ecc.ide.editor.wizard.jdbc.DBConnectionPage;
import com.ecc.ide.editor.wizard.jdbc.JDBCPoolAndDataSourceSelectPage;
import com.ecc.ide.editor.wizard.jdbc.JDBCSQLDefinePage;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import com.ecc.ide.editor.wizard.jdbc.SQLDefineInfo;
import com.ecc.ide.editor.wizard.jdbc.SelectedColumnInfo;
import com.ecc.ide.editor.wizard.jdbc.TableColumnInfo;
import com.ecc.ide.editor.wizard.jdbc.TableDataMapPage;
import com.ecc.ide.editor.wizard.jdbc.TableInfo;
import com.ecc.ide.editor.wizard.jdbc.TableServiceFinalPage;
import com.ecc.ide.editor.wizard.jdbc.TableViewProcedureSelectPage;
import java.util.Vector;
import org.eclipse.jface.wizard.IWizardPage;

public class JDBCSQLServiceWizard
extends ECCIDEWizard {
    boolean isCanFInish = false;
    private DBConnectionPage connectionPage;
    private TableViewProcedureSelectPage tableSelectPage;
    private TableDataMapPage tableDataMapPage;
    private TableServiceFinalPage serviceFinalPage;
    private JDBCSQLDefinePage sqlDefinePage;
    private TableInfo[] tableInfos;
    private JDBCPoolAndDataSourceSelectPage poolDataSourcePage;
    private String poolServiceId;
    private String dataSourceName;

    public void addPages() {
        this.connectionPage = new DBConnectionPage(Messages.getString("JDBCSQLServiceWizard.DBConnection_Page_1"), Messages.getString("JDBCSQLServiceWizard.Please_specify_the_dest_database_to_connect_to_!_2"), null);
        this.connectionPage.setRootPath(this.rootPath);
        this.addPage((IWizardPage)this.connectionPage);
        this.tableSelectPage = new TableViewProcedureSelectPage(Messages.getString("JDBCSQLServiceWizard.Table_select_Page_3"), Messages.getString("JDBCSQLServiceWizard.please_select_the_dest_Table_or_view__to_access_!_4"), null);
        this.tableSelectPage.setCheckSelect(true);
        this.addPage((IWizardPage)this.tableSelectPage);
        this.tableDataMapPage = new TableDataMapPage(Messages.getString("JDBCSQLServiceWizard.Data_Map_page_5"), Messages.getString("JDBCSQLServiceWizard.Setting_up_the_table_column_and_data_define_mapping._6"), null);
        this.tableDataMapPage.setDataDictionary(this.dataDictionary);
        this.tableDataMapPage.setDataEditorProfile(this.dataEditorProfile);
        this.addPage((IWizardPage)this.tableDataMapPage);
        this.sqlDefinePage = new JDBCSQLDefinePage(Messages.getString("JDBCSQLServiceWizard.SQL_define_Page_1"), Messages.getString("JDBCSQLServiceWizard.define_the_sql._2"), null);
        this.sqlDefinePage.setDataDictionary(this.dataDictionary);
        this.sqlDefinePage.setDataEditorProfile(this.dataEditorProfile);
        this.addPage((IWizardPage)this.sqlDefinePage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.connectionPage) {
            this.tableSelectPage.setDBConnection(this.connectionPage.getConnection());
            this.isCanFInish = true;
            return this.tableSelectPage;
        }
        if (page == this.tableSelectPage) {
            this.tableInfos = this.tableSelectPage.getTableInfos();
            this.tableDataMapPage.setTableInfos(this.tableInfos);
            return this.tableDataMapPage;
        }
        if (page == this.tableDataMapPage) {
            this.sqlDefinePage.setTableInfos(this.tableInfos);
            return this.sqlDefinePage;
        }
        return null;
    }

    public boolean performFinish() {
        try {
            this.poolServiceId = this.poolDataSourcePage.getServiceID();
            this.dataSourceName = this.poolDataSourcePage.getDataSourceName();
            this.connectionPage.getConnection().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean canFinish() {
        return this.tableDataMapPage.canFinish();
    }

    public XMLNode getXMLNode() {
        XMLNode node = this.xmlContentNode;
        if (node == null) {
            node = new XMLNode();
        }
        node.setNodeName("JDBCSQLExecService");
        node.setAttrValue("poolServiceName", this.poolServiceId);
        node.setAttrValue("dataSourceName", this.dataSourceName);
        Vector sqlDefines = this.sqlDefinePage.getSQLDefines();
        if (sqlDefines == null) {
            return node;
        }
        int i = 0;
        while (i < sqlDefines.size()) {
            XMLNode iNode;
            SelectedColumnInfo column;
            XMLNode inputNode;
            SQLDefineInfo sqlInfo = (SQLDefineInfo)sqlDefines.elementAt(i);
            String sqlType = sqlInfo.sqlType;
            XMLNode aNode = new XMLNode();
            aNode.setNodeName("JDBCSQLDef");
            aNode.setAttrValue("id", sqlInfo.sqlID);
            node.add(aNode);
            if (sqlInfo.errorCode != null) {
                aNode.setAttrValue("errorCode", sqlInfo.errorCode);
            }
            if (sqlInfo.errorMessage != null) {
                aNode.setAttrValue("errorMessage", sqlInfo.errorMessage);
            }
            if (sqlInfo.sqlStr != null && sqlInfo.sqlStr.length() != 0) {
                aNode.setAttrValue("SQLStr", sqlInfo.sqlStr);
            }
            if ("Select".equals(sqlType)) {
                inputNode = new XMLNode();
                inputNode.setNodeName("input");
                XMLNode outNode = new XMLNode();
                outNode.setNodeName("output");
                int oIdx = 1;
                int iIdx = 1;
                int k = 0;
                while (k < sqlInfo.selectedColumns.size()) {
                    TableColumnInfo column2 = (TableColumnInfo)sqlInfo.selectedColumns.elementAt(k);
                    XMLNode oNode = new XMLNode();
                    oNode.setNodeName("param");
                    oNode.setAttrValue("dataName", column2.dataName);
                    oNode.setAttrValue("idx", String.valueOf(oIdx++));
                    oNode.setAttrValue("dataType", column2.columnTypeName.toUpperCase());
                    outNode.add(oNode);
                    ++k;
                }
                String conditionStr = "";
                conditionStr = this.getConditionStr(sqlInfo.conditions, inputNode, iIdx);
                aNode.add(outNode);
                aNode.add(inputNode);
                aNode.setAttrValue("sqlType", "select");
                if (sqlInfo.iCollName != null && sqlInfo.iCollName.trim().length() != 0) {
                    aNode.setAttrValue("iCollName", sqlInfo.iCollName);
                }
                if (sqlInfo.maxRecords != null && sqlInfo.maxRecords.trim().length() != 0) {
                    aNode.setAttrValue("maxRecords", sqlInfo.maxRecords);
                }
            } else if ("Update".equals(sqlType)) {
                inputNode = new XMLNode();
                inputNode.setNodeName("input");
                int iIdx = 1;
                int k = 0;
                while (k < sqlInfo.selectedColumns.size()) {
                    column = (SelectedColumnInfo)sqlInfo.selectedColumns.elementAt(k);
                    int idx = column.columnName.lastIndexOf(".");
                    String tableName = column.columnName.substring(0, idx);
                    if (column.dataName != null) {
                        iNode = new XMLNode();
                        iNode.setNodeName("param");
                        iNode.setAttrValue("dataName", column.dataName);
                        iNode.setAttrValue("idx", String.valueOf(iIdx++));
                        inputNode.add(iNode);
                    }
                    ++k;
                }
                String conditionStr = "";
                conditionStr = this.getConditionStr(sqlInfo.conditions, inputNode, iIdx);
                aNode.add(inputNode);
                aNode.setAttrValue("sqlType", "update");
            } else if ("Insert".equals(sqlType)) {
                inputNode = new XMLNode();
                inputNode.setNodeName("input");
                int iIdx = 1;
                int k = 0;
                while (k < sqlInfo.selectedColumns.size()) {
                    column = (SelectedColumnInfo)sqlInfo.selectedColumns.elementAt(k);
                    int idx = column.columnName.lastIndexOf(".");
                    if (column.dataName != null) {
                        iNode = new XMLNode();
                        iNode.setNodeName("param");
                        iNode.setAttrValue("dataName", column.dataName);
                        iNode.setAttrValue("idx", String.valueOf(iIdx++));
                        inputNode.add(iNode);
                    }
                    ++k;
                }
                aNode.add(inputNode);
                aNode.setAttrValue("sqlType", "insert");
            } else if ("Delete".equals(sqlType)) {
                inputNode = new XMLNode();
                inputNode.setNodeName("input");
                int iIdx = 1;
                String conditionStr = "";
                conditionStr = this.getConditionStr(sqlInfo.conditions, inputNode, iIdx);
                aNode.add(inputNode);
                aNode.setAttrValue("sqlType", "delete");
            }
            ++i;
        }
        return node;
    }

    private String getConditionStr(Vector conditions, XMLNode inputNode, int iIdx) {
        if (conditions == null) {
            return "";
        }
        String conditionStr = "";
        int k = 0;
        while (k < conditions.size()) {
            ConditionItem item = (ConditionItem)conditions.elementAt(k);
            conditionStr = String.valueOf(conditionStr) + item.OP + " " + item.columnName + item.operator;
            if (item.dataName != null) {
                conditionStr = String.valueOf(conditionStr) + "? ";
                XMLNode iNode = new XMLNode();
                iNode.setNodeName("param");
                iNode.setAttrValue("dataName", item.dataName.substring(1, item.dataName.length() - 1));
                iNode.setAttrValue("idx", String.valueOf(iIdx++));
                inputNode.add(iNode);
            } else {
                String valueStr = this.getValueStr(item.value, item.columnTypeName);
                conditionStr = String.valueOf(conditionStr) + valueStr + " ";
            }
            ++k;
        }
        return conditionStr;
    }

    private String getValueStr(String value, String columnType) {
        if (columnType == null) {
            return value;
        }
        if ((columnType = columnType.toUpperCase()).indexOf("INT") != -1) {
            return value;
        }
        if (columnType.equals("DOUBLE")) {
            return value;
        }
        if (columnType.equals("REAL")) {
            return value;
        }
        if (columnType.equals("DECIMAL")) {
            return value;
        }
        return "'" + value + "'";
    }
}

