/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.wizard.ECCIDEWizard;
import com.ecc.ide.editor.wizard.jdbc.DBConnectionPage;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import com.ecc.ide.editor.wizard.jdbc.TableColumnInfo;
import com.ecc.ide.editor.wizard.jdbc.TableDataMapPage;
import com.ecc.ide.editor.wizard.jdbc.TableInfo;
import com.ecc.ide.editor.wizard.jdbc.TableServiceFinalPage;
import com.ecc.ide.editor.wizard.jdbc.TableViewProcedureSelectPage;
import org.eclipse.jface.wizard.IWizardPage;

public class JDBCTableServiceWizard
extends ECCIDEWizard {
    boolean isCanFInish = false;
    private DBConnectionPage connectionPage;
    private TableViewProcedureSelectPage tableSelectPage;
    private TableDataMapPage tableDataMapPage;
    private TableServiceFinalPage serviceFinalPage;
    private TableInfo tableInfo;
    private String sequenceColumnName;
    private String maxLines;
    private String poolServiceId;
    private String dataSourceName;

    public void addPages() {
        this.connectionPage = new DBConnectionPage(Messages.getString("JDBCTableServiceWizard.DBConnection_Page_1"), Messages.getString("JDBCTableServiceWizard.Please_specify_the_dest_database_to_connect_to_!_2"), null);
        this.connectionPage.setRootPath(this.rootPath);
        this.addPage((IWizardPage)this.connectionPage);
        this.tableSelectPage = new TableViewProcedureSelectPage(Messages.getString("JDBCTableServiceWizard.Table_select_Page_3"), Messages.getString("JDBCTableServiceWizard.please_select_the_dest_Table_or_view__to_access_!_4"), null);
        this.addPage((IWizardPage)this.tableSelectPage);
        this.tableDataMapPage = new TableDataMapPage(Messages.getString("JDBCTableServiceWizard.Data_Map_page_5"), Messages.getString("JDBCTableServiceWizard.setting_up_the_table_column_and_data_define_mapping_._6"), null);
        this.tableDataMapPage.setDataDictionary(this.dataDictionary);
        this.tableDataMapPage.setDataEditorProfile(this.dataEditorProfile);
        this.addPage((IWizardPage)this.tableDataMapPage);
        this.serviceFinalPage = new TableServiceFinalPage(Messages.getString("JDBCTableServiceWizard.Table_Service_Final_Page_7"), Messages.getString("JDBCTableServiceWizard.Please_confirm_the_table_service_selection_!_8"), null);
        this.addPage((IWizardPage)this.serviceFinalPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.connectionPage) {
            this.tableSelectPage.setDBConnection(this.connectionPage.getConnection());
            this.isCanFInish = true;
            return this.tableSelectPage;
        }
        if (page == this.tableSelectPage) {
            this.tableInfo = this.tableSelectPage.getTableInfo();
            this.tableDataMapPage.setTableInfo(this.tableInfo);
            return this.tableDataMapPage;
        }
        if (page == this.tableDataMapPage) {
            this.serviceFinalPage.setTableInfo(this.tableInfo);
            return this.serviceFinalPage;
        }
        return null;
    }

    public boolean performFinish() {
        try {
            this.sequenceColumnName = this.serviceFinalPage.getSequenceColumnName();
            this.maxLines = this.serviceFinalPage.getMaxLines();
            this.connectionPage.getConnection().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean canFinish() {
        return this.tableDataMapPage.canFinish();
    }

    public XMLNode getXMLNode() {
        TableInfo tableInfo = this.tableSelectPage.getTableInfo();
        XMLNode node = this.xmlContentNode;
        if (node == null) {
            node = new XMLNode();
            node.setNodeName("JDBCTableService");
        }
        node.setAttrValue("tableName", tableInfo.tableName);
        node.setAttrValue("schema", tableInfo.schemaName);
        node.setAttrValue("tableSequenceColumn", this.sequenceColumnName);
        node.setAttrValue("poolServiceName", this.poolServiceId);
        node.setAttrValue("dataSourceName", this.dataSourceName);
        node.setAttrValue("maxLine", this.maxLines);
        int i = 0;
        while (i < tableInfo.columns.size()) {
            TableColumnInfo column = (TableColumnInfo)tableInfo.columns.elementAt(i);
            if (column.isSelected) {
                XMLNode aNode = new XMLNode();
                aNode.setNodeName("column");
                aNode.setAttrValue("columnName", column.columnName);
                aNode.setAttrValue("dataName", column.dataName);
                aNode.setAttrValue("columnType", column.columnTypeName.toUpperCase());
                node.add(aNode);
            }
            ++i;
        }
        return node;
    }
}

