/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.DataDictionarySelectDialog;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import com.ecc.ide.editor.wizard.jdbc.ResultSetInfo;
import com.ecc.ide.editor.wizard.jdbc.TableColumnInfo;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ResultSetMapDialog
extends Dialog {
    private Table rsInfoTable;
    private Shell shell;
    private Text iCollText;
    private Combo appendCombo;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;
    private ResultSetInfo rsInfo = null;

    public ResultSetMapDialog(Shell parent) {
        super(parent);
    }

    public ResultSetMapDialog(Shell parent, int style) {
        super(parent, style);
    }

    public void open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67696);
        this.shell.setLayout((Layout)new GridLayout());
        this.shell.setText(Messages.getString("SQLDefineDialog.Define_the__1"));
        this.shell.setSize(500, 300);
        Composite container = new Composite((Composite)this.shell, 0);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 4;
        layout.verticalSpacing = 5;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        GridData gridData_5 = new GridData();
        gridData_5.widthHint = 150;
        label.setLayoutData((Object)new GridData(768));
        label.setText(Messages.getString("TableDataMapPage.Selected_Table_Info_1"));
        Text rsInfoText = new Text(container, 2056);
        rsInfoText.setLayoutData((Object)new GridData(768));
        rsInfoText.setText(String.valueOf(this.rsInfo.columnName));
        Label label_1 = new Label(container, 0);
        label_1.setLayoutData((Object)new GridData(768));
        label_1.setText("Append");
        this.appendCombo = new Combo(container, 0);
        this.appendCombo.setLayoutData((Object)new GridData(768));
        this.appendCombo.setItems(new String[]{"true", "false"});
        Label label_2 = new Label(container, 0);
        label_2.setLayoutData((Object)new GridData(768));
        label_2.setText("ICollName");
        this.iCollText = new Text(container, 2056);
        this.iCollText.setLayoutData((Object)new GridData(768));
        this.iCollText.setEditable(false);
        Button iCollButton = new Button(container, 0);
        iCollButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetMapDialog.this.selectICollName();
            }
        });
        iCollButton.setText(Messages.getString("DataMapPage.>>_10"));
        this.iCollText.setLayoutData((Object)new GridData(768));
        this.rsInfoTable = new Table(container, 67616);
        this.rsInfoTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ResultSetMapDialog.this.mapColumnToData();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        GridData gridData_1 = new GridData(1808);
        gridData_1.horizontalSpan = 4;
        gridData_1.verticalSpan = 5;
        this.rsInfoTable.setLayoutData((Object)gridData_1);
        this.rsInfoTable.setLinesVisible(true);
        this.rsInfoTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.rsInfoTable, 0);
        tableColumn.setWidth(100);
        tableColumn.setText(Messages.getString("TableDataMapPage.ColumnName_2"));
        TableColumn tableColumn_6 = new TableColumn(this.rsInfoTable, 0);
        tableColumn_6.setWidth(100);
        tableColumn_6.setText(Messages.getString("TableDataMapPage.Data_Name_3"));
        TableColumn tableColumn_1 = new TableColumn(this.rsInfoTable, 0);
        tableColumn_1.setWidth(78);
        tableColumn_1.setText(Messages.getString("TableDataMapPage.ColumnType_4"));
        TableColumn tableColumn_2 = new TableColumn(this.rsInfoTable, 0);
        tableColumn_2.setWidth(100);
        tableColumn_2.setText(Messages.getString("TableDataMapPage.Length_5"));
        Composite composite = new Composite(container, 0);
        GridData gridData_6 = new GridData(768);
        gridData_6.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData_6);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite.setLayout((Layout)gridLayout);
        Button button = new Button(composite, 0);
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 100;
        button.setLayoutData((Object)gridData_2);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetMapDialog.this.createNewData();
            }
        });
        button.setText(Messages.getString("TableDataMapPage.Create_new_data_6"));
        Button button_1 = new Button(composite, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetMapDialog.this.mapColumnToData();
            }
        });
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 100;
        button_1.setLayoutData((Object)gridData_3);
        button_1.setText(Messages.getString("TableDataMapPage.Map_The_Data_7"));
        this.loadResultSetInfo();
        Composite composite_1 = new Composite((Composite)this.shell, 0);
        composite_1.setLayoutData((Object)new GridData(128));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.makeColumnsEqualWidth = true;
        gridLayout_1.numColumns = 2;
        composite_1.setLayout((Layout)gridLayout_1);
        Button button_2 = new Button(composite_1, 0);
        GridData gridData = new GridData(128);
        gridData.widthHint = 80;
        button_2.setLayoutData((Object)gridData);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetMapDialog.this.updateResultSetInfo();
                ResultSetMapDialog.this.shell.dispose();
            }
        });
        button_2.setText(Messages.getString("SQLDefineDialog._____OK______7"));
        Button button_3 = new Button(composite_1, 0);
        GridData gridData_4 = new GridData(128);
        gridData_4.widthHint = 80;
        button_3.setLayoutData((Object)gridData_4);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetMapDialog.this.shell.dispose();
            }
        });
        button_3.setText(Messages.getString("SQLDefineDialog.___Cancel____8"));
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void setRsInfo(ResultSetInfo rsInfo) {
        this.rsInfo = rsInfo;
    }

    private void loadResultSetInfo() {
        if (this.rsInfo == null) {
            return;
        }
        try {
            this.rsInfoTable.removeAll();
            int i = 0;
            while (i < this.rsInfo.subColumns.size()) {
                TableColumnInfo column = (TableColumnInfo)this.rsInfo.subColumns.elementAt(i);
                TableItem item = new TableItem(this.rsInfoTable, 0);
                if (column.isSelected) {
                    item.setChecked(true);
                }
                item.setText(column.columnName);
                if (column.dataName != null) {
                    item.setText(1, column.dataName);
                } else {
                    String dataName = this.getDataName(column.columnName);
                    if (dataName != null) {
                        item.setText(1, dataName);
                        column.dataName = dataName;
                    }
                }
                item.setText(2, column.columnTypeName);
                item.setText(3, String.valueOf(column.precision));
                item.setText(4, String.valueOf(column.scale));
                item.setData((Object)column);
                ++i;
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getParent(), (String)Messages.getString("TableDataMapPage.Error_8"), (String)(String.valueOf(Messages.getString("TableDataMapPage.Access_Database_failed_!_nException__n_9")) + e));
            e.printStackTrace();
        }
    }

    private String getDataName(String columnName) {
        if (this.dataDictionary == null) {
            return null;
        }
        XMLNode dataNode = this.dataDictionary.findChildNodeIgnoreCase(columnName);
        if (dataNode != null) {
            return dataNode.getAttrValue("id");
        }
        return null;
    }

    private void mapColumnToData() {
        TableItem[] items = this.rsInfoTable.getSelection();
        if (items.length != 1) {
            return;
        }
        DataDictionarySelectDialog dialog = new DataDictionarySelectDialog(this.getParent(), 0);
        dialog.setProfile(this.dataEditorProfile);
        dialog.setDataDictionary(this.dataDictionary);
        Vector datas = (Vector)dialog.open();
        if (datas == null || datas.size() == 0) {
            return;
        }
        XMLNode dataNode = (XMLNode)datas.elementAt(0);
        String dataID = dataNode.getAttrValue("id");
        if (dataID != null) {
            items[0].setText(1, dataID);
            TableColumnInfo column = (TableColumnInfo)items[0].getData();
            column.dataName = dataID;
        }
    }

    private void createNewData() {
        TableItem[] items = this.rsInfoTable.getSelection();
        if (items.length != 1) {
            return;
        }
        TableColumnInfo column = (TableColumnInfo)items[0].getData();
        DataDictionarySelectDialog dialog = new DataDictionarySelectDialog(this.getParent(), 0);
        dialog.setProfile(this.dataEditorProfile);
        dialog.setDataDictionary(this.dataDictionary);
        dialog.setDataName(column.columnName);
        dialog.setEditable(true);
        Vector datas = (Vector)dialog.open();
        if (datas == null || datas.size() == 0) {
            return;
        }
        XMLNode dataNode = (XMLNode)datas.elementAt(0);
        String dataID = dataNode.getAttrValue("id");
        if (dataID != null) {
            items[0].setText(1, dataID);
            column.dataName = dataID;
        }
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    private void selectICollName() {
        DataDictionarySelectDialog dialog = new DataDictionarySelectDialog(this.getParent(), 0);
        dialog.setProfile(this.dataEditorProfile);
        dialog.setDataDictionary(this.dataDictionary);
        dialog.setFilterStr("dataCollection");
        Vector datas = (Vector)dialog.open();
        if (datas == null || datas.size() == 0) {
            return;
        }
        XMLNode dataNode = (XMLNode)datas.elementAt(0);
        if (!dataNode.getNodeName().equals("dataCollection")) {
            return;
        }
        String dataID = dataNode.getAttrValue("id");
        this.iCollText.setText(dataID);
    }

    private void updateResultSetInfo() {
        this.rsInfo.iCollName = this.iCollText.getText();
        this.rsInfo.append = this.appendCombo.getItem(this.appendCombo.getSelectionIndex());
    }
}

