/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import com.ecc.ide.editor.wizard.jdbc.SQLConditionDefinePanel;
import com.ecc.ide.editor.wizard.jdbc.SQLDefineInfo;
import com.ecc.ide.editor.wizard.jdbc.TableColumnInfo;
import com.ecc.ide.editor.wizard.jdbc.TableInfo;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SelectSQLDefinePanel
extends SashForm {
    private Text text;
    private Table table;
    private SQLConditionDefinePanel conditionDefinePanel;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;
    private TableInfo[] tableInfos;

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.conditionDefinePanel.setDataDictionary(node);
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
        this.conditionDefinePanel.setDataEditorProfile(profile);
    }

    public void setTableInfos(TableInfo[] infos) {
        this.tableInfos = infos;
        this.conditionDefinePanel.setTableInfos(infos);
        this.loadTableInfo(infos);
    }

    public SelectSQLDefinePanel(Composite parent, int style) {
        super(parent, style | 0x200);
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label label_2 = new Label(composite, 0);
        label_2.setText(Messages.getString("SelectSQLDefinePanel.SQL_Sting__1"));
        this.text = new Text(composite, 2048);
        GridData gridData = new GridData(768);
        this.text.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalSpan = 2;
        label.setLayoutData((Object)gridData_1);
        label.setText(Messages.getString("SelectSQLDefinePanel.Please_Select_the_column_to_select_from__2"));
        this.table = new Table(composite, 67616);
        GridData gridData_2 = new GridData(1808);
        gridData_2.horizontalSpan = 2;
        this.table.setLayoutData((Object)gridData_2);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(100);
        tableColumn.setText(Messages.getString("SelectSQLDefinePanel.Column_Name_3"));
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(100);
        tableColumn_1.setText(Messages.getString("SelectSQLDefinePanel.DataName_4"));
        TableColumn tableColumn_2 = new TableColumn(this.table, 0);
        tableColumn_2.setWidth(100);
        tableColumn_2.setText(Messages.getString("SelectSQLDefinePanel.Column_Type_5"));
        this.conditionDefinePanel = new SQLConditionDefinePanel((Composite)this, 0);
        GridData gridData_3 = new GridData(1808);
        gridData_3.horizontalSpan = 2;
        this.conditionDefinePanel.setLayoutData(gridData_3);
        this.setWeights(new int[]{1, 1});
    }

    private void loadTableInfo(TableInfo[] tableInfos) {
        try {
            this.table.removeAll();
            int k = 0;
            while (k < tableInfos.length) {
                TableInfo tableInfo = tableInfos[k];
                int i = 0;
                while (i < tableInfo.columns.size()) {
                    TableColumnInfo column = (TableColumnInfo)tableInfo.columns.elementAt(i);
                    TableItem item = new TableItem(this.table, 0);
                    if (column.isSelected) {
                        item.setChecked(true);
                    }
                    if (tableInfo.tableName != null) {
                        item.setText(String.valueOf(tableInfo.tableName) + "." + column.columnName);
                    } else {
                        item.setText(column.columnName);
                    }
                    if (column.dataName != null) {
                        item.setText(1, column.dataName);
                    }
                    item.setText(2, column.columnTypeName);
                    item.setText(3, String.valueOf(column.precision));
                    item.setText(4, String.valueOf(column.scale));
                    item.setData((Object)column);
                    ++i;
                }
                ++k;
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("SelectSQLDefinePanel.Error_7"), (String)(String.valueOf(Messages.getString("SelectSQLDefinePanel.Internal_Error_!_nException__n_8")) + e));
            e.printStackTrace();
        }
    }

    public void dispose() {
        super.dispose();
        this.conditionDefinePanel.dispose();
    }

    protected void checkSubclass() {
    }

    public SQLDefineInfo getSQLDefineInfo() {
        SQLDefineInfo sqlDefine = new SQLDefineInfo();
        sqlDefine.conditions = this.conditionDefinePanel.getConditions();
        sqlDefine.userCondition = this.conditionDefinePanel.getUserCondition();
        sqlDefine.selectedColumns = new Vector();
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                TableColumnInfo column = (TableColumnInfo)items[i].getData();
                sqlDefine.selectedColumns.addElement(column);
            }
            ++i;
        }
        return sqlDefine;
    }
}

