/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ServiceSelectPage
extends WizardPage {
    private Table serviceListTable;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;
    private XMLNode commonServiceNode;
    private XMLNode selfDefineNode;
    private String filterStr;
    private String[] serviceIds;
    private XMLNode[] serviceNodes;
    private boolean isOk = false;
    private boolean isMulti = false;

    public ServiceSelectPage(String pageName) {
        super(pageName);
    }

    public ServiceSelectPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        container.setLayout((Layout)layout);
        layout.verticalSpacing = 9;
        Label label_8 = new Label(container, 0);
        GridData gridData_9 = new GridData();
        gridData_9.horizontalSpan = 4;
        label_8.setLayoutData((Object)gridData_9);
        label_8.setText(Messages.getString("ServiceSelectPage.Service_list_1"));
        this.serviceListTable = this.isMulti ? new Table(container, 67586) : new Table(container, 67584);
        this.serviceListTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServiceSelectPage.this.updateButtons();
            }
        });
        GridData gridData_8 = new GridData(1808);
        gridData_8.horizontalSpan = 4;
        this.serviceListTable.setLayoutData((Object)gridData_8);
        this.serviceListTable.setLinesVisible(true);
        this.serviceListTable.setHeaderVisible(true);
        TableColumn tableColumn_2 = new TableColumn(this.serviceListTable, 0);
        tableColumn_2.setWidth(108);
        tableColumn_2.setText(Messages.getString("ServiceSelectPage.Service_Type_2"));
        TableColumn tableColumn_4 = new TableColumn(this.serviceListTable, 0);
        tableColumn_4.setWidth(213);
        tableColumn_4.setText(Messages.getString("ServiceSelectPage.Service_ID_3"));
        TableColumn tableColumn_5 = new TableColumn(this.serviceListTable, 0);
        tableColumn_5.setWidth(250);
        tableColumn_5.setText(Messages.getString("ServiceSelectPage.Document_4"));
        this.setControl((Control)container);
        this.initializeTable();
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    public void setFilter(String filterStr) {
        this.filterStr = filterStr;
    }

    public void setCommonServiceNode(XMLNode node) {
        this.commonServiceNode = node;
    }

    public void setSelfDefineNode(XMLNode node) {
        this.selfDefineNode = node;
    }

    public void setIsMulti(boolean isMulti) {
        this.isMulti = isMulti;
    }

    private void initializeTable() {
        Vector services;
        if (this.commonServiceNode != null) {
            services = this.commonServiceNode.getChilds();
            int i = 0;
            while (services != null && i < services.size()) {
                XMLNode aNode = (XMLNode)services.elementAt(i);
                if (!("#text".equals(aNode.getNodeName()) || this.filterStr != null && this.filterStr.indexOf(aNode.getNodeName()) == -1)) {
                    TableItem item = new TableItem(this.serviceListTable, 0);
                    item.setText(aNode.getNodeName());
                    item.setText(1, aNode.getAttrValue("id"));
                    if (aNode.getAttrValue("desc") != null) {
                        item.setText(2, aNode.getAttrValue("desc"));
                    }
                    item.setData((Object)aNode);
                }
                ++i;
            }
        }
        if (this.selfDefineNode == null) {
            return;
        }
        XMLNode servicesNode = this.selfDefineNode.getChild("services");
        services = servicesNode.getChilds();
        if (services == null) {
            return;
        }
        int i = 0;
        while (services != null && i < services.size()) {
            XMLNode aNode = (XMLNode)services.elementAt(i);
            if (!("#text".equals(aNode.getNodeName()) || this.filterStr != null && this.filterStr.indexOf(aNode.getNodeName()) == -1)) {
                TableItem item = new TableItem(this.serviceListTable, 0);
                item.setText(aNode.getNodeName());
                item.setText(1, aNode.getAttrValue("id"));
                if (aNode.getAttrValue("desc") != null) {
                    item.setText(2, aNode.getAttrValue("desc"));
                }
                item.setData((Object)aNode);
            }
            ++i;
        }
    }

    private void updateButtons() {
        TableItem[] items = this.serviceListTable.getSelection();
        if (items.length <= 0) {
            this.isOk = false;
            this.serviceIds = null;
            this.serviceNodes = null;
        } else {
            ArrayList<String> svcIdList = new ArrayList<String>();
            ArrayList<XMLNode> svcNodeList = new ArrayList<XMLNode>();
            int i = 0;
            while (i < items.length) {
                XMLNode node = (XMLNode)items[i].getData();
                svcIdList.add(node.getAttrValue("id"));
                svcNodeList.add(node);
                ++i;
            }
            this.isOk = true;
            this.serviceIds = svcIdList.toArray(new String[0]);
            this.serviceNodes = svcNodeList.toArray(new XMLNode[0]);
        }
        this.getContainer().updateButtons();
    }

    public boolean canFlipToNextPage() {
        return this.isOk;
    }

    public String getServiceID() {
        if (this.serviceIds != null || this.serviceIds.length > 0) {
            return this.serviceIds[0];
        }
        return null;
    }

    public XMLNode getServiceNode() {
        if (this.serviceNodes != null || this.serviceNodes.length > 0) {
            return this.serviceNodes[0];
        }
        return null;
    }

    public String[] getServiceIDs() {
        return this.serviceIds;
    }

    public XMLNode[] getServiceNodes() {
        return this.serviceNodes;
    }
}

