/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.DataDictionarySelectDialog;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import com.ecc.ide.editor.wizard.jdbc.ResultSetInfo;
import com.ecc.ide.editor.wizard.jdbc.ResultSetMapDialog;
import com.ecc.ide.editor.wizard.jdbc.TableColumnInfo;
import com.ecc.ide.editor.wizard.jdbc.TableInfo;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableDataMapPage
extends WizardPage {
    private Table tableInfoTable;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;
    private boolean isCanFinish = false;

    public TableDataMapPage(String pageName) {
        super(pageName);
    }

    public TableDataMapPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        layout.verticalSpacing = 9;
        this.setControl((Control)container);
        Label label = new Label(container, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("TableDataMapPage.Selected_Table_Info_1"));
        this.tableInfoTable = new Table(container, 67616);
        this.tableInfoTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableDataMapPage.this.mapColumnToData();
            }

            public void mouseUp(MouseEvent e) {
                TableDataMapPage.this.getContainer().updateButtons();
            }
        });
        GridData gridData_1 = new GridData(1808);
        gridData_1.horizontalSpan = 2;
        this.tableInfoTable.setLayoutData((Object)gridData_1);
        this.tableInfoTable.setLinesVisible(true);
        this.tableInfoTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.tableInfoTable, 0);
        tableColumn.setWidth(100);
        tableColumn.setText(Messages.getString("TableDataMapPage.ColumnName_2"));
        TableColumn tableColumn_6 = new TableColumn(this.tableInfoTable, 0);
        tableColumn_6.setWidth(100);
        tableColumn_6.setText(Messages.getString("TableDataMapPage.Data_Name_3"));
        TableColumn tableColumn_1 = new TableColumn(this.tableInfoTable, 0);
        tableColumn_1.setWidth(78);
        tableColumn_1.setText(Messages.getString("TableDataMapPage.ColumnType_4"));
        TableColumn tableColumn_2 = new TableColumn(this.tableInfoTable, 0);
        tableColumn_2.setWidth(100);
        tableColumn_2.setText(Messages.getString("TableDataMapPage.Length_5"));
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite.setLayout((Layout)gridLayout);
        Button button = new Button(composite, 0);
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 100;
        button.setLayoutData((Object)gridData_2);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableDataMapPage.this.createNewData();
            }
        });
        button.setText(Messages.getString("TableDataMapPage.Create_new_data_6"));
        Button button_1 = new Button(composite, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableDataMapPage.this.mapColumnToData();
            }
        });
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 100;
        button_1.setLayoutData((Object)gridData_3);
        button_1.setText(Messages.getString("TableDataMapPage.Map_The_Data_7"));
        final Button button_2 = new Button(composite, 2);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (button_2.getSelection()) {
                    TableDataMapPage.this.setAllTableItem(true);
                } else {
                    TableDataMapPage.this.setAllTableItem(false);
                }
            }
        });
        button_2.setLayoutData((Object)gridData_3);
        button_2.setText("\u5168\u90e8\u9009\u62e9");
        button_2.setSelection(true);
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.loadTableInfo(tableInfo);
        this.isCanFinish = true;
    }

    public void setTableInfos(TableInfo[] infos) {
        this.loadTableInfo(infos);
        this.isCanFinish = true;
        super.getWizard().getContainer().updateButtons();
    }

    private void loadTableInfo(TableInfo tableInfo) {
        try {
            this.tableInfoTable.removeAll();
            int i = 0;
            while (i < tableInfo.columns.size()) {
                TableColumnInfo column = (TableColumnInfo)tableInfo.columns.elementAt(i);
                TableItem item = new TableItem(this.tableInfoTable, 0);
                if (column.isSelected) {
                    item.setChecked(true);
                }
                item.setText(column.columnName);
                if (column.dataName != null) {
                    item.setText(1, column.dataName);
                } else {
                    String dataName = this.getDataName(column.columnName, tableInfo.tableName);
                    if (dataName != null) {
                        item.setText(1, dataName);
                        column.dataName = dataName;
                    }
                }
                item.setText(2, column.columnTypeName);
                item.setText(3, String.valueOf(column.precision));
                item.setText(4, String.valueOf(column.scale));
                item.setChecked(true);
                if ("REF CURSOR".equals(column.columnTypeName)) {
                    ResultSetInfo rsInfo = (ResultSetInfo)tableInfo.columns.elementAt(i);
                    item.setData((Object)rsInfo);
                } else {
                    item.setData((Object)column);
                }
                ++i;
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("TableDataMapPage.Error_8"), (String)(String.valueOf(Messages.getString("TableDataMapPage.Access_Database_failed_!_nException__n_9")) + e));
            e.printStackTrace();
        }
    }

    private void loadTableInfo(TableInfo[] tableInfos) {
        try {
            this.tableInfoTable.removeAll();
            int k = 0;
            while (k < tableInfos.length) {
                TableInfo tableInfo = tableInfos[k];
                int i = 0;
                while (i < tableInfo.columns.size()) {
                    TableColumnInfo column = (TableColumnInfo)tableInfo.columns.elementAt(i);
                    TableItem item = new TableItem(this.tableInfoTable, 0);
                    if (column.isSelected) {
                        item.setChecked(true);
                    }
                    if (tableInfo.tableName != null) {
                        item.setText(String.valueOf(tableInfo.tableName) + "." + column.columnName);
                    } else {
                        item.setText(column.columnName);
                    }
                    String dataName = this.getDataName(column.columnName, tableInfo.tableName);
                    if (dataName != null) {
                        item.setText(1, dataName);
                        column.dataName = dataName;
                    }
                    item.setText(2, column.columnTypeName);
                    item.setText(3, String.valueOf(column.precision));
                    item.setText(4, String.valueOf(column.scale));
                    item.setData((Object)column);
                    ++i;
                }
                ++k;
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("TableDataMapPage.Error_11"), (String)(String.valueOf(Messages.getString("TableDataMapPage.Access_Database_failed_!_nException__n_12")) + e));
            e.printStackTrace();
        }
    }

    public boolean canFinish() {
        return this.isCanFinish;
    }

    public void gotoNextPage() {
        TableItem[] items = this.tableInfoTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableColumnInfo column = (TableColumnInfo)items[i].getData();
            column.isSelected = items[i].getChecked();
            ++i;
        }
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    private String getDataName(String columnName, String tableName) {
        if (this.dataDictionary == null) {
            return null;
        }
        XMLNode dataNode = this.dataDictionary.findChildNodeIgnoreCase(columnName);
        if (dataNode == null) {
            dataNode = this.dataDictionary.findChildNodeIgnoreCase(String.valueOf(tableName) + "_" + columnName);
        }
        if (dataNode != null) {
            return dataNode.getAttrValue("id");
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        boolean canFlip = false;
        boolean dataSeted = true;
        TableItem[] items = this.tableInfoTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableColumnInfo column = (TableColumnInfo)items[i].getData();
            if (items[i].getChecked()) {
                if (column.dataName == null) {
                    dataSeted = false;
                } else {
                    canFlip = true;
                }
                column.isSelected = true;
            } else {
                column.isSelected = false;
            }
            ++i;
        }
        return canFlip && dataSeted;
    }

    private void mapColumnToData() {
        TableItem[] items = this.tableInfoTable.getSelection();
        if (items.length != 1) {
            return;
        }
        TableColumnInfo column = (TableColumnInfo)items[0].getData();
        if ("REF CURSOR".equals(column.columnTypeName)) {
            ResultSetInfo rsInfo = (ResultSetInfo)items[0].getData();
            int i = 0;
            while (i < rsInfo.subColumns.size()) {
                TableColumnInfo column1 = (TableColumnInfo)rsInfo.subColumns.elementAt(i);
                column1.isSelected = true;
                ++i;
            }
            ResultSetMapDialog dialog = new ResultSetMapDialog(this.getShell(), 0);
            dialog.setDataEditorProfile(this.dataEditorProfile);
            dialog.setDataDictionary(this.dataDictionary);
            dialog.setRsInfo(rsInfo);
            dialog.open();
        } else {
            DataDictionarySelectDialog dialog = new DataDictionarySelectDialog(this.getShell(), 0);
            dialog.setProfile(this.dataEditorProfile);
            dialog.setDataDictionary(this.dataDictionary);
            Vector datas = (Vector)dialog.open();
            if (datas == null || datas.size() == 0) {
                return;
            }
            XMLNode dataNode = (XMLNode)datas.elementAt(0);
            String dataID = dataNode.getAttrValue("id");
            if (dataID != null) {
                items[0].setText(1, dataID);
                column.dataName = dataID;
                items[0].setChecked(true);
                this.getContainer().updateButtons();
            }
        }
    }

    private void createNewData() {
        TableItem[] items = this.tableInfoTable.getSelection();
        if (items.length != 1) {
            return;
        }
        TableColumnInfo column = (TableColumnInfo)items[0].getData();
        if ("REF CURSOR".equals(column.columnTypeName)) {
            return;
        }
        DataDictionarySelectDialog dialog = new DataDictionarySelectDialog(this.getShell(), 0);
        dialog.setProfile(this.dataEditorProfile);
        dialog.setDataDictionary(this.dataDictionary);
        dialog.setDataName(column.columnName);
        dialog.setEditable(true);
        Vector datas = (Vector)dialog.open();
        if (datas == null || datas.size() == 0) {
            return;
        }
        XMLNode dataNode = (XMLNode)datas.elementAt(0);
        String dataID = dataNode.getAttrValue("id");
        if (dataID != null) {
            items[0].setText(1, dataID);
            column.dataName = dataID;
            this.getContainer().updateButtons();
        }
    }

    private void setAllTableItem(boolean isSelect) {
        TableItem[] items = this.tableInfoTable.getItems();
        if (items == null || items.length == 0) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            items[i].setChecked(isSelect);
            ++i;
        }
    }
}

