/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc;

import com.ecc.ide.editor.wizard.jdbc.Messages;
import com.ecc.ide.editor.wizard.jdbc.ResultSetInfo;
import com.ecc.ide.editor.wizard.jdbc.TableColumnInfo;
import com.ecc.ide.editor.wizard.jdbc.TableInfo;
import com.swtdesigner.ResourceManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TableViewProcedureSelectPage
extends WizardPage {
    private Table infoListTable;
    private Tree dbCatalogTree;
    private Connection connection;
    private String selectedTable = null;
    private TableInfo tableInfo;
    private TableColumn tableColumn_0;
    private TableColumn tableColumn_1;
    private TableColumn tableColumn_2;
    private TableColumn tableColumn_3;
    private TableColumn tableColumn_4;
    private TreeItem tableItem;
    private TreeItem viewItem;
    private boolean checkSelect = false;
    private String selectType = "table";
    static /* synthetic */ Class class$0;

    public void setCheckSelect(boolean value) {
        this.checkSelect = value;
    }

    public TableViewProcedureSelectPage(String pageName) {
        super(pageName);
    }

    public TableViewProcedureSelectPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(container, 0);
        if (this.checkSelect) {
            this.dbCatalogTree = new Tree((Composite)sashForm, 2080);
            this.dbCatalogTree.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    TableViewProcedureSelectPage.this.getContainer().updateButtons();
                }
            });
        } else {
            this.dbCatalogTree = new Tree((Composite)sashForm, 2048);
        }
        this.dbCatalogTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewProcedureSelectPage.this.loadDestDBInfo();
            }
        });
        this.infoListTable = new Table((Composite)sashForm, 67584);
        this.infoListTable.setLinesVisible(true);
        this.infoListTable.setHeaderVisible(true);
        this.tableColumn_0 = new TableColumn(this.infoListTable, 0);
        this.tableColumn_0.setWidth(100);
        this.tableColumn_0.setText(Messages.getString("TableViewProcedureSelectPage.New_column_2"));
        this.tableColumn_1 = new TableColumn(this.infoListTable, 0);
        this.tableColumn_1.setWidth(100);
        this.tableColumn_1.setText(Messages.getString("TableViewProcedureSelectPage.New_column_3"));
        this.tableColumn_2 = new TableColumn(this.infoListTable, 0);
        this.tableColumn_2.setWidth(100);
        this.tableColumn_2.setText(Messages.getString("TableViewProcedureSelectPage.New_column_4"));
        this.tableColumn_3 = new TableColumn(this.infoListTable, 0);
        this.tableColumn_3.setWidth(100);
        this.tableColumn_3.setText(Messages.getString("TableViewProcedureSelectPage.New_column_5"));
        this.tableColumn_4 = new TableColumn(this.infoListTable, 0);
        this.tableColumn_4.setWidth(100);
        this.tableColumn_4.setText(Messages.getString("TableViewProcedureSelectPage.New_column_6"));
        sashForm.setWeights(new int[]{1, 1});
        this.setControl((Control)container);
    }

    public void setDBConnection(Connection connection) {
        this.connection = connection;
        try {
            this.dbCatalogTree.removeAll();
            TreeItem item = new TreeItem(this.dbCatalogTree, 0);
            item.setText(Messages.getString("TableViewProcedureSelectPage.DataBase_7"));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ecc.ide.editor.wizard.jdbc.TableViewProcedureSelectPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            item.setImage(ResourceManager.getImage(clazz, "/images/db_obj.gif"));
            this.tableItem = new TreeItem(item, 0);
            this.tableItem.setText("Tables");
            this.tableItem.setData((Object)"Tables");
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("com.ecc.ide.editor.wizard.jdbc.TableViewProcedureSelectPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.tableItem.setImage(ResourceManager.getImage(clazz2, "/images/EJAccess.gif"));
            this.loadDBTableInfo(this.tableItem, new String[]{"TABLE"}, "table");
            this.viewItem = new TreeItem(item, 0);
            this.viewItem.setText("Views");
            this.viewItem.setData((Object)"Views");
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("com.ecc.ide.editor.wizard.jdbc.TableViewProcedureSelectPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.viewItem.setImage(ResourceManager.getImage(clazz3, "/images/EJAccess.gif"));
            this.loadDBTableInfo(this.viewItem, new String[]{"VIEW"}, "view");
            TreeItem aItem = new TreeItem(item, 0);
            aItem.setText("Store Procedures");
            aItem.setData((Object)"Procedures");
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("com.ecc.ide.editor.wizard.jdbc.TableViewProcedureSelectPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            aItem.setImage(ResourceManager.getImage(clazz4, "/images/EJAccess.gif"));
            this.loadDBProcedureInfo(aItem, "procedure");
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("TableViewProcedureSelectPage.Error_23"), (String)(String.valueOf(Messages.getString("TableViewProcedureSelectPage.Access_Database_failed_!_nException__n_24")) + e));
            e.printStackTrace();
        }
    }

    private void loadDestDBInfo() {
        TreeItem[] items = this.dbCatalogTree.getSelection();
        if (items.length != 1) {
            return;
        }
        String id = (String)items[0].getData();
        if (id == null) {
            return;
        }
        this.selectedTable = null;
        if (id.equals("table")) {
            TableInfo info = (TableInfo)items[0].getData("tableInfo");
            if (info != null) {
                this.loadTableInfo(info);
            } else {
                info = this.loadTableDataMeta(items[0].getText());
                items[0].setData("tableInfo", (Object)info);
            }
            if ("table".equals(this.selectType)) {
                this.tableInfo = info;
                this.selectedTable = items[0].getText();
            }
        } else if (id.equals("view")) {
            TableInfo info = (TableInfo)items[0].getData("tableInfo");
            if (info != null) {
                this.loadTableInfo(info);
            } else {
                info = this.loadTableDataMeta(items[0].getText());
                items[0].setData("tableInfo", (Object)info);
            }
            if ("table".equals(this.selectType)) {
                this.tableInfo = info;
                this.selectedTable = items[0].getText();
            }
        } else if (id.equals("procedure")) {
            TableInfo info = (TableInfo)items[0].getData("tableInfo");
            if (info != null) {
                this.loadProcedureInfo(info);
            } else {
                info = this.loadProcedureDataMeta(items[0].getText());
                items[0].setData("tableInfo", (Object)info);
            }
            if ("procedure".equals(this.selectType)) {
                this.tableInfo = info;
                this.selectedTable = items[0].getText();
            }
        }
        super.getWizard().getContainer().updateButtons();
    }

    private void updateButtons() {
        super.getWizard().getContainer().updateButtons();
    }

    private void loadDBTableInfo(TreeItem parent, String[] tableTypes, String id) {
        if (this.connection == null) {
            return;
        }
        try {
            DatabaseMetaData dbMeta = this.connection.getMetaData();
            ResultSet result = dbMeta.getTables(null, null, null, tableTypes);
            while (result.next()) {
                String tableName = result.getString(3);
                String schemaName = result.getString(2);
                TreeItem item = new TreeItem(parent, 0);
                if (schemaName != null) {
                    item.setText(String.valueOf(schemaName) + "." + tableName);
                } else {
                    item.setText(tableName);
                }
                item.setData((Object)id);
                if (id.equals("table")) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("com.ecc.ide.editor.wizard.jdbc.TableViewProcedureSelectPage");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    item.setImage(ResourceManager.getImage(clazz, "/images/table.gif"));
                    continue;
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("com.ecc.ide.editor.wizard.jdbc.TableViewProcedureSelectPage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                item.setImage(ResourceManager.getImage(clazz, "/images/dataView.gif"));
            }
            result.close();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("TableViewProcedureSelectPage.Error_41"), (String)(String.valueOf(Messages.getString("TableViewProcedureSelectPage.Access_Database_failed_!_nException__n_42")) + e));
            e.printStackTrace();
        }
    }

    private void loadDBProcedureInfo(TreeItem parent, String id) {
        if (this.connection == null) {
            return;
        }
        try {
            DatabaseMetaData dbMeta = this.connection.getMetaData();
            ResultSet result = dbMeta.getProcedures(null, null, null);
            while (result.next()) {
                String procedureName = result.getString(3);
                String schemaName = result.getString(2);
                TreeItem item = new TreeItem(parent, 0);
                item.setText(String.valueOf(schemaName) + "." + procedureName);
                item.setData((Object)id);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("com.ecc.ide.editor.wizard.jdbc.TableViewProcedureSelectPage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                item.setImage(ResourceManager.getImage(clazz, "/images/genAction.gif"));
            }
            result.close();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("TableViewProcedureSelectPage.Error_45"), (String)(String.valueOf(Messages.getString("TableViewProcedureSelectPage.Access_Database_failed_!_nException__n_46")) + e));
            e.printStackTrace();
        }
    }

    private TableInfo loadTableDataMeta(String tableName) {
        try {
            String schemaName = null;
            String name = tableName;
            int idx = tableName.indexOf(46);
            if (idx != -1) {
                schemaName = tableName.substring(0, idx);
                name = tableName.substring(idx + 1);
            }
            TableInfo tInfo = new TableInfo(schemaName, name);
            this.infoListTable.removeAll();
            this.tableColumn_0.setText(Messages.getString("TableViewProcedureSelectPage.Column_Name_47"));
            this.tableColumn_1.setText(Messages.getString("TableViewProcedureSelectPage.column_Type_48"));
            this.tableColumn_2.setText(Messages.getString("TableViewProcedureSelectPage.Length[Precision]_49"));
            this.tableColumn_3.setText(Messages.getString("TableViewProcedureSelectPage.scale_50"));
            this.tableColumn_4.setText("");
            String strSQL = "Select * from " + tableName;
            Statement state = this.connection.createStatement();
            ResultSet rs = state.executeQuery(strSQL);
            ResultSetMetaData metaData = rs.getMetaData();
            int i = 0;
            while (i < metaData.getColumnCount()) {
                String columnName = metaData.getColumnName(i + 1);
                String columnTypeName = metaData.getColumnTypeName(i + 1);
                int columnType = metaData.getColumnType(i + 1);
                int precision = metaData.getPrecision(i + 1);
                int scale = metaData.getScale(i + 1);
                TableItem item = new TableItem(this.infoListTable, 0);
                item.setText(columnName);
                item.setText(1, columnTypeName);
                item.setText(2, String.valueOf(precision));
                item.setText(3, String.valueOf(scale));
                TableColumnInfo column = new TableColumnInfo();
                column.tableName = tableName;
                tInfo.addColumn(column);
                column.columnName = columnName;
                column.columnType = columnType;
                column.columnTypeName = columnTypeName;
                column.isSelected = true;
                column.length = precision;
                column.precision = precision;
                column.scale = scale;
                ++i;
            }
            rs.close();
            state.close();
            return tInfo;
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("TableViewProcedureSelectPage.Error_53"), (String)(String.valueOf(Messages.getString("TableViewProcedureSelectPage.Access_Database_failed_!_nException__n_54")) + e));
            e.printStackTrace();
            return null;
        }
    }

    private void loadTableInfo(TableInfo tableInfo) {
        try {
            this.infoListTable.removeAll();
            this.tableColumn_0.setText(Messages.getString("TableViewProcedureSelectPage.Column_Name_55"));
            this.tableColumn_1.setText(Messages.getString("TableViewProcedureSelectPage.column_Type_56"));
            this.tableColumn_2.setText(Messages.getString("TableViewProcedureSelectPage.Length[Precision]_57"));
            this.tableColumn_3.setText(Messages.getString("TableViewProcedureSelectPage.scale_58"));
            this.tableColumn_4.setText("");
            int i = 0;
            while (i < tableInfo.columns.size()) {
                TableColumnInfo column = (TableColumnInfo)tableInfo.columns.elementAt(i);
                TableItem item = new TableItem(this.infoListTable, 0);
                item.setText(column.columnName);
                item.setText(1, column.columnTypeName);
                item.setText(2, String.valueOf(column.precision));
                item.setText(3, String.valueOf(column.scale));
                ++i;
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("TableViewProcedureSelectPage.Error_60"), (String)(String.valueOf(Messages.getString("TableViewProcedureSelectPage.Access_Database_failed_!_nException__n_61")) + e));
            e.printStackTrace();
        }
    }

    private TableInfo loadProcedureDataMeta(String procedureName) {
        String[] inoutMode = new String[]{"UnKnown", "IN", "INOUT", "OUT", "RETURN", "ResultSet"};
        try {
            this.infoListTable.removeAll();
            this.tableColumn_0.setText(Messages.getString("TableViewProcedureSelectPage.parameter_Name_68"));
            this.tableColumn_1.setText(Messages.getString("TableViewProcedureSelectPage.In/out_69"));
            this.tableColumn_2.setText(Messages.getString("TableViewProcedureSelectPage.column_Type_70"));
            this.tableColumn_3.setText(Messages.getString("TableViewProcedureSelectPage.Length[Precision]_71"));
            this.tableColumn_4.setText(Messages.getString("TableViewProcedureSelectPage.scale_72"));
            String schemaName = null;
            int idx = procedureName.indexOf(46);
            if (idx != -1) {
                schemaName = procedureName.substring(0, idx);
                procedureName = procedureName.substring(idx + 1);
            }
            TableInfo tInfo = new TableInfo(schemaName, procedureName);
            ResultSetInfo rsInfo = null;
            boolean isCursor = false;
            ResultSet rs = this.connection.getMetaData().getProcedureColumns(null, schemaName, procedureName, null);
            while (rs.next()) {
                String columnName = rs.getString(4);
                if (columnName == null) continue;
                short columnType = rs.getShort(5);
                String typeName = rs.getString(7);
                int length = rs.getInt(9);
                int precision = rs.getInt(8);
                short scale = rs.getShort(10);
                if ("REF CURSOR".equals(typeName)) {
                    String packageName = rs.getString(1);
                    tInfo.addProcedurePackageName(packageName);
                    rsInfo = new ResultSetInfo();
                    rsInfo.columnName = columnName;
                    rsInfo.columnTypeName = typeName;
                    rsInfo.length = precision;
                    rsInfo.precision = precision;
                    rsInfo.scale = scale;
                    rsInfo.inOutType = columnType;
                    tInfo.addColumn(rsInfo);
                    TableItem item = new TableItem(this.infoListTable, 0);
                    item.setText(columnName);
                    item.setText(1, inoutMode[columnType]);
                    item.setText(2, typeName);
                    item.setText(3, String.valueOf(length));
                    item.setText(4, String.valueOf(scale));
                    isCursor = true;
                    continue;
                }
                if (isCursor) {
                    if (rsInfo == null) continue;
                    TableColumnInfo column = new TableColumnInfo();
                    rsInfo.addColumn(column);
                    column.columnName = columnName;
                    column.columnTypeName = typeName;
                    column.length = precision;
                    column.precision = precision;
                    column.scale = scale;
                    column.inOutType = columnType;
                    continue;
                }
                TableItem item = new TableItem(this.infoListTable, 0);
                item.setText(columnName);
                item.setText(1, inoutMode[columnType]);
                item.setText(2, typeName);
                item.setText(3, String.valueOf(length));
                item.setText(4, String.valueOf(scale));
                TableColumnInfo column = new TableColumnInfo();
                tInfo.addColumn(column);
                column.columnName = columnName;
                column.columnTypeName = typeName;
                column.length = precision;
                column.precision = precision;
                column.scale = scale;
                column.inOutType = columnType;
            }
            rs.close();
            return tInfo;
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("TableViewProcedureSelectPage.Error_73"), (String)(String.valueOf(Messages.getString("TableViewProcedureSelectPage.Access_Database_failed_!_nException__n_74")) + e));
            e.printStackTrace();
            return null;
        }
    }

    private void loadProcedureInfo(TableInfo tableInfo) {
        String[] inoutMode = new String[]{"UnKnown", "IN", "INOUT", "OUT", "RETURN", "ResultSet"};
        try {
            this.infoListTable.removeAll();
            this.tableColumn_0.setText(Messages.getString("TableViewProcedureSelectPage.parameter_Name_81"));
            this.tableColumn_1.setText(Messages.getString("TableViewProcedureSelectPage.In/out_82"));
            this.tableColumn_2.setText(Messages.getString("TableViewProcedureSelectPage.column_Type_83"));
            this.tableColumn_3.setText(Messages.getString("TableViewProcedureSelectPage.Length[Precision]_84"));
            this.tableColumn_4.setText(Messages.getString("TableViewProcedureSelectPage.scale_85"));
            int i = 0;
            while (i < tableInfo.columns.size()) {
                TableColumnInfo column = (TableColumnInfo)tableInfo.columns.elementAt(i);
                TableItem item = new TableItem(this.infoListTable, 0);
                item.setText(column.columnName);
                item.setText(1, inoutMode[column.inOutType]);
                item.setText(2, column.columnTypeName);
                item.setText(3, String.valueOf(column.length));
                item.setText(4, String.valueOf(column.scale));
                ++i;
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("TableViewProcedureSelectPage.Error_86"), (String)(String.valueOf(Messages.getString("TableViewProcedureSelectPage.Access_Database_failed_!_nException__n_87")) + e));
            e.printStackTrace();
        }
    }

    public boolean canFlipToNextPage() {
        if (!this.checkSelect && this.selectedTable != null) {
            return true;
        }
        if (this.checkSelect) {
            TreeItem[] items = this.tableItem.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].getChecked()) {
                    return true;
                }
                ++i;
            }
            items = this.viewItem.getItems();
            i = 0;
            while (i < items.length) {
                if (items[i].getChecked()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String getTableName() {
        return this.selectedTable;
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public TableInfo[] getTableInfos() {
        TableInfo info;
        TableInfo[] tmp = new TableInfo[20];
        int count = 0;
        TreeItem[] items = this.tableItem.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                info = (TableInfo)items[i].getData("tableInfo");
                if (info == null) {
                    info = this.loadTableDataMeta(items[i].getText());
                    items[i].setData("tableInfo", (Object)info);
                }
                tmp[count++] = info;
            }
            ++i;
        }
        items = this.viewItem.getItems();
        i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                info = (TableInfo)items[i].getData("tableInfo");
                if (info == null) {
                    info = this.loadTableDataMeta(items[i].getText());
                    items[i].setData("tableInfo", (Object)info);
                }
                tmp[count++] = info;
            }
            ++i;
        }
        if (count > 0) {
            TableInfo[] infos = new TableInfo[count];
            int i2 = 0;
            while (i2 < count) {
                infos[i2] = tmp[i2];
                ++i2;
            }
            return infos;
        }
        return null;
    }

    public void setSelectType(String type) {
        this.selectType = type;
    }
}

